/*
 * Decompiled with CFR 0.152.
 */
package pacBio;

import fileOperation.OneMatch;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;
import misc.OsHelper;
import misc.StringUtils;

public class CollectSeqencesFCGR13 {
    static String LABEL = "Barcode";
    public static final String[] ABC = new String[]{"FCGR1A", "FCGR1B", "FCGR3A", "FCGR3B"};
    public static int MATCH_MIN_SCORE = 6000;

    public static void main(String[] args) throws Exception {
        File fastaDir = new File(args[0]);
        File backBone = new File(args[1]);
        File summaryFile = new File(args[2]);
        File outputDir = new File(args[3]);
        File[] fastaFiles = fastaDir.listFiles();
        StringBuilder allMatchResult = new StringBuilder();
        LinkedHashMap<String, List<OneMatch>> allConsensusByLocus = new LinkedHashMap<String, List<OneMatch>>();
        File[] fileArray = fastaFiles;
        int n = fastaFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File fastaFile = fileArray[n2];
            if (fastaFile.getName().endsWith("fasta")) {
                System.out.println(fastaFile.getName());
                Map<String, List<OneMatch>> SampleResultByLocus = CollectSeqencesFCGR13.collectConsensus(fastaFile, backBone, allMatchResult);
                CollectSeqencesFCGR13.filleInSequence(SampleResultByLocus, fastaFile);
                CollectSeqencesFCGR13.loadAccuracy(SampleResultByLocus, summaryFile);
                CollectSeqencesFCGR13.loadExtractedSequence(SampleResultByLocus);
                for (String locus : SampleResultByLocus.keySet()) {
                    System.out.println("\t" + locus);
                    if (!allConsensusByLocus.containsKey(locus)) {
                        allConsensusByLocus.put(locus, new ArrayList());
                    }
                    ((List)allConsensusByLocus.get(locus)).addAll(CollectSeqencesFCGR13.limitMatches(SampleResultByLocus.get(locus), locus));
                }
            }
            ++n2;
        }
        CollectSeqencesFCGR13.writeDetailMatchRecord(outputDir, allMatchResult);
        CollectSeqencesFCGR13.writeRulesetFile(outputDir, allConsensusByLocus);
        CollectSeqencesFCGR13.writeRulesetInfoFile(outputDir, allConsensusByLocus);
    }

    private static void loadExtractedSequence(Map<String, List<OneMatch>> allConsensusByLocus) {
        for (String locus : allConsensusByLocus.keySet()) {
            for (OneMatch match : allConsensusByLocus.get(locus)) {
                CollectSeqencesFCGR13.extractSequence(match, locus);
            }
        }
    }

    private static List<OneMatch> limitMatches(List<OneMatch> list, String locus) {
        int standardedSize = CollectSeqencesFCGR13.getStandardedSize(locus);
        ArrayList<OneMatch> selectedMatches = new ArrayList<OneMatch>();
        if (list.size() == 0) {
            return selectedMatches;
        }
        ArrayList<Integer> sizeList = new ArrayList<Integer>();
        for (OneMatch match : list) {
            System.out.println(String.valueOf(match.getName()) + " " + match.isForwardExist() + " " + match.isReverseExist());
            sizeList.add(match.getTrimedSequence().length());
        }
        int count = 0;
        Object[] num = sizeList.toArray();
        Arrays.sort(num);
        int x = num.length - 1;
        while (x >= 0) {
            int y = (Integer)num[x];
            if (y < standardedSize) break;
            selectedMatches.add(CollectSeqencesFCGR13.findBySize(list, y, selectedMatches));
            if (++count >= 2) {
                return selectedMatches;
            }
            --x;
        }
        if (count == 0) {
            selectedMatches.add(CollectSeqencesFCGR13.findBySize(list, (Integer)num[num.length - 1], selectedMatches));
        }
        if (selectedMatches.size() == 0) {
            System.out.println(String.valueOf(locus) + " no seq");
        }
        return selectedMatches;
    }

    private static OneMatch findBySize(List<OneMatch> list, int y, List<OneMatch> selectedMatches) {
        for (OneMatch match : list) {
            if (match.getTrimedSequence().length() != y || selectedMatches.contains(match)) continue;
            return match;
        }
        return null;
    }

    private static int getStandardedSize(String locus) {
        return 7000;
    }

    private static void writeRulesetInfoFile(File outputDir, Map<String, List<OneMatch>> allConsensusByLocus) {
        StringBuilder info = new StringBuilder();
        info.append("Gene").append("\t").append("Sample").append("\t").append("SequenceName").append("\t").append("SubReadsNum").append("\t").append("MatchSize").append("\t");
        info.append("AfterTrimSize").append("\t").append("PredictedAccuracy").append("\n");
        File infoFile = new File(outputDir, "sequenceInfo.txt");
        for (String locus : allConsensusByLocus.keySet()) {
            for (OneMatch match : allConsensusByLocus.get(locus)) {
                info.append(locus).append("\t");
                info.append(match.getName().split("--")[0].replaceFirst("Barcode", "")).append("\t");
                info.append(match.getName()).append("\t");
                info.append(match.getName().split("NumReads")[1]).append("\t");
                int matchSize = 0;
                matchSize = match.isForwardExist() ? match.getForwardEnd() - match.getForwardStart() + 1 : match.getReverseEnd() - match.getReverseStart() + 1;
                info.append(matchSize).append("\t");
                info.append(match.getTrimedSequence().length()).append("\t");
                info.append(match.getAccuracy()).append("\n");
            }
        }
        FileManager.writeTextFile(infoFile, info.toString(), true);
    }

    private static void writeRulesetFile(File outputDir, Map<String, List<OneMatch>> allConsensusByLocus) {
        for (String locus : allConsensusByLocus.keySet()) {
            StringBuilder sequences = new StringBuilder();
            File rulesetFile = new File(outputDir, String.valueOf(locus) + ".fasta");
            for (OneMatch match : allConsensusByLocus.get(locus)) {
                sequences.append(">").append(match.getName()).append("\n");
                sequences.append(match.getTrimedSequence()).append("\n");
            }
            FileManager.writeTextFile(rulesetFile, sequences.toString(), true);
        }
    }

    private static String extractSequence(OneMatch match, String locus) {
        HashMap<String, Integer> geneStartMap = new HashMap<String, Integer>();
        HashMap<String, Integer> geneEndMap = new HashMap<String, Integer>();
        geneStartMap.put("FCGR1A", 618);
        geneStartMap.put("FCGR1B", 595);
        geneStartMap.put("FCGR3A", 558);
        geneStartMap.put("FCGR3B", 419);
        geneEndMap.put("FCGR1A", 8312);
        geneEndMap.put("FCGR1B", 8254);
        geneEndMap.put("FCGR3A", 8210);
        geneEndMap.put("FCGR3B", 8182);
        String trimedAndCorrectedSequence = null;
        System.out.println("extractSequence for " + match.getName());
        if (match.isForwardExist()) {
            System.out.println("111111111 ");
            int startOffset = 0;
            if (match.getForwardTargetStart() < (Integer)geneStartMap.get(locus)) {
                startOffset = (Integer)geneStartMap.get(locus) - match.getForwardTargetStart();
            }
            int beginIndex = match.getForwardStart() + startOffset;
            int endOffset = 0;
            if (match.getForwardTargetEnd() > (Integer)geneEndMap.get(locus)) {
                endOffset = match.getForwardTargetEnd() - (Integer)geneEndMap.get(locus);
            }
            int endIndex = match.getForwardEnd() - endOffset;
            trimedAndCorrectedSequence = match.getSequence().substring(beginIndex - 1, endIndex);
        } else {
            System.out.println("22222222 ");
            int endOffset = 0;
            if (match.getReverseTargetStart() < (Integer)geneStartMap.get(locus)) {
                endOffset = (Integer)geneStartMap.get(locus) - match.getReverseTargetStart();
            }
            int endIndex = match.getReverseEnd() - endOffset;
            int startOffset = 0;
            if (match.getReverseTargetEnd() > (Integer)geneEndMap.get(locus)) {
                startOffset = match.getReverseTargetEnd() - (Integer)geneEndMap.get(locus);
            }
            int beginIndex = match.getReverseStart() + startOffset;
            trimedAndCorrectedSequence = StringUtils.revCompSeq(match.getSequence().substring(beginIndex - 1, endIndex));
        }
        System.out.println("set for " + match.getName());
        match.setTrimedSequence(trimedAndCorrectedSequence);
        return trimedAndCorrectedSequence;
    }

    private static void writeDetailMatchRecord(File outputDir, StringBuilder allMatchResult) {
        FileManager.writeTextFile(new File(outputDir, "matchDetail.txt"), allMatchResult.toString(), true);
    }

    private static void loadAccuracy(Map<String, List<OneMatch>> sampleResultByLocus, File summaryFile) {
        HashMap<String, String> infoMap = new HashMap<String, String>();
        String[] lines = FileManager.readTextFile(summaryFile).split("\n");
        int i = 1;
        while (i < lines.length) {
            String[] items = lines[i].split(",");
            infoMap.put(items[1].trim(), items[6].trim());
            ++i;
        }
        for (List<OneMatch> matches : sampleResultByLocus.values()) {
            for (OneMatch match : matches) {
                match.setAccuracy((String)infoMap.get(match.getName()));
            }
        }
    }

    private static void filleInSequence(Map<String, List<OneMatch>> sampleResultByLocus, File fastaFile) {
        HashMap<String, String> seqMap = new HashMap<String, String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            String line = lines[i].trim();
            if (i % 2 == 0) {
                String name = line.substring(1);
                seqMap.put(name, lines[i + 1].trim());
            }
            ++i;
        }
        for (List<OneMatch> matches : sampleResultByLocus.values()) {
            for (OneMatch match : matches) {
                match.setSequence((String)seqMap.get(match.getName()));
            }
        }
    }

    private static Map<String, List<OneMatch>> collectConsensus(File fastaFile, File backBone, StringBuilder allMatchResult) throws Exception {
        String matchResult = CollectSeqencesFCGR13.alignByCrossmatch(fastaFile, backBone);
        Map<String, List<OneMatch>> sampleResult = CollectSeqencesFCGR13.parseMatchResult(matchResult, allMatchResult);
        Map<String, List<OneMatch>> SampleResultByLocus = CollectSeqencesFCGR13.AnalyzeTypingResult(sampleResult);
        return SampleResultByLocus;
    }

    private static Map<String, List<OneMatch>> AnalyzeTypingResult(Map<String, List<OneMatch>> sampleResult) {
        Map<String, List<OneMatch>> SampleResultByLocus = CollectSeqencesFCGR13.initLocusResultMap();
        for (String seqName : sampleResult.keySet()) {
            List<OneMatch> matches = sampleResult.get(seqName);
            OneMatch bestTargetMatch = CollectSeqencesFCGR13.getBestTarget(matches);
            if (!CollectSeqencesFCGR13.passQcheck(bestTargetMatch)) continue;
            CollectSeqencesFCGR13.addToResult(bestTargetMatch, SampleResultByLocus);
        }
        return SampleResultByLocus;
    }

    private static void addToResult(OneMatch bestTargetMatch, Map<String, List<OneMatch>> sampleResultByLocus) {
        String type;
        String string = type = bestTargetMatch.isForwardExist() ? bestTargetMatch.getForwardType() : bestTargetMatch.getReverseType();
        if (sampleResultByLocus.containsKey(type)) {
            sampleResultByLocus.get(type).add(bestTargetMatch);
        }
    }

    private static boolean passQcheck(OneMatch match) {
        int score;
        int n = score = match.getForwardScore() > match.getReverseScore() ? match.getForwardScore() : match.getReverseScore();
        return score > MATCH_MIN_SCORE;
    }

    private static OneMatch getBestTarget(List<OneMatch> matches) {
        OneMatch bestTarget = null;
        int score = 0;
        for (OneMatch match : matches) {
            if (match.isForwardExist() && match.getForwardScore() > score) {
                score = match.getForwardScore();
                bestTarget = match;
            }
            if (!match.isReverseExist() || match.getReverseScore() <= score) continue;
            score = match.getReverseScore();
            bestTarget = match;
        }
        if (bestTarget.isForwardExist() && bestTarget.getForwardScore() == score) {
            bestTarget.setReverseExist(false);
        } else if (bestTarget.isReverseExist() && bestTarget.getReverseScore() == score) {
            bestTarget.setForwardExist(false);
        }
        return bestTarget;
    }

    private static Map<String, List<OneMatch>> initLocusResultMap() {
        LinkedHashMap<String, List<OneMatch>> SampleResultByLocus = new LinkedHashMap<String, List<OneMatch>>();
        String[] stringArray = ABC;
        int n = ABC.length;
        int n2 = 0;
        while (n2 < n) {
            String locus = stringArray[n2];
            SampleResultByLocus.put(locus, new ArrayList());
            ++n2;
        }
        return SampleResultByLocus;
    }

    private static Map<String, List<OneMatch>> parseMatchResult(String matchResult, StringBuilder allMatchResult) throws Exception {
        String[] lines = matchResult.split("\n");
        String fullName = null;
        OneMatch aMatch = null;
        HashMap<String, List<OneMatch>> sampleResult = new HashMap<String, List<OneMatch>>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.indexOf(LABEL) > 0 && line.trim().split("\\s+").length >= 12 && line.trim().split("\\s+")[4].length() > 2) {
                allMatchResult.append(line).append("\n");
                String[] items = line.trim().split("\\s+");
                fullName = items[4].trim();
                aMatch = CollectSeqencesFCGR13.populateAmatch(line);
                if (!sampleResult.containsKey(fullName)) {
                    sampleResult.put(fullName, new ArrayList());
                }
                ((List)sampleResult.get(fullName)).add(aMatch);
            }
            ++n2;
        }
        return sampleResult;
    }

    private static OneMatch populateAmatch(String line) {
        String[] items = line.trim().split("\\s+");
        String fullName = items[4].trim();
        String sampleName = CollectSeqencesFCGR13.getSampleName(fullName);
        boolean isRevComp = items[8].trim().equals("C");
        String type = isRevComp ? items[9].trim() : items[8].trim();
        OneMatch aMatch = new OneMatch();
        aMatch.setName(fullName);
        if (isRevComp) {
            aMatch.setReverseExist(true);
            aMatch.setReverseType(type);
            aMatch.setReverseScore(Integer.valueOf(items[0].trim()));
            aMatch.setReverseTargetStart(Integer.valueOf(items[12].trim()));
            aMatch.setReverseTargetEnd(Integer.valueOf(items[11].trim()));
            aMatch.setReverseFullName(fullName);
            aMatch.setReverseStart(Integer.valueOf(items[5].trim()));
            aMatch.setReverseEnd(Integer.valueOf(items[6].trim()));
            aMatch.setReverseMisMatch(Double.valueOf(items[1].trim()) + Double.valueOf(items[2].trim()) + Double.valueOf(items[3].trim()));
        } else {
            aMatch.setForwardExist(true);
            aMatch.setForwardType(type);
            aMatch.setForwardScore(Integer.valueOf(items[0].trim()));
            aMatch.setForwardTargetStart(Integer.valueOf(items[9].trim()));
            aMatch.setForwardTargetEnd(Integer.valueOf(items[10].trim()));
            aMatch.setForwardFullName(fullName);
            aMatch.setForwardStart(Integer.valueOf(items[5].trim()));
            aMatch.setForwardEnd(Integer.valueOf(items[6].trim()));
            aMatch.setForwardMisMatch(Double.valueOf(items[1].trim()) + Double.valueOf(items[2].trim()) + Double.valueOf(items[3].trim()));
        }
        return aMatch;
    }

    private static String getSampleName(String id) {
        String name = id.split("--")[0].replace("Barcode", "");
        return name;
    }

    private static String alignByCrossmatch(File fastaFile, File backBone) throws Exception {
        File tempOutputFile = File.createTempFile("out", "txt");
        tempOutputFile.deleteOnExit();
        String cmd = "/genome/bin/cross_match " + fastaFile.getAbsolutePath() + " " + backBone.getAbsolutePath();
        String data = OsHelper.excuteCommand(cmd);
        System.out.println(data);
        return data;
    }
}

