/*
 * Decompiled with CFR 0.152.
 */
package nmerCluster;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;
import nmerCluster.FastaReader;
import nmerCluster.NmerCluster;
import nmerCluster.RawReadPair;
import ruleset.Nmer;

public class SeparateByType {
    public static void main(String[] args) throws Exception {
        File typingFile = new File(args[0]);
        File clusterDir = new File(args[1]);
        File rulesetDir = new File(args[2]);
        File outputDir = new File(args[3]);
        Map<String, List<String>> types = SeparateByType.getSampleType(typingFile, clusterDir.getName());
        SeparateByType.separateByTypeReadsByType(types, clusterDir, rulesetDir, outputDir);
    }

    private static void separateByTypeReadsByType(Map<String, List<String>> types, File clusterDir, File rulesetDir, File outputDir) throws IOException {
        if (!outputDir.exists() || !outputDir.isDirectory()) {
            outputDir.mkdirs();
        }
        for (String locus : types.keySet()) {
            List<File> locusFastas = SeparateByType.getLocusFastas(clusterDir, locus);
            System.out.println(types.get(locus).toString());
            for (File locusFasta : locusFastas) {
                String[] n = locusFasta.getName().substring(0, locusFasta.getName().length() - 3).split("-");
                String exon = n[n.length - 1];
                String locusExon = String.valueOf(locus) + "-" + exon;
                File rulesetFile = new File(rulesetDir, String.valueOf(locusExon) + ".fa");
                System.out.println(rulesetFile.getName());
                String string = SeparateByType.separateByTypeForExon(types.get(locus), locusFasta, rulesetFile, outputDir, locusExon, clusterDir.getName(), locus);
            }
        }
    }

    private static String separateByTypeForExon(List<String> typeList, File locusFasta, File rulesetFile, File outputDir, String locusExon, String sampleName, String locus) throws IOException {
        StringBuilder builder = new StringBuilder();
        if (typeList.size() == 0) {
            return builder.toString();
        }
        if (typeList.size() == 1) {
            File file = SeparateByType.writeFileWithTypeName(typeList.get(0), locusFasta, outputDir, locusExon, sampleName);
            System.out.println("\tWrite Homo file " + file.getName());
            builder.append(locusExon).append("\t").append(file.getName()).append("\t").append(typeList.get(0)).append("\n");
            return builder.toString();
        }
        System.out.println("\tNeed separate file ");
        Map<String, String> sequences = SeparateByType.getSequences(rulesetFile, locus.startsWith("DRB") ? "DRB" : locus);
        Map<String, String> typeSequences = SeparateByType.loadTypeSequences(typeList, sequences);
        Map<String, String> uniqueSequences = SeparateByType.combineSameSequences(typeSequences);
        if (uniqueSequences.size() != 0) {
            if (uniqueSequences.size() == 1) {
                String type = null;
                Iterator<String> iterator = uniqueSequences.keySet().iterator();
                if (iterator.hasNext()) {
                    String name;
                    type = name = iterator.next();
                }
                File file = SeparateByType.writeFileWithTypeName(type, locusFasta, outputDir, locusExon, sampleName);
                System.out.println("\tWrite One file " + file.getName());
                builder.append(locusExon).append("\t").append(file.getName()).append("\t").append(type).append("\n");
                System.out.println(builder.toString());
                return builder.toString();
            }
            LinkedHashMap<String, List<Nmer>> clusterNmers = new LinkedHashMap<String, List<Nmer>>();
            SeparateByType.computeClusterNmers(locusExon, uniqueSequences, clusterNmers);
            SeparateByType.writeClusteredFile(clusterNmers, uniqueSequences, locusFasta, outputDir, locusExon, sampleName);
        }
        return builder.toString();
    }

    private static void writeClusteredFile(Map<String, List<Nmer>> clusterNmers, Map<String, String> uniqueSequences, File locusFasta, File outputDir, String locusExon, String sampleName) throws IOException {
        FastaReader fastaReader = new FastaReader();
        fastaReader.fastaRead(locusFasta);
        LinkedHashMap<String, List<RawReadPair>> destMap = new LinkedHashMap<String, List<RawReadPair>>();
        block0: for (RawReadPair pair : fastaReader.readPairList) {
            for (String type : clusterNmers.keySet()) {
                List<Nmer> nmers = clusterNmers.get(type);
                String nmerSeq1 = nmers.get(0).getSequence();
                String nmerSeq2 = nmers.get(nmers.size() - 1).getSequence();
                String sequenceA = pair.sequences[0];
                String sequenceB = pair.sequences[1];
                if (sequenceA.indexOf(nmerSeq1) > -1 || sequenceA.indexOf(NmerCluster.revComp(nmerSeq1)) > -1) {
                    SeparateByType.addToDestMap(type, destMap, pair);
                    continue block0;
                }
                if (sequenceB.indexOf(nmerSeq1) > -1 || sequenceB.indexOf(NmerCluster.revComp(nmerSeq1)) > -1) {
                    SeparateByType.addToDestMap(type, destMap, pair);
                    continue block0;
                }
                if (sequenceA.indexOf(nmerSeq2) > -1 || sequenceA.indexOf(NmerCluster.revComp(nmerSeq2)) > -1) {
                    SeparateByType.addToDestMap(type, destMap, pair);
                    continue block0;
                }
                if (sequenceB.indexOf(nmerSeq2) <= -1 && sequenceB.indexOf(NmerCluster.revComp(nmerSeq2)) <= -1) continue;
                SeparateByType.addToDestMap(type, destMap, pair);
                continue block0;
            }
        }
        System.out.println("Total read pairs=" + fastaReader.readPairList.size());
        for (String type : destMap.keySet()) {
            System.out.println("\t" + type + " " + ((List)destMap.get(type)).size());
        }
        System.out.println("outputDir=" + outputDir.getAbsolutePath() + " " + locusExon);
        SeparateByType.writeToFile(destMap, new File(outputDir, locusExon), sampleName);
    }

    private static void writeToFile(Map<String, List<RawReadPair>> destMap, File outputDir, String sampleName) throws IOException {
        if (!outputDir.exists() || !outputDir.isDirectory()) {
            outputDir.mkdirs();
        }
        for (String type : destMap.keySet()) {
            File fastaFile = new File(outputDir, String.valueOf(sampleName) + "-" + type.replace(",", "-") + ".fa");
            System.out.println(fastaFile.getName());
            BufferedWriter writer = new BufferedWriter(new FileWriter(fastaFile));
            List<RawReadPair> readPairList = destMap.get(type);
            Collections.shuffle(readPairList);
            for (RawReadPair readPair : readPairList) {
                writer.write(">" + readPair.id + "/1" + "\n");
                writer.write(String.valueOf(readPair.sequences[0]) + "\n");
                writer.write(">" + readPair.id + "/2" + "\n");
                writer.write(String.valueOf(readPair.sequences[1]) + "\n");
            }
            writer.flush();
            writer.close();
        }
    }

    private static void addToDestMap(String destinations, Map<String, List<RawReadPair>> destMap, RawReadPair pair) {
        if (!destMap.containsKey(destinations)) {
            destMap.put(destinations, new ArrayList());
        }
        destMap.get(destinations).add(pair);
    }

    private static void computeClusterNmers(String locusExon, Map<String, String> uniqueSequences, Map<String, List<Nmer>> clusterNmers) {
        List<Nmer> nMerList;
        String sequence;
        int offset = SeparateByType.getOffset(locusExon);
        ArrayList<String> coveredTypes = new ArrayList<String>();
        ArrayList<String> unCoveredTypes = new ArrayList<String>();
        for (String type : uniqueSequences.keySet()) {
            sequence = uniqueSequences.get(type);
            nMerList = SeparateByType.constructNmers(sequence, type, uniqueSequences, 30, offset, coveredTypes);
            if (nMerList.size() > 0) {
                coveredTypes.add(type);
                clusterNmers.put(type, nMerList);
                continue;
            }
            unCoveredTypes.add(type);
        }
        for (String type : unCoveredTypes) {
            sequence = uniqueSequences.get(type);
            nMerList = SeparateByType.constructNmers(sequence, type, uniqueSequences, 20, offset, coveredTypes);
            if (nMerList.size() > 0) {
                coveredTypes.add(type);
                clusterNmers.put(type, nMerList);
                continue;
            }
            System.out.println("give up " + type);
        }
    }

    private static int getOffset(String locusExon) {
        int offset = 0;
        if (locusExon.indexOf("A-bridge") > -1) {
            offset = 70;
        } else if (locusExon.indexOf("B-bridge") > -1 || locusExon.indexOf("C-bridge") > -1) {
            offset = 60;
        }
        return offset;
    }

    private static boolean findMatch(String nmer, Map<String, String> uniqueSequences) {
        for (String name : uniqueSequences.keySet()) {
            if (uniqueSequences.get(name).indexOf(nmer) <= -1) continue;
            return true;
        }
        return false;
    }

    private static List<Nmer> constructNmers(String sequence, String thisType, Map<String, String> allSequences, int nmerSize, int offset, List<String> coveredTypes) {
        ArrayList<Nmer> nMerList = new ArrayList<Nmer>();
        ArrayList<String> nMerSeq = new ArrayList<String>();
        int i = offset;
        while (i <= sequence.length() - nmerSize - offset) {
            Nmer nMer = new Nmer(sequence.substring(i, i + nmerSize), i + 1);
            if (nMer.getSequence().indexOf("X") < 0 && !nMerSeq.contains(nMer.getSequence()) && !SeparateByType.findMatch(nMer.getSequence(), SeparateByType.getOtherUniqueSequences(thisType, allSequences, coveredTypes))) {
                nMerList.add(nMer);
                nMerSeq.add(nMer.getSequence());
            }
            ++i;
        }
        System.out.println("nMerList.size()=" + nMerList.size());
        return nMerList;
    }

    private static Map<String, String> getOtherUniqueSequences(String thisType, Map<String, String> allSequences, List<String> coveredTypes) {
        LinkedHashMap<String, String> otherSequences = new LinkedHashMap<String, String>();
        for (String type : allSequences.keySet()) {
            if (thisType.equals(type) || coveredTypes.contains(type)) continue;
            otherSequences.put(type, allSequences.get(type));
        }
        return otherSequences;
    }

    private static Map<String, String> combineSameSequences(Map<String, String> typeSequences) {
        LinkedHashMap<String, String> uniquenceSequences = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> sequenceToName = new LinkedHashMap<String, String>();
        for (String type : typeSequences.keySet()) {
            String seq = typeSequences.get(type);
            if (seq.equals("?")) continue;
            if (sequenceToName.containsKey(seq)) {
                String collectionName = String.valueOf((String)sequenceToName.get(seq)) + "," + type;
                sequenceToName.put(seq, collectionName);
                continue;
            }
            sequenceToName.put(seq, type);
        }
        for (String seq : sequenceToName.keySet()) {
            uniquenceSequences.put((String)sequenceToName.get(seq), seq);
        }
        return uniquenceSequences;
    }

    private static Map<String, String> loadTypeSequences(List<String> typeList, Map<String, String> sequences) {
        LinkedHashMap<String, String> typeSequences = new LinkedHashMap<String, String>();
        for (String type : typeList) {
            for (String rulesetType : sequences.keySet()) {
                if (!rulesetType.startsWith(String.valueOf(type) + ":") && !rulesetType.equals(type)) continue;
                typeSequences.put(type, sequences.get(rulesetType));
                System.out.println(String.valueOf(type) + " -> " + rulesetType);
                break;
            }
            if (typeSequences.containsKey(type)) continue;
            if (type.startsWith("DRB4*01:03")) {
                typeSequences.put(type, sequences.get("DRB4*01:03:01:01"));
                System.out.println(String.valueOf(type) + " -> " + "DRB4*01:03:01:01");
                continue;
            }
            typeSequences.put(type, "?");
            System.out.println(String.valueOf(type) + " -> " + "?");
        }
        return typeSequences;
    }

    private static Map<String, String> getSequences(File fastaFile, String header) {
        LinkedHashMap<String, String> sequences = new LinkedHashMap<String, String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">" + header)) {
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                sequences.put(name, sequence);
            }
            ++i;
        }
        return sequences;
    }

    private static File writeFileWithTypeName(String type, File locusFasta, File outputDir, String locusExon, String sampleName) {
        File outputLocusExonDir = new File(outputDir, locusExon);
        if (!outputLocusExonDir.exists() || !outputLocusExonDir.isDirectory()) {
            outputLocusExonDir.mkdirs();
        }
        String fileName = SeparateByType.constructName(type, sampleName);
        File newFile = new File(outputLocusExonDir, String.valueOf(fileName) + ".fa");
        FileManager.copyFile(locusFasta, newFile, true);
        return newFile;
    }

    private static String constructName(String type, String sampleName) {
        String[] items = type.split(":");
        return String.valueOf(sampleName) + "-" + items[0];
    }

    private static List<File> getLocusFastas(File clusterDir, String locus) {
        File[] files;
        ArrayList<File> locusFastas = new ArrayList<File>();
        File[] fileArray = files = clusterDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().startsWith(String.valueOf(clusterDir.getName()) + "-" + locus) && file.getName().endsWith("fa")) {
                locusFastas.add(file);
            }
            ++n2;
        }
        return locusFastas;
    }

    private static Map<String, List<String>> getSampleType(File typingFile, String sampleName) {
        String[] lines;
        LinkedHashMap<String, List<String>> types = new LinkedHashMap<String, List<String>>();
        String[] stringArray = lines = FileManager.readTextFile(typingFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            String line = stringArray[n2];
            String[] items = line.trim().split("\t");
            if (items.length >= 4 && (name = items[0].trim()).equals(sampleName)) {
                String locus = items[1].trim();
                if (locus.startsWith("DRB")) {
                    locus = "DRB1";
                }
                if (!types.containsKey(locus)) {
                    types.put(locus, new ArrayList());
                }
                if (items[2].trim().indexOf("Not_Present") < 0) {
                    ((List)types.get(locus)).add(items[2].trim());
                }
                if (!items[2].trim().equals(items[3].trim()) && items[3].trim().indexOf("Not_Present") < 0) {
                    ((List)types.get(locus)).add(items[3].trim());
                }
            }
            ++n2;
        }
        return types;
    }
}

