/*
 * Decompiled with CFR 0.152.
 */
package newRuleset;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class GenerateMICAbridge45 {
    public static void main(String[] args) throws Exception {
        File input = new File(args[0]);
        File output = new File(args[1]);
        String header = args[2];
        File exon4 = new File(input, String.valueOf(header) + "-exon4.fa");
        File exon5 = new File(input, String.valueOf(header) + "-exon5.fa");
        File bridge45 = new File(output, String.valueOf(header) + "-bridge45.fa");
        Map<String, String> seq4 = GenerateMICAbridge45.getSequences(exon4);
        Map<String, String> seq5 = GenerateMICAbridge45.getSequences(exon5);
        LinkedHashMap<String, String> seq45 = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> bridgeSeq45 = new LinkedHashMap<String, String>();
        GenerateMICAbridge45.combineAndCutSequences(seq4, seq5, seq45, bridgeSeq45);
        GenerateMICAbridge45.writeFastaOutput(bridgeSeq45, bridge45);
    }

    private static void writeFastaOutput(Map<String, String> seq, File outfile) {
        StringBuilder sb = new StringBuilder();
        for (String name : seq.keySet()) {
            sb.append(">").append(name).append("\n");
            sb.append(seq.get(name)).append("\n");
        }
        FileManager.writeTextFile(outfile, sb.toString(), true);
    }

    private static void combineAndCutSequences(Map<String, String> seq4, Map<String, String> seq5, Map<String, String> seq45, Map<String, String> bridgeSeq45) {
        int standardLen = 0;
        for (String name : seq4.keySet()) {
            if (name.indexOf("sudo") > 0 || !seq5.containsKey(name)) continue;
            if (standardLen == 0) {
                standardLen = seq4.get(name).length();
            }
            seq45.put(name, String.valueOf(seq4.get(name)) + seq5.get(name));
            int end = 65;
            if (seq4.get(name).length() < standardLen) {
                System.out.println(String.valueOf(name) + " " + (end -= standardLen - seq4.get(name).length()));
            }
            bridgeSeq45.put(name, String.valueOf(seq4.get(name).substring(27, seq4.get(name).length() - end)) + "XXXXXXXXXX" + seq5.get(name).substring(0, seq5.get(name).length() - 32));
        }
    }

    private static Map<String, String> getSequences(File fastaFile) {
        LinkedHashMap<String, String> sequences = new LinkedHashMap<String, String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">")) {
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                sequences.put(name, sequence);
            }
            ++i;
        }
        return sequences;
    }

    private static void outputAmb(Map<String, String> seq, File outfile) {
        StringBuilder sb = new StringBuilder();
        LinkedHashMap seqName = new LinkedHashMap();
        for (String name : seq.keySet()) {
            if (!seqName.containsKey(seq.get(name))) {
                seqName.put(seq.get(name), new ArrayList());
            }
            ((List)seqName.get(seq.get(name))).add(name);
        }
        for (String sequence : seqName.keySet()) {
            if (((List)seqName.get(sequence)).size() <= 1) continue;
            sb.append(GenerateMICAbridge45.createOutput((List)seqName.get(sequence))).append("\n");
        }
        FileManager.writeTextFile(outfile, sb.toString(), true);
    }

    private static String createOutput(List<String> list) {
        String out = String.valueOf(list.get(0)) + "R";
        for (String n : list) {
            out = String.valueOf(out) + "\t" + n;
        }
        return out;
    }
}

