/*
 * Decompiled with CFR 0.152.
 */
package newRuleset;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class GenerateMICAbridge23 {
    public static void main(String[] args) throws Exception {
        File input = new File(args[0]);
        File output = new File(args[1]);
        String header = args[2];
        File exon2 = new File(input, String.valueOf(header) + "-exon2.fa");
        File exon3 = new File(input, String.valueOf(header) + "-exon3.fa");
        File bridge23 = new File(output, String.valueOf(header) + "-bridge23.fa");
        File bridge23amb = new File(output, String.valueOf(header) + "-bridge23-hap-amb.txt");
        Map<String, String> seq2 = GenerateMICAbridge23.getSequences(exon2);
        Map<String, String> seq3 = GenerateMICAbridge23.getSequences(exon3);
        LinkedHashMap<String, String> seq23 = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> bridgeSeq23 = new LinkedHashMap<String, String>();
        GenerateMICAbridge23.combineAndCutSequences(seq2, seq3, seq23, bridgeSeq23);
        GenerateMICAbridge23.writeFastaOutput(bridgeSeq23, bridge23);
    }

    private static void writeFastaOutput(Map<String, String> seq, File outfile) {
        StringBuilder sb = new StringBuilder();
        for (String name : seq.keySet()) {
            sb.append(">").append(name).append("\n");
            sb.append(seq.get(name)).append("\n");
        }
        FileManager.writeTextFile(outfile, sb.toString(), true);
    }

    private static void combineAndCutSequences(Map<String, String> seq2, Map<String, String> seq3, Map<String, String> seq23, Map<String, String> bridgeSeq23) {
        for (String name : seq2.keySet()) {
            if (name.indexOf("sudo") > 0) continue;
            seq23.put(name, String.valueOf(seq2.get(name)) + seq3.get(name));
            bridgeSeq23.put(name, String.valueOf(seq2.get(name).substring(67)) + "XXXXXXXXXX" + seq3.get(name).substring(0, seq3.get(name).length() - 159));
        }
    }

    private static Map<String, String> getSequences(File fastaFile) {
        LinkedHashMap<String, String> sequences = new LinkedHashMap<String, String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">")) {
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                sequences.put(name, sequence);
            }
            ++i;
        }
        return sequences;
    }

    private static void outputAmb(Map<String, String> seq, File outfile) {
        StringBuilder sb = new StringBuilder();
        LinkedHashMap seqName = new LinkedHashMap();
        for (String name : seq.keySet()) {
            if (!seqName.containsKey(seq.get(name))) {
                seqName.put(seq.get(name), new ArrayList());
            }
            ((List)seqName.get(seq.get(name))).add(name);
        }
        for (String sequence : seqName.keySet()) {
            if (((List)seqName.get(sequence)).size() <= 1) continue;
            sb.append(GenerateMICAbridge23.createOutput((List)seqName.get(sequence))).append("\n");
        }
        FileManager.writeTextFile(outfile, sb.toString(), true);
    }

    private static String createOutput(List<String> list) {
        String out = String.valueOf(list.get(0)) + "R";
        for (String n : list) {
            out = String.valueOf(out) + "\t" + n;
        }
        return out;
    }
}

