/*
 * Decompiled with CFR 0.152.
 */
package newRuleset;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import misc.FileManager;
import newRuleset.ExtractFastaAllExonAllGene;

public class GenerateExon67 {
    public static void main(String[] args) throws Exception {
        File input = new File(args[0]);
        File output = new File(args[1]);
        String header = args[2];
        File padFile = new File(args[3]);
        File exon6 = new File(input, String.valueOf(header) + "-exon6.fa");
        File exon7 = new File(input, String.valueOf(header) + "-exon7.fa");
        File exon67 = new File(output, String.valueOf(header) + "-exon67.fa");
        Map<String, Map<String, String>> pad = ExtractFastaAllExonAllGene.getPadInfo(padFile);
        Map<String, String> seq6 = GenerateExon67.getSequences(exon6);
        Map<String, String> seq7 = GenerateExon67.getSequences(exon7);
        LinkedHashMap<String, String> seq67 = new LinkedHashMap<String, String>();
        GenerateExon67.combineAndCutSequences(seq6, seq7, seq67, pad);
        GenerateExon67.writeFastaOutput(seq67, exon67);
    }

    private static void writeFastaOutput(Map<String, String> seq, File outfile) {
        StringBuilder sb = new StringBuilder();
        for (String name : seq.keySet()) {
            sb.append(">").append(name).append("\n");
            sb.append(seq.get(name)).append("\n");
        }
        FileManager.writeTextFile(outfile, sb.toString(), true);
        System.out.println(outfile.getAbsolutePath());
    }

    private static void combineAndCutSequences(Map<String, String> seq6, Map<String, String> seq7, Map<String, String> seq67, Map<String, Map<String, String>> pad) {
        System.out.println("No exon 7: ");
        for (String name : seq6.keySet()) {
            if (name.indexOf("sudo") > 0) continue;
            if (seq7.containsKey(name)) {
                seq67.put(name, String.valueOf(seq6.get(name)) + "XXXXXXXXXX" + seq7.get(name));
                continue;
            }
            if (pad.containsKey(name) && seq7.containsKey(pad.get(name).get("7"))) {
                seq67.put(name, String.valueOf(seq6.get(name)) + "XXXXXXXXXX" + seq7.get(pad.get(name).get("7")));
                continue;
            }
            System.out.println(name);
        }
    }

    private static Map<String, String> getSequences(File fastaFile) {
        LinkedHashMap<String, String> sequences = new LinkedHashMap<String, String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">")) {
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                sequences.put(name, sequence);
            }
            ++i;
        }
        return sequences;
    }
}

