/*
 * Decompiled with CFR 0.152.
 */
package newRuleset;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;
import newRuleset.GenerateACbridge68;

public class GenerateDPB1bridge45 {
    public static void main(String[] args) throws Exception {
        File exon4 = new File(args[0]);
        File exon5 = new File(args[1]);
        File intron4 = new File(args[2]);
        File output = new File(args[3]);
        String header = args[4];
        File exon45 = new File(output, String.valueOf(header) + "-bridge45.fa");
        Map<String, String> seq4 = GenerateDPB1bridge45.getSequences(exon4);
        Map<String, String> seq5 = GenerateDPB1bridge45.getSequences(exon5);
        Map<String, String> intron4seq = GenerateDPB1bridge45.getSequences(intron4);
        LinkedHashMap<String, String> seq45 = new LinkedHashMap<String, String>();
        GenerateDPB1bridge45.combineAndCutSequences(seq4, seq5, intron4seq, seq45, header);
        GenerateDPB1bridge45.writeFastaOutput(seq45, exon45);
    }

    private static void writeFastaOutput(Map<String, String> seq, File outfile) {
        StringBuilder sb = new StringBuilder();
        for (String name : seq.keySet()) {
            sb.append(">").append(name).append("\n");
            if (seq.get(name).indexOf("*") >= 0) {
                System.out.println(String.valueOf(name) + " contains unknown char ");
            }
            sb.append(seq.get(name)).append("\n");
        }
        FileManager.writeTextFile(outfile, sb.toString(), true);
        System.out.println(outfile.getAbsolutePath());
    }

    private static void combineAndCutSequences(Map<String, String> seq4, Map<String, String> seq5, Map<String, String> intron4, Map<String, String> seq45, String header) {
        for (String name : seq5.keySet()) {
            if (seq4.containsKey(name) && intron4.containsKey(name)) {
                seq45.put(name, GenerateDPB1bridge45.customTrim(seq4.get(name), intron4.get(name), seq5.get(name), header));
                continue;
            }
            if (seq4.containsKey(name)) {
                seq45.put(name, GenerateDPB1bridge45.customTrim(seq4.get(name), GenerateDPB1bridge45.getIntronPadding(name, intron4), seq5.get(name), header));
                continue;
            }
            if (!intron4.containsKey(name)) {
                System.out.println("No intron " + name);
                continue;
            }
            if (seq4.containsKey(name)) continue;
            System.out.println(name);
        }
    }

    private static String customTrim(String seq4, String intron4, String exon5, String header) {
        String left = null;
        String right = null;
        if (header.equals("DPB1")) {
            left = String.valueOf(seq4) + intron4.substring(0, 62);
            right = String.valueOf(intron4.substring(intron4.length() - 204, intron4.length())) + exon5;
        } else if (header.equals("DQB1")) {
            left = intron4.substring(15, 238);
            right = String.valueOf(intron4.substring(intron4.length() - 152, intron4.length())) + exon5;
        }
        return String.valueOf(left) + "XXXXXXXXXX" + right;
    }

    private static String getIntronPadding(String name, Map<String, String> intron4) {
        String paddName = GenerateACbridge68.getClosestPaddingAllele(name, intron4);
        if (paddName != null) {
            System.out.println(String.valueOf(name) + " -> " + paddName);
            return intron4.get(paddName);
        }
        String baseElements = name.split(":")[0];
        if (baseElements.length() >= 6) {
            baseElements = baseElements.substring(0, baseElements.length() - 1);
        }
        for (String type : intron4.keySet()) {
            String thisBaseElements = type.split(":")[0];
            if (!baseElements.equals(thisBaseElements = thisBaseElements.substring(0, thisBaseElements.length() - 1))) continue;
            System.out.println(String.valueOf(name) + " -> " + type);
            return intron4.get(type);
        }
        Iterator<String> iterator = intron4.keySet().iterator();
        if (iterator.hasNext()) {
            String type;
            type = iterator.next();
            System.out.println(String.valueOf(name) + " -> " + type);
            return intron4.get(type);
        }
        System.out.println("!!!!!!! No close memeber for " + name);
        return null;
    }

    public static String getClosestPaddingAllele(String alleleName, Map<String, String> allSeq) {
        String[] nameElements = alleleName.split(":");
        int fieldCount = 1;
        while (fieldCount < nameElements.length) {
            String searchName = "";
            int i = 0;
            while (i < nameElements.length - fieldCount) {
                searchName = searchName.length() > 0 ? String.valueOf(searchName) + ":" + nameElements[i] : nameElements[i];
                ++i;
            }
            for (String type : allSeq.keySet()) {
                String seq;
                if (!type.startsWith(String.valueOf(searchName) + ":") || (seq = allSeq.get(type)).indexOf("*") >= 0) continue;
                return type;
            }
            ++fieldCount;
        }
        return null;
    }

    private static Map<String, String> getSequences(File fastaFile) {
        LinkedHashMap<String, String> sequences = new LinkedHashMap<String, String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">")) {
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                sequences.put(name, sequence);
            }
            ++i;
        }
        return sequences;
    }

    private static void outputAmb(Map<String, String> seq, File outfile) {
        StringBuilder sb = new StringBuilder();
        LinkedHashMap seqName = new LinkedHashMap();
        for (String name : seq.keySet()) {
            if (!seqName.containsKey(seq.get(name))) {
                seqName.put(seq.get(name), new ArrayList());
            }
            ((List)seqName.get(seq.get(name))).add(name);
        }
        for (String sequence : seqName.keySet()) {
            if (((List)seqName.get(sequence)).size() <= 1) continue;
            sb.append(GenerateDPB1bridge45.createOutput((List)seqName.get(sequence))).append("\n");
        }
        FileManager.writeTextFile(outfile, sb.toString(), true);
    }

    private static String createOutput(List<String> list) {
        String out = String.valueOf(list.get(0)) + "R";
        for (String n : list) {
            out = String.valueOf(out) + "\t" + n;
        }
        return out;
    }
}

