/*
 * Decompiled with CFR 0.152.
 */
package newRuleset;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;
import newRuleset.Tools;

public class ExtractFullSeqFromAlignmentFile {
    public static final String[] LOCUS_NAMES = new String[]{"A", "B", "C", "DPA1", "DPB1", "DQA1", "DQB1", "DRB"};
    public static final String CDNA_File_END = "_nuc.txt";
    public static final String PROTEIN_File_END = "_prot.txt";
    public static final boolean FILL_UNKNOWN = false;

    public static void main(String[] args) throws Exception {
        File[] files;
        File inputDir = new File(args[0]);
        File outputDir = new File(args[1]);
        boolean keepPadding = new Boolean(args[2]);
        LinkedHashMap<String, Map<String, String>> paddingInfo = new LinkedHashMap<String, Map<String, String>>();
        File[] fileArray = files = inputDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File input = fileArray[n2];
            if (input.getName().endsWith(CDNA_File_END)) {
                String locusName = ExtractFullSeqFromAlignmentFile.createLocusName(input.getName(), CDNA_File_END);
                if (Arrays.asList(LOCUS_NAMES).contains(locusName)) {
                    System.out.println("Process " + input.getName());
                    LinkedHashMap<String, String> seq = new LinkedHashMap<String, String>();
                    Tools.loadAllSequence(input, locusName, seq);
                    Map<String, String> translatedSeq = ExtractFullSeqFromAlignmentFile.translateSequences(seq);
                    Map<String, String> anchorSeqMap = ExtractFullSeqFromAlignmentFile.initAnchorSeq();
                    Map<String, String> unknownFilledSeq = ExtractFullSeqFromAlignmentFile.padUnknown(translatedSeq, paddingInfo, anchorSeqMap, locusName);
                    File proteinFile = new File(inputDir, String.valueOf(locusName) + PROTEIN_File_END);
                    LinkedHashMap<String, String> proteinSeq = new LinkedHashMap<String, String>();
                    Tools.loadAllSequence(proteinFile, locusName, proteinSeq);
                    Map<String, String> translatedProteinSeq = ExtractFullSeqFromAlignmentFile.translateSequences(proteinSeq);
                    Map<String, String> proteinAnchorSeqMap = ExtractFullSeqFromAlignmentFile.initAnchorSeq();
                    Map<String, String> proteinUnknownFilledSeq = ExtractFullSeqFromAlignmentFile.padUnknownBasedOnMap(translatedProteinSeq, paddingInfo, proteinAnchorSeqMap, locusName, unknownFilledSeq);
                    ExtractFullSeqFromAlignmentFile.writeCdnaFiles(translatedSeq, outputDir, locusName, keepPadding);
                    ExtractFullSeqFromAlignmentFile.writeProteinFiles(translatedProteinSeq, outputDir, locusName, keepPadding);
                }
            }
            ++n2;
        }
    }

    private static void writeProteinFiles(Map<String, String> paddedSeq, File outputDir, String locusName, boolean keepPadding) {
        if (keepPadding) {
            ExtractFullSeqFromAlignmentFile.writeSeqFiles(paddedSeq, new File(outputDir, String.valueOf(locusName) + "_prot.fa"), locusName, true);
        } else {
            ExtractFullSeqFromAlignmentFile.writeSeqFiles(paddedSeq, new File(outputDir, String.valueOf(locusName) + "_prot.fa"), locusName, false);
        }
    }

    private static void writeCdnaFiles(Map<String, String> paddedSeq, File outputDir, String locusName, boolean keepPadding) {
        if (keepPadding) {
            ExtractFullSeqFromAlignmentFile.writeSeqFiles(paddedSeq, new File(outputDir, String.valueOf(locusName) + "_nuc.fa"), locusName, true);
        } else {
            ExtractFullSeqFromAlignmentFile.writeSeqFiles(paddedSeq, new File(outputDir, String.valueOf(locusName) + "_nuc.fa"), locusName, false);
        }
    }

    private static void writePaddingInfo(Map<String, Map<String, String>> paddingInfo, File outputDir) {
        StringBuilder paddingLog = new StringBuilder();
        paddingLog.append("AlleleName").append("\t").append("Exon").append("\t").append("PadUnknownBaseWithClosestAllele").append("\n");
        for (String name : paddingInfo.keySet()) {
            Map<String, String> exonPadding = paddingInfo.get(name);
            for (String exon : exonPadding.keySet()) {
                paddingLog.append(name).append("\t").append(exon).append("\t").append(exonPadding.get(exon)).append("\n");
            }
        }
        FileManager.writeTextFile(new File(outputDir, "unknownPaddingLog.txt"), paddingLog.toString(), true);
    }

    private static Map<String, String> initAnchorSeq() {
        HashMap<String, String> anchorSeqMap = new HashMap<String, String>();
        anchorSeqMap.put("A", "A*01:01:01:01");
        anchorSeqMap.put("B", "B*07:02:01:01");
        anchorSeqMap.put("C", "C*01:02:01:01");
        anchorSeqMap.put("DPA1", "DPA1*01:03:01:01");
        anchorSeqMap.put("DPB1", "DPB1*01:01:01:01");
        anchorSeqMap.put("DQA1", "DQA1*01:01:01:01");
        anchorSeqMap.put("DQB1", "DQB1*05:01:01:01");
        anchorSeqMap.put("DRB", "DRB1*01:01:01:01");
        return anchorSeqMap;
    }

    private static void writeSeqFiles(Map<String, String> seq, File output, String locusName, boolean keepPadding) {
        StringBuilder builder = new StringBuilder();
        for (String name : seq.keySet()) {
            builder.append(">").append(name).append("\n");
            String sequence = seq.get(name).replaceAll("\\|", "");
            if (!keepPadding) {
                builder.append(sequence.replaceAll("\\.", "")).append("\n");
                continue;
            }
            builder.append(sequence).append("\n");
        }
        FileManager.writeTextFile(output, builder.toString(), true);
    }

    private static Map<String, String> padUnknown(Map<String, String> translatedSeq, Map<String, Map<String, String>> paddingInfo, Map<String, String> anchorSeqMap, String locusName) {
        LinkedHashMap<String, String> paddedSeq = new LinkedHashMap<String, String>();
        for (String name : translatedSeq.keySet()) {
            String s = translatedSeq.get(name);
            if (s.indexOf("*") >= 0) {
                paddingInfo.put(name, new LinkedHashMap());
                String newseq = "";
                String[] exonSequences = s.split("\\|");
                int i = 0;
                while (i < exonSequences.length) {
                    if (exonSequences[i].indexOf("*") < 0) {
                        newseq = String.valueOf(newseq) + exonSequences[i];
                    } else {
                        String closestAllele = ExtractFullSeqFromAlignmentFile.getClosestPaddingAllele(name, translatedSeq, i);
                        if (closestAllele == null) {
                            closestAllele = anchorSeqMap.get(locusName);
                        }
                        paddingInfo.get(name).put(String.valueOf(i + 1), closestAllele);
                        int j = 0;
                        while (j < exonSequences[i].length()) {
                            char c = exonSequences[i].charAt(j);
                            if (c == '*') {
                                char padChar;
                                c = padChar = ExtractFullSeqFromAlignmentFile.getPadChar(translatedSeq.get(closestAllele), i, j);
                            }
                            newseq = String.valueOf(newseq) + c;
                            ++j;
                        }
                    }
                    if (i < exonSequences.length - 1) {
                        newseq = String.valueOf(newseq) + "|";
                    }
                    ++i;
                }
                paddedSeq.put(name, newseq);
            } else {
                paddedSeq.put(name, s);
            }
            if (((String)paddedSeq.get(name)).length() == translatedSeq.get(anchorSeqMap.get(locusName)).length()) continue;
            System.out.println("diff cdna length " + name + " " + ((String)paddedSeq.get(name)).length());
        }
        return paddedSeq;
    }

    private static Map<String, String> padUnknownBasedOnMap(Map<String, String> translatedSeq, Map<String, Map<String, String>> paddingInfo, Map<String, String> anchorSeqMap, String locusName, Map<String, String> cdnaPaddedSeq) {
        LinkedHashMap<String, String> paddedSeq = new LinkedHashMap<String, String>();
        for (String name : translatedSeq.keySet()) {
            String s = translatedSeq.get(name);
            if (s.indexOf("*") >= 0) {
                String newseq = "";
                Map<String, String> exonsPadding = paddingInfo.get(name);
                int j = 0;
                while (j < s.length()) {
                    char c = s.charAt(j);
                    if (c == '*') {
                        char padChar;
                        List<String> paddingAlleles = ExtractFullSeqFromAlignmentFile.getAllPaddingAllele(s, exonsPadding, cdnaPaddedSeq.get(name));
                        String paddingAlleleForExon = ExtractFullSeqFromAlignmentFile.getPaddingAlleleForExon(s, exonsPadding, cdnaPaddedSeq.get(name), name, j);
                        c = padChar = ExtractFullSeqFromAlignmentFile.choosePaddingChar(paddingAlleles, translatedSeq, j, name, paddingAlleleForExon);
                    }
                    newseq = String.valueOf(newseq) + c;
                    ++j;
                }
                paddedSeq.put(name, newseq);
            } else {
                paddedSeq.put(name, s);
            }
            if (((String)paddedSeq.get(name)).length() < translatedSeq.get(anchorSeqMap.get(locusName)).length()) {
                String newSeq = (String)paddedSeq.get(name);
                int i = 0;
                while (i < translatedSeq.get(anchorSeqMap.get(locusName)).length() - ((String)paddedSeq.get(name)).length()) {
                    newSeq = String.valueOf(newSeq) + ".";
                    ++i;
                }
                paddedSeq.put(name, newSeq);
            }
            if (((String)paddedSeq.get(name)).length() == translatedSeq.get(anchorSeqMap.get(locusName)).length()) continue;
            System.out.println("diff protein length " + name + " " + ((String)paddedSeq.get(name)).length());
        }
        return paddedSeq;
    }

    private static char choosePaddingChar(List<String> paddingAlleles, Map<String, String> translatedSeq, int index, String aname, String paddingAlleleForExon) {
        char padChar = '*';
        boolean consistant = true;
        for (String name : paddingAlleles) {
            char thisChar = translatedSeq.get(name).charAt(index);
            if (thisChar == '*') continue;
            if (padChar == '*') {
                padChar = thisChar;
                continue;
            }
            if (padChar == thisChar) continue;
            System.out.println(String.valueOf(aname) + " different padding info " + padChar + " " + thisChar + " at " + index);
            System.out.println(paddingAlleles.toString());
            consistant = false;
        }
        if (!consistant) {
            System.out.println(String.valueOf(paddingAlleleForExon) + " " + index);
            return translatedSeq.get(paddingAlleleForExon).charAt(index);
        }
        return padChar;
    }

    private static List<String> getAllPaddingAllele(String proteinSeq, Map<String, String> exonsPadding, String cdnaSeq) {
        ArrayList<String> alleles = new ArrayList<String>();
        for (String name : exonsPadding.values()) {
            if (alleles.contains(name)) continue;
            alleles.add(name);
        }
        return alleles;
    }

    private static String getPaddingAlleleForExon(String proteinSeq, Map<String, String> exonsPadding, String cdnaSeq, String aname, int position) {
        int cleanedProteinPosition = proteinSeq.substring(0, position).replaceAll("\\|", "").replaceAll("\\.", "").length() + 1;
        String[] exonSeqs = cdnaSeq.split("\\|");
        int counter = 1;
        int index = 0;
        String[] stringArray = exonSeqs;
        int n = exonSeqs.length;
        int n2 = 0;
        while (n2 < n) {
            String exonSeq = stringArray[n2];
            if ((index += exonSeq.replaceAll("\\|", "").replaceAll("\\.", "").length()) > cleanedProteinPosition * 3) break;
            ++counter;
            ++n2;
        }
        return exonsPadding.get(String.valueOf(counter));
    }

    private static char getPadChar(String paddingSeq, int exon, int index) {
        String[] exons = paddingSeq.split("\\|");
        return exons[exon].charAt(index);
    }

    public static String getClosestPaddingAllele(String alleleName, Map<String, String> allSeq, int exonIndex) {
        String[] nameElements = alleleName.split(":");
        String baseName = alleleName.split(":")[0];
        int fieldCount = 1;
        while (fieldCount < nameElements.length) {
            String searchName = "";
            int i = 0;
            while (i < nameElements.length - fieldCount) {
                searchName = searchName.length() > 0 ? String.valueOf(searchName) + ":" + nameElements[i] : nameElements[i];
                ++i;
            }
            for (String type : allSeq.keySet()) {
                String seq;
                String exonSeq;
                if (!type.startsWith(String.valueOf(searchName) + ":") || (exonSeq = (seq = allSeq.get(type)).split("\\|")[exonIndex]).indexOf("*") >= 0) continue;
                return type;
            }
            ++fieldCount;
        }
        return null;
    }

    public static Map<String, String> translateSequences(Map<String, String> seqs) {
        LinkedHashMap<String, String> actualSeq = new LinkedHashMap<String, String>();
        String headerSeq = "";
        String anchorType = "";
        for (String type : seqs.keySet()) {
            String seq = seqs.get(type);
            if (seq.startsWith("-")) continue;
            headerSeq = seq;
            anchorType = type;
            break;
        }
        for (String type : seqs.keySet()) {
            if (type.equals(anchorType)) {
                actualSeq.put(type, headerSeq);
                continue;
            }
            String rawSeq = seqs.get(type);
            String translatedSeq = "";
            int i = 0;
            while (i < headerSeq.length()) {
                if (i >= rawSeq.length()) break;
                translatedSeq = rawSeq.charAt(i) == '-' ? String.valueOf(translatedSeq) + headerSeq.charAt(i) : String.valueOf(translatedSeq) + rawSeq.charAt(i);
                ++i;
            }
            actualSeq.put(type, translatedSeq);
        }
        return actualSeq;
    }

    private static Map<String, String> getPadInfo(String[] data) {
        LinkedHashMap<String, String> pad = new LinkedHashMap<String, String>();
        String[] stringArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() == 0) break;
            String[] items = line.trim().split("\\s+");
            pad.put(items[0].trim(), items[1].trim());
            ++n2;
        }
        return pad;
    }

    private static String createLocusName(String name, String end) {
        return name.replace(end, "").toUpperCase();
    }
}

