/*
 * Decompiled with CFR 0.152.
 */
package newRuleset;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import misc.FileManager;
import newRuleset.ExtractFullSeqFromAlignmentFile;
import newRuleset.Tools;

public class ExtractFastaAllIntronExonAllGene {
    private static final String EXT = "_gen.txt";

    public static void main(String[] args) throws Exception {
        File[] files;
        File inputDir = new File(args[0]);
        File outputDir = new File(args[1]);
        File[] fileArray = files = inputDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File input = fileArray[n2];
            if (input.getName().endsWith(EXT)) {
                System.out.println("process " + input.getName());
                String gene = input.getName().replace(EXT, "");
                LinkedHashMap<String, String> seq = new LinkedHashMap<String, String>();
                Tools.loadAllSequence(input, gene, seq);
                Map<String, String> translatedSeq = ExtractFullSeqFromAlignmentFile.translateSequences(seq);
                ExtractFastaAllIntronExonAllGene.generateExonSeqenceFiles(translatedSeq, outputDir, gene);
            }
            ++n2;
        }
    }

    private static void generateExonSeqenceFiles(Map<String, String> translatedSeq, File outputDir, String header) {
        String headerSeq = "";
        Iterator<String> iterator = translatedSeq.keySet().iterator();
        if (iterator.hasNext()) {
            String seq;
            String type = iterator.next();
            headerSeq = seq = translatedSeq.get(type);
            System.out.println("set Header " + type);
        }
        int exonIntronCount = headerSeq.split("\\|").length;
        int exonCount = 0;
        int fieldNumber = 0;
        while (fieldNumber < exonIntronCount) {
            String regionName = "";
            if (fieldNumber == 0) {
                regionName = "5UTR";
            } else if (fieldNumber == exonIntronCount - 1) {
                regionName = "3UTR";
            } else if (fieldNumber % 2 == 1) {
                regionName = "exon" + (exonCount + 1);
            } else if (fieldNumber % 2 == 0) {
                regionName = "intron" + (exonCount + 1);
                ++exonCount;
            }
            ExtractFastaAllIntronExonAllGene.writeFastaFile(translatedSeq, outputDir, header, regionName, fieldNumber);
            ++fieldNumber;
        }
    }

    private static void writeFastaFile(Map<String, String> actualSeqs, File outputDir, String header, String regionName, int fieldNumber) {
        File exonFa = new File(outputDir, String.valueOf(header) + "-" + regionName + ".fa");
        StringBuilder builder = new StringBuilder();
        for (String name : actualSeqs.keySet()) {
            if (actualSeqs.get(name).split("\\|").length <= fieldNumber) {
                System.out.println(String.valueOf(name) + " not exist exon " + fieldNumber);
                System.out.println(actualSeqs.get(name));
            }
            String s = actualSeqs.get(name).split("\\|")[fieldNumber].replaceAll("\\.", "");
            builder.append(">").append(name).append("\n");
            builder.append(s).append("\n");
        }
        FileManager.writeTextFile(exonFa, builder.toString(), true);
    }
}

