/*
 * Decompiled with CFR 0.152.
 */
package newRuleset;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import misc.FileManager;
import newRuleset.ExtractFullSeqFromAlignmentFile;
import newRuleset.Tools;

public class ExtractFastaAllExonAllGene {
    private static final String EXT = "_nuc.txt";

    public static void main(String[] args) throws Exception {
        File[] files;
        File inputDir = new File(args[0]);
        File outputDir = new File(args[1]);
        File padFile = new File(args[2]);
        File[] fileArray = files = inputDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File input = fileArray[n2];
            if (input.getName().endsWith(EXT)) {
                String gene = input.getName().replace(EXT, "");
                LinkedHashMap<String, String> seq = new LinkedHashMap<String, String>();
                Map<String, Map<String, String>> pad = ExtractFastaAllExonAllGene.getPadInfo(padFile);
                Tools.loadAllSequence(input, gene, seq);
                Map<String, String> translatedSeq = ExtractFullSeqFromAlignmentFile.translateSequences(seq);
                ExtractFastaAllExonAllGene.generateExonSeqenceFiles(translatedSeq, outputDir, pad, gene);
            }
            ++n2;
        }
    }

    private static void generateExonSeqenceFiles(Map<String, String> translatedSeq, File outputDir, Map<String, Map<String, String>> pad, String header) {
        String headerSeq = "";
        for (String type : translatedSeq.keySet()) {
            String seq = translatedSeq.get(type);
            if (seq.startsWith("-") || seq.startsWith("*")) continue;
            headerSeq = seq;
            break;
        }
        int exonCount = headerSeq.split("\\|").length;
        int exonNumber = 0;
        while (exonNumber < exonCount) {
            ExtractFastaAllExonAllGene.writeExonFastaFile(translatedSeq, outputDir, pad, header, exonNumber);
            ++exonNumber;
        }
    }

    private static void writeExonFastaFile(Map<String, String> actualSeqs, File outputDir, Map<String, Map<String, String>> pad, String header, int exonNumber) {
        File exonFa = new File(outputDir, String.valueOf(header) + "-exon" + (exonNumber + 1) + ".fa");
        StringBuilder builder = new StringBuilder();
        System.out.println("----- contains N in exon" + (exonNumber + 1) + " " + header);
        for (String name : actualSeqs.keySet()) {
            String s;
            if (actualSeqs.get(name).split("\\|").length <= exonNumber) {
                System.out.println(String.valueOf(name) + " not exist exon " + exonNumber);
                System.out.println(actualSeqs.get(name));
            }
            if (ExtractFastaAllExonAllGene.allN(s = actualSeqs.get(name).split("\\|")[exonNumber].replaceAll("\\.", "").replaceAll("\\*", "N")) || ExtractFastaAllExonAllGene.mostlyN(s, name)) continue;
            builder.append(">").append(name).append("\n");
            if (s.indexOf("N") >= 0) {
                String paddingAllele = null;
                if (pad.containsKey(name)) {
                    paddingAllele = pad.get(name).get(String.valueOf(exonNumber + 1));
                } else {
                    paddingAllele = ExtractFullSeqFromAlignmentFile.getClosestPaddingAllele(name, actualSeqs, exonNumber);
                    if (paddingAllele == null) {
                        Iterator<String> iterator = actualSeqs.keySet().iterator();
                        if (iterator.hasNext()) {
                            String a;
                            paddingAllele = a = iterator.next();
                        }
                        System.out.println("\t no record use " + paddingAllele + " for exon " + (exonNumber + 1));
                    }
                }
                s = actualSeqs.get(name).split("\\|")[exonNumber].replaceAll("\\*", "N");
                String newseq = "";
                String padSeq = actualSeqs.get(paddingAllele).split("\\|")[exonNumber].replaceAll("\\*", "N");
                int i = 0;
                while (i < s.length()) {
                    if (s.charAt(i) == 'N' && padSeq.charAt(i) == 'N') {
                        System.out.println(padSeq);
                        System.out.println(s);
                        System.out.println(String.valueOf(name) + " pad contains N in exon " + (exonNumber + 1));
                    }
                    newseq = String.valueOf(newseq) + (s.charAt(i) == 'N' ? padSeq.charAt(i) : s.charAt(i));
                    ++i;
                }
                builder.append(newseq.replaceAll("\\.", "")).append("\n");
                continue;
            }
            builder.append(s).append("\n");
        }
        FileManager.writeTextFile(exonFa, builder.toString(), true);
    }

    private static boolean allN(String s) {
        return s.replaceAll("N", "").length() == 0;
    }

    private static boolean mostlyN(String s, String name) {
        int len = s.length();
        if ((double)s.replaceAll("N", "").length() <= 0.25 * (double)len) {
            System.out.println(String.valueOf(name) + " " + s);
            return true;
        }
        return false;
    }

    public static Map<String, Map<String, String>> getPadInfo(File padFile) {
        String[] data = FileManager.readTextFile(padFile).split("\n");
        LinkedHashMap<String, Map<String, String>> pad = new LinkedHashMap<String, Map<String, String>>();
        String[] stringArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() == 0) break;
            String[] items = line.trim().split("\\s+");
            String name = items[0].trim();
            if (!pad.containsKey(name)) {
                pad.put(name, new LinkedHashMap());
            }
            ((Map)pad.get(name)).put(items[1].trim(), items[2].trim());
            ++n2;
        }
        return pad;
    }
}

