/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import misc.FileManager;

public class UpdateAmpliconSequence {
    public static String COUNT_AMPLICON = "SELECT p.sequence from pcr.primer p, pcr.amplicon a where p.primer_id = a.fwd_primer_id and a.name ilike ?";
    public static String UPDATE_AMPLICON = "update pcr.amplicon set sequence=? WHERE name ilike ?";

    public static void main(String[] args) {
        File assoFile = new File(args[0]);
        File seqFile = new File(args[1]);
        String sequence = UpdateAmpliconSequence.getSequenceFromFasta(seqFile);
        String[] assoData = FileManager.readTextFile(assoFile).split("\n");
        String[] info = null;
        String amplicon = null;
        int i = 0;
        while (i < assoData.length) {
            info = assoData[i].split(",");
            amplicon = info[0].trim();
            int start = new Integer(info[1].trim());
            int end = new Integer(info[2].trim());
            UpdateAmpliconSequence.excuteUpdate(amplicon, start, end, sequence);
            ++i;
        }
        System.out.println("done");
    }

    private static String getSequenceFromFasta(File fasta) {
        String[] lines = FileManager.readTextFile(fasta).split("\n");
        StringBuilder builder = new StringBuilder();
        StringBuilder seq = new StringBuilder();
        int i = 1;
        while (i < lines.length) {
            seq.append(lines[i].trim());
            ++i;
        }
        return seq.toString().toUpperCase();
    }

    private static void excuteUpdate(String ampName, int start, int end, String sequence) {
        String url = "jdbc:postgresql://asclepius.fhcrc.org:5432/gemsprod";
        ResultSet resultSet = null;
        String primerSeq = null;
        String ampliconSeq = null;
        try {
            Class.forName("org.postgresql.Driver");
            Connection db = DriverManager.getConnection(url, "gems", "Caff1ne");
            PreparedStatement preparedStatement = db.prepareStatement(COUNT_AMPLICON);
            preparedStatement.setString(1, ampName);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                primerSeq = resultSet.getString(1).toUpperCase();
                ampliconSeq = sequence.substring(start - 1, end);
                if (!ampliconSeq.startsWith(primerSeq)) {
                    System.out.println("not right " + primerSeq + " " + ampliconSeq);
                }
                preparedStatement = db.prepareStatement(UPDATE_AMPLICON);
                preparedStatement.setString(1, ampliconSeq);
                preparedStatement.setString(2, ampName);
                preparedStatement.executeUpdate();
            } else {
                System.out.println("not find " + ampName);
            }
            UpdateAmpliconSequence.closeResources(resultSet, preparedStatement, db);
        }
        catch (Exception e) {
            System.err.println("Got an exception! ");
            System.err.println(e.getMessage());
        }
    }

    private static void excuteUpdate(String sql, String mainPlate, String mainCoord, String newPlate, String newCoord) {
        String url = "jdbc:postgresql://asclepius.fhcrc.org:5432/gemsprod";
        try {
            Class.forName("org.postgresql.Driver");
            Connection db = DriverManager.getConnection(url, "gems", "Caff1ne");
            PreparedStatement preparedStatement = db.prepareStatement(sql);
            preparedStatement.setString(1, mainPlate);
            preparedStatement.setString(2, mainCoord);
            preparedStatement.setString(3, newPlate);
            preparedStatement.setString(4, newCoord);
            preparedStatement.executeUpdate();
            UpdateAmpliconSequence.closeResources(null, preparedStatement, db);
        }
        catch (Exception e) {
            System.err.println("Got an exception! ");
            System.err.println(e.getMessage());
        }
    }

    public static void closeResources(ResultSet resultSet, Statement statement, Connection connection) {
        SQLException sqlException = new SQLException();
        boolean isSQLExceptionEncountered = false;
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (isSQLExceptionEncountered) {
            System.out.println("error close resource");
        }
    }
}

