/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class Temp {
    public static void main(String[] args) throws Exception {
        File file = new File(args[0]);
        File out = new File(args[1]);
        String[] lines = FileManager.readTextFile(file).split("\n");
        System.out.println(lines.length);
        StringBuilder builder = new StringBuilder();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0) {
                String[] items = line.split("\t");
                System.out.println(String.valueOf(line) + " >>>>>>>> " + items.length);
                int i = 0;
                while (i < items.length) {
                    if (i == 6 && items[i].trim().length() > 2 && items[i].indexOf(".") > 0) {
                        builder.append("\t").append("\t");
                        break;
                    }
                    builder.append(items[i].trim()).append("\t");
                    ++i;
                }
                builder.append("\n");
            }
            ++n2;
        }
        FileManager.writeTextFile(out, builder.toString(), true);
    }

    private static String format(String[] folderNames) {
        StringBuilder builder = new StringBuilder();
        String[] stringArray = folderNames;
        int n = folderNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fn = stringArray[n2];
            builder.append("'").append(fn.split("_")[1]).append("'").append(", ");
            ++n2;
        }
        return builder.toString();
    }

    private static char[] orderedCharBases(char char1, char char2) {
        char[] orderedBases = new char[2];
        if (char1 > char2) {
            orderedBases[0] = char2;
            orderedBases[1] = char1;
        } else {
            orderedBases[0] = char1;
            orderedBases[1] = char2;
        }
        return orderedBases;
    }

    private static String getNewName(String name) {
        String newName = "";
        String[] item = name.split("_");
        int i = 1;
        while (i < item.length) {
            newName = String.valueOf(newName) + item[i] + "_";
            ++i;
        }
        return newName.substring(0, newName.length() - 1);
    }

    private static String processRatio(int start, int end, String[] data, String[] header, Map<String, Map<String, String>> alleleMap) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] line = null;
        ArrayList<Integer> ratio = null;
        String[] info = data[start].split(",");
        int i = 0;
        while (i < 11) {
            stringBuilder.append(info[i]).append(",");
            ++i;
        }
        i = 11;
        while (i < header.length) {
            ratio = new ArrayList<Integer>();
            boolean isHomo = Temp.checkMajorAlleles(start, end, data, header[i].trim(), alleleMap);
            int j = start;
            while (j <= end) {
                line = data[j].split(",");
                if (i < line.length && line[i].trim().length() > 5) {
                    ratio.add(Temp.formatRatio(line[i].trim()));
                }
                ++j;
            }
            long std = Temp.analyzeRatio(ratio);
            if (std >= 10L) {
                System.out.println(String.valueOf(isHomo ? "homo " : "hete ") + " std = " + std + " at allele " + info[2] + " primer=" + info[5] + " position=" + header[i]);
            }
            stringBuilder.append(std == -1L ? "N/A" : String.valueOf(std)).append(",");
            ++i;
        }
        return stringBuilder.append("\n").toString();
    }

    private static boolean checkMajorAlleles(int start, int end, String[] data, String position, Map<String, Map<String, String>> alleleMap) {
        block3: {
            String cellLine = data[start].split(",")[4].trim();
            try {
                String allele = alleleMap.get(cellLine).get(position);
                if (allele.charAt(0) == allele.charAt(2)) {
                    return true;
                }
            }
            catch (NullPointerException e) {
                String allele = alleleMap.get(String.valueOf(cellLine) + "-2").get(position);
                if (allele.charAt(0) != allele.charAt(2)) break block3;
                return true;
            }
        }
        return false;
    }

    private static long analyzeRatio(List<Integer> ratio) {
        if (ratio.size() < 2) {
            return -1L;
        }
        double mean = 0.0;
        for (Integer value : ratio) {
            mean += (double)value.intValue();
        }
        mean /= (double)ratio.size();
        double sumSquaredDev = 0.0;
        for (Integer value : ratio) {
            sumSquaredDev += Math.pow((double)value.intValue() - mean, 2.0);
        }
        return Math.round(Math.sqrt(sumSquaredDev / ((double)ratio.size() - 1.0)));
    }

    private static Integer formatRatio(String value) {
        String a = value.split("\\(")[1];
        return new Integer(a.split("\\)")[0]);
    }

    private static String getSequenceFromFasta(File fasta) {
        String[] lines = FileManager.readTextFile(fasta).split("\n");
        StringBuilder builder = new StringBuilder();
        StringBuilder seq = new StringBuilder();
        int i = 1;
        while (i < lines.length) {
            seq.append(lines[i].trim());
            ++i;
        }
        return seq.toString();
    }
}

