/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import misc.StreamReaderThread;

public class SystemCommand
implements Serializable {
    private static final long serialVersionUID = -6057303895055874647L;
    private static final String WHITESPACE = "\\s+";
    private String standardError;
    private String standardOut;
    private String[] commandAndArguments;
    private String[] environmentVariables;
    private File workingDirectory;
    private int exitValue;
    private boolean isOutputCaptured;
    private Process process;
    private StreamReaderThread standardOutThread;
    private StreamReaderThread standardErrorThread;
    private InputStream inputStream;
    private InputStream errorStream;
    private StringBuffer standardOutBuffer = new StringBuffer();
    private StringBuffer standardErrorBuffer = new StringBuffer();

    public SystemCommand(String command) {
        this.initialize(this.splitCommandAndArguments(command), null, null, false);
    }

    public SystemCommand(String command, boolean isOutputCaptured) {
        this.initialize(this.splitCommandAndArguments(command), null, null, isOutputCaptured);
    }

    public SystemCommand(String command, File workingDirectory, boolean isOutputCaptured) {
        this.initialize(this.splitCommandAndArguments(command), null, workingDirectory, isOutputCaptured);
    }

    public SystemCommand(String[] commandAndArguments, File workingDirectory, boolean isOutputCaptured) {
        this.initialize(commandAndArguments, null, workingDirectory, isOutputCaptured);
    }

    public SystemCommand(String command, String[] environmentVariables, File workingDirectory, boolean isOutputCaptured) {
        this.initialize(this.splitCommandAndArguments(command), environmentVariables, workingDirectory, isOutputCaptured);
    }

    public SystemCommand(String[] commandAndArguments, String[] environmentVariables, File workingDirectory, boolean isOutputCaptured) {
        this.initialize(commandAndArguments, environmentVariables, workingDirectory, isOutputCaptured);
    }

    private void initialize(String[] commandAndArgumentsArg, String[] environmentVariablesArg, File workingDirectoryArg, boolean isOutputCapturedArg) {
        this.commandAndArguments = commandAndArgumentsArg;
        this.environmentVariables = environmentVariablesArg;
        this.workingDirectory = workingDirectoryArg;
        this.isOutputCaptured = isOutputCapturedArg;
    }

    public void makeItSo() {
        try {
            try {
                this.process = Runtime.getRuntime().exec(this.getCommandAndArguments(), this.getEnvironmentVariables(), this.getWorkingDirectory());
                this.inputStream = this.process.getInputStream();
                this.errorStream = this.process.getErrorStream();
                this.standardOutThread = new StreamReaderThread(this.inputStream, this.standardOutBuffer, this.isOutputCaptured());
                this.standardErrorThread = new StreamReaderThread(this.errorStream, this.standardErrorBuffer, this.isOutputCaptured());
                this.standardOutThread.start();
                this.standardErrorThread.start();
                this.process.waitFor();
            }
            catch (Exception e) {
                if (this.process != null) {
                    this.process.destroy();
                    try {
                        this.process.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                e.printStackTrace();
                this.joinThread(this.standardOutThread);
                this.joinThread(this.standardErrorThread);
                this.closeInputStream(this.inputStream);
                this.closeInputStream(this.errorStream);
                this.setStandardOut(this.getOutput(this.standardOutBuffer));
                this.setStandardError(this.getOutput(this.standardErrorBuffer));
                this.setExitValue(this.process.exitValue());
            }
        }
        finally {
            this.joinThread(this.standardOutThread);
            this.joinThread(this.standardErrorThread);
            this.closeInputStream(this.inputStream);
            this.closeInputStream(this.errorStream);
            this.setStandardOut(this.getOutput(this.standardOutBuffer));
            this.setStandardError(this.getOutput(this.standardErrorBuffer));
            this.setExitValue(this.process.exitValue());
        }
    }

    public void destroy() {
        if (this.process != null) {
            this.process.destroy();
            try {
                this.process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.joinThread(this.standardOutThread);
        this.joinThread(this.standardErrorThread);
        this.closeInputStream(this.inputStream);
        this.closeInputStream(this.errorStream);
        this.setStandardOut(this.getOutput(this.standardOutBuffer));
        this.setStandardError(this.getOutput(this.standardErrorBuffer));
        this.setExitValue(this.process.exitValue());
    }

    private String getOutput(StringBuffer stringBuffer) {
        return stringBuffer.length() > 0 ? stringBuffer.toString() : null;
    }

    private void joinThread(Thread thread) {
        if (thread != null) {
            try {
                thread.join();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void closeInputStream(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String[] splitCommandAndArguments(String commandAndArgumentsArg) {
        return commandAndArgumentsArg.split(WHITESPACE);
    }

    public int getExitValue() {
        return this.exitValue;
    }

    private void setExitValue(int exitValue) {
        this.exitValue = exitValue;
    }

    private String[] getCommandAndArguments() {
        return this.commandAndArguments;
    }

    private String[] getEnvironmentVariables() {
        return this.environmentVariables;
    }

    private boolean isOutputCaptured() {
        return this.isOutputCaptured;
    }

    public String getStandardError() {
        return this.standardError;
    }

    private void setStandardError(String standardError) {
        this.standardError = standardError;
    }

    public String getStandardOut() {
        return this.standardOut;
    }

    private void setStandardOut(String standardOut) {
        this.standardOut = standardOut;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CommandAndArguments=\"").append(this.commandAndArguments != null ? Arrays.asList(this.commandAndArguments) : null);
        stringBuffer.append("\" EnvironmentVariables:=\"").append(this.environmentVariables != null ? Arrays.asList(this.environmentVariables) : null);
        stringBuffer.append("\" WorkingDirectory:=\"").append(this.workingDirectory);
        stringBuffer.append("\" IsOutputCaptured:=\"").append(this.isOutputCaptured);
        stringBuffer.append("\" ExitValue:=\"").append(this.exitValue);
        stringBuffer.append("\" StandardOut:=\"").append(this.standardOut);
        stringBuffer.append("\" StandardError:=\"").append(this.standardError).append("\"");
        return stringBuffer.toString();
    }
}

