/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileHandler;
import misc.FileHelper;
import misc.LogUtil;
import misc.SnpCommon;
import misc.SnpConfig;
import misc.StringUtils;

public class SnpOptimize {
    private String chromatDir;
    private String backbone;
    private String outputDir;
    private SnpConfig config;
    private LogUtil log;
    private FileHandler handler;
    private LogUtil snpOptimizeLog;
    private SnpConfig snpConfig;
    private String snpDataDir;
    private String filterFile;
    private List filterData;
    private String optimizedFile;
    private List posList;
    private Map callDic;
    private List keepList;
    private List homoClList;
    private List newPosList;
    private Map optimizedMap;

    public SnpOptimize(String chrDir, String fn, String outDir, SnpConfig conf, LogUtil mainLog) {
        this.chromatDir = chrDir;
        this.backbone = fn;
        this.outputDir = outDir;
        this.config = conf;
        this.log = mainLog;
        this.handler = new FileHandler();
        this.homoClList = new ArrayList();
        this.snpOptimizeLog = new LogUtil(FileHelper.SNP_OPTIMIZE_LOG);
        this.snpConfig = new SnpConfig();
        this.posList = new ArrayList();
        this.callDic = new HashMap();
        this.keepList = new ArrayList();
        this.newPosList = new ArrayList();
        this.optimizedMap = new HashMap();
    }

    public void optimize() throws IOException {
        System.out.println("\tSnp Optimize...");
        this.snpOptimizeLog.enter("<Script Optimize>\n");
        this.snpDataDir = FileHelper.snpDataDir(this.outputDir, this.chromatDir);
        this.filterFile = FileHelper.snpFilteredDataFile(this.snpDataDir);
        this.filterData = this.handler.readFile(this.filterFile);
        this.optimizedFile = FileHelper.snpOptimizedDataFile(this.snpDataDir);
        if (this.config.isHasHomoFile()) {
            this.homoClList = SnpCommon.getHomoCellLines(this.config.getHomoFilePath());
        }
        this.optimizeData();
        this.formatOptimizedCalls();
        this.writeOptimizedDataFile();
        this.snpOptimizeLog.exit("</Script Optimize>\n");
        this.snpOptimizeLog.write(this.snpDataDir);
    }

    public void writeOptimizedDataFile() throws IOException {
        ArrayList<String> data = new ArrayList<String>();
        LinkedHashMap dataMap = new LinkedHashMap();
        String header = "BackbonePosition";
        int i = 0;
        while (i < this.newPosList.size()) {
            String newPos = (String)this.newPosList.get(i);
            header = String.valueOf(header) + "\t" + newPos;
            ++i;
        }
        data.add(String.valueOf(header) + "\n");
        Object[] cls = this.optimizedMap.keySet().toArray();
        Arrays.sort(cls);
        int i2 = 0;
        while (i2 < cls.length) {
            String cl;
            String line = cl = (String)cls[i2];
            Map baseMap = (Map)this.optimizedMap.get(cl);
            int j = 0;
            while (j < this.keepList.size()) {
                Integer pos = (Integer)this.keepList.get(j);
                line = String.valueOf(line) + "\t" + (String)baseMap.get(pos);
                ++j;
            }
            data.add(String.valueOf(line) + "\n");
            ++i2;
        }
        this.handler.writeFile(this.optimizedFile, data);
        this.log.add("<INFO> " + this.newPosList.size() + " SNPs detected\n");
    }

    public void formatOptimizedCalls() {
        this.snpOptimizeLog.enter("<Function organizeFilteredData>\n");
        int i = 0;
        while (i < this.keepList.size()) {
            Integer pos = (Integer)this.keepList.get(i);
            Map baseMap = (Map)this.callDic.get(pos);
            for (String cl : baseMap.keySet()) {
                String[] value;
                if (!this.optimizedMap.containsKey(cl)) {
                    this.optimizedMap.put(cl, new HashMap());
                }
                Map posMap = (Map)this.optimizedMap.get(cl);
                String call = (String)baseMap.get(cl);
                if (call.charAt(0) != '?' && new Integer((value = SnpCommon.formatBaseCall(call))[1]) > this.config.getQualAssure()) {
                    call = value[0];
                }
                posMap.put(pos, call);
            }
            ++i;
        }
        this.snpOptimizeLog.exit("</Function organizeFilteredData>\n");
    }

    public String formatPositionData(Integer pos, Map firmDic, List heteList, List baseList) {
        String tmpPos = pos.toString();
        if (this.config.isFlag()) {
            Map baseMap = (Map)this.callDic.get(pos);
            double odd = this.countOdd(baseMap);
            if (odd > (double)SnpConfig.ODD_LIMIT) {
                tmpPos = String.valueOf(this.formatFlag(SnpConfig.FLAG_CHAR, 3)) + pos.toString() + this.formatFlag(SnpConfig.FLAG_CHAR, 3);
            } else if (firmDic.keySet().size() == 1 && (heteList.size() == 1 || heteList.size() == 0)) {
                tmpPos = String.valueOf(this.formatFlag(SnpConfig.FLAG_CHAR, 2)) + pos.toString() + this.formatFlag(SnpConfig.FLAG_CHAR, 2);
            } else if (firmDic.keySet().size() == 1 && heteList.size() > 1) {
                tmpPos = String.valueOf(this.formatFlag(SnpConfig.FLAG_CHAR, 1)) + pos.toString() + this.formatFlag(SnpConfig.FLAG_CHAR, 1);
            }
            if (baseList.size() > 2) {
                this.snpOptimizeLog.add("<WARNING> more than 2 alleles at position " + pos + " " + StringUtils.listToString(baseList) + "\n");
                this.log.add("<WARNING> more than 2 alleles at position " + pos + "\n");
            }
        }
        return tmpPos;
    }

    public String formatFlag(String flag, int num) {
        String ret = "";
        int i = 0;
        while (i < num) {
            ret = String.valueOf(ret) + flag;
            ++i;
        }
        return ret;
    }

    public double countOdd(Map map) {
        if (!this.config.isProbablityFilter()) {
            return 1.0;
        }
        List list = this.collectCallInfo(map);
        Map homoMap = (Map)list.get(0);
        List heteList = (List)list.get(1);
        if (homoMap.keySet().size() > 2) {
            return 1.0;
        }
        int n1 = 0;
        int n2 = 0;
        Object[] o = homoMap.keySet().toArray();
        if (homoMap.keySet().size() == 2) {
            n1 = (Integer)homoMap.get(o[0]);
            n2 = (Integer)homoMap.get(o[1]);
        } else if (homoMap.keySet().size() == 1) {
            n1 = (Integer)homoMap.get(o[0]);
            n2 = 0;
        } else if (homoMap.keySet().size() == 0) {
            n1 = 0;
            n2 = 0;
        }
        if (heteList.size() > (n1 + n2 + heteList.size()) / 2) {
            return this.calculateOdd(n1, n2, heteList.size());
        }
        return 1.0;
    }

    public double calculateOdd(int n1, int n2, int n12) {
        int tot = (n1 + n2 + n12) * 2;
        double p1 = 1.0 * (double)(2 * n1 + n12) / (double)tot;
        double p2 = 1.0 * (double)(2 * n2 + n12) / (double)tot;
        double ph1 = Math.pow(p1, 2.0);
        double ph2 = Math.pow(p2, 2.0);
        double p12 = p1 * p2 + p2 * p1;
        double prob = this.fact(tot / 2) / (this.fact(n1) * this.fact(n2) * this.fact(n12)) * (Math.pow(ph1, n1) * Math.pow(ph2, n2) * Math.pow(p12, n12));
        return 1.0 / prob;
    }

    public double fact(int num) {
        double ret = 1.0;
        int i = 0;
        while (i < num) {
            ret *= (double)(i + 1);
            ++i;
        }
        return ret;
    }

    public List collectCallInfo(Map map) {
        ArrayList<String> heteList = new ArrayList<String>();
        HashMap<String, Integer> homoMap = new HashMap<String, Integer>();
        for (String cl : map.keySet()) {
            if (this.homoClList.contains(cl)) continue;
            String call = (String)map.get(cl);
            if (call.indexOf(47) > -1) {
                heteList.add(call);
                continue;
            }
            String tmpCall = SnpCommon.formatBaseCall(call)[0];
            if (tmpCall.length() <= 0 || "ATCG".indexOf(tmpCall) <= -1) continue;
            if (!homoMap.containsKey(tmpCall)) {
                homoMap.put(tmpCall, new Integer(0));
            }
            int num = (Integer)homoMap.get(tmpCall);
            homoMap.put(tmpCall, new Integer(num + 1));
        }
        ArrayList<Cloneable> ret = new ArrayList<Cloneable>();
        ret.add(homoMap);
        ret.add(heteList);
        return ret;
    }

    public void optimizeData() {
        this.snpOptimizeLog.enter("<Function optimizeData>\n");
        String[] positions = ((String)this.filterData.get(0)).split("\t");
        int i = 1;
        while (i < positions.length) {
            this.posList.add(new Integer(positions[i]));
            if (this.checkRowData(i, new Integer(positions[i]))) {
                this.keepList.add(new Integer(positions[i]));
            }
            ++i;
        }
        this.snpOptimizeLog.exit("</Function optimizeData>\n");
    }

    public boolean checkRowData(int i, Integer pos) {
        String cl;
        String call;
        String[] items;
        int unknown = 0;
        HashMap<String, List> firmDic = new HashMap<String, List>();
        ArrayList<String> baseList = new ArrayList<String>();
        ArrayList<String> heteList = new ArrayList<String>();
        HashMap<String, String> baseMap = new HashMap<String, String>();
        int j = 1;
        while (j < this.filterData.size()) {
            items = ((String)this.filterData.get(j)).trim().split("\t");
            call = items[i];
            cl = items[0];
            if (call.indexOf(47) <= -1) {
                if (call.charAt(0) == '?' || call.charAt(0) == 'E') {
                    ++unknown;
                    baseMap.put(cl, call);
                } else {
                    String base = call.substring(0, 1);
                    if (!firmDic.containsKey(base)) {
                        firmDic.put(base, new ArrayList());
                    }
                    List list = (List)firmDic.get(base);
                    list.add(call);
                    firmDic.put(base, list);
                    baseMap.put(cl, call);
                }
            }
            ++j;
        }
        j = 1;
        while (j < this.filterData.size()) {
            items = ((String)this.filterData.get(j)).trim().split("\t");
            call = items[i];
            cl = items[0];
            if (call.indexOf(47) > -1) {
                String allele2;
                String allele1;
                if (call.charAt(0) == '?') {
                    allele1 = call.substring(1, 2);
                    allele2 = call.substring(3, 4);
                } else {
                    allele1 = call.substring(0, 1);
                    allele2 = call.substring(2, 3);
                }
                if (firmDic.keySet().size() >= 2 && !firmDic.containsKey(allele2)) {
                    call = "?" + this.takeHigherPeak(call);
                } else if (call.charAt(0) != '?') {
                    heteList.add(call);
                }
                if (!baseList.contains(allele1)) {
                    baseList.add(allele1);
                }
                baseMap.put(cl, call);
            } else {
                String tmpCall = SnpCommon.formatBaseCall(call)[0];
                if (tmpCall.length() > 0 && !tmpCall.equals("E") && !baseList.contains(tmpCall)) {
                    baseList.add(tmpCall);
                }
            }
            ++j;
        }
        boolean keep = this.isKeepPosition(unknown, firmDic, heteList, baseList, pos);
        if (keep) {
            this.callDic.put(pos, baseMap);
            this.newPosList.add(this.formatPositionData(pos, firmDic, heteList, baseList));
        }
        return keep;
    }

    public boolean passOverAllQuall(Map firmDic, List heteList) {
        Integer qual;
        for (String base : firmDic.keySet()) {
            List list = (List)firmDic.get(base);
            for (String call : list) {
                qual = new Integer(SnpCommon.formatBaseCall(call)[1]);
                if (qual <= 25) continue;
                return true;
            }
        }
        for (String call : heteList) {
            qual = new Integer(SnpCommon.formatBaseCall(call)[1]);
            if (qual <= 25) continue;
            return true;
        }
        return false;
    }

    public boolean isKeepPosition(int unknown, Map firmDic, List heteList, List baseList, Integer pos) {
        if (!this.passOverAllQuall(firmDic, heteList)) {
            this.snpOptimizeLog.add("discard position : " + pos + ", reason = fail overall quality\n");
            return false;
        }
        if (baseList.size() == 1 && heteList.size() == 0) {
            this.snpOptimizeLog.add("discard position : " + pos + ", reason = no enough variation\n");
            return false;
        }
        if (this.config.isErrorProof() && baseList.size() == 1 && !this.passHeteOverAllQual(heteList)) {
            this.snpOptimizeLog.add("discard position : " + pos + ", reason = error proof\n");
            return false;
        }
        return true;
    }

    public boolean passHeteOverAllQual(List heteList) {
        for (String call : heteList) {
            Integer qual = new Integer(SnpCommon.formatBaseCall(call)[1]);
            if (qual >= 30) continue;
            return true;
        }
        return false;
    }

    public String takeHigherPeak(String call) {
        String[] tmp = SnpCommon.formatBaseCall(call);
        return String.valueOf(tmp[0].substring(0, 1)) + "(" + tmp[1] + ")";
    }
}

