/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileHandler;
import misc.FileHelper;
import misc.LogUtil;
import misc.SnpCommon;
import misc.SnpConfig;

public class SnpFilter {
    private String chromatDir;
    private String backbone;
    private String outputDir;
    private SnpConfig config;
    private LogUtil log;
    private FileHandler handler;
    private LogUtil snpFilterLog;
    private SnpConfig snpConfig;
    private String snpDataDir;
    private String rawChrFile;
    private List rawChrData;
    private String rawClFile;
    private List rawClData;
    private String analysisFile;
    private List analysisData;
    private String filterFile;
    private String polyDir;
    private Map fastaDic;
    private Map qualDic;
    private Map cellLineMap;
    private List fChromats;
    private List rChromats;
    private List posList;
    private Map callDic;
    private List keepList;
    private Map posClDic;
    private Map posCallDic;
    private Map untrustMap;
    private Map untrustCallMap;
    private Map callMap;
    private Map filteredMap;

    public SnpFilter(String chrDir, String fn, String outDir, SnpConfig conf, LogUtil mainLog) {
        this.chromatDir = chrDir;
        this.backbone = fn;
        this.outputDir = outDir;
        this.config = conf;
        this.log = mainLog;
        this.handler = new FileHandler();
        this.snpFilterLog = new LogUtil(FileHelper.SNP_FILTER_LOG);
        this.snpConfig = new SnpConfig();
        this.cellLineMap = new HashMap();
        this.fChromats = new ArrayList();
        this.rChromats = new ArrayList();
        this.posList = new ArrayList();
        this.callDic = new HashMap();
        this.keepList = new ArrayList();
        this.posClDic = new HashMap();
        this.posCallDic = new HashMap();
        this.untrustMap = new HashMap();
        this.untrustCallMap = new HashMap();
        this.callMap = new HashMap();
        this.filteredMap = new HashMap();
    }

    public void filter() throws IOException {
        System.out.println("\tSnp Filter...");
        this.snpFilterLog.enter("<Script Filter>\n");
        this.snpDataDir = FileHelper.snpDataDir(this.outputDir, this.chromatDir);
        this.polyDir = FileHelper.polyDir(this.outputDir, this.chromatDir, this.config);
        this.rawChrFile = FileHelper.snpChromatRawDataFile(this.snpDataDir);
        this.rawChrData = this.handler.readFile(this.rawChrFile);
        this.rawClFile = FileHelper.snpCellLineRawDataFile(this.snpDataDir);
        this.rawClData = this.handler.readFile(this.rawClFile);
        this.analysisFile = FileHelper.snpAnalysisDataFile(this.snpDataDir);
        this.analysisData = this.handler.readFile(this.analysisFile);
        this.filterFile = FileHelper.snpFilteredDataFile(this.snpDataDir);
        String fastaFile = FileHelper.fastaFile(this.snpDataDir);
        this.fastaDic = FileHandler.getAllFasta(fastaFile);
        String qualFile = FileHelper.qualFile(this.snpDataDir);
        this.qualDic = FileHandler.getAllFasta(qualFile);
        this.filterByDirection();
        this.organizeFilteredData();
        this.writeFilteredDataFile();
        this.snpFilterLog.exit("</Script Filter>\n");
        this.snpFilterLog.write(this.snpDataDir);
    }

    public void filterByDirection() throws IOException {
        this.snpFilterLog.enter("<Function FilterByDirection>\n");
        this.sortChromatByDirection();
        String[] positions = ((String)this.analysisData.get(0)).split("\t");
        int i = 1;
        while (i < positions.length) {
            this.posList.add(new Integer(positions[i]));
            ++i;
        }
        this.getCellLineMap();
        this.getAnalysisCallDic();
        this.getCellLineDataDic();
        this.getKeepList();
        this.getPosCallDic();
        this.evaluateUntrustCalls();
        this.generateFilteredData();
        this.snpFilterLog.exit("</Function FilterByDirection>\n");
    }

    public void writeFilteredDataFile() throws IOException {
        Integer pos;
        ArrayList<String> data = new ArrayList<String>();
        LinkedHashMap dataMap = new LinkedHashMap();
        String header = "BackbonePosition";
        int i = 0;
        while (i < this.keepList.size()) {
            pos = (Integer)this.keepList.get(i);
            header = String.valueOf(header) + "\t" + ((Integer)this.keepList.get(i)).toString();
            ++i;
        }
        data.add(String.valueOf(header) + "\n");
        Object[] cls = this.filteredMap.keySet().toArray();
        Arrays.sort(cls);
        int i2 = 0;
        while (i2 < cls.length) {
            String cl;
            String line = cl = (String)cls[i2];
            Map baseMap = (Map)this.filteredMap.get(cl);
            int j = 0;
            while (j < this.keepList.size()) {
                pos = (Integer)this.keepList.get(j);
                line = String.valueOf(line) + "\t" + (String)baseMap.get(pos);
                ++j;
            }
            data.add(String.valueOf(line) + "\n");
            ++i2;
        }
        this.handler.writeFile(this.filterFile, data);
    }

    public void organizeFilteredData() {
        this.snpFilterLog.enter("<Function organizeFilteredData>\n");
        int i = 0;
        while (i < this.keepList.size()) {
            Integer pos = (Integer)this.keepList.get(i);
            System.out.println(pos);
            Map baseMap = (Map)this.callMap.get(pos);
            for (String cl : baseMap.keySet()) {
                if (!this.filteredMap.containsKey(cl)) {
                    this.filteredMap.put(cl, new HashMap());
                }
                Map posMap = (Map)this.filteredMap.get(cl);
                String call = (String)baseMap.get(cl);
                posMap.put(pos, call);
            }
            ++i;
        }
        this.snpFilterLog.exit("</Function organizeFilteredData>\n");
    }

    public void generateFilteredData() {
        int i = 0;
        while (i < this.keepList.size()) {
            Integer pos = (Integer)this.keepList.get(i);
            Map cMap = (Map)this.callDic.get(pos);
            Map aMap = (Map)this.posClDic.get(pos);
            List plist = (List)this.posCallDic.get(pos);
            HashMap<String, String> baseMap = new HashMap<String, String>();
            String untrust = null;
            String uCall = null;
            if (this.untrustMap.containsKey(pos)) {
                untrust = (String)this.untrustMap.get(pos);
                uCall = (String)this.untrustCallMap.get(pos);
            }
            for (String cl : this.cellLineMap.keySet()) {
                List list = (List)this.cellLineMap.get(cl);
                String baseChr = (String)aMap.get(cl);
                String call = this.getPosCall(baseChr, untrust, uCall, baseMap, cMap, list, plist);
                baseMap.put(cl, call);
            }
            if (this.untrustMap.containsKey(pos) && !this.truePosition(uCall, baseMap, pos)) {
                System.out.println("--- " + pos);
                this.keepList.remove(i);
                --i;
            } else {
                this.callMap.put(pos, baseMap);
            }
            ++i;
        }
    }

    public boolean truePosition(String uCall, Map baseMap, Integer pos) {
        Iterator it = baseMap.keySet().iterator();
        String tmpCall = null;
        while (it.hasNext()) {
            String cl = (String)it.next();
            String call = (String)baseMap.get(cl);
            if (!this.validCall(call) || call.charAt(0) == '?' && call.indexOf(47) > -1 || SnpCommon.isSameCall(SnpCommon.formatBaseCall(call)[0], uCall)) continue;
            if (tmpCall == null) {
                tmpCall = SnpCommon.formatBaseCall(call)[0];
                continue;
            }
            if (SnpCommon.isSameCall(tmpCall, SnpCommon.formatBaseCall(call)[0])) continue;
            return true;
        }
        return false;
    }

    public String getPosCall(String baseChr, String untrust, String uCall, Map baseMap, Map cMap, List list, List plist) {
        if (baseChr.endsWith("X")) {
            return "?(-1)";
        }
        String call = (String)cMap.get(baseChr);
        if (untrust != null && untrust.equals("F") && this.fChromats.contains(baseChr)) {
            return this.getTrustCall(list, this.fChromats, cMap, call, uCall);
        }
        if (untrust != null && untrust.equals("R") && this.rChromats.contains(baseChr)) {
            return this.getTrustCall(list, this.rChromats, cMap, call, uCall);
        }
        return this.getOptmizedCall(list, plist, cMap, call, untrust, uCall);
    }

    public boolean untrustChr(String untrust, String uCall, String chr, String acall) {
        if (untrust != null && untrust.equals("F") && this.fChromats.contains(chr) && uCall != null && SnpCommon.isSameCall(SnpCommon.formatBaseCall(acall)[0], uCall)) {
            return true;
        }
        return untrust != null && untrust.equals("R") && this.rChromats.contains(chr) && uCall != null && SnpCommon.isSameCall(SnpCommon.formatBaseCall(acall)[0], uCall);
    }

    public String getOptmizedCall(List chrList, List homoList, Map cMap, String call, String untrust, String uCall) {
        int qual;
        String acall;
        if (call.charAt(0) != '?' && call.indexOf(47) > -1) {
            for (String chr : chrList) {
                if (this.untrustChr(untrust, uCall, chr, acall = (String)cMap.get(chr))) continue;
                qual = new Integer(SnpCommon.formatBaseCall(acall)[1]);
                if (acall.charAt(0) == '?' || acall.indexOf(47) != -1 || qual < this.config.getQualAssure() || homoList.size() >= 2 || (homoList.size() != 1 || !homoList.get(0).equals(acall.substring(0, 1))) && homoList.size() != 0) continue;
                call = "?" + call;
                break;
            }
        } else if (call.charAt(0) == '?' && "ATCG".indexOf(call.charAt(1)) > -1) {
            for (String chr : chrList) {
                if (this.untrustChr(untrust, uCall, chr, acall = (String)cMap.get(chr))) continue;
                qual = new Integer(SnpCommon.formatBaseCall(acall)[1]);
                if (acall.charAt(0) != '?') {
                    if (call.indexOf(47) > -1 && acall.indexOf(47) > -1 || call.indexOf(47) == -1 && acall.indexOf(47) == -1) {
                        call = acall;
                    } else {
                        if (call.indexOf(47) <= -1 || acall.indexOf(47) != -1) continue;
                        call = qual >= this.config.getQualAssure() ? acall : acall;
                    }
                } else {
                    if (call.indexOf(47) != -1 || acall.indexOf(47) <= -1) continue;
                    call = acall;
                }
                break;
            }
        }
        if (call.charAt(0) != '?') {
            qual = new Integer(SnpCommon.formatBaseCall(call)[1]);
            for (String chr : chrList) {
                if (this.untrustChr(untrust, uCall, chr, acall = (String)cMap.get(chr)) || acall.charAt(0) == '?') continue;
                if (call.indexOf(47) > -1 && acall.indexOf(47) == -1) {
                    call = "?" + call;
                    break;
                }
                if (call.indexOf(47) != -1 || acall.indexOf(47) <= -1 || qual >= 45) continue;
                call = "?" + acall;
                break;
            }
        }
        return call;
    }

    public String getTrustCall(List chrList, List chromats, Map cMap, String call, String uCall) {
        String tmpCall = null;
        int tmpQual = -1;
        for (String chr : chrList) {
            String acall;
            int aqual;
            if (chromats.contains(chr) || (aqual = new Integer(SnpCommon.formatBaseCall(acall = (String)cMap.get(chr))[1]).intValue()) <= tmpQual) continue;
            tmpCall = acall;
            tmpQual = aqual;
        }
        if (tmpCall == null) {
            String base = SnpCommon.formatBaseCall(call)[0];
            if (SnpCommon.isSameCall(base, uCall)) {
                return call.indexOf(63) > -1 ? call : "?" + call;
            }
            return call;
        }
        return tmpCall;
    }

    public void evaluateUntrustCalls() {
        this.snpFilterLog.enter("<Function evaluateUntrustCalls>\n");
        int i = 0;
        while (i < this.keepList.size()) {
            Integer pos = (Integer)this.keepList.get(i);
            int[] tmp = this.getPosDiffNumbers(pos);
            int fpDiff = tmp[0];
            int fnDiff = tmp[1];
            int diff = tmp[2];
            int fQual = tmp[3];
            int rQual = tmp[4];
            int counter = tmp[5];
            int maxDiff = Math.max(Math.max(diff, fpDiff), fnDiff);
            if (maxDiff > 5 && maxDiff > counter / 2) {
                String untrustDir = maxDiff == fpDiff ? "F" : (maxDiff == fnDiff ? "R" : (fQual > rQual ? "R" : "F"));
                String untrustCall = untrustDir.equals("F") ? this.getPosUntrustCall(pos, this.fChromats) : this.getPosUntrustCall(pos, this.rChromats);
                this.untrustMap.put(pos, untrustDir);
                this.untrustCallMap.put(pos, untrustCall);
                this.snpFilterLog.add("untrust call : " + untrustCall + " at position " + pos + "\n");
            }
            ++i;
        }
        this.snpFilterLog.exit("</Function evaluateUntrustCalls>\n");
    }

    public String getPosUntrustCall(Integer pos, List chromats) {
        Map aMap = (Map)this.callDic.get(pos);
        HashMap<String, Integer> tmpMap = new HashMap<String, Integer>();
        for (String chr : chromats) {
            String call = (String)aMap.get(chr);
            if (!this.validCall(call)) continue;
            String[] temp = SnpCommon.formatBaseCall(call);
            String base = this.orderBase(temp[0]);
            if (tmpMap.containsKey(base)) {
                int num = (Integer)tmpMap.get(base);
                tmpMap.put(base, new Integer(++num));
                continue;
            }
            tmpMap.put(base, new Integer(1));
        }
        int max = 0;
        String ret = null;
        for (String x : tmpMap.keySet()) {
            int num = (Integer)tmpMap.get(x);
            if (num <= max) continue;
            max = num;
            ret = x;
        }
        return ret.length() == 1 ? ret : String.valueOf(ret.substring(0, 1)) + "/" + ret.substring(1, 2);
    }

    public String orderBase(String base) {
        String[] tmp = base.split("/");
        if (tmp.length == 1) {
            return base;
        }
        if (tmp[0].compareTo(tmp[1]) < 0) {
            return String.valueOf(tmp[0]) + tmp[1];
        }
        return String.valueOf(tmp[1]) + tmp[0];
    }

    public int[] getPosDiffNumbers(Integer pos) {
        int diff = 0;
        int fpDiff = 0;
        int fnDiff = 0;
        int fQual = 0;
        int rQual = 0;
        int counter = 0;
        Map aMap = (Map)this.callDic.get(pos);
        for (String cl : this.cellLineMap.keySet()) {
            List list = (List)this.cellLineMap.get(cl);
            String[] ftemp = this.getDirectionCallInfo(list, aMap, this.fChromats);
            String[] rtemp = this.getDirectionCallInfo(list, aMap, this.rChromats);
            String fcall = ftemp[0];
            String rcall = rtemp[0];
            int fq = new Integer(ftemp[1]);
            int rq = new Integer(rtemp[1]);
            if (fcall == null || rcall == null) continue;
            fQual += fq;
            rQual += rq;
            if (fcall.indexOf(47) > -1 && rcall.indexOf(47) == -1) {
                ++fpDiff;
            } else if (fcall.indexOf(47) == -1 && rcall.indexOf(47) > -1) {
                ++fnDiff;
            } else {
                diff += SnpCommon.isSameCall(fcall, rcall) ? 0 : 1;
            }
            ++counter;
        }
        int[] ret = new int[]{fpDiff, fnDiff, diff, fQual, rQual, counter};
        return ret;
    }

    public String[] getDirectionCallInfo(List list, Map aMap, List chromats) {
        Iterator ait = list.iterator();
        String call = null;
        int q = -1;
        while (ait.hasNext()) {
            String chr = (String)ait.next();
            String thisCall = (String)aMap.get(chr);
            if (!this.validCall(thisCall)) continue;
            String[] temp = SnpCommon.formatBaseCall(thisCall);
            String base = temp[0];
            int qual = new Integer(temp[1]);
            if (!chromats.contains(chr)) continue;
            if (call == null) {
                call = base;
                q = qual;
                continue;
            }
            if (qual <= q) continue;
            call = base;
            q = qual;
        }
        String[] ret = new String[]{call, String.valueOf(q)};
        return ret;
    }

    public boolean validCall(String call) {
        String baseCall = "ATGC";
        char tcall = call.charAt(0) == '?' ? call.charAt(1) : call.charAt(0);
        return baseCall.indexOf(tcall) > -1;
    }

    public void getPosCallDic() {
        int i = 0;
        while (i < this.keepList.size()) {
            Integer pos = (Integer)this.keepList.get(i);
            ArrayList<String> homoList = new ArrayList<String>();
            Map clMap = (Map)this.posClDic.get(pos);
            Map ccMap = (Map)this.callDic.get(pos);
            for (String cl : clMap.keySet()) {
                String call;
                String chr = (String)clMap.get(cl);
                if (chr.equals("X") || (call = (String)ccMap.get(chr)).charAt(0) == '?' || call.indexOf(47) != -1 || homoList.contains(call.substring(0, 1))) continue;
                homoList.add(call.substring(0, 1));
            }
            this.posCallDic.put(pos, homoList);
            ++i;
        }
    }

    public void getCellLineDataDic() {
        String[] positions = ((String)this.rawClData.get(0)).split("\t");
        int i = 1;
        while (i < positions.length) {
            Integer pos = new Integer(positions[i]);
            HashMap<String, String> baseMap = new HashMap<String, String>();
            int j = 1;
            while (j < this.rawClData.size()) {
                String[] items = ((String)this.rawClData.get(j)).trim().split("\t");
                String cl = items[0];
                String[] entry = items[i].split("/");
                baseMap.put(cl, entry[entry.length - 1]);
                ++j;
            }
            this.posClDic.put(pos, baseMap);
            ++i;
        }
    }

    public void getKeepList() {
        int i = 0;
        while (i < this.posList.size()) {
            Integer pos = (Integer)this.posList.get(i);
            Map baseMap = (Map)this.callDic.get(pos);
            boolean[] fDir = this.checkSnpByDirection(baseMap, this.fChromats);
            boolean[] rDir = this.checkSnpByDirection(baseMap, this.rChromats);
            if (fDir[0] && rDir[0]) {
                this.keepList.add(pos);
            } else if (fDir[0] && !fDir[1] || rDir[0] && !rDir[1]) {
                this.keepList.add(pos);
            } else {
                this.snpFilterLog.add("discard position : " + pos + "\n");
            }
            ++i;
        }
    }

    public boolean[] checkSnpByDirection(Map baseMap, List chromats) {
        Iterator it = chromats.iterator();
        boolean snp = false;
        boolean same = true;
        String read = null;
        while (it.hasNext()) {
            String thisRead;
            String chr = (String)it.next();
            String call = (String)baseMap.get(chr);
            if (call.indexOf("?") >= 0) continue;
            if (call.indexOf("/") > 0) {
                snp = true;
                thisRead = call.substring(0, 3);
            } else {
                thisRead = call.substring(0, 1);
            }
            if (read == null) {
                read = thisRead;
                continue;
            }
            if (SnpCommon.isSameCall(read, thisRead)) continue;
            snp = true;
            same = false;
        }
        boolean[] ret = new boolean[]{snp, same};
        return ret;
    }

    public void getAnalysisCallDic() {
        int i = 0;
        while (i < this.posList.size()) {
            Integer pos = (Integer)this.posList.get(i);
            HashMap<String, String> baseMap = new HashMap<String, String>();
            int j = 1;
            while (j < this.analysisData.size()) {
                String[] items = ((String)this.analysisData.get(j)).trim().split("\t");
                String chr = items[0];
                String call = items[i + 1];
                baseMap.put(chr, call);
                ++j;
            }
            this.callDic.put(pos, baseMap);
            ++i;
        }
    }

    public void getCellLineMap() {
        for (String chr : this.fastaDic.keySet()) {
            String cl = chr.split(this.config.getDelimeter())[this.config.getCellLinePos()];
            if (!this.cellLineMap.containsKey(cl)) {
                this.cellLineMap.put(cl, new ArrayList());
            }
            List list = (List)this.cellLineMap.get(cl);
            list.add(chr);
        }
    }

    public void sortChromatByDirection() {
        int i = 1;
        while (i < this.rawChrData.size()) {
            String[] items = ((String)this.rawChrData.get(i)).trim().split("\t");
            String chr = items[0];
            int j = 1;
            while (j < items.length) {
                String direction = items[j].split("/")[3];
                if (direction.equals("F")) {
                    this.fChromats.add(chr);
                    break;
                }
                if (direction.equals("R")) {
                    this.rChromats.add(chr);
                    break;
                }
                ++j;
            }
            ++i;
        }
    }
}

