/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileHandler;
import misc.FileHelper;
import misc.LogUtil;
import misc.SnpCommon;
import misc.SnpConfig;
import misc.StringUtils;

public class SnpAnalysis {
    private String chromatDir;
    private String backbone;
    private String outputDir;
    private SnpConfig config;
    private LogUtil log;
    private FileHandler handler;
    private LogUtil snpAnalysisLog;
    private String snpDataDir;
    private String rawFile;
    private List rawData;
    private String analysisFile;
    private String polyDir;
    private Map fastaDic;
    private Map qualDic;
    private Map fRefDic;
    private Map rRefDic;
    private Map fReadDic;
    private Map rReadDic;
    private Map fHeteDic;
    private Map rHeteDic;
    private List fChromats;
    private List rChromats;
    private List homoClList;
    private List posList;
    private List keepList;
    private Map callDic;
    private Map callMap;

    public SnpAnalysis(String chrDir, String fn, String outDir, SnpConfig conf, LogUtil mainLog) {
        this.chromatDir = chrDir;
        this.backbone = fn;
        this.outputDir = outDir;
        this.config = conf;
        this.log = mainLog;
        this.handler = new FileHandler();
        this.snpAnalysisLog = new LogUtil(FileHelper.SNP_ANALYSIS_LOG);
        this.homoClList = new ArrayList();
        this.posList = new ArrayList();
        this.keepList = new ArrayList();
        this.callDic = new HashMap();
        this.callMap = new HashMap();
        this.fRefDic = new HashMap();
        this.rRefDic = new HashMap();
        this.fReadDic = new HashMap();
        this.rReadDic = new HashMap();
        this.fHeteDic = new HashMap();
        this.rHeteDic = new HashMap();
        this.fChromats = new ArrayList();
        this.rChromats = new ArrayList();
    }

    public void analyze() throws IOException {
        System.out.println("\tSnp Analysis...");
        this.snpAnalysisLog.enter("<Script Analyze>\n");
        this.snpDataDir = FileHelper.snpDataDir(this.outputDir, this.chromatDir);
        this.polyDir = FileHelper.polyDir(this.outputDir, this.chromatDir, this.config);
        this.rawFile = FileHelper.snpChromatRawDataFile(this.snpDataDir);
        this.rawData = this.handler.readFile(this.rawFile);
        this.analysisFile = FileHelper.snpAnalysisDataFile(this.snpDataDir);
        String fastaFile = FileHelper.fastaFile(this.snpDataDir);
        this.fastaDic = FileHandler.getAllFasta(fastaFile);
        String qualFile = FileHelper.qualFile(this.snpDataDir);
        this.qualDic = FileHandler.getAllFasta(qualFile);
        if (this.config.isHasHomoFile()) {
            this.homoClList = SnpCommon.getHomoCellLines(this.config.getHomoFilePath());
        }
        System.out.println("getRefChromatDic");
        this.getRefChromatDic();
        System.out.println("getChromatReadDic");
        this.getChromatReadDic();
        System.out.println("checkSnp");
        this.checkSnp();
        System.out.println("organizeAnalysisData");
        this.organizeAnalysisData();
        System.out.println("writeAnalysisDataFile");
        this.writeAnalysisDataFile();
        this.snpAnalysisLog.exit("</Script Analyze>\n");
        this.snpAnalysisLog.write(this.snpDataDir);
    }

    public void writeAnalysisDataFile() throws IOException {
        Integer pos;
        ArrayList<String> data = new ArrayList<String>();
        LinkedHashMap dataMap = new LinkedHashMap();
        String header = "BackbonePosition";
        int i = 0;
        while (i < this.posList.size()) {
            pos = (Integer)this.posList.get(i);
            if (this.keepList.contains(pos)) {
                header = String.valueOf(header) + "\t" + ((Integer)this.posList.get(i)).toString();
            }
            ++i;
        }
        data.add(String.valueOf(header) + "\n");
        Object[] chrs = this.callMap.keySet().toArray();
        Arrays.sort(chrs);
        int i2 = 0;
        while (i2 < chrs.length) {
            String chr;
            String line = chr = (String)chrs[i2];
            Map baseMap = (Map)this.callMap.get(chr);
            int j = 0;
            while (j < this.posList.size()) {
                pos = (Integer)this.posList.get(j);
                if (this.keepList.contains(pos)) {
                    line = String.valueOf(line) + "\t" + (String)baseMap.get(pos);
                }
                ++j;
            }
            data.add(String.valueOf(line) + "\n");
            ++i2;
        }
        this.handler.writeFile(this.analysisFile, data);
    }

    public void organizeAnalysisData() {
        this.snpAnalysisLog.enter("<Function organizeAnalysisData>\n");
        this.getKeepList();
        int i = 0;
        while (i < this.posList.size()) {
            Integer pos = (Integer)this.posList.get(i);
            if (this.keepList.contains(pos)) {
                Map baseMap = (Map)this.callDic.get(pos);
                for (String chr : baseMap.keySet()) {
                    if (!this.callMap.containsKey(chr)) {
                        this.callMap.put(chr, new HashMap());
                    }
                    Map posMap = (Map)this.callMap.get(chr);
                    String call = (String)baseMap.get(chr);
                    posMap.put(pos, call);
                }
            }
            ++i;
        }
        this.snpAnalysisLog.exit("</Function organizeAnalysisData>\n");
    }

    public void getKeepList() {
        int i = 0;
        while (i < this.posList.size()) {
            String allele = null;
            boolean keep = false;
            Integer pos = (Integer)this.posList.get(i);
            Map baseMap = (Map)this.callDic.get(pos);
            for (String chr : baseMap.keySet()) {
                String call = (String)baseMap.get(chr);
                if (call.substring(0, 1).equals("E")) continue;
                if (call.split("/").length == 2 && call.indexOf(63) < 0) {
                    keep = true;
                    break;
                }
                if (call.indexOf(63) == 0) continue;
                if (allele == null) {
                    allele = call.substring(0, 1);
                    continue;
                }
                if (allele.equals(call.substring(0, 1))) continue;
                keep = true;
                break;
            }
            if (keep) {
                this.keepList.add(pos);
            } else {
                this.snpAnalysisLog.add("discard position: " + pos + "\n");
            }
            ++i;
        }
    }

    public void checkSnp() throws IOException {
        this.snpAnalysisLog.enter("<Function checkSnp>\n");
        int i = 0;
        while (i < this.posList.size()) {
            Integer pos = (Integer)this.posList.get(i);
            HashMap<String, String> map = new HashMap<String, String>();
            this.snpAnalysisLog.enter("Position: " + pos + "\n");
            int j = 1;
            while (j < this.rawData.size()) {
                String reason;
                String allele;
                String[] items = ((String)this.rawData.get(j)).trim().split("\t");
                String chr = items[0];
                String[] entry = items[i + 1].split("/");
                String cl = chr.split(this.config.getDelimeter())[this.config.getCellLinePos()];
                int qual = new Integer(entry[1]);
                String direction = entry[3];
                if (entry[0].equals("N")) {
                    allele = "?";
                    reason = "unsureQ";
                } else if (qual >= this.config.getQualAssureHomo() || this.homoClList.contains(cl)) {
                    allele = direction.equals("R") ? StringUtils.revCompSeq(entry[0]) : entry[0];
                    reason = "homoQ";
                } else if (qual >= this.config.getQualCutoff() && qual < this.config.getQualAssureHomo()) {
                    String[] value = direction.equals("F") ? this.getPolyByRefChromat(this.fRefDic, this.fReadDic, this.fHeteDic, pos, entry, chr) : this.getPolyByRefChromat(this.rRefDic, this.rReadDic, this.rHeteDic, pos, entry, chr);
                    allele = value[0];
                    reason = value[1];
                } else {
                    allele = "?";
                    reason = "unsureQ";
                }
                map.put(chr, String.valueOf(allele) + "(" + qual + ")");
                this.snpAnalysisLog.add(String.valueOf(chr) + " -> " + allele + "(" + qual + ")" + ", reason = " + reason + "\n");
                ++j;
            }
            this.callDic.put(pos, map);
            this.snpAnalysisLog.exit(" \n");
            ++i;
        }
        this.snpAnalysisLog.exit("</Function checkSnp>\n");
    }

    public String[] getPolyByRefChromat(Map refDic, Map readDic, Map heteDic, Integer pos, String[] entry, String chr) throws IOException {
        String allele;
        String reason;
        String direction = entry[3];
        if (this.isChrInRefDic(refDic, pos, chr)) {
            String reason2 = "isRef";
            String allele2 = direction.equals("R") ? StringUtils.revCompSeq(entry[0]) : entry[0];
            String[] ret = new String[]{allele2, reason2};
            return ret;
        }
        if (this.indexError(entry, chr)) {
            String reason3 = "error";
            String allele3 = "E";
            String[] ret = new String[]{allele3, reason3};
            return ret;
        }
        int qual = new Integer(entry[1]);
        int chrPos = new Integer(entry[2]);
        boolean passQ = this.passQualCutOff(qual, chrPos, (String)this.qualDic.get(chr));
        if (this.isSinglePeak(entry, chr)) {
            reason = "single";
            allele = direction.equals("R") ? StringUtils.revCompSeq(entry[0]) : entry[0];
            allele = String.valueOf(passQ ? "" : "?") + allele;
        } else {
            String[] peakInfo = this.getPeakInfo(chr, chrPos);
            boolean[] noiseCancelInfo = this.isNoiseCanceled(entry, refDic, pos, chr);
            if (noiseCancelInfo[0]) {
                reason = "canceled";
                if (noiseCancelInfo[1]) {
                    allele = direction.equals("R") ? StringUtils.revCompSeq(peakInfo[1]) : peakInfo[1];
                    System.out.println("dddddddd major peak canceled " + chr);
                } else {
                    allele = direction.equals("R") ? StringUtils.revCompSeq(peakInfo[0]) : peakInfo[0];
                }
                allele = String.valueOf(passQ ? "" : "?") + allele;
            } else {
                String[] value = this.analyzeDoublePeak(refDic, readDic, heteDic, pos, entry, chr, passQ);
                allele = value[0];
                reason = value[1];
                if (!passQ && allele.indexOf(63) == -1) {
                    allele = String.valueOf('?') + allele;
                }
            }
        }
        String[] ret = new String[]{allele, reason};
        return ret;
    }

    public String[] analyzeDoublePeak(Map refDic, Map readDic, Map heteDic, Integer pos, String[] entry, String chr, boolean passQ) throws IOException {
        Map alleleMap1 = null;
        Map alleleMap2 = null;
        String direction = entry[3];
        int qual = new Integer(entry[1]);
        int chrPos = new Integer(entry[2]);
        String baseAround = this.getBaseAround(chr, chrPos);
        List posReadList = (List)readDic.get(pos);
        Map posRefDic = (Map)refDic.get(pos);
        Map posHeteDic = (Map)heteDic.get(pos);
        String allele = this.getPeakInfo(chr, chrPos)[0];
        String peak2 = this.getPeakInfo(chr, chrPos)[1];
        if (posRefDic.containsKey(allele)) {
            alleleMap1 = (Map)posRefDic.get(allele);
        }
        if (posRefDic.containsKey(peak2)) {
            alleleMap2 = (Map)posRefDic.get(peak2);
        }
        if (posReadList.contains(allele) && posReadList.contains(peak2)) {
            if (alleleMap1 != null && alleleMap1.containsKey(baseAround) && alleleMap2 != null && alleleMap2.containsKey(baseAround) && passQ) {
                return this.checkHtByRef2((String)alleleMap1.get(baseAround), (String)alleleMap2.get(baseAround), posHeteDic, allele, peak2, chrPos, direction, chr);
            }
            if (alleleMap1 != null && alleleMap1.containsKey(baseAround) && (alleleMap2 == null || !alleleMap2.containsKey(baseAround)) && passQ) {
                return this.checkHtByRef1((String)alleleMap1.get(baseAround), posHeteDic, allele, peak2, chrPos, direction, chr);
            }
            if ((alleleMap1 == null || !alleleMap1.containsKey(baseAround)) && alleleMap2 != null && alleleMap2.containsKey(baseAround) && passQ) {
                return this.checkHtByRef1_2((String)alleleMap2.get(baseAround), posHeteDic, allele, peak2, chrPos, direction, chr);
            }
            return this.checkHtNoRef(posHeteDic, allele, peak2, chrPos, direction, chr);
        }
        if (posReadList.size() >= 2 && posReadList.contains(allele) && !posReadList.contains(peak2)) {
            if (alleleMap1 != null && alleleMap1.containsKey(baseAround) && passQ) {
                return this.checkHomoByRef1((String)alleleMap1.get(baseAround), allele, peak2, chrPos, direction, chr);
            }
            return this.checkHomoNoRef(allele, peak2, chrPos, direction, chr);
        }
        if (posReadList.size() >= 2 && !posReadList.contains(allele) && !posReadList.contains(peak2)) {
            return this.checkQuestionCallNoRef(allele, peak2, chrPos, direction, chr);
        }
        if (posReadList.size() == 1 && posReadList.contains(allele)) {
            if (alleleMap1 != null && alleleMap1.containsKey(baseAround) && passQ) {
                return this.checkHomoHtByRef1((String)alleleMap1.get(baseAround), posHeteDic, allele, peak2, chrPos, direction, chr);
            }
            return this.checkHomoHtNoRef(posHeteDic, allele, peak2, chrPos, direction, chr);
        }
        if (posReadList.size() == 1 && posReadList.contains(peak2)) {
            if (alleleMap2 != null && alleleMap2.containsKey(baseAround) && passQ) {
                return this.checkHtByRef1_2((String)alleleMap2.get(baseAround), posHeteDic, allele, peak2, chrPos, direction, chr);
            }
            return this.checkHtNoRef(posHeteDic, allele, peak2, chrPos, direction, chr);
        }
        if (posReadList.size() == 1 && !posReadList.contains(allele) && !posReadList.contains(peak2)) {
            return this.checkQuestionCallNoRef(allele, peak2, chrPos, direction, chr);
        }
        return this.checkQuestionCallNoRef(allele, peak2, chrPos, direction, chr);
    }

    public String[] checkHomoHtNoRef(Map posHeteDic, String allele, String allele2, int chrPos, String direction, String chr) throws IOException {
        String[] peakInfo = this.getPeakInfo(chr, chrPos);
        float area1 = new Float(peakInfo[2]).floatValue();
        float area2 = new Float(peakInfo[3]).floatValue();
        return this.checkHomoHtNoNormalized(allele, allele2, area1, area2, direction, posHeteDic);
    }

    public String[] checkHomoHtByRef1(String ref, Map posHeteDic, String allele, String allele2, int chrPos, String direction, String chr) throws IOException {
        int offset;
        String[] refArInfo;
        String[] entry = ref.split(",");
        String refChr = entry[0];
        int refPos = new Integer(entry[2]);
        String[] peakInfo = this.getPeakInfo(chr, chrPos);
        String[] refPeakInfo = this.getPeakInfo(refChr, refPos);
        float area1 = new Float(peakInfo[2]).floatValue();
        float area2 = new Float(peakInfo[3]).floatValue();
        float refArea = new Float(refPeakInfo[2]).floatValue();
        String[] arInfo = this.getBestPeak(chr, chrPos);
        boolean nomalized = this.isNomalize(arInfo, refArInfo = this.getRefPeak(refChr, refPos, offset = new Integer(arInfo[0]) - chrPos));
        if (nomalized) {
            return this.checkHomoHtByRefPrimaryPeak(allele, allele2, area1, area2, refArea, direction, posHeteDic);
        }
        return this.checkHomoHtNoNormalized(allele, allele2, area1, area2, direction, posHeteDic);
    }

    public String[] checkHomoHtNoNormalized(String allele, String allele2, float area1, float area2, String direction, Map posHeteDic) {
        String reason;
        String call;
        if ((double)area2 > this.config.getHtPeak()) {
            call = this.formatHtCall(allele, allele2, direction);
            reason = "137";
        } else if ((double)area2 < 0.1 || (double)area1 <= 1.0 && (double)(area2 / area1) < this.config.getNoiseRatio() || (double)area1 > 1.0 && (double)(area2 / area1) < 0.1) {
            call = direction.equals("R") ? StringUtils.revCompSeq(allele) : allele;
            reason = "138";
        } else if ((double)area2 > this.config.getNoisePeak()) {
            call = this.EvaluateHtCall(allele, allele2, area1, area2, direction, posHeteDic);
            reason = "139";
        } else if ((double)area2 < this.config.getNoisePeak()) {
            call = "?" + (direction.equals("R") ? StringUtils.revCompSeq(allele) : allele);
            reason = "140";
        } else {
            call = "?" + (direction.equals("R") ? StringUtils.revCompSeq(allele) : allele);
            reason = "141";
        }
        String[] ret = new String[]{call, reason};
        return ret;
    }

    public String[] checkHomoHtByRefPrimaryPeak(String allele, String allele2, float area1, float area2, float refArea1, String direction, Map posHeteDic) {
        String reason;
        String call;
        if ((double)(refArea1 / area1) > 1.4 && (double)(refArea1 / area1) < 4.0 && (double)area2 > this.config.getNoisePeak()) {
            call = this.formatHtCall(allele, allele2, direction);
            reason = "130";
        } else if ((double)(refArea1 / area1) > 1.4 && ((double)(refArea1 / area1) < 4.0 || (double)area1 > 0.2) && (double)area2 < this.config.getNoisePeak() && (double)area2 > 0.1) {
            call = "?" + this.formatHtCall(allele, allele2, direction);
            reason = "131";
        } else if ((double)(refArea1 / area1) > 1.3 && ((double)(refArea1 / area1) < 4.0 || (double)area1 > 0.2) && ((double)refArea1 > 1.5 || (double)area1 > 1.0) && (double)area2 > this.config.getNoisePeak()) {
            call = this.formatHtCall(allele, allele2, direction);
            reason = "132";
        } else if ((double)(refArea1 / area1) < 1.2 && (double)area2 < this.config.getNoisePeak()) {
            call = direction.equals("R") ? StringUtils.revCompSeq(allele) : allele;
            reason = "133";
        } else if ((double)area2 < 0.1 || (double)area1 <= 1.0 && (double)(area2 / area1) < this.config.getNoiseRatio() || (double)area1 > 1.0 && (double)(area2 / area1) < 0.1) {
            call = direction.equals("R") ? StringUtils.revCompSeq(allele) : allele;
            reason = "134";
        } else if ((double)area2 < this.config.getNoisePeak()) {
            call = "?" + (direction.equals("R") ? StringUtils.revCompSeq(allele) : allele);
            reason = "135";
        } else {
            call = this.EvaluateHtCall(allele, allele2, area1, area2, direction, posHeteDic);
            reason = "136";
        }
        String[] ret = new String[]{call, reason};
        return ret;
    }

    public String[] checkQuestionCallNoRef(String allele, String allele2, int chrPos, String direction, String chr) throws IOException {
        String reason;
        String call;
        String[] peakInfo = this.getPeakInfo(chr, chrPos);
        float area1 = new Float(peakInfo[2]).floatValue();
        float area2 = new Float(peakInfo[3]).floatValue();
        if ((double)area2 > this.config.getHtPeak() + 0.1) {
            call = "?" + this.formatHtCall(allele, allele2, direction);
            reason = "128";
        } else {
            call = "?" + (direction.equals("R") ? StringUtils.revCompSeq(allele) : allele);
            reason = "129";
        }
        String[] ret = new String[]{call, reason};
        return ret;
    }

    public String[] checkHomoNoRef(String allele, String allele2, int chrPos, String direction, String chr) throws IOException {
        String[] peakInfo = this.getPeakInfo(chr, chrPos);
        float area1 = new Float(peakInfo[2]).floatValue();
        float area2 = new Float(peakInfo[3]).floatValue();
        return this.checkHomoNoNormalized(allele, allele2, area1, area2, direction);
    }

    public String[] checkHtNoRef(Map posHeteDic, String allele, String allele2, int chrPos, String direction, String chr) throws IOException {
        String[] peakInfo = this.getPeakInfo(chr, chrPos);
        float area1 = new Float(peakInfo[2]).floatValue();
        float area2 = new Float(peakInfo[3]).floatValue();
        return this.checkHtNoNormalized(allele, allele2, area1, area2, direction, posHeteDic);
    }

    public String[] checkHomoByRef1(String ref, String allele, String allele2, int chrPos, String direction, String chr) throws IOException {
        int offset;
        String[] refArInfo;
        String[] entry = ref.split(",");
        String refChr = entry[0];
        int refPos = new Integer(entry[2]);
        String[] peakInfo = this.getPeakInfo(chr, chrPos);
        String[] refPeakInfo = this.getPeakInfo(refChr, refPos);
        float area1 = new Float(peakInfo[2]).floatValue();
        float area2 = new Float(peakInfo[3]).floatValue();
        float refArea = new Float(refPeakInfo[2]).floatValue();
        String[] arInfo = this.getBestPeak(chr, chrPos);
        boolean nomalized = this.isNomalize(arInfo, refArInfo = this.getRefPeak(refChr, refPos, offset = new Integer(arInfo[0]) - chrPos));
        if (nomalized) {
            return this.checkHomoByRefPrimaryPeak(allele, allele2, area1, area2, refArea, direction);
        }
        return this.checkHomoNoNormalized(allele, allele2, area1, area2, direction);
    }

    public String[] checkHomoNoNormalized(String allele, String allele2, float area1, float area2, String direction) {
        String reason;
        String call;
        if ((double)area2 < this.config.getHtPeak()) {
            call = direction.equals("R") ? StringUtils.revCompSeq(allele) : allele;
            reason = "125";
        } else if ((double)area2 > this.config.getHtPeak() + 0.1) {
            call = "?" + this.formatHtCall(allele, allele2, direction);
            reason = "126";
        } else {
            call = "?" + (direction.equals("R") ? StringUtils.revCompSeq(allele) : allele);
            reason = "127";
        }
        String[] ret = new String[]{call, reason};
        return ret;
    }

    public String[] checkHomoByRefPrimaryPeak(String allele, String allele2, float area1, float area2, float refArea1, String direction) {
        String reason;
        String call;
        if ((double)(refArea1 / area1) < 1.4) {
            call = direction.equals("R") ? StringUtils.revCompSeq(allele) : allele;
            reason = "121";
        } else if ((double)area2 < this.config.getHtPeak()) {
            call = direction.equals("R") ? StringUtils.revCompSeq(allele) : allele;
            reason = "122";
        } else if ((double)area2 > this.config.getHtPeak() + 0.1) {
            call = "?" + this.formatHtCall(allele, allele2, direction);
            reason = "123";
        } else {
            call = "?" + (direction.equals("R") ? StringUtils.revCompSeq(allele) : allele);
            reason = "124";
        }
        String[] ret = new String[]{call, reason};
        return ret;
    }

    public String[] checkHtByRef1_2(String ref, Map posHeteDic, String allele, String allele2, int chrPos, String direction, String chr) throws IOException {
        int offset;
        String[] refArInfo;
        String[] entry = ref.split(",");
        String refChr = entry[0];
        int refPos = new Integer(entry[2]);
        String[] peakInfo = this.getPeakInfo(chr, chrPos);
        String[] refPeakInfo = this.getPeakInfo(refChr, refPos);
        float area1 = new Float(peakInfo[2]).floatValue();
        float area2 = new Float(peakInfo[3]).floatValue();
        float refArea = new Float(refPeakInfo[2]).floatValue();
        String[] arInfo = this.getBestPeak(chr, chrPos);
        boolean nomalized = this.isNomalize(arInfo, refArInfo = this.getRefPeak(refChr, refPos, offset = new Integer(arInfo[0]) - chrPos));
        if (nomalized) {
            return this.checkHtByRefSecondaryPeak(allele, allele2, area1, area2, refArea, direction, posHeteDic);
        }
        return this.checkHtNoNormalized(allele, allele2, area1, area2, direction, posHeteDic);
    }

    public String[] checkHtByRef1(String ref1, Map posHeteDic, String allele, String allele2, int chrPos, String direction, String chr) throws IOException {
        int offset;
        String[] refArInfo1;
        String[] entry1 = ref1.split(",");
        String refChr1 = entry1[0];
        int refPos1 = new Integer(entry1[2]);
        String[] peakInfo = this.getPeakInfo(chr, chrPos);
        String[] refPeakInfo1 = this.getPeakInfo(refChr1, refPos1);
        float area1 = new Float(peakInfo[2]).floatValue();
        float area2 = new Float(peakInfo[3]).floatValue();
        float refArea1 = new Float(refPeakInfo1[2]).floatValue();
        String[] arInfo = this.getBestPeak(chr, chrPos);
        boolean nomalized = this.isNomalize(arInfo, refArInfo1 = this.getRefPeak(refChr1, refPos1, offset = new Integer(arInfo[0]) - chrPos));
        if (nomalized) {
            return this.checkHtByRefPrimaryPeak(allele, allele2, area1, area2, refArea1, direction, posHeteDic);
        }
        return this.checkHtNoNormalized(allele, allele2, area1, area2, direction, posHeteDic);
    }

    public String[] checkHtByRef2(String ref1, String ref2, Map posHeteDic, String allele, String allele2, int chrPos, String direction, String chr) throws IOException {
        String[] entry1 = ref1.split(",");
        String[] entry2 = ref2.split(",");
        String refChr1 = entry1[0];
        String refChr2 = entry2[0];
        int refPos1 = new Integer(entry1[2]);
        int refPos2 = new Integer(entry2[2]);
        String[] peakInfo = this.getPeakInfo(chr, chrPos);
        String[] refPeakInfo1 = this.getPeakInfo(refChr1, refPos1);
        String[] refPeakInfo2 = this.getPeakInfo(refChr2, refPos2);
        float area1 = new Float(peakInfo[2]).floatValue();
        float area2 = new Float(peakInfo[3]).floatValue();
        float refArea1 = new Float(refPeakInfo1[2]).floatValue();
        float refArea2 = new Float(refPeakInfo2[2]).floatValue();
        String[] arInfo = this.getBestPeak(chr, chrPos);
        int offset = new Integer(arInfo[0]) - chrPos;
        String[] refArInfo1 = this.getRefPeak(refChr1, refPos1, offset);
        String[] refArInfo2 = this.getRefPeak(refChr2, refPos2, offset);
        boolean nomalized1 = this.isNomalize(arInfo, refArInfo1);
        boolean nomalized2 = this.isNomalize(arInfo, refArInfo2);
        if (nomalized1) {
            return this.checkHtByRefPrimaryPeak(allele, allele2, area1, area2, refArea1, direction, posHeteDic);
        }
        if (nomalized2) {
            return this.checkHtByRefSecondaryPeak(allele, allele2, area1, area2, refArea2, direction, posHeteDic);
        }
        return this.checkHtNoNormalized(allele, allele2, area1, area2, direction, posHeteDic);
    }

    public String[] checkHtNoNormalized(String allele, String allele2, float area1, float area2, String direction, Map posHeteDic) {
        String reason;
        String call;
        if ((double)area2 > this.config.getHtPeak()) {
            call = this.formatHtCall(allele, allele2, direction);
            reason = "116";
        } else if ((double)area2 > this.config.getNoisePeak() && (double)(area2 / area1) > this.config.getHtRatio()) {
            call = this.formatHtCall(allele, allele2, direction);
            reason = "117";
        } else if ((double)area2 < 0.1 || (double)area1 <= 1.0 && (double)(area2 / area1) < this.config.getNoiseRatio() || (double)area1 > 1.0 && (double)(area2 / area1) < 0.1) {
            call = direction.equals("R") ? StringUtils.revCompSeq(allele) : allele;
            reason = "118";
        } else if ((double)area2 < this.config.getNoisePeak()) {
            call = "?" + (direction.equals("R") ? StringUtils.revCompSeq(allele) : allele);
            reason = "119";
        } else {
            call = this.EvaluateHtCall(allele, allele2, area1, area2, direction, posHeteDic);
            reason = "120";
        }
        String[] ret = new String[]{call, reason};
        return ret;
    }

    public String[] checkHtByRefSecondaryPeak(String allele, String allele2, float area1, float area2, float refArea2, String direction, Map posHeteDic) {
        String reason;
        String call;
        if ((double)(refArea2 / area2) > 1.3) {
            if ((double)area2 >= this.config.getNoisePeak() && (double)(refArea2 / area2) < 5.0) {
                call = this.formatHtCall(allele, allele2, direction);
                reason = "108";
            } else if ((double)area2 < this.config.getNoisePeak() && ((double)(refArea2 / area2) >= 5.0 || (double)(area2 / area1) < this.config.getNoiseRatio())) {
                call = direction.equals("R") ? StringUtils.revCompSeq(allele) : allele;
                reason = "109";
            } else if ((double)area2 < 0.1 || (double)area1 <= 1.0 && (double)(area2 / area1) < this.config.getNoiseRatio() || (double)area1 > 1.0 && (double)(area2 / area1) < 0.1) {
                call = direction.equals("R") ? StringUtils.revCompSeq(allele) : allele;
                reason = "110";
            } else if ((double)area2 < this.config.getNoisePeak()) {
                call = "?" + (direction.equals("R") ? StringUtils.revCompSeq(allele) : allele);
                reason = "111";
            } else {
                call = "?" + this.formatHtCall(allele, allele2, direction);
                reason = "112";
            }
        } else if ((double)area2 < 0.1 || (double)area1 <= 1.0 && (double)(area2 / area1) < this.config.getNoiseRatio() || (double)area1 > 1.0 && (double)(area2 / area1) < 0.1) {
            call = direction.equals("R") ? StringUtils.revCompSeq(allele) : allele;
            reason = "113";
        } else if ((double)area2 < this.config.getNoisePeak()) {
            call = "?" + (direction.equals("R") ? StringUtils.revCompSeq(allele) : allele);
            reason = "114";
        } else {
            call = this.EvaluateHtCall(allele, allele2, area1, area2, direction, posHeteDic);
            reason = "115";
        }
        String[] ret = new String[]{call, reason};
        return ret;
    }

    public String[] checkHtByRefPrimaryPeak(String allele, String allele2, float area1, float area2, float refArea1, String direction, Map posHeteDic) {
        String reason;
        String call;
        if (this.peakDrop(refArea1, area1, area2)) {
            if ((double)area2 > this.config.getNoisePeak()) {
                call = this.formatHtCall(allele, allele2, direction);
                reason = "100";
            } else if ((double)area2 < 0.1 || (double)area1 <= 1.0 && (double)(area2 / area1) < this.config.getNoiseRatio() || (double)area1 > 1.0 && (double)(area2 / area1) < 0.1) {
                call = "?" + (direction.equals("R") ? StringUtils.revCompSeq(allele) : allele);
                reason = "101";
            } else {
                call = "?" + this.formatHtCall(allele, allele2, direction);
                reason = "102";
            }
        } else if ((double)(refArea1 / area1) < 1.2 && (double)area2 < this.config.getNoisePeak()) {
            call = direction.equals("R") ? StringUtils.revCompSeq(allele) : allele;
            reason = "103";
        } else if ((double)area2 < 0.1 || (double)area1 <= 1.0 && (double)(area2 / area1) < this.config.getNoiseRatio() || (double)area1 > 1.0 && (double)(area2 / area1) < 0.1) {
            call = direction.equals("R") ? StringUtils.revCompSeq(allele) : allele;
            reason = "104";
        } else if ((double)area2 < this.config.getNoisePeak()) {
            call = "?" + (direction.equals("R") ? StringUtils.revCompSeq(allele) : allele);
            reason = "105";
        } else if ((double)area2 > this.config.getHtPeak()) {
            call = this.formatHtCall(allele, allele2, direction);
            reason = "106";
        } else {
            call = this.EvaluateHtCall(allele, allele2, area1, area2, direction, posHeteDic);
            reason = "107";
        }
        String[] ret = new String[]{call, reason};
        return ret;
    }

    public String EvaluateHtCall(String allele, String allele2, float area1, float area2, String direction, Map posHeteDic) {
        String peaks = allele.compareTo(allele2) < 0 ? String.valueOf(allele) + allele2 : String.valueOf(allele2) + allele;
        if (posHeteDic.containsKey(peaks)) {
            float ratio = area2 / area1;
            String[] value = ((String)posHeteDic.get(peaks)).split(",");
            float refRatio = new Float(value[1]).floatValue();
            if ((double)(ratio / refRatio) < 0.5) {
                return direction.equals("R") ? StringUtils.revCompSeq(allele) : allele;
            }
            return "?" + this.formatHtCall(allele, allele2, direction);
        }
        return "?" + this.formatHtCall(allele, allele2, direction);
    }

    public boolean peakDrop(float refArea1, float area1, float area2) {
        if ((double)(refArea1 / area1) > 1.4 && (double)(refArea1 / area1) < 4.0) {
            return true;
        }
        return (double)(refArea1 / area1) > 1.3 && (double)(refArea1 / area1) < 4.0 && ((double)refArea1 > 1.5 || (double)area1 > 1.0);
    }

    public String formatHtCall(String allele1, String allele2, String direction) {
        String call1 = direction.equals("R") ? StringUtils.revCompSeq(allele1) : allele1;
        String call2 = direction.equals("R") ? StringUtils.revCompSeq(allele2) : allele2;
        return String.valueOf(call1) + "/" + call2;
    }

    public boolean isNomalize(String[] arInfo, String[] refArInfo) {
        if (arInfo[3].endsWith(refArInfo[1])) {
            float area;
            float refArea = new Float(refArInfo[0]).floatValue();
            return !(refArea > (area = new Float(arInfo[2]).floatValue()) && (double)((refArea - area) / refArea) > 0.25) && (!(refArea <= area) || !((double)((area - refArea) / area) > 0.25));
        }
        return false;
    }

    public String[] getRefPeak(String chr, int pos, int offset) throws IOException {
        String polyFn = new File(new File(this.polyDir), String.valueOf(chr) + ".poly").getAbsolutePath();
        List polyData = this.handler.readFile(polyFn);
        String[] data = ((String)polyData.get(pos + offset + 1)).trim().split("\\s+");
        String[] ret = new String[]{data[3], data[0]};
        return ret;
    }

    public String[] getBestPeak(String chr, int pos) throws IOException {
        String polyFn = new File(new File(this.polyDir), String.valueOf(chr) + ".poly").getAbsolutePath();
        List polyData = this.handler.readFile(polyFn);
        int maxQual = 0;
        int maxPos = -1;
        String[] quals = ((String)this.qualDic.get(chr)).trim().split("\\s+");
        int i = pos - 2;
        while (i < pos + 3) {
            if (i != pos && i != pos + 1 && new Integer(quals[i]) > maxQual) {
                maxQual = new Integer(quals[i]);
                maxPos = i;
            }
            ++i;
        }
        String[] data = ((String)polyData.get(maxPos + 1)).trim().split("\\s+");
        float maxArea = new Float(data[3]).floatValue();
        String maxCall = data[0];
        String[] ret = new String[]{String.valueOf(maxPos), String.valueOf(maxQual), String.valueOf(maxArea), maxCall};
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean[] isNoiseCanceled(String[] entry, Map refDic, Integer pos, String chr) throws IOException {
        boolean[] ret = new boolean[]{false, false};
        int chrPos = new Integer(entry[2]);
        String baseAround = this.getBaseAround(chr, chrPos);
        String[] peakInfo = this.getPeakInfo(chr, chrPos);
        float area1 = new Float(peakInfo[2]).floatValue();
        float area2 = new Float(peakInfo[3]).floatValue();
        String allele = peakInfo[0];
        String peak2 = peakInfo[1];
        Map alleleMap = (Map)refDic.get(pos);
        if (alleleMap.containsKey(allele)) {
            Map baseMap = (Map)alleleMap.get(allele);
            if (!baseMap.containsKey(baseAround)) return ret;
            String[] value = ((String)baseMap.get(baseAround)).split(",");
            String refChr = value[0];
            int refChrPos = new Integer(value[2]);
            String[] refPeakInfo = this.getPeakInfo(refChr, refChrPos);
            float refArea1 = new Float(refPeakInfo[2]).floatValue();
            float refArea2 = new Float(refPeakInfo[3]).floatValue();
            String refPeak2 = refPeakInfo[1];
            if (!peak2.equals(refPeak2)) {
                return ret;
            }
            if ((double)Math.abs(area2 - refArea2) < 0.1 || (double)Math.abs(refArea2 / refArea1 - area2 / area1) < 0.1) {
                ret[0] = true;
                return ret;
            }
            if (!((double)refArea2 > 0.25) || !((double)Math.abs(area2 - refArea2) < 0.15) && !((double)Math.abs(refArea2 / refArea1 - area2 / area1) < 0.15)) return ret;
            ret[0] = true;
            return ret;
        }
        if (!((double)(area2 / area1) > 0.75) || !alleleMap.containsKey(peak2)) return ret;
        Map baseMap = (Map)alleleMap.get(peak2);
        if (!baseMap.containsKey(baseAround)) return ret;
        String[] value = ((String)baseMap.get(baseAround)).split(",");
        String refChr = value[0];
        int refChrPos = new Integer(value[2]);
        String[] refPeakInfo = this.getPeakInfo(refChr, refChrPos);
        float refArea1 = new Float(refPeakInfo[2]).floatValue();
        float refArea2 = new Float(refPeakInfo[3]).floatValue();
        String refPeak2 = refPeakInfo[1];
        if (!allele.equals(refPeak2)) {
            return ret;
        }
        if (!((double)Math.abs(refArea2 / refArea1 - area2 / area1) < 0.2)) return ret;
        System.out.println("new noise canceled");
        ret[0] = true;
        ret[1] = true;
        return ret;
    }

    public boolean isSinglePeak(String[] entry, String chr) throws IOException {
        int chrPos = new Integer(entry[2]);
        String polyFn = new File(new File(this.polyDir), String.valueOf(chr) + ".poly").getAbsolutePath();
        List polyData = this.handler.readFile(polyFn);
        String[] data = ((String)polyData.get(chrPos + 1)).trim().split("\\s+");
        return data[4].equals("N") && new Integer(data[5]) == -1 || data[0].equals(data[4]);
    }

    public boolean passQualCutOff(int qual, int chrPos, String quals) {
        int[] aveQual = SnpCommon.getAveQualAround(chrPos, quals, 4);
        int[] aveQual3 = SnpCommon.getAveQualAround3(chrPos, quals, 4);
        return aveQual[0] > this.config.getQualAroundCutoff() && aveQual[1] > this.config.getQualAroundCutoff() || qual > this.config.getQualAroundCutoffHigh() && (aveQual[0] > this.config.getQualAroundCutoffHigh() || aveQual[1] > this.config.getQualAroundCutoffHigh()) || aveQual[0] > this.config.getQualAssure() || aveQual[1] > this.config.getQualAssure() || aveQual3[0] > this.config.getQualAssure() || aveQual3[1] > this.config.getQualAssure();
    }

    public boolean indexError(String[] entry, String chr) throws IOException {
        int chrPos = new Integer(entry[2]);
        String polyFn = new File(new File(this.polyDir), String.valueOf(chr) + ".poly").getAbsolutePath();
        List polyData = this.handler.readFile(polyFn);
        String[] data = ((String)polyData.get(chrPos + 1)).trim().split("\\s+");
        if (!data[0].equals(entry[0]) && !data[4].equals(entry[0])) {
            System.out.println("index error:" + data[0] + " " + data[4] + entry[0]);
            return true;
        }
        return false;
    }

    public boolean isChrInRefDic(Map refDic, Integer pos, String chr) {
        Map posRefDic = (Map)refDic.get(pos);
        for (String call : posRefDic.keySet()) {
            Map alleleMap = (Map)posRefDic.get(call);
            for (String baseAround : alleleMap.keySet()) {
                String tmpChr = ((String)alleleMap.get(baseAround)).split(",")[0];
                if (!tmpChr.equals(chr)) continue;
                return true;
            }
        }
        return false;
    }

    public void getChromatReadDic() throws IOException {
        this.snpAnalysisLog.enter("<Function getChromatReadDic>\n");
        int i = 0;
        while (i < this.posList.size()) {
            Integer pos = (Integer)this.posList.get(i);
            this.fReadDic.put(pos, new ArrayList());
            this.rReadDic.put(pos, new ArrayList());
            this.fHeteDic.put(pos, new HashMap());
            this.rHeteDic.put(pos, new HashMap());
            int j = 1;
            while (j < this.rawData.size()) {
                String[] items = ((String)this.rawData.get(j)).trim().split("\t");
                String chr = items[0];
                String[] entry = items[i + 1].split("/");
                if (new Integer(entry[1]) >= this.config.getQualCutoff()) {
                    if (this.fChromats.contains(chr)) {
                        this.checkQualifiedRead(chr, pos, entry, this.fReadDic);
                        this.checkQualifiedHete(chr, pos, entry, this.fHeteDic);
                    } else if (this.rChromats.contains(chr)) {
                        this.checkQualifiedRead(chr, pos, entry, this.rReadDic);
                        this.checkQualifiedHete(chr, pos, entry, this.rHeteDic);
                    }
                }
                ++j;
            }
            ++i;
        }
        this.addRefHeteToLog();
        this.snpAnalysisLog.exit("</Function getChromatReadDic>\n");
    }

    public void addRefHeteToLog() {
        int i = 0;
        while (i < this.posList.size()) {
            String value;
            Integer pos = (Integer)this.posList.get(i);
            this.snpAnalysisLog.add("ref hete for pos: " + pos + "\n");
            Map map = (Map)this.fHeteDic.get(pos);
            for (String call : map.keySet()) {
                value = (String)map.get(call);
                this.snpAnalysisLog.add("forward ref hete: " + call + " " + value + "\n");
            }
            map = (Map)this.rHeteDic.get(pos);
            for (String call : map.keySet()) {
                value = (String)map.get(call);
                this.snpAnalysisLog.add("reverse ref hete: " + call + " " + value + "\n");
            }
            ++i;
        }
    }

    public void checkQualifiedHete(String chr, Integer pos, String[] entry, Map heteDic) throws IOException {
        String cl = chr.split(this.config.getDelimeter())[this.config.getCellLinePos()];
        if (this.homoClList.contains(cl)) {
            return;
        }
        Map map = (Map)heteDic.get(pos);
        int chrPos = new Integer(entry[2]);
        int[] aveQual = SnpCommon.getAveQualAround(new Integer(entry[2]), (String)this.qualDic.get(chr), 4);
        int[] aveQual3 = SnpCommon.getAveQualAround3(new Integer(entry[2]), (String)this.qualDic.get(chr), 4);
        if (aveQual[0] > this.config.getQualAroundCutoff() && aveQual[1] > this.config.getQualAroundCutoff() || aveQual[0] > this.config.getQualAroundCutoffHigh() || aveQual[1] > this.config.getQualAroundCutoffHigh() || aveQual3[0] > this.config.getQualAssure() || aveQual3[1] > this.config.getQualAssure()) {
            String polyFn = new File(new File(this.polyDir), String.valueOf(chr) + ".poly").getAbsolutePath();
            List polyData = this.handler.readFile(polyFn);
            String[] data = ((String)polyData.get(chrPos + 1)).trim().split("\\s+");
            Float f = new Float(data[7]);
            if ((double)f.floatValue() > 0.25) {
                String base1 = data[0];
                String base2 = data[4];
                String call = base1.compareTo(base2) < 0 ? String.valueOf(base1) + base2 : String.valueOf(base2) + base1;
                float ratio = new Float(data[7]).floatValue() / new Float(data[3]).floatValue();
                if (!map.containsKey(call)) {
                    map.put(call, String.valueOf(chr) + "," + ratio);
                } else {
                    String[] items = ((String)map.get(call)).split(",");
                    Float f2 = new Float(items[1]);
                    if (ratio > f2.floatValue()) {
                        map.put(call, String.valueOf(chr) + "," + ratio);
                    }
                }
            }
        }
    }

    public void checkQualifiedRead(String chr, Integer pos, String[] entry, Map readDic) throws IOException {
        String cl;
        List list = (List)readDic.get(pos);
        if (this.homoClList.size() > 0 && this.homoClList.contains(cl = chr.split(this.config.getDelimeter())[this.config.getCellLinePos()])) {
            if (!list.contains(entry[0])) {
                list.add(entry[0]);
            }
            return;
        }
        if (new Integer(entry[1]) >= 35) {
            int[] aveQual = SnpCommon.getAveQualAround(new Integer(entry[2]), (String)this.qualDic.get(chr), 4);
            int[] aveQual3 = SnpCommon.getAveQualAround3(new Integer(entry[2]), (String)this.qualDic.get(chr), 4);
            if ((aveQual[0] > this.config.getQualAroundCutoff() && aveQual[1] > this.config.getQualAroundCutoff() || aveQual[0] > this.config.getQualAroundCutoffHigh() || aveQual[1] > this.config.getQualAroundCutoffHigh() || aveQual3[0] > this.config.getQualAssure() || aveQual3[1] > this.config.getQualAssure()) && !list.contains(entry[0])) {
                list.add(entry[0]);
            }
        }
    }

    public void getRefChromatDic() throws IOException {
        this.snpAnalysisLog.enter("<Function getRefChromatDic>\n");
        this.sortChromatByDirection();
        String[] positions = ((String)this.rawData.get(0)).split("\t");
        int i = 1;
        while (i < positions.length) {
            this.posList.add(new Integer(positions[i]));
            ++i;
        }
        int i2 = 0;
        while (i2 < this.posList.size()) {
            Integer pos = (Integer)this.posList.get(i2);
            this.fRefDic.put(pos, new HashMap());
            this.rRefDic.put(pos, new HashMap());
            int j = 1;
            while (j < this.rawData.size()) {
                String[] items = ((String)this.rawData.get(j)).trim().split("\t");
                String chr = items[0];
                String[] entry = items[i2 + 1].split("/");
                if (new Integer(entry[1]) >= this.config.getRefChromatQuality()) {
                    if (this.fChromats.contains(chr)) {
                        this.checkQualifiedRefChromat(chr, pos, entry, this.fRefDic);
                    } else if (this.rChromats.contains(chr)) {
                        this.checkQualifiedRefChromat(chr, pos, entry, this.rRefDic);
                    }
                }
                ++j;
            }
            ++i2;
        }
        if (this.config.isHomoExist()) {
            this.forceRefChromats(this.fRefDic, this.fChromats);
            this.forceRefChromats(this.rRefDic, this.rChromats);
        }
        this.addRefToLog();
        this.snpAnalysisLog.exit("</Function getRefChromatDic>\n");
    }

    public void addRefToLog() {
        int i = 0;
        while (i < this.posList.size()) {
            Map bMap;
            Integer pos = (Integer)this.posList.get(i);
            this.snpAnalysisLog.add("ref for pos: " + pos + "\n");
            Map aMap = (Map)this.fRefDic.get(pos);
            for (String a : aMap.keySet()) {
                bMap = (Map)aMap.get(a);
                for (String b : bMap.keySet()) {
                    this.snpAnalysisLog.add("forward ref: " + a + " " + b + " " + (String)bMap.get(b) + "\n");
                }
            }
            aMap = (Map)this.rRefDic.get(pos);
            for (String a : aMap.keySet()) {
                bMap = (Map)aMap.get(a);
                for (String b : bMap.keySet()) {
                    this.snpAnalysisLog.add("reverse ref: " + a + " " + b + " " + (String)bMap.get(b) + "\n");
                }
            }
            ++i;
        }
    }

    public void forceRefChromats(Map refDic, List chromats) throws IOException {
        int i = 0;
        while (i < this.posList.size()) {
            Integer pos = (Integer)this.posList.get(i);
            Map map = (Map)refDic.get(pos);
            if (map.size() == 0) {
                int tempChrPos = -1;
                int tempQual = -1;
                float temp2ndPeak = 2.0f;
                String tempChr = "";
                String tempAllele = "";
                String tempBaseAround = "";
                int j = 1;
                while (j < this.rawData.size()) {
                    String[] items = ((String)this.rawData.get(j)).trim().split("\t");
                    String chr = items[0];
                    String[] entry = items[i + 1].split("/");
                    int thisQual = new Integer(entry[1]);
                    if (chromats.contains(chr) && thisQual >= this.config.getQualCutoff()) {
                        int thisChrPos = new Integer(entry[2]);
                        float this2ndPeak = new Float(this.getPeakInfo(chr, thisChrPos)[3]).floatValue();
                        String thisAllele = entry[0];
                        String thisBaseAround = this.getBaseAround(chr, thisChrPos);
                        if (SnpCommon.passContQual(thisChrPos, (String)this.qualDic.get(chr), 2, 35) && thisQual > tempQual && this2ndPeak <= temp2ndPeak) {
                            tempChrPos = thisChrPos;
                            tempChr = chr;
                            tempAllele = thisAllele;
                            tempQual = thisQual;
                            temp2ndPeak = this2ndPeak;
                            tempBaseAround = thisBaseAround;
                        }
                    }
                    ++j;
                }
                if (tempQual > 0) {
                    HashMap<String, String> baseMap = new HashMap<String, String>();
                    baseMap.put(tempBaseAround, String.valueOf(tempChr) + "," + tempQual + "," + tempChrPos);
                    map.put(tempAllele, baseMap);
                }
            }
            ++i;
        }
    }

    public String[] getPeakInfo(String chr, int pos) throws IOException {
        String polyFn = new File(new File(this.polyDir), String.valueOf(chr) + ".poly").getAbsolutePath();
        List polyData = this.handler.readFile(polyFn);
        String[] data = ((String)polyData.get(pos + 1)).trim().split("\\s+");
        String[] ret = new String[]{data[0], data[4], data[3], data[7]};
        return ret;
    }

    public void checkQualifiedRefChromat(String chr, Integer pos, String[] entry, Map refDic) throws IOException {
        String baseAround = this.getBaseAround(chr, new Integer(entry[2]));
        String allele = entry[0];
        int qual = new Integer(entry[1]);
        int chrPos = new Integer(entry[2]);
        boolean highQ = this.highQual(new Integer(entry[2]), (String)this.qualDic.get(chr));
        boolean allHighQ = this.allHighQual(new Integer(entry[2]), (String)this.qualDic.get(chr));
        boolean lowNoise = this.lowNoiseAround(chrPos, chr);
        if (this.homoClList.size() > 0) {
            String cl = chr.split(this.config.getDelimeter())[this.config.getCellLinePos()];
            if (this.homoClList.contains(cl) && highQ) {
                this.populateRefMap(chr, pos, refDic, baseAround, allele, qual, chrPos);
            }
        } else if (allHighQ || highQ && lowNoise) {
            this.populateRefMap(chr, pos, refDic, baseAround, allele, qual, chrPos);
        }
    }

    private void populateRefMap(String chr, Integer pos, Map refDic, String baseAround, String allele, int qual, int chrPos) {
        Map map = (Map)refDic.get(pos);
        Map baseMap = map.containsKey(allele) ? (Map)map.get(allele) : new HashMap();
        if (baseMap.containsKey(baseAround)) {
            String[] items = ((String)baseMap.get(baseAround)).split(",");
            if (new Integer(items[1]) < qual) {
                baseMap.put(baseAround, String.valueOf(chr) + "," + qual + "," + chrPos);
            }
        } else {
            baseMap.put(baseAround, String.valueOf(chr) + "," + qual + "," + chrPos);
        }
        map.put(allele, baseMap);
    }

    public boolean lowNoiseAround(int chrPos, String chr) throws IOException {
        String polyFn = new File(new File(this.polyDir), String.valueOf(chr) + ".poly").getAbsolutePath();
        List polyData = this.handler.readFile(polyFn);
        int lineNum = chrPos + 1;
        boolean ret = true;
        String[] data = ((String)polyData.get(lineNum)).trim().split("\\s+");
        Float f = new Float(data[7]);
        if ((double)f.floatValue() > 0.15) {
            return false;
        }
        int i = lineNum - 2;
        while (i < lineNum + 3) {
            if (i >= 1 && i < polyData.size() && !(data = ((String)polyData.get(i)).trim().split("\\s+"))[4].equals("N")) {
                Float f2 = new Float(data[3]);
                Float f3 = new Float(data[7]);
                if (f2.floatValue() / f3.floatValue() < 5.0f) {
                    return false;
                }
            }
            ++i;
        }
        return ret;
    }

    public boolean allHighQual(int chrPos, String chrQuals) {
        boolean ret = true;
        String[] quals = chrQuals.trim().split("\\s+");
        int i = chrPos - 2;
        while (i < chrPos + 3) {
            if (i >= 0 && i < quals.length && new Integer(quals[i]) < this.config.getRefChromatQualityHigh()) {
                return false;
            }
            ++i;
        }
        return ret;
    }

    public boolean highQual(int chrPos, String chrQuals) {
        boolean ret = true;
        String[] quals = chrQuals.trim().split("\\s+");
        int i = chrPos - 2;
        while (i < chrPos + 3) {
            if (i >= 0 && i < quals.length && new Integer(quals[i]) < this.config.getRefChromatQuality()) {
                return false;
            }
            ++i;
        }
        return ret;
    }

    public String getBaseAround(String chr, int pos) throws IOException {
        String polyFn = new File(new File(this.polyDir), String.valueOf(chr) + ".poly").getAbsolutePath();
        List polyData = this.handler.readFile(polyFn);
        String[] data5 = ((String)polyData.get(pos)).trim().split("\\s+");
        if (pos + 2 < polyData.size()) {
            String[] data3 = ((String)polyData.get(pos + 2)).trim().split("\\s+");
            return String.valueOf(data5[0]) + data3[0];
        }
        return String.valueOf(data5[0]) + "N";
    }

    public void sortChromatByDirection() {
        int i = 1;
        while (i < this.rawData.size()) {
            String[] items = ((String)this.rawData.get(i)).trim().split("\t");
            String chr = items[0];
            int j = 1;
            while (j < items.length) {
                String direction = items[j].split("/")[3];
                if (direction.equals("F")) {
                    this.fChromats.add(chr);
                    break;
                }
                if (direction.equals("R")) {
                    this.rChromats.add(chr);
                    break;
                }
                ++j;
            }
            ++i;
        }
    }
}

