/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import misc.AmbiguityPair;
import misc.AmbiguityTestResult;
import misc.DiploidType;
import misc.FileManager;
import misc.StringUtils;
import misc.TestAmbiguity0620;

public class ResolveAmbiguity0620 {
    private static boolean IS_MIN_SET = true;
    private static int OPT_PRIMER_SIZE = 18;
    private static int MIN_PRIMER_SIZE = 16;
    private static int MAX_PRIMER_SIZE = 20;
    private static int OPT_PRIMER_TM = 52;
    private static int MIN_PRIMER_TM = 47;
    private static int MAX_PRIMER_TM = 60;

    public static void main(String[] args) throws Exception {
        String type = args[0];
        File fastaAlignmentFile = new File(args[1]);
        File ambiguityFile = new File(args[2]);
        File symbolFile = new File(args[3]);
        File currentPrimerFile = new File(args[4]);
        File outputFile = new File(args[5]);
        Map<String, String> sequenceMap = TestAmbiguity0620.parseAlignmentFile(fastaAlignmentFile, type);
        Map<String, String> testedPrimerMap = TestAmbiguity0620.parsePrimerFile(currentPrimerFile);
        Map<String, String> primerMap = TestAmbiguity0620.parsePrimerFile(currentPrimerFile);
        Map<String, Integer> bindingSitesMap = TestAmbiguity0620.getPrimerBindingSites(primerMap, sequenceMap);
        String[] ambiguities = FileManager.readTextFile(ambiguityFile).split("\n");
        Map<String, List> symbolMap = TestAmbiguity0620.parseSymbolFile(symbolFile, type);
        StringBuffer stringBuffer = new StringBuffer();
        List<Integer> primerStaticsList = TestAmbiguity0620.initPrimerStataicsList(primerMap);
        List<Integer> primerUniqueList = TestAmbiguity0620.initPrimerStataicsList(primerMap);
        int workedCount = 0;
        int failedCount = 0;
        AmbiguityTestResult ambiguityTestResult = null;
        System.out.println("Designed Primers: \n----------------------");
        String[] stringArray = ambiguities;
        int n = ambiguities.length;
        int n2 = 0;
        while (n2 < n) {
            String ambiguity = stringArray[n2];
            ambiguityTestResult = TestAmbiguity0620.testing(sequenceMap, symbolMap, primerMap, ambiguity, stringBuffer, bindingSitesMap, primerStaticsList, primerUniqueList, false);
            if (!ambiguityTestResult.isAllResolved()) {
                ResolveAmbiguity0620.designPrimers(sequenceMap, symbolMap, primerMap, ambiguityTestResult, ambiguity);
                bindingSitesMap = TestAmbiguity0620.getPrimerBindingSites(primerMap, sequenceMap);
                primerStaticsList = TestAmbiguity0620.initPrimerStataicsList(primerMap);
                primerUniqueList = TestAmbiguity0620.initPrimerStataicsList(primerMap);
            }
            ++n2;
        }
        System.out.println("----------------------\n");
        ArrayList<AmbiguityTestResult> results = new ArrayList<AmbiguityTestResult>();
        String[] stringArray2 = ambiguities;
        int n3 = ambiguities.length;
        n = 0;
        while (n < n3) {
            String ambiguity = stringArray2[n];
            ambiguityTestResult = TestAmbiguity0620.testing(sequenceMap, symbolMap, primerMap, ambiguity, stringBuffer, bindingSitesMap, primerStaticsList, primerUniqueList, true);
            if (ambiguityTestResult.isAllResolved()) {
                ++workedCount;
            } else {
                ++failedCount;
                results.add(ambiguityTestResult);
            }
            ++n;
        }
        System.out.println("\n\n---------------Unresolved-----------");
        for (AmbiguityTestResult result : results) {
            System.out.println(String.valueOf(result.getAmbiguityPairs().get(0).getDiploidType1().getHaploid1()) + "+" + result.getAmbiguityPairs().get(0).getDiploidType1().getHaploid2());
        }
        System.out.println("\nStatistics: \n----------------------");
        System.out.println("total ambiguities:\t" + ambiguities.length);
        System.out.println("resolved:\t" + workedCount);
        System.out.println("unresolved:\t" + failedCount + "\n");
        int i = 0;
        for (String primer : primerMap.keySet()) {
            System.out.println(String.valueOf(primer) + "\t" + primerMap.get(primer) + "\tworks\t" + primerStaticsList.get(i) + "\tunique\t" + primerUniqueList.get(i));
            ++i;
        }
        System.out.println("----------------------\n");
        TestAmbiguity0620.buildMiniPrimerSetBasedOnPrimerSize(sequenceMap, symbolMap, primerMap, ambiguities, stringBuffer, bindingSitesMap, primerStaticsList, primerUniqueList, testedPrimerMap, ambiguityFile, type);
        FileManager.writeTextFile(outputFile, stringBuffer.toString(), true);
    }

    private static void designPrimers(Map<String, String> sequenceMap, Map<String, List> symbolMap, Map<String, String> primerMap, AmbiguityTestResult ambiguityTestResult, String ambiguity) {
        if (!ambiguityTestResult.isTestable()) {
            return;
        }
        ResolveAmbiguity0620.testAndDesignPrimers(sequenceMap, symbolMap, primerMap, ambiguityTestResult, ambiguity);
    }

    private static void testAndDesignPrimers(Map<String, String> sequenceMap, Map<String, List> symbolMap, Map<String, String> primerMap, AmbiguityTestResult ambiguityTestResult, String ambiguity) {
        List<AmbiguityPair> ambiguityPairs = ambiguityTestResult.getAmbiguityPairs();
        String fullSequence = null;
        List<Integer> variationPositions = null;
        String primer = null;
        List<Integer> primerStaticsList = null;
        List<Integer> primerUniqueList = null;
        Map<String, Integer> bindingSitesMap = null;
        Object newResult = null;
        for (AmbiguityPair ambiguityPair : ambiguityPairs) {
            if (ambiguityPair.isResolved() || TestAmbiguity0620.testing(sequenceMap, symbolMap, primerMap, ambiguityPair, null, bindingSitesMap = TestAmbiguity0620.getPrimerBindingSites(primerMap, sequenceMap), primerStaticsList = TestAmbiguity0620.initPrimerStataicsList(primerMap), primerUniqueList = TestAmbiguity0620.initPrimerStataicsList(primerMap), false).isAllResolved()) continue;
            fullSequence = ResolveAmbiguity0620.getFullSequence(sequenceMap, symbolMap, ambiguityPair);
            variationPositions = ResolveAmbiguity0620.getMaxVariationPositions(sequenceMap, symbolMap, ambiguityPair);
            primer = ResolveAmbiguity0620.testAndDesign(sequenceMap, symbolMap, primerMap, ambiguityPair, variationPositions, fullSequence);
            if (primer != null && TestAmbiguity0620.testing(sequenceMap, symbolMap, primerMap, ambiguity, null, bindingSitesMap = TestAmbiguity0620.getPrimerBindingSites(primerMap, sequenceMap), primerStaticsList = TestAmbiguity0620.initPrimerStataicsList(primerMap), primerUniqueList = TestAmbiguity0620.initPrimerStataicsList(primerMap), false).isAllResolved()) break;
        }
    }

    private static String testAndDesign(Map<String, String> sequenceMap, Map<String, List> symbolMap, Map<String, String> primerMap, AmbiguityPair ambiguityPair, List<Integer> variationPositions, String fullSequence) {
        int start = -1;
        int end = -1;
        HashMap<String, String> tmpMap = null;
        Map<String, Integer> tmpBindMap = null;
        List<Integer> tmpStaticsList = null;
        List<Integer> tmpUniqueList = null;
        int i = 0;
        while (i < variationPositions.size() - 1) {
            block14: {
                block16: {
                    block15: {
                        block13: {
                            if (fullSequence.charAt(variationPositions.get(i)) != '|') break block13;
                            start = -1;
                            end = -1;
                            break block14;
                        }
                        if (fullSequence.charAt(variationPositions.get(i + 1)) != '|') break block15;
                        if (start == -1) break block14;
                        end = variationPositions.get(i - 1);
                        break block16;
                    }
                    if (variationPositions.get(i + 1) - variationPositions.get(i) + 1 <= MAX_PRIMER_SIZE) {
                        if (start == -1) {
                            start = variationPositions.get(i);
                        } else if (variationPositions.get(i + 1) - start + 1 > MAX_PRIMER_SIZE) {
                            end = variationPositions.get(i);
                        }
                        if (i + 1 == variationPositions.size() - 1 && variationPositions.get(i + 1) - start + 1 <= MAX_PRIMER_SIZE) {
                            end = variationPositions.get(i + 1);
                        }
                    } else if (start > -1) {
                        end = variationPositions.get(i);
                    }
                }
                if (start > -1 && end > -1) {
                    String reversePrimer;
                    String forwardPrimer = ResolveAmbiguity0620.getPrimer(start, end, fullSequence, false);
                    if (forwardPrimer != null) {
                        tmpMap = new HashMap<String, String>();
                        tmpMap.put("tmp", forwardPrimer);
                        tmpBindMap = TestAmbiguity0620.getPrimerBindingSites(tmpMap, sequenceMap);
                        tmpStaticsList = TestAmbiguity0620.initPrimerStataicsList(tmpMap);
                        tmpUniqueList = TestAmbiguity0620.initPrimerStataicsList(tmpMap);
                        if (!primerMap.containsValue(forwardPrimer) && TestAmbiguity0620.testing(sequenceMap, symbolMap, tmpMap, ambiguityPair, null, tmpBindMap, tmpStaticsList, tmpUniqueList, false).isAllResolved()) {
                            primerMap.put(String.valueOf(primerMap.size() + 1) + "F", forwardPrimer);
                            System.out.println("No. " + primerMap.size() + " forwardPrimer " + forwardPrimer + " " + start + " " + end);
                            return forwardPrimer;
                        }
                    }
                    if ((reversePrimer = ResolveAmbiguity0620.getPrimer(start, end, fullSequence, true)) != null) {
                        tmpMap = new HashMap();
                        tmpMap.put("tmp", reversePrimer);
                        tmpBindMap = TestAmbiguity0620.getPrimerBindingSites(tmpMap, sequenceMap);
                        tmpStaticsList = TestAmbiguity0620.initPrimerStataicsList(tmpMap);
                        tmpUniqueList = TestAmbiguity0620.initPrimerStataicsList(tmpMap);
                        if (!primerMap.containsValue(reversePrimer) && TestAmbiguity0620.testing(sequenceMap, symbolMap, tmpMap, ambiguityPair, null, tmpBindMap, tmpStaticsList, tmpUniqueList, false).isAllResolved()) {
                            primerMap.put(String.valueOf(primerMap.size() + 1) + "R", reversePrimer);
                            System.out.println("No. " + primerMap.size() + " reversePrimer " + reversePrimer + " " + start + " " + end);
                            return reversePrimer;
                        }
                    }
                    start = -1;
                    end = -1;
                }
            }
            ++i;
        }
        return null;
    }

    private static List<Integer> getVariationPositions(Map<String, String> sequenceMap, Map<String, List> symbolMap, DiploidType diploidType) {
        ArrayList<Integer> variationPositions = new ArrayList<Integer>();
        String sequence1 = TestAmbiguity0620.getHaplotyleSequence(sequenceMap, symbolMap, diploidType.getHaploid1());
        String sequence2 = TestAmbiguity0620.getHaplotyleSequence(sequenceMap, symbolMap, diploidType.getHaploid2());
        int i = 0;
        while (i < Math.min(sequence1.length(), sequence2.length())) {
            if (sequence1.charAt(i) != sequence2.charAt(i) && sequence1.charAt(i) != '*' && sequence2.charAt(i) != '*') {
                variationPositions.add(i);
            } else if (sequence1.charAt(i) == '|' && sequence2.charAt(i) == '|') {
                variationPositions.add(i);
            }
            ++i;
        }
        return variationPositions;
    }

    private static List<Integer> getMaxVariationPositions(Map<String, String> sequenceMap, Map<String, List> symbolMap, AmbiguityPair ambiguityPair) {
        List<Integer> variationPositions1 = ResolveAmbiguity0620.getVariationPositions(sequenceMap, symbolMap, ambiguityPair.getDiploidType1());
        List<Integer> variationPositions2 = ResolveAmbiguity0620.getVariationPositions(sequenceMap, symbolMap, ambiguityPair.getDiploidType2());
        return variationPositions1.size() >= variationPositions2.size() ? variationPositions1 : variationPositions2;
    }

    private static String getFullSequence(Map<String, String> sequenceMap, Map<String, List> symbolMap, AmbiguityPair ambiguityPair) {
        String fullSequence = null;
        ArrayList<String> sequences = new ArrayList<String>();
        sequences.add(TestAmbiguity0620.getHaplotyleSequence(sequenceMap, symbolMap, ambiguityPair.getDiploidType1().getHaploid1()));
        sequences.add(TestAmbiguity0620.getHaplotyleSequence(sequenceMap, symbolMap, ambiguityPair.getDiploidType1().getHaploid2()));
        sequences.add(TestAmbiguity0620.getHaplotyleSequence(sequenceMap, symbolMap, ambiguityPair.getDiploidType2().getHaploid1()));
        sequences.add(TestAmbiguity0620.getHaplotyleSequence(sequenceMap, symbolMap, ambiguityPair.getDiploidType2().getHaploid2()));
        for (String sequence : sequences) {
            if (fullSequence != null && fullSequence.indexOf("*") <= -1) continue;
            if (fullSequence == null) {
                fullSequence = sequence;
                continue;
            }
            if (ResolveAmbiguity0620.countStars(fullSequence) <= ResolveAmbiguity0620.countStars(sequence)) continue;
            fullSequence = sequence;
        }
        return fullSequence;
    }

    private static String optimizePrimerSequence(String fullSequence, String primer, boolean isRevComp) {
        double meltingTm = TestAmbiguity0620.calculateMeltingTemp(primer.replaceAll("\\.", ""));
        if (meltingTm < (double)MIN_PRIMER_TM) {
            return ResolveAmbiguity0620.MaximizePrimerSequence(fullSequence, primer, isRevComp);
        }
        if (meltingTm > (double)MAX_PRIMER_TM) {
            return ResolveAmbiguity0620.MinimizePrimerSequence(fullSequence, primer, isRevComp);
        }
        return primer;
    }

    private static String MinimizePrimerSequence(String fullSequence, String primer, boolean isRevComp) {
        String newPrimer = primer;
        if (TestAmbiguity0620.calculateMeltingTemp(primer.replaceAll("\\.", "")) <= (double)MAX_PRIMER_TM || primer.replaceAll("\\.", "").length() <= 16) {
            return newPrimer;
        }
        newPrimer = isRevComp ? newPrimer.substring(1, newPrimer.length()) : newPrimer.substring(1, newPrimer.length());
        newPrimer = ResolveAmbiguity0620.MinimizePrimerSequence(fullSequence, newPrimer, isRevComp);
        return newPrimer;
    }

    private static String MaximizePrimerSequence(String fullSequence, String primer, boolean isRevComp) {
        String newPrimer = primer;
        if (TestAmbiguity0620.calculateMeltingTemp(primer.replaceAll("\\.", "")) >= (double)MIN_PRIMER_TM || primer.replaceAll("\\.", "").length() >= 25 || fullSequence.indexOf(newPrimer) >= fullSequence.length() - newPrimer.length() || isRevComp && fullSequence.charAt(fullSequence.indexOf(StringUtils.revCompSeq(newPrimer)) + newPrimer.length()) == '|' || !isRevComp && fullSequence.charAt(fullSequence.indexOf(newPrimer) - 1) == '|') {
            return newPrimer;
        }
        newPrimer = isRevComp ? String.valueOf(StringUtils.revCompSeq(String.valueOf(fullSequence.charAt(fullSequence.indexOf(StringUtils.revCompSeq(newPrimer)) + newPrimer.length())))) + newPrimer : String.valueOf(fullSequence.charAt(fullSequence.indexOf(newPrimer) - 1)) + newPrimer;
        newPrimer = ResolveAmbiguity0620.MaximizePrimerSequence(fullSequence, newPrimer, isRevComp);
        return newPrimer;
    }

    private static String getPrimer(int start, int end, String fullSequence, boolean isRevComp) {
        String primer = null;
        int index = fullSequence.indexOf("|");
        if (index == -1 || isRevComp && index < start || !isRevComp && index > end) {
            if (end - start + 1 <= OPT_PRIMER_SIZE) {
                primer = isRevComp ? StringUtils.revCompSeq(fullSequence.substring(start, Math.min(start + OPT_PRIMER_SIZE, fullSequence.length()))) : fullSequence.substring(Math.max(end - OPT_PRIMER_SIZE + 1, 0), end + 1);
            } else {
                primer = fullSequence.substring(start, end + 1);
                if (isRevComp) {
                    primer = StringUtils.revCompSeq(primer);
                }
            }
        } else if (end - start + 1 <= OPT_PRIMER_SIZE) {
            primer = isRevComp ? StringUtils.revCompSeq(fullSequence.substring(start, Math.min(start + OPT_PRIMER_SIZE, index))) : fullSequence.substring(Math.max(end - OPT_PRIMER_SIZE + 1, index + 1), end + 1);
        } else {
            primer = fullSequence.substring(start, end + 1);
            if (isRevComp) {
                primer = StringUtils.revCompSeq(primer);
            }
        }
        primer = ResolveAmbiguity0620.optimizePrimerSequence(fullSequence, primer, isRevComp);
        return primer.length() < MIN_PRIMER_SIZE ? null : primer;
    }

    private static int countStars(String sequence) {
        int count = 0;
        int i = 0;
        while (i < sequence.length()) {
            if (sequence.charAt(i) == '*') {
                ++count;
            }
            ++i;
        }
        return count;
    }
}

