/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class ReAssociateResolvingChromats {
    public static String UPDATE_PROJECT_ID = "update pcr.chromat_report_mv set project_id=(select distinct(mv.project_id) from pcr.chromat_report_mv mv JOIN pcr.plate_coord pc ON (parent_coordinate_id=pc.plate_coord_id) JOIN pcr.experiment e ON (parent_experiment_id = e.experiment_id) AND e.plate_name=? AND pc.coordinate=?) WHERE experiment_name=? AND coordinate=?";
    public static String UPDATE_PROJECT_NAME = "update pcr.chromat_report_mv set project_name=(select distinct(mv.project_name) from pcr.chromat_report_mv mv JOIN pcr.plate_coord pc ON (parent_coordinate_id=pc.plate_coord_id) JOIN pcr.experiment e ON (parent_experiment_id = e.experiment_id) AND e.plate_name=? AND pc.coordinate=?) WHERE experiment_name=? AND coordinate=?";
    public static String UPDATE_PRIMER_NAME = "Update pcr.chromat_report_mv set seq_primer_name=? where experiment_name=? AND coordinate=?";

    public static void main(String[] args) {
        File assoFile = new File(args[0]);
        String[] assoData = FileManager.readTextFile(assoFile).split("\n");
        String[] info = null;
        String mainPlate = null;
        String mainCoord = null;
        String newPlate = null;
        String newCoord = null;
        int i = 1;
        while (i < assoData.length) {
            info = assoData[i].split(",");
            mainPlate = info[1].trim();
            mainCoord = info[2].trim();
            newPlate = info[3].trim();
            newCoord = info[4].trim();
            ReAssociateResolvingChromats.excuteUpdate(UPDATE_PROJECT_ID, mainPlate, mainCoord, newPlate, newCoord);
            ReAssociateResolvingChromats.excuteUpdate(UPDATE_PROJECT_NAME, mainPlate, mainCoord, newPlate, newCoord);
            ReAssociateResolvingChromats.excutePrimerUpdate(UPDATE_PRIMER_NAME, info[5].trim(), newPlate, newCoord);
            ++i;
        }
        System.out.println("done");
    }

    private static void excutePrimerUpdate(String sql, String primerName, String newPlate, String newCoord) {
        String url = "jdbc:postgresql://asclepius.fhcrc.org:5432/gemsprod";
        try {
            Class.forName("org.postgresql.Driver");
            Connection db = DriverManager.getConnection(url, "gems", "Caff1ne");
            PreparedStatement preparedStatement = db.prepareStatement(sql);
            System.out.println(String.valueOf(primerName) + " " + newPlate + " " + newCoord);
            preparedStatement.setString(1, primerName);
            preparedStatement.setString(2, newPlate);
            preparedStatement.setString(3, newCoord);
            int status = preparedStatement.executeUpdate();
            System.out.println(status);
            ReAssociateResolvingChromats.closeResources(null, preparedStatement, db);
        }
        catch (Exception e) {
            System.err.println("Got an exception! ");
            System.err.println(e.getMessage());
        }
    }

    private static void excuteUpdate(String sql, String mainPlate, String mainCoord, String newPlate, String newCoord) {
        String url = "jdbc:postgresql://asclepius.fhcrc.org:5432/gemsprod";
        try {
            Class.forName("org.postgresql.Driver");
            Connection db = DriverManager.getConnection(url, "gems", "Caff1ne");
            PreparedStatement preparedStatement = db.prepareStatement(sql);
            preparedStatement.setString(1, mainPlate);
            preparedStatement.setString(2, mainCoord);
            preparedStatement.setString(3, newPlate);
            preparedStatement.setString(4, newCoord);
            preparedStatement.executeUpdate();
            ReAssociateResolvingChromats.closeResources(null, preparedStatement, db);
        }
        catch (Exception e) {
            System.err.println("Got an exception! ");
            System.err.println(e.getMessage());
        }
    }

    public static void closeResources(ResultSet resultSet, Statement statement, Connection connection) {
        SQLException sqlException = new SQLException();
        boolean isSQLExceptionEncountered = false;
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (isSQLExceptionEncountered) {
            System.out.println("error close resource");
        }
    }

    private static void sizeCheck(Map<String, List<String>> map1, Map<String, List<String>> map2, String type) {
        if (map1.size() != map2.size()) {
            System.out.println("Warning: sample size different in " + type + " " + map1.size() + " : " + map2.size());
        }
    }

    private static List<String> getPrimerList(String headerLine) {
        String[] info;
        ArrayList<String> primers = new ArrayList<String>();
        String[] stringArray = info = headerLine.split(",");
        int n = info.length;
        int n2 = 0;
        while (n2 < n) {
            String primer = stringArray[n2];
            if (primer.trim().length() > 0) {
                primers.add(primer.trim());
            }
            ++n2;
        }
        return primers;
    }

    private static int getMaxPrimerSize(Map<String, List<String>> ausMap) {
        int max = 0;
        for (List<String> list : ausMap.values()) {
            if (list.size() <= max) continue;
            max = list.size();
        }
        return max;
    }
}

