/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.io.File;
import misc.FileManager;
import misc.OsHelper;
import misc.SystemCommand;

public class PickPrimerInGap {
    private static int SIZE = 2500;

    public static void main(String[] args) throws Exception {
        File fastaFile = new File(args[0]);
        File primerFile = new File(args[1]);
        File primerInGapFile = new File(args[2]);
        File inputFile = File.createTempFile("input", ".txt");
        File tmpFile = File.createTempFile("output", ".txt");
        String sequence = PickPrimerInGap.getSequenceFromFasta(fastaFile);
        String[] primers = FileManager.readTextFile(primerFile).split("\n");
        StringBuffer outputPrimers = new StringBuffer();
        outputPrimers.append("Forward Primer\tReverse Primer\tForward Primer Start\tReverse Primer End\tForward Primer Tm\tReverse Primer Tm\tForward Primer Self Any\tReverse Primer Self Any\tForward Primer Self End\tReverse Primer Self End\tAmplicon Size\n");
        Object primerPre = null;
        int i = 2;
        while (i < primers.length) {
            ++i;
        }
        int count = sequence.length() / SIZE;
        int i2 = 0;
        while (i2 < count) {
            int start = i2 * SIZE + 1;
            StringBuffer buffer = new StringBuffer();
            buffer.append("PRIMER_SEQUENCE_ID=mySequence\n");
            buffer.append("SEQUENCE=").append(sequence).append("\n");
            buffer.append("INCLUDED_REGION=").append(start).append(",").append(SIZE).append("\n");
            buffer.append("PRIMER_PRODUCT_SIZE_RANGE=200-400 100-500\n");
            buffer.append("PRIMER_OPT_SIZE=25\n");
            buffer.append("PRIMER_MIN_SIZE=20\n");
            buffer.append("PRIMER_MAX_SIZE=30\n");
            buffer.append("PRIMER_OPT_TM=60.0\n");
            buffer.append("PRIMER_MIN_TM=58.0\n");
            buffer.append("PRIMER_MAX_TM=62.0\n");
            buffer.append("PRIMER_MAX_DIFF_TM=1.2\n");
            buffer.append("PRIMER_DNA_CONC=0.25\n");
            buffer.append("PRIMER_SALT_CONC=50.0\n");
            buffer.append("PRIMER_SELF_ANY=2\n");
            buffer.append("PRIMER_SELF_END=2\n");
            buffer.append("PRIMER_MAX_POLY_X=7\n");
            buffer.append("PRIMER_NUM_RETURN=2\n");
            buffer.append("PRIMER_FIRST_BASE_INDEX=1\n");
            buffer.append("PRIMER_MAX_END_STABILITY=20\n");
            buffer.append("=\n");
            System.out.println(inputFile.getAbsolutePath());
            FileManager.writeTextFile(inputFile, buffer.toString(), true);
            String cmd = "/genome/bin_common/primer3_core < " + inputFile.getAbsolutePath() + " > " + tmpFile.getAbsolutePath();
            String[] acmd = new String[]{"/bin/sh", "-c", cmd};
            SystemCommand systemCommand = new SystemCommand(acmd, inputFile.getParentFile(), false);
            systemCommand.makeItSo();
            OsHelper.excuteCommand(cmd);
            System.out.println(cmd);
            outputPrimers.append(PickPrimerInGap.parseOutput(FileManager.readTextFile(tmpFile)));
            ++i2;
        }
        FileManager.writeTextFile(primerFile, outputPrimers.toString(), true);
    }

    private static String parseOutput(String output) {
        StringBuffer buffer = new StringBuffer();
        String[] data = output.trim().split("\n");
        boolean find = false;
        String[] stringArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String info = stringArray[n2];
            if (info.startsWith("PRIMER_LEFT_SEQUENCE=")) {
                System.out.println("find primer");
                buffer.append(info.split("=")[1].trim());
            }
            if (info.startsWith("PRIMER_RIGHT_SEQUENCE=")) {
                buffer.append("\t").append(info.split("=")[1].trim());
            }
            if (info.startsWith("PRIMER_LEFT=")) {
                buffer.append("\t").append(info.split("=")[1].split(",")[0].trim());
            }
            if (info.startsWith("PRIMER_RIGHT=")) {
                buffer.append("\t").append(info.split("=")[1].split(",")[0].trim());
            }
            if (info.startsWith("PRIMER_LEFT_TM=")) {
                buffer.append("\t").append(info.split("=")[1].trim());
            }
            if (info.startsWith("PRIMER_RIGHT_TM=")) {
                buffer.append("\t").append(info.split("=")[1].trim());
            }
            if (info.startsWith("PRIMER_LEFT_SELF_ANY=")) {
                buffer.append("\t").append(info.split("=")[1].trim());
            }
            if (info.startsWith("PRIMER_RIGHT_SELF_ANY=")) {
                buffer.append("\t").append(info.split("=")[1].trim());
            }
            if (info.startsWith("PRIMER_LEFT_SELF_END=")) {
                buffer.append("\t").append(info.split("=")[1].trim());
            }
            if (info.startsWith("PRIMER_RIGHT_SELF_END=")) {
                buffer.append("\t").append(info.split("=")[1].trim());
            }
            if (info.startsWith("PRIMER_PRODUCT_SIZE=")) {
                buffer.append("\t").append(info.split("=")[1].trim()).append("\n");
            }
            ++n2;
        }
        return buffer.toString();
    }

    private static String getSequenceFromFasta(File fasta) {
        String[] lines = FileManager.readTextFile(fasta).split("\n");
        StringBuilder seq = new StringBuilder();
        int i = 1;
        while (i < lines.length) {
            seq.append(lines[i].trim());
            ++i;
        }
        return seq.toString();
    }
}

