/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class GroupCellLineBySnp3 {
    private static int VARIATION_LIMIT = 2;
    private static int GROUP_NUMBER = 4;
    private static int SNP_MIN_QUALITY = 30;

    public static void main(String[] args) throws Exception {
        File ampliconList = new File(args[0]);
        File snpOutputDir = new File(args[1]);
        File cellLineFile = new File(args[2]);
        File outputFile = new File(args[3]);
        String[] amplicons = FileManager.readTextFile(ampliconList).split("\n");
        Map<String, List> majorSnpMap = GroupCellLineBySnp3.getCommonSnpPositionList(amplicons, snpOutputDir);
        String[] cellLines = FileManager.readTextFile(cellLineFile).split("\n");
        List posList = null;
        String[] data = null;
        Object header = null;
        String[] calls = null;
        boolean matchScore = false;
        boolean misMatchScore = false;
        Object call1 = null;
        Object call2 = null;
        String cellLine = null;
        LinkedHashMap map = new LinkedHashMap();
        StringBuffer headerBuffer = new StringBuffer();
        HashMap<String, String> fullNameMap = new HashMap<String, String>();
        String[] stringArray = cellLines;
        int n = cellLines.length;
        int n2 = 0;
        while (n2 < n) {
            String cl = stringArray[n2];
            map.put(cl.substring(3, cl.length()), new ArrayList());
            fullNameMap.put(cl.substring(3, cl.length()), cl);
            ++n2;
        }
        int total = 0;
        for (String amplicon : majorSnpMap.keySet()) {
            posList = majorSnpMap.get(amplicon);
            total += posList.size();
            data = FileManager.readTextFile(new File(snpOutputDir, String.valueOf(amplicon) + ".txt")).split("\n");
            int i = 3;
            while (i < data.length) {
                calls = data[i].split("\\s+");
                cellLine = calls[0].substring(3, calls[0].length());
                int j = 1;
                while (j < calls.length) {
                    if (posList.contains(j)) {
                        ((List)map.get(cellLine)).add(GroupCellLineBySnp3.formatCall(calls[j]));
                    }
                    ++j;
                }
                ++i;
            }
        }
        headerBuffer.append("48 ").append(total).append("\n");
        List list = null;
        for (String cl : map.keySet()) {
            headerBuffer.append((String)fullNameMap.get(cl)).append("  ");
            list = (List)map.get(cl);
            for (String pos : list) {
                headerBuffer.append(pos);
            }
            headerBuffer.append("\n");
        }
        FileManager.writeTextFile(outputFile, headerBuffer.toString(), true);
    }

    private static String formatCall(String call) {
        String read = call.split("\\(")[0];
        if (read.indexOf("/") > 0) {
            char r1 = read.charAt(0);
            char r2 = read.charAt(2);
            if (r1 == 'A' && r2 == 'C' || r1 == 'C' && r2 == 'A') {
                return "M";
            }
            if (r1 == 'A' && r2 == 'G' || r1 == 'G' && r2 == 'A') {
                return "R";
            }
            if (r1 == 'A' && r2 == 'T' || r1 == 'T' && r2 == 'A') {
                return "W";
            }
            if (r1 == 'C' && r2 == 'T' || r1 == 'T' && r2 == 'C') {
                return "Y";
            }
            if (r1 == 'C' && r2 == 'G' || r1 == 'G' && r2 == 'C') {
                return "S";
            }
            if (r1 == 'T' && r2 == 'G' || r1 == 'G' && r2 == 'T') {
                return "K";
            }
            System.out.println("uknown call " + read);
        }
        return read;
    }

    private static String[] getDataByCellLine(String[] data, String cellLine) {
        String[] ret = null;
        String[] stringArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String info = stringArray[n2];
            ret = info.split("\\s+");
            if (ret[0].equals(cellLine)) {
                return ret;
            }
            ++n2;
        }
        return null;
    }

    private static Map<String, List> getCommonSnpPositionList(String[] amplicons, File snpOutputDir) {
        File snpFile = null;
        String[] data = null;
        String[] header = null;
        Object snps = null;
        ArrayList<Integer> posList = null;
        int totalCount = 0;
        LinkedHashMap<String, List> majorSnpMap = new LinkedHashMap<String, List>();
        String[] stringArray = amplicons;
        int n = amplicons.length;
        int n2 = 0;
        while (n2 < n) {
            String amplicon = stringArray[n2];
            System.out.println(amplicon);
            snpFile = new File(snpOutputDir, String.valueOf(amplicon) + ".txt");
            data = FileManager.readTextFile(snpFile).split("\n");
            header = data[0].split("\\s+");
            if (header.length > 1 && data.length > 3) {
                posList = new ArrayList<Integer>();
                int i = 1;
                while (i < header.length) {
                    int quality = new Integer(header[i].split(":")[1]);
                    if (quality >= SNP_MIN_QUALITY && !GroupCellLineBySnp3.isRareSnp(data, i)) {
                        posList.add(i);
                    }
                    ++i;
                }
                majorSnpMap.put(amplicon, posList);
                totalCount += posList.size();
            }
            ++n2;
        }
        System.out.println("total common snp " + totalCount);
        return majorSnpMap;
    }

    private static boolean isRareSnp(String[] data, int pos) {
        Object snps = null;
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        String call = null;
        String read1 = null;
        String read2 = null;
        int i = 3;
        while (i < data.length) {
            call = data[i].split("\\s+")[pos].trim();
            if (call.indexOf("(") > 0) {
                call = call.split("\\(")[0];
            }
            if (!(read1 = String.valueOf(call.charAt(0))).equals("N") && !read1.equals("?")) {
                if (!countMap.containsKey(read1)) {
                    countMap.put(read1, 0);
                }
                countMap.put(read1, (Integer)countMap.get(read1) + 1);
                if (call.indexOf("/") > 0) {
                    read2 = String.valueOf(call.charAt(2));
                    if (!countMap.containsKey(read2)) {
                        countMap.put(read2, 0);
                    }
                    countMap.put(read2, (Integer)countMap.get(read2) + 1);
                }
            }
            ++i;
        }
        int maxCount = 0;
        String maxRead = null;
        for (String read : countMap.keySet()) {
            Integer count = (Integer)countMap.get(read);
            if (count <= maxCount) continue;
            maxCount = count;
            maxRead = read;
        }
        for (String read : countMap.keySet()) {
            if (read.equals(maxRead) || (Integer)countMap.get(read) < VARIATION_LIMIT) continue;
            return false;
        }
        System.out.println("rare snp " + pos);
        return true;
    }
}

