/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.io.File;
import misc.FileManager;

public class FixSequenceWithQualityTmp {
    private static int MIN_Q = 50;

    public static void main(String[] args) throws Exception {
        File fastaFile = new File(args[0]);
        String sequence = FixSequenceWithQualityTmp.getSequenceFromFasta(fastaFile);
        StringBuilder builder = new StringBuilder();
        boolean isStart = false;
        int i = 0;
        while (i < sequence.length()) {
            if (sequence.charAt(i) == 'N') {
                if (!isStart) {
                    isStart = true;
                    builder.append(i + 1);
                }
            } else if (isStart) {
                isStart = false;
                builder.append("\t").append(i).append("\n");
            }
            ++i;
        }
        if (sequence.charAt(sequence.length() - 1) == 'N') {
            builder.append("\t").append(sequence.length()).append("\n");
        }
        System.out.println(builder.toString());
    }

    private static String getSequenceFromFasta(File fasta) {
        String[] lines = FileManager.readTextFile(fasta).split("\n");
        StringBuilder seq = new StringBuilder();
        int i = 1;
        while (i < lines.length) {
            seq.append(lines[i].trim());
            ++i;
        }
        return seq.toString();
    }

    private static String[] getQualityFromQuality(File fasta) {
        String[] lines = FileManager.readTextFile(fasta).split("\n");
        StringBuilder seq = new StringBuilder();
        int i = 1;
        while (i < lines.length) {
            seq.append(lines[i].trim()).append(" ");
            ++i;
        }
        return seq.toString().trim().split("\\s+");
    }
}

