/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class FileManager {
    private static final String GEMS_FILE_SYSTEM_ROOT_DIRECTORY = "/home/gemsd/GeMS/GeMSFileSystem";
    private static final String GEMS_TEMPORARY_WORKING_DIRECTORY = System.getProperty("gems.config.tmpDir");
    private static final String UNIX_LINK_COMMAND = "ln";
    private static final String UNIX_LINK_SYMBOLIC = "-s";
    private static final String UTF_8 = "UTF-8";
    private static final String DOT_ZIP = ".zip";
    public static final int PARSING_UNIT = 3;
    static String HEADER = "@Barcode";

    private FileManager() {
    }

    public static boolean copyFile(File src, File dest, boolean isOverWrite) {
        block7: {
            FileChannel srcFileChannel = null;
            FileChannel destFileChannel = null;
            if (!FileManager.isFileReadyForWrite(dest, isOverWrite)) {
                return false;
            }
            try {
                try {
                    if (!dest.exists()) {
                        dest.createNewFile();
                    }
                    srcFileChannel = new FileInputStream(src).getChannel();
                    destFileChannel = new FileOutputStream(dest).getChannel();
                    srcFileChannel.transferTo(0L, srcFileChannel.size(), destFileChannel);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    FileManager.closeFileDestination(srcFileChannel);
                    FileManager.closeFileDestination(destFileChannel);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                FileManager.closeFileDestination(srcFileChannel);
                FileManager.closeFileDestination(destFileChannel);
                throw throwable;
            }
            FileManager.closeFileDestination(srcFileChannel);
            FileManager.closeFileDestination(destFileChannel);
        }
        return true;
    }

    public static String readFile(File src) {
        return FileManager.readAnyFile(src, false);
    }

    public static String readTextFile(File src) {
        return FileManager.readAnyFile(src, true);
    }

    public static boolean writeFile(File dest, String srcData, boolean isOverWrite) {
        return FileManager.writeAnyFile(dest, srcData, isOverWrite, false);
    }

    public static boolean writeTextFile(File dest, String srcData, boolean isOverWrite) {
        return FileManager.writeAnyFile(dest, srcData, isOverWrite, true);
    }

    public static List readDirectory(File src, FilenameFilter fileNameFilter) {
        return FileManager.readSubDirectory(src, fileNameFilter, src.getParentFile().getAbsolutePath().length());
    }

    public static boolean writeDirectory(File dest, List srcFiles, boolean isOverWrite) {
        Object object2 = null;
        String key = null;
        TreeMap map = null;
        boolean result = true;
        for (Object object2 : srcFiles) {
            if (object2 instanceof List && !FileManager.writeDirectory(dest, object2, isOverWrite)) {
                result = false;
            }
            if (!(object2 instanceof TreeMap)) continue;
            map = object2;
            key = (String)map.firstKey();
            if (FileManager.writeFile(new File(String.valueOf(dest.getAbsolutePath()) + key), (String)map.get(key), isOverWrite)) continue;
            result = false;
        }
        return result;
    }

    public static boolean delete(File file) {
        File[] files;
        if (file == null) {
            return false;
        }
        if (file.isDirectory() && (files = file.listFiles()) != null && files.length > 0) {
            int i = 0;
            while (i < files.length) {
                FileManager.delete(files[i]);
                ++i;
            }
        }
        return file.delete();
    }

    public static File getFile(String id) {
        File subRoot = null;
        if (id.length() <= 3) {
            subRoot = new File(GEMS_FILE_SYSTEM_ROOT_DIRECTORY, "0");
        } else {
            subRoot = new File(GEMS_FILE_SYSTEM_ROOT_DIRECTORY, id.substring(0, 1));
            if ((id.length() - 1) % 3 == 0) {
                int i = 0;
                while (i < (id.length() - 1) / 3 - 1) {
                    subRoot = new File(subRoot, id.substring(1 + i * 3, 1 + (i + 1) * 3));
                    ++i;
                }
            } else {
                int i = 0;
                while (i < (id.length() - 1) / 3) {
                    subRoot = new File(subRoot, id.substring(1 + i * 3, 1 + (i + 1) * 3));
                    ++i;
                }
            }
        }
        return new File(subRoot, id);
    }

    public static File getFile(String id, File root) {
        File subRoot = null;
        if (id.length() <= 3) {
            subRoot = new File(root, "0");
        } else {
            subRoot = new File(root, id.substring(0, 1));
            if ((id.length() - 1) % 3 == 0) {
                int i = 0;
                while (i < (id.length() - 1) / 3 - 1) {
                    subRoot = new File(subRoot, id.substring(1 + i * 3, 1 + (i + 1) * 3));
                    ++i;
                }
            } else {
                int i = 0;
                while (i < (id.length() - 1) / 3) {
                    subRoot = new File(subRoot, id.substring(1 + i * 3, 1 + (i + 1) * 3));
                    ++i;
                }
            }
        }
        return new File(subRoot, id);
    }

    public static File getTemporaryWorkingDirectory() {
        return new File(GEMS_TEMPORARY_WORKING_DIRECTORY);
    }

    public static List<File> findFiles(File rootDirectory, FilenameFilter fileNameFilter) {
        return FileManager.findFiles(rootDirectory, fileNameFilter, rootDirectory.getPath().length());
    }

    public static File[] listDirectories(File dir) {
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        };
        return dir.listFiles(fileFilter);
    }

    private static List<File> findFiles(File rootDirectory, FilenameFilter fileNameFilter, int originalRootDirectory) {
        ArrayList<File> foundFiles = new ArrayList<File>();
        File[] files = rootDirectory.listFiles(fileNameFilter);
        if (files != null && files.length > 0) {
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    foundFiles.addAll(FileManager.findFiles(files[i], fileNameFilter, originalRootDirectory));
                } else if (files[i].isFile()) {
                    foundFiles.add(new File(files[i].getPath().substring(originalRootDirectory)));
                }
                ++i;
            }
        } else {
            foundFiles.add(new File(rootDirectory.getPath().substring(originalRootDirectory)));
        }
        return foundFiles;
    }

    private static List<TreeMap> readSubDirectory(File src, FilenameFilter fileNameFilter, int originalSourceDirectorySize) {
        ArrayList<TreeMap> fileList = new ArrayList<TreeMap>();
        TreeMap<String, String> map = null;
        StringBuffer stringBuffer = null;
        File[] files = src.listFiles(fileNameFilter);
        if (files != null && files.length > 0) {
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    fileList.addAll(FileManager.readSubDirectory(files[i], fileNameFilter, originalSourceDirectorySize));
                } else if (files[i].isFile()) {
                    map = new TreeMap<String, String>();
                    stringBuffer = new StringBuffer();
                    map.put(stringBuffer.append(files[i].getParent().substring(originalSourceDirectorySize)).append(File.separator).append(files[i].getName()).toString(), FileManager.readFile(files[i]));
                    fileList.add(map);
                }
                ++i;
            }
        }
        return fileList;
    }

    private static String readAnyFile(File src, boolean isTextOnly) {
        String data;
        block5: {
            FileChannel srcFileChannel = null;
            ByteBuffer byteBuffer = null;
            data = null;
            try {
                try {
                    srcFileChannel = new FileInputStream(src).getChannel();
                    byteBuffer = ByteBuffer.allocate((int)srcFileChannel.size());
                    srcFileChannel.read(byteBuffer);
                    data = new String(byteBuffer.array(), UTF_8);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    FileManager.closeFileDestination(srcFileChannel);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                FileManager.closeFileDestination(srcFileChannel);
                throw throwable;
            }
            FileManager.closeFileDestination(srcFileChannel);
        }
        return data;
    }

    private static boolean writeAnyFile(File dest, String srcData, boolean isOverWrite, boolean isTextOnly) {
        block8: {
            if (!FileManager.isFileReadyForWrite(dest, isOverWrite)) {
                return false;
            }
            FileChannel destFileChannel = null;
            try {
                try {
                    destFileChannel = new FileOutputStream(dest).getChannel();
                    if (srcData == null) {
                        System.out.println("srcData=null");
                        destFileChannel.write(ByteBuffer.wrap("".getBytes(UTF_8)));
                    } else {
                        destFileChannel.write(ByteBuffer.wrap(srcData.getBytes(UTF_8)));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    FileManager.closeFileDestination(destFileChannel);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                FileManager.closeFileDestination(destFileChannel);
                throw throwable;
            }
            FileManager.closeFileDestination(destFileChannel);
        }
        return true;
    }

    private static boolean isFileReadyForWrite(File dest, boolean isOverWrite) {
        if (dest.exists() && dest.isFile() && !isOverWrite) {
            return false;
        }
        if (!dest.getParentFile().isDirectory()) {
            dest.getParentFile().mkdirs();
        }
        return true;
    }

    private static void closeFileDestination(FileChannel fileChannel) {
        if (fileChannel != null) {
            try {
                fileChannel.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void closeBufferedInputStream(BufferedInputStream bufferedInputStream) {
        if (bufferedInputStream != null) {
            try {
                bufferedInputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void closeBufferedOutputStream(BufferedOutputStream bufferedOutputStream) {
        if (bufferedOutputStream != null) {
            try {
                bufferedOutputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Map<String, String> getSequencesFromFasta(File fastaFile) {
        LinkedHashMap<String, String> sequences = new LinkedHashMap<String, String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">")) {
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                ++i;
                sequences.put(name, sequence);
            }
            ++i;
        }
        return sequences;
    }

    public static Map<String, String> getSequencesFromFastq(File fastqFile) {
        LinkedHashMap<String, String> sequences = new LinkedHashMap<String, String>();
        String[] lines = FileManager.readTextFile(fastqFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            String line = lines[i].trim();
            if (line.startsWith(HEADER)) {
                String name = line.trim().substring(1);
                sequences.put(name, lines[i + 1].trim());
                ++i;
            }
            ++i;
        }
        return sequences;
    }

    public static void writeFastaFile(File output, Map<String, String> sequences) {
        StringBuilder builder = new StringBuilder();
        for (String name : sequences.keySet()) {
            builder.append(">").append(name).append("\n");
            builder.append(sequences.get(name)).append("\n");
        }
        FileManager.writeTextFile(output, builder.toString(), true);
    }

    public static String revCompSeq(String seq) {
        String ret = "";
        String base = "";
        int i = seq.length() - 1;
        while (i >= 0) {
            if ("Aa".indexOf(seq.charAt(i)) > -1) {
                base = "T";
            } else if ("Tt".indexOf(seq.charAt(i)) > -1) {
                base = "A";
            } else if ("Cc".indexOf(seq.charAt(i)) > -1) {
                base = "G";
            } else if ("Gg".indexOf(seq.charAt(i)) > -1) {
                base = "C";
            } else if ("Nn".indexOf(seq.charAt(i)) > -1) {
                base = "N";
            } else if ("Ww".indexOf(seq.charAt(i)) > -1) {
                base = "W";
            } else if (".".indexOf(seq.charAt(i)) > -1) {
                base = ".";
            }
            ret = String.valueOf(ret) + base;
            --i;
        }
        return ret;
    }
}

