/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.io.File;
import misc.FileManager;

public class CutFasta2 {
    private static int OVERLAP_SIZE = 0;
    private static int UNIT_SIZE = 1000000;

    public static void main(String[] args) throws Exception {
        File fasta = new File(args[0]);
        File outputDir = new File(args[1]);
        int left = 0;
        String name = "mhc";
        File newFile = null;
        String backbone = CutFasta2.getSequenceFromFasta(fasta);
        int i = 0;
        while (i < 100) {
            int end = Math.min((i + 1) * UNIT_SIZE, backbone.length());
            newFile = new File(outputDir, String.valueOf(name) + "-" + left + "-" + end + ".fa");
            CutFasta2.cut(backbone, left, end, newFile);
            System.out.println(newFile.getAbsolutePath());
            left += UNIT_SIZE;
            if (end == backbone.length()) break;
            ++i;
        }
    }

    private static String getSequenceFromFasta(File fasta) {
        String[] lines = FileManager.readTextFile(fasta).split("\n");
        StringBuilder builder = new StringBuilder();
        StringBuilder seq = new StringBuilder();
        int i = 1;
        while (i < lines.length) {
            seq.append(lines[i].trim());
            ++i;
        }
        return seq.toString();
    }

    private static void cut(String seq, int start, int end, File output) {
        StringBuilder builder = new StringBuilder();
        builder.append(">").append(output.getName()).append("\n");
        builder.append(seq.substring(start, end));
        FileManager.writeTextFile(output, builder.toString(), true);
    }
}

