/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.io.File;
import misc.FileManager;

public class CutFasta {
    private static int OVERLAP_SIZE = 100;
    private static int UNIT_SIZE = 10000;

    public static void main(String[] args) throws Exception {
        File fastaDir = new File(args[0]);
        File outputDir = new File(args[1]);
        FileManager.writeTextFile(outputDir, CutFasta.getSequenceFromFasta(fastaDir), true);
    }

    public static String getSequenceFromFasta(File fasta) {
        String[] lines = FileManager.readTextFile(fasta).split("\n");
        StringBuilder builder = new StringBuilder();
        StringBuilder seq = new StringBuilder();
        int i = 1;
        while (i < lines.length) {
            seq.append(lines[i].trim());
            ++i;
        }
        return seq.toString();
    }

    private static void cut(String seq, int start, int end, File output) {
        StringBuilder builder = new StringBuilder();
        builder.append(">").append(output.getName()).append("\n");
        builder.append(seq.toString().substring(start, end));
        FileManager.writeTextFile(output, builder.toString(), true);
    }
}

