/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.io.IOException;
import misc.FileHandler;
import misc.FileHelper;
import misc.LogUtil;
import misc.OsHelper;
import misc.SnpConfig;

public class CustomPhred {
    private String chromatDir;
    private String outputDir;
    private SnpConfig config;
    private LogUtil phredLog;

    public CustomPhred(String chrDir, String outDir, SnpConfig conf) {
        this.chromatDir = chrDir;
        this.outputDir = outDir;
        this.config = conf;
        this.phredLog = new LogUtil(FileHelper.PHRED_LOG);
    }

    public void runPhred() throws IOException {
        System.out.println("\tphred...");
        this.phredLog.enter("<Script CustomPhred>\n");
        String snpDataDir = FileHelper.snpDataDir(this.outputDir, this.chromatDir);
        String polyDir = FileHelper.polyDir(this.outputDir, this.chromatDir, this.config);
        String fastaFile = FileHelper.fastaFile(snpDataDir);
        String qualFile = FileHelper.qualFile(snpDataDir);
        String fastaTrimFile = FileHelper.fastaTrimFile(snpDataDir);
        String qualTrimFile = FileHelper.qualTrimFile(snpDataDir);
        String cmd1 = "/genome/bin/phred -id " + this.chromatDir + " -sa " + fastaFile + " -qa " + qualFile + " -dd " + polyDir;
        String cmd2 = "/genome/bin/phred -id " + this.chromatDir + " -sa " + fastaTrimFile + " -qa " + qualTrimFile + " -trim_alt \"\" -trim_cutoff " + this.config.getTrimCutoff() + " -trim_fasta";
        String data1 = OsHelper.excuteCommand(cmd1);
        String data2 = OsHelper.excuteCommand(cmd2);
        this.phredLog.add(String.valueOf(cmd1) + "\n");
        this.phredLog.add(data1);
        this.phredLog.add(String.valueOf(cmd2) + "\n");
        this.phredLog.add(data2);
        FileHandler.fastaCorrect(fastaFile);
        FileHandler.qualCorrect(qualFile);
        FileHandler.fastaCorrect(fastaTrimFile);
        FileHandler.qualCorrect(qualTrimFile);
        this.phredLog.add("Correct File Format...\n");
        this.phredLog.exit("</Script CustomPhred>\n");
        this.phredLog.write(snpDataDir);
    }
}

