/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import misc.FileManager;

public class CompareKeyForGeneContent {
    private static final String N_READ_RESULT = "?";
    private static final String PRESENT_AND_POSITIVE_RESULT = "p+";
    private static final String PRESENT_AND_NEGATIVE_RESULT = "p-";
    private static final String ABSENT_RESULT = "n";
    private static final String PRESENT_RESULT = "p";

    public static void main(String[] args) throws Exception {
        File snpResultFile = new File(args[0]);
        File keyFile = new File(args[1]);
        File resultFile = new File(args[2]);
        Map<String, String> snpResultMap = CompareKeyForGeneContent.parseSnpResult(snpResultFile);
        Map<String, String> keyMap = CompareKeyForGeneContent.parseKey(keyFile);
        StringBuilder builder = new StringBuilder();
        for (String cellLine : snpResultMap.keySet()) {
            if (keyMap.containsKey(snpResultMap.get(cellLine))) {
                builder.append(cellLine).append("\t").append(keyMap.get(snpResultMap.get(cellLine))).append("\n");
                continue;
            }
            System.out.println("No key for " + cellLine + " " + snpResultMap.get(cellLine));
            builder.append(cellLine).append("\t").append("Unknown").append("\n");
        }
        FileManager.writeTextFile(resultFile, builder.toString(), true);
    }

    private static Map<String, String> parseSnpResult(File snpResultFile) {
        LinkedHashMap<String, String> snpResultMap = new LinkedHashMap<String, String>();
        String[] data = FileManager.readTextFile(snpResultFile).split("\n");
        LinkedHashMap rawDataMap = new LinkedHashMap();
        String[] header = data[0].trim().split("\\s+");
        int i = 1;
        while (i < data.length) {
            String[] info = data[i].split("\\s+");
            rawDataMap.put(info[0], new HashMap());
            int j = 1;
            while (j < header.length) {
                ((Map)rawDataMap.get(info[0])).put(header[j], info[j].trim());
                ++j;
            }
            ++i;
        }
        String answer = null;
        for (String cellLine : rawDataMap.keySet()) {
            answer = CompareKeyForGeneContent.getAnswer((Map)rawDataMap.get(cellLine));
            snpResultMap.put(cellLine, answer);
        }
        return snpResultMap;
    }

    private static String getAnswer(Map<String, String> snpResult) {
        String answer = "";
        answer = String.valueOf(answer) + CompareKeyForGeneContent.translate(snpResult.get("2DL2"));
        answer = String.valueOf(answer) + CompareKeyForGeneContent.translate(snpResult.get("2DL3"));
        answer = String.valueOf(answer) + CompareKeyForGeneContent.translate(snpResult.get("2DP1"));
        answer = String.valueOf(answer) + CompareKeyForGeneContent.translate(snpResult.get("2DS2"));
        answer = String.valueOf(answer) + CompareKeyForGeneContent.translate(snpResult.get("2DS35"));
        answer = String.valueOf(answer) + CompareKeyForGeneContent.translate(snpResult.get("3DL1"));
        answer = String.valueOf(answer) + CompareKeyForGeneContent.translate(snpResult.get("3DS1"));
        return answer;
    }

    private static String translate(String info) {
        if (info.indexOf(PRESENT_AND_POSITIVE_RESULT) > -1 || info.equalsIgnoreCase(PRESENT_RESULT)) {
            return "1";
        }
        if (info.indexOf(PRESENT_AND_NEGATIVE_RESULT) > -1 || info.equalsIgnoreCase(ABSENT_RESULT)) {
            return "0";
        }
        System.out.println("can not translate " + info);
        return N_READ_RESULT;
    }

    private static Map<String, String> parseKey(File keyFile) {
        LinkedHashMap<String, String> keyMap = new LinkedHashMap<String, String>();
        String[] data = FileManager.readTextFile(keyFile).split("\n");
        String type = null;
        String key = null;
        int i = 1;
        while (i < data.length) {
            String[] info = data[i].split("\\s+");
            type = info[0];
            key = "";
            int j = 1;
            while (j < info.length) {
                key = String.valueOf(key) + (info[j].trim().equals("+") ? "1" : "0");
                ++j;
            }
            if (keyMap.containsKey(key)) {
                keyMap.put(key, String.valueOf((String)keyMap.get(key)) + "/" + type);
            } else {
                keyMap.put(key, type);
            }
            ++i;
        }
        for (String k : keyMap.keySet()) {
            System.out.println(String.valueOf(k) + " " + (String)keyMap.get(k));
        }
        return keyMap;
    }
}

