/*
 * Decompiled with CFR 0.152.
 */
package kirTyping;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import misc.FileManager;

public class checkIndexFile {
    public static String[] index = new String[]{"A", "B", "C", "D", "E", "F", "G", "H"};

    public static void main(String[] args) throws Exception {
        File inputFile = new File(args[0]);
        File sampleFile = new File(args[1]);
        Map<Integer, Map<String, String>> plateSampleMap = checkIndexFile.loadSampleMap(inputFile);
        for (Integer num : plateSampleMap.keySet()) {
            System.out.println("Plate " + num);
            Map<String, String> sampleMap = plateSampleMap.get(num);
            for (String string : sampleMap.keySet()) {
                System.out.println(String.valueOf(string) + " " + sampleMap.get(string));
            }
        }
        LinkedHashMap<Integer, Map<String, Boolean>> plateSampleHitMap = new LinkedHashMap<Integer, Map<String, Boolean>>();
        Map<String, String> samplePlateCoord = checkIndexFile.loadSamplePlateCoord(sampleFile, plateSampleMap, plateSampleHitMap);
        for (String name : samplePlateCoord.keySet()) {
            System.out.println(String.valueOf(name) + " " + samplePlateCoord.get(name));
        }
        StringBuilder ret = new StringBuilder();
        for (Integer n : plateSampleMap.keySet()) {
            Map<String, String> sampleMap = plateSampleMap.get(n);
            Map sampleHitMap = (Map)plateSampleHitMap.get(n);
            ret.append("Plate ").append(n).append(",").append(",");
            int i = 1;
            while (i <= 12) {
                ret.append(i).append(",");
                ++i;
            }
            ret.append("\n");
            i = 0;
            while (i < index.length) {
                ret.append(",").append(index[i]).append(",");
                int j = 1;
                while (j <= 12) {
                    String coord = String.valueOf(index[i]) + j;
                    if (sampleHitMap.containsKey(coord)) {
                        ret.append(sampleMap.get(coord)).append(",");
                    } else {
                        ret.append(",");
                    }
                    ++j;
                }
                ret.append("\n");
                ++i;
            }
            ret.append("\n");
        }
        System.out.println(ret.toString());
    }

    private static Map<String, String> loadSamplePlateCoord(File sampleFile, Map<Integer, Map<String, String>> plateSampleMap, Map<Integer, Map<String, Boolean>> plateSampleHitMap) {
        String[] lines;
        LinkedHashMap<String, String> samplePlateCoord = new LinkedHashMap<String, String>();
        String[] stringArray = lines = FileManager.readTextFile(sampleFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String sample = line.trim().split(",")[1].split("-")[0];
            String plateCoord = checkIndexFile.findCoord(sample, plateSampleMap, plateSampleHitMap);
            samplePlateCoord.put(line.trim(), plateCoord);
            ++n2;
        }
        return samplePlateCoord;
    }

    private static String findCoord(String sample, Map<Integer, Map<String, String>> plateSampleMap, Map<Integer, Map<String, Boolean>> plateSampleHitMap) {
        for (Integer plate : plateSampleMap.keySet()) {
            Map<String, String> sampleMap = plateSampleMap.get(plate);
            for (String coord : sampleMap.keySet()) {
                if (!sample.equals(sampleMap.get(coord))) continue;
                if (!plateSampleHitMap.containsKey(plate)) {
                    plateSampleHitMap.put(plate, new LinkedHashMap());
                }
                plateSampleHitMap.get(plate).put(coord, true);
                return "Plate" + plate + "-" + coord;
            }
        }
        System.out.println("can't find " + sample);
        return null;
    }

    public static Map<Integer, Map<String, String>> loadSampleMap(File inputFile) {
        LinkedHashMap<Integer, Map<String, String>> plateSampleMap = new LinkedHashMap<Integer, Map<String, String>>();
        String[] lines = FileManager.readTextFile(inputFile).split("\n");
        int plateNumber = 0;
        LinkedHashMap<String, String> sampleMap = null;
        int i = 0;
        while (i < lines.length) {
            String line = lines[i].trim();
            String[] items = line.split(",");
            if (line.startsWith("Plate")) {
                if (plateNumber > 0) {
                    plateSampleMap.put(plateNumber, sampleMap);
                }
                plateNumber = new Integer(items[0].split("\\s+")[1]);
                sampleMap = new LinkedHashMap<String, String>();
                int j = i + 1;
                while (j <= i + 8) {
                    String line2 = lines[j].trim();
                    System.out.println(line2);
                    String[] items2 = line2.split(",");
                    String row = items2[1].trim();
                    System.out.println("row=" + row);
                    int x = 1;
                    while (x <= 12) {
                        String coord = String.valueOf(row) + x;
                        String sample = "";
                        if (1 + x < items2.length) {
                            sample = items2[1 + x].trim();
                        }
                        sampleMap.put(coord, sample);
                        ++x;
                    }
                    ++j;
                }
                i += 8;
            }
            ++i;
        }
        plateSampleMap.put(plateNumber, sampleMap);
        return plateSampleMap;
    }
}

