/*
 * Decompiled with CFR 0.152.
 */
package kirTyping;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import misc.FileManager;

public class GeneNameCoversion {
    public static void main(String[] args) throws Exception {
        File inputFile = new File(args[0]);
        File lookupFile = new File(args[1]);
        File outputFile = new File(args[2]);
        Map<String, String> names = GeneNameCoversion.parseLookupNames(lookupFile);
        StringBuilder out = new StringBuilder();
        String[] data = FileManager.readTextFile(inputFile).split("\n");
        out.append(data[0]).append("\n");
        int i = 1;
        while (i < data.length) {
            String[] items = data[i].trim().split("\\s+");
            if (items[1].trim().equals("Unknown") || items[1].trim().equals("?")) {
                out.append(data[i].trim()).append("\n");
            } else {
                out.append(data[i].trim()).append("\t");
                out.append(GeneNameCoversion.convertName(items[1].trim(), names)).append("\t");
                out.append(GeneNameCoversion.convertName(items[3].trim(), names)).append("\n");
            }
            ++i;
        }
        FileManager.writeTextFile(outputFile, out.toString(), true);
    }

    private static String convertName(String type, Map<String, String> names) {
        String[] typePairs;
        StringBuilder t = new StringBuilder();
        String[] stringArray = typePairs = type.split("/");
        int n = typePairs.length;
        int n2 = 0;
        while (n2 < n) {
            String typePair = stringArray[n2];
            String[] types = typePair.split("\\+");
            String type1 = names.get(types[0]);
            String type2 = names.get(types[1]);
            if (type1 == null || type2 == null) {
                System.out.println(String.valueOf(typePair) + " ??? ");
            }
            t.append(type1).append("+").append(type2).append("/");
            ++n2;
        }
        String r = t.toString();
        return r.substring(0, r.length() - 1);
    }

    private static Map<String, String> parseLookupNames(File inputFile) {
        String[] data;
        LinkedHashMap<String, String> names = new LinkedHashMap<String, String>();
        String[] stringArray = data = FileManager.readTextFile(inputFile).split("\n");
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] items = line.split(",");
            names.put(items[0].trim(), items[1].trim());
            ++n2;
        }
        return names;
    }
}

