/*
 * Decompiled with CFR 0.152.
 */
package kirTyping;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import kirTyping.ResolveGeneContent;
import misc.FileManager;

public class GeneCopiesForAmbiguity {
    public static void main(String[] args) throws Exception {
        File geneContentFile = new File(args[0]);
        File ambiguityFile = new File(args[1]);
        File symbolFile = new File(args[2]);
        Map<String, String> geneContentMap = ResolveGeneContent.parseGeneContent(geneContentFile);
        Map<String, String> geneSymbolMap = ResolveGeneContent.parseGeneSymbol(symbolFile);
        String[] ambiguities = FileManager.readTextFile(ambiguityFile).split("\n");
        GeneCopiesForAmbiguity.detectGeneCopyDifference(ambiguities, geneContentMap, geneSymbolMap);
    }

    private static void detectGeneCopyDifference(String[] ambiguities, Map<String, String> geneContentMap, Map<String, String> geneSymbolMap) {
        String[] stringArray = ambiguities;
        int n = ambiguities.length;
        int n2 = 0;
        while (n2 < n) {
            String ambiguity = stringArray[n2];
            String[] pairs = ambiguity.trim().split("\t");
            System.out.println("---------------------------");
            int i = 0;
            while (i < pairs.length - 1) {
                String pair1 = pairs[i];
                int j = i + 1;
                while (j < pairs.length) {
                    String pair2 = pairs[j];
                    System.out.println("compare " + pair1 + " with " + pair2);
                    GeneCopiesForAmbiguity.comparePairs(pair1, pair2, geneContentMap, geneSymbolMap);
                    ++j;
                }
                ++i;
            }
            ++n2;
        }
    }

    private static void comparePairs(String pair1, String pair2, Map<String, String> geneContentMap, Map<String, String> geneSymbolMap) {
        Map<String, Integer> map1 = GeneCopiesForAmbiguity.getGeneCopyMap(pair1, geneContentMap);
        Map<String, Integer> map2 = GeneCopiesForAmbiguity.getGeneCopyMap(pair2, geneContentMap);
        if (map1.size() != map2.size()) {
            System.out.println("error occur!!!");
        }
        for (String gene : map1.keySet()) {
            if (map1.get(gene).intValue() == map2.get(gene).intValue()) continue;
            System.out.println("** Diff " + geneSymbolMap.get(gene) + " " + map1.get(gene) + " " + map2.get(gene));
        }
    }

    private static Map<String, Integer> getGeneCopyMap(String pair, Map<String, String> geneContentMap) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String[] haps = pair.trim().split("\\+");
        String hap1 = geneContentMap.get(haps[0]);
        String hap2 = geneContentMap.get(haps[1]);
        GeneCopiesForAmbiguity.collect(hap1, map);
        GeneCopiesForAmbiguity.collect(hap2, map);
        return map;
    }

    private static void collect(String hap, Map<String, Integer> map) {
        int i = 0;
        while (i < hap.length()) {
            String gene = String.valueOf(hap.charAt(i));
            if (!map.containsKey(gene)) {
                map.put(gene, 1);
            } else {
                map.put(gene, map.get(gene) + 1);
            }
            ++i;
        }
    }
}

