/*
 * Decompiled with CFR 0.152.
 */
package kirTyping;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import misc.FileManager;

public class DetectKirGenesUniqueDifference {
    public static String[] GENE_NAMES = new String[]{"2DL1", "2DL2", "2DL3", "2DL4", "2DL5", "2DP1", "2DS1", "2DS2", "2DS3", "2DS4", "2DS5", "3DL1", "3DL2", "3DL3", "3DP1", "3DS1"};

    public static void main(String[] args) throws Exception {
        File fastaAlignmentFile = new File(args[0]);
        Map<String, Map<String, String>> sequenceMap = DetectKirGenesUniqueDifference.parseAlignmentFile(fastaAlignmentFile);
        DetectKirGenesUniqueDifference.findUniqueAlleles(sequenceMap);
    }

    private static void findUniqueAlleles(Map<String, Map<String, String>> sequenceMap) {
        String sequence = null;
        String[] stringArray = GENE_NAMES;
        int n = GENE_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String geneName = stringArray[n2];
            if (!sequenceMap.containsKey(geneName)) {
                System.out.println("missing " + geneName);
            } else {
                System.out.println("\n\nchecking " + geneName);
                Map<String, String> subMap = sequenceMap.get(geneName);
                int size = DetectKirGenesUniqueDifference.getSequenceLength(subMap);
                int i = 0;
                while (i < size) {
                    char checker = '*';
                    int count = 0;
                    for (String name : subMap.keySet()) {
                        sequence = subMap.get(name);
                        if (sequence.charAt(i) == checker && checker != '*') {
                            ++count;
                            continue;
                        }
                        if (sequence.charAt(i) != checker && checker == '*') {
                            checker = sequence.charAt(i);
                            ++count;
                            continue;
                        }
                        if (sequence.charAt(i) == checker || checker == '*' || sequence.charAt(i) == '*') continue;
                        count = 0;
                        break;
                    }
                    if (count > 0) {
                        if (DetectKirGenesUniqueDifference.isAllOtherTypeDifferent(i, checker, geneName, sequenceMap)) {
                            System.out.println("Unique at " + (i + 1) + " " + checker + " frequency=" + count);
                        } else if (DetectKirGenesUniqueDifference.isMoreTypesShareSameAlleles(i, checker, geneName, sequenceMap, 1)) {
                            System.out.println("Same as " + (i + 1) + " " + checker + " frequency=" + count);
                        }
                    }
                    ++i;
                }
            }
            ++n2;
        }
    }

    private static boolean isMoreTypesShareSameAlleles(int index, char checker, String geneName, Map<String, Map<String, String>> sequenceMap, int limit) {
        int count = 0;
        HashMap<String, Integer> records = new HashMap<String, Integer>();
        for (String name : sequenceMap.keySet()) {
            if (name.equals(geneName)) continue;
            Map<String, String> subMap = sequenceMap.get(name);
            int subCount = 0;
            for (String sequence : subMap.values()) {
                if (sequence.charAt(index) == checker) {
                    ++subCount;
                    continue;
                }
                if (sequence.charAt(index) == '*') continue;
                subCount = 0;
                break;
            }
            if (subCount <= 0) continue;
            records.put(name, subCount);
            ++count;
        }
        if (count <= limit && count > 0) {
            for (String name : records.keySet()) {
                System.out.println("\t" + name + " frequency=" + records.get(name));
            }
            return true;
        }
        return false;
    }

    private static boolean isAllOtherTypeDifferent(int index, char checker, String geneName, Map<String, Map<String, String>> sequenceMap) {
        for (String name : sequenceMap.keySet()) {
            if (name.equals(geneName)) continue;
            Map<String, String> subMap = sequenceMap.get(name);
            for (String sequence : subMap.values()) {
                if (sequence.charAt(index) != checker) continue;
                return false;
            }
        }
        return true;
    }

    private static int getSequenceLength(Map<String, String> subMap) {
        Iterator<String> iterator = subMap.values().iterator();
        if (iterator.hasNext()) {
            String sequence = iterator.next();
            return sequence.length();
        }
        return 0;
    }

    private static Map<String, Map<String, String>> parseAlignmentFile(File fastaAlignmentFile) {
        HashMap<String, Map<String, String>> sequenceMap = new HashMap<String, Map<String, String>>();
        String[] lines = FileManager.readTextFile(fastaAlignmentFile).split("\n");
        String[] data = null;
        String hapType = null;
        Map subMap = null;
        String sequence = null;
        String name = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() >= 6 && (line.trim().charAt(4) == '*' || line.trim().charAt(5) == '*')) {
                data = line.trim().split("\\s+");
                name = data[0].trim();
                hapType = name.substring(0, 4);
                subMap = sequenceMap.containsKey(hapType) ? (Map)sequenceMap.get(hapType) : new LinkedHashMap();
                sequence = subMap.containsKey(name) ? (String)subMap.get(name) : "";
                int i = 1;
                while (i < data.length) {
                    sequence = String.valueOf(sequence) + data[i].trim().replaceAll("|", "").toUpperCase();
                    ++i;
                }
                subMap.put(name, sequence);
                sequenceMap.put(hapType, subMap);
            }
            ++n2;
        }
        return sequenceMap;
    }
}

