/*
 * Decompiled with CFR 0.152.
 */
package kirTyping;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kirTyping.AmpliconPosition;
import kirTyping.Condition;
import kirTyping.GeneResult;
import kirTyping.Key;
import misc.FileManager;

public class DetectKirGeneContent {
    private static final String N_RESULT = "?";
    private static final String POSITIVE = "+";
    private static final String NEGATIVE = "-";
    private static Map<String, Map<Integer, Map<String, String>>> amplicon_data_map = new HashMap<String, Map<Integer, Map<String, String>>>();
    private static final String[] GENES = new String[]{"2DL1", "2DL2", "2DL3", "2DL5", "2DP1", "2DS1", "2DS2", "2DS4", "2DS3", "2DS5", "2DS35", "3DL1", "3DS1"};

    public static void main(String[] args) throws Exception {
        File ruleFile = new File(args[0]);
        File outputRoot = new File(args[1]);
        File resultFile = new File(args[2]);
        Map<String, List<Key>> ruleSets = DetectKirGeneContent.parseRuleSet(ruleFile);
        DetectKirGeneContent.validateRuleSet(ruleSets);
        List<Key> keys = null;
        HashMap<String, Map<String, String>> resultMap = new HashMap<String, Map<String, String>>();
        for (String gene : ruleSets.keySet()) {
            System.out.println("--------" + gene + "-----------");
            keys = ruleSets.get(gene);
            DetectKirGeneContent.populateGeneResult(keys, gene, outputRoot, resultMap);
        }
        FileManager.writeTextFile(resultFile, DetectKirGeneContent.formatResult(resultMap), true);
    }

    private static void validateRuleSet(Map<String, List<Key>> ruleSets) {
        for (String gene : ruleSets.keySet()) {
            Key determinateKey = ruleSets.get(gene).get(0);
            System.out.println(String.valueOf(gene) + " determinate key " + determinateKey.getAmpliconPosition().toString());
            for (Key key : ruleSets.get(gene)) {
                System.out.println("\t" + key.getAmpliconPosition().getAmplicon() + " " + key.getAmpliconPosition().getPosition() + " " + key.getConditions().size());
            }
        }
    }

    private static void populateGeneResult(List<Key> keys, String gene, File outputRoot, Map<String, Map<String, String>> resultMap) {
        File ampSnpFile = null;
        HashMap geneResult = new HashMap();
        Map<Object, Object> map = new HashMap();
        AmpliconPosition ampliconPosition = null;
        for (Key key : keys) {
            ampliconPosition = key.getAmpliconPosition();
            ampSnpFile = new File(outputRoot, String.valueOf(ampliconPosition.getAmplicon()) + ".csv");
            if (!amplicon_data_map.containsKey(ampSnpFile.getName())) {
                map = DetectKirGeneContent.parseSnpFile(ampSnpFile);
                amplicon_data_map.put(ampSnpFile.getName(), map);
            }
            if (!(map = amplicon_data_map.get(ampSnpFile.getName())).containsKey(ampliconPosition.getPosition())) continue;
            for (String cellline : ((Map)map.get(ampliconPosition.getPosition())).keySet()) {
                if (!geneResult.containsKey(cellline)) {
                    geneResult.put(cellline, new ArrayList());
                }
                ((List)geneResult.get(cellline)).add(DetectKirGeneContent.interpretPresentAbsent(map, cellline, key));
            }
        }
        for (String cellLine : geneResult.keySet()) {
            if (!resultMap.containsKey(cellLine)) {
                resultMap.put(cellLine, new HashMap());
            }
            resultMap.get(cellLine).put(gene, DetectKirGeneContent.concludeResult((List)geneResult.get(cellLine), cellLine));
        }
    }

    private static String concludeResult(List<GeneResult> list, String cellLine) {
        GeneResult determinate = list.get(0);
        if (determinate.getResult().equals(N_RESULT)) {
            System.out.print(String.valueOf(cellLine) + " determinate is Unknown, use backups : ");
            for (GeneResult geneResult : list) {
                if (geneResult.getResult().equals(N_RESULT)) continue;
                determinate = geneResult;
                System.out.print(geneResult.getResult());
                break;
            }
            System.out.print("\n");
        }
        boolean isDiff = false;
        ArrayList<GeneResult> diffPos = new ArrayList<GeneResult>();
        int consistantCount = 0;
        int diffCount = 0;
        int i = 1;
        while (i < list.size()) {
            if (!determinate.getResult().equals(N_RESULT) && !list.get(i).getResult().equals(N_RESULT)) {
                if (!determinate.getResult().equals(list.get(i).getResult())) {
                    isDiff = true;
                    diffPos.add(list.get(i));
                    ++diffCount;
                } else {
                    ++consistantCount;
                }
            }
            ++i;
        }
        if (isDiff) {
            System.out.println(String.valueOf(cellLine) + " determinate is different than backups " + " consistant count " + consistantCount + ", different count " + diffCount + " at : " + DetectKirGeneContent.formatPos(diffPos) + " determinate=" + determinate.getAmpliconPosition().getAmplicon() + NEGATIVE + determinate.getAmpliconPosition().getPosition() + " " + determinate.getResult());
        }
        return determinate.getResult();
    }

    private static String formatPos(List<GeneResult> diffPos) {
        StringBuilder builder = new StringBuilder();
        for (GeneResult geneResult : diffPos) {
            builder.append(geneResult.getAmpliconPosition().getAmplicon()).append(NEGATIVE).append(geneResult.getAmpliconPosition().getPosition()).append(",");
        }
        return builder.toString();
    }

    private static GeneResult interpretPresentAbsent(Map<Integer, Map<String, String>> map, String cellLine, Key key) {
        GeneResult geneResult = new GeneResult();
        AmpliconPosition ampliconPosition = key.getAmpliconPosition();
        geneResult.setAmpliconPosition(ampliconPosition);
        String allele = map.get(ampliconPosition.getPosition()).get(cellLine);
        if (allele.startsWith("N") || allele.startsWith(NEGATIVE)) {
            geneResult.setResult(N_RESULT);
            return geneResult;
        }
        if (DetectKirGeneContent.isPassConditionChecking(map, cellLine, key.getConditions())) {
            if (DetectKirGeneContent.isBaseExistInAllele(allele, ampliconPosition)) {
                geneResult.setResult(POSITIVE);
                return geneResult;
            }
            geneResult.setResult(NEGATIVE);
            return geneResult;
        }
        geneResult.setResult(N_RESULT);
        return geneResult;
    }

    private static boolean isMeetCondition(Condition condition, Map<Integer, Map<String, String>> map, String cellLine) {
        AmpliconPosition ampliconPosition = condition.getAmpliconPosition();
        String allele = map.get(ampliconPosition.getPosition()).get(cellLine);
        if (allele.startsWith("N") || allele.startsWith(NEGATIVE)) {
            return false;
        }
        boolean isBaseExistInAllele = DetectKirGeneContent.isBaseExistInAllele(allele, ampliconPosition);
        return isBaseExistInAllele && condition.isTrue || !isBaseExistInAllele && !condition.isTrue;
    }

    private static boolean isBaseExistInAllele(String allele, AmpliconPosition ampliconPosition) {
        int i = 0;
        while (i < ampliconPosition.getBases().length()) {
            if (allele.indexOf(ampliconPosition.getBases().charAt(i)) >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isPassConditionChecking(Map<Integer, Map<String, String>> map, String cellLine, List<List<Condition>> conditions) {
        if (conditions == null || conditions.size() == 0) {
            return true;
        }
        for (List<Condition> aConditionList : conditions) {
            boolean allPassed = true;
            for (Condition condition : aConditionList) {
                if (DetectKirGeneContent.isMeetCondition(condition, map, cellLine)) continue;
                allPassed = false;
            }
            if (!allPassed) continue;
            return true;
        }
        return false;
    }

    private static Map<String, List<Key>> parseRuleSet(File ruleFile) {
        HashMap<String, List<Key>> ruleSets = new HashMap<String, List<Key>>();
        String[] lines = FileManager.readTextFile(ruleFile).split("\n");
        String gene = null;
        Key aKey = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0) {
                String[] items = line.trim().split("\t");
                gene = items[0];
                if (!ruleSets.containsKey(gene)) {
                    ruleSets.put(gene, new ArrayList());
                }
                aKey = DetectKirGeneContent.convertIntoKey(items);
                DetectKirGeneContent.mergeOrAddKey((List)ruleSets.get(gene), aKey);
            }
            ++n2;
        }
        return ruleSets;
    }

    private static void mergeOrAddKey(List<Key> keys, Key aKey) {
        boolean isExist = false;
        for (Key key : keys) {
            if (!key.getInput().equals(aKey.getInput())) continue;
            if (aKey.getConditions().size() > 0) {
                key.getConditions().add(aKey.getConditions().get(0));
            }
            isExist = true;
        }
        if (!isExist) {
            if (aKey.isDeterminate()) {
                keys.add(0, aKey);
            } else {
                keys.add(aKey);
            }
        }
    }

    private static Key convertIntoKey(String[] items) {
        Key aKey = new Key();
        aKey.setInput(items[1].trim());
        aKey.setConditions(new ArrayList<List<Condition>>());
        aKey.setAmpliconPosition(DetectKirGeneContent.parseAmpliconPosition(items[1].trim()));
        if (items.length == 2) {
            return aKey;
        }
        if (items[2].equals("#")) {
            aKey.setDeterminate(true);
        } else if (items.length >= 3) {
            ArrayList<Condition> conditions = new ArrayList<Condition>();
            int i = 2;
            while (i < items.length) {
                conditions.add(DetectKirGeneContent.parseCondition(items[i].trim()));
                ++i;
            }
            aKey.getConditions().add(conditions);
        }
        return aKey;
    }

    private static Condition parseCondition(String conditionStr) {
        Condition condition = new Condition();
        String ampPosStr = conditionStr;
        if (conditionStr.startsWith("!")) {
            condition.setTrue(false);
            ampPosStr = conditionStr.substring(1, conditionStr.length());
        } else {
            condition.setTrue(true);
        }
        condition.setAmpliconPosition(DetectKirGeneContent.parseAmpliconPosition(ampPosStr));
        return condition;
    }

    private static AmpliconPosition parseAmpliconPosition(String input) {
        AmpliconPosition ampliconPosition = new AmpliconPosition();
        String[] info = input.split("_");
        ampliconPosition.setAmplicon(info[0]);
        String[] posBase = info[1].split(NEGATIVE);
        ampliconPosition.setPosition(Integer.valueOf(posBase[0]));
        ampliconPosition.setBases(posBase[1]);
        return ampliconPosition;
    }

    private static String formatResult(Map<String, Map<String, String>> resultMap) {
        StringBuilder content = new StringBuilder();
        StringBuilder header = new StringBuilder();
        header.append("CellLine").append("\t");
        String[] stringArray = GENES;
        int n = GENES.length;
        int n2 = 0;
        while (n2 < n) {
            String gene = stringArray[n2];
            header.append(gene).append("\t");
            ++n2;
        }
        content.append(header.toString().trim()).append("\n");
        StringBuilder thisLine = null;
        Map<String, String> amp_result = null;
        for (String cellLine : resultMap.keySet()) {
            thisLine = new StringBuilder();
            thisLine.append(cellLine).append("\t");
            amp_result = resultMap.get(cellLine);
            String[] stringArray2 = GENES;
            int n3 = GENES.length;
            int n4 = 0;
            while (n4 < n3) {
                String gene = stringArray2[n4];
                thisLine.append(amp_result.get(gene)).append("\t");
                ++n4;
            }
            content.append(thisLine.toString().trim()).append("\n");
        }
        return content.toString();
    }

    private static Map<Integer, Map<String, String>> parseSnpFile(File snpFile) {
        HashMap<Integer, Map<String, String>> snpData = new HashMap<Integer, Map<String, String>>();
        String[] data = FileManager.readTextFile(snpFile).split("\n");
        String cellLine = null;
        String allele = null;
        Integer position = null;
        String[] positions = data[1].trim().split(",");
        int i = 1;
        while (i < positions.length) {
            position = new Integer(positions[i].split(":")[1].trim());
            snpData.put(position, new HashMap());
            int j = 5;
            while (j < data.length) {
                cellLine = data[j].split(",")[0].trim();
                allele = data[j].split(",")[i].trim();
                ((Map)snpData.get(position)).put(cellLine, allele);
                ++j;
            }
            ++i;
        }
        return snpData;
    }
}

