/*
 * Decompiled with CFR 0.152.
 */
package kirTyping;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.DiploidType;
import misc.FileManager;

public class CustomResolveGeneContent {
    public static void main(String[] args) throws Exception {
        File geneContentFile = new File(args[0]);
        File symbolFile = new File(args[1]);
        Map<String, String> geneContentMap = CustomResolveGeneContent.parseGeneContent(geneContentFile);
        Map<String, String> geneSymbolMap = CustomResolveGeneContent.parseGeneSymbol(symbolFile);
        Map<String, String> statisticsMap = CustomResolveGeneContent.testGeneContent(geneContentMap, geneSymbolMap);
    }

    private static Map<String, String> testGeneContent(Map<String, String> geneContentMap, Map<String, String> geneSymbolMap) {
        Map<String, Integer> geneWorkingMap = CustomResolveGeneContent.initCountMap(geneSymbolMap);
        Map<String, Integer> geneUniqueWorkingMap = CustomResolveGeneContent.initCountMap(geneSymbolMap);
        Map<String, String> patternMap = CustomResolveGeneContent.testGenePattern(geneContentMap, geneSymbolMap);
        CustomResolveGeneContent.buildStaticsPattern(geneSymbolMap, geneWorkingMap, geneUniqueWorkingMap, patternMap);
        for (String symbol : geneWorkingMap.keySet()) {
            System.out.println(String.valueOf(symbol) + "->" + geneSymbolMap.get(symbol) + "\t" + geneWorkingMap.get(symbol) + "\t" + geneUniqueWorkingMap.get(symbol));
        }
        CustomResolveGeneContent.testDiploidGeneContent(geneSymbolMap, geneContentMap);
        return patternMap;
    }

    private static void testDiploidGeneContent(Map<String, String> geneSymbolMap, Map<String, String> geneContentMap) {
        List<DiploidType> diploidTypes = CustomResolveGeneContent.getDiploidTypes(geneContentMap);
        System.out.print("\t\t\t");
        for (String value : geneSymbolMap.values()) {
            System.out.print(String.valueOf(value) + "\t");
        }
        System.out.println();
        CustomResolveGeneContent.getDiploidPattern(geneSymbolMap, geneContentMap, diploidTypes);
        for (DiploidType diploidType : diploidTypes) {
            System.out.print(String.valueOf(diploidType.getHaploid1()) + "+" + diploidType.getHaploid2() + "\t");
            String pattern = diploidType.getPattern();
            int i = 0;
            while (i < pattern.length()) {
                System.out.print(String.valueOf(pattern.charAt(i)) + "\t");
                ++i;
            }
            System.out.println();
        }
        DiploidType diploidType1 = null;
        DiploidType diploidType2 = null;
        int totalPairs = 0;
        int unResolved = 0;
        HashMap ambigiousMap = new HashMap();
        int i = 0;
        while (i < diploidTypes.size() - 1) {
            diploidType1 = diploidTypes.get(i);
            int j = i + 1;
            while (j < diploidTypes.size()) {
                diploidType2 = diploidTypes.get(j);
                ++totalPairs;
                if (diploidType1.getPattern().equals(diploidType2.getPattern())) {
                    ++unResolved;
                    if (!ambigiousMap.containsKey(diploidType1.getPattern())) {
                        ambigiousMap.put(diploidType1.getPattern(), new ArrayList());
                    }
                    if (!((List)ambigiousMap.get(diploidType1.getPattern())).contains(String.valueOf(diploidType1.getHaploid1()) + "+" + diploidType1.getHaploid2())) {
                        ((List)ambigiousMap.get(diploidType1.getPattern())).add(String.valueOf(diploidType1.getHaploid1()) + "+" + diploidType1.getHaploid2());
                    }
                    if (!((List)ambigiousMap.get(diploidType1.getPattern())).contains(String.valueOf(diploidType2.getHaploid1()) + "+" + diploidType2.getHaploid2())) {
                        ((List)ambigiousMap.get(diploidType1.getPattern())).add(String.valueOf(diploidType2.getHaploid1()) + "+" + diploidType2.getHaploid2());
                    }
                }
                ++j;
            }
            ++i;
        }
        System.out.println("Total diploid pairs compared " + totalPairs);
        System.out.println("Unresloved diploid pairs " + unResolved);
        for (List list : ambigiousMap.values()) {
            System.out.print("Diploid Type Ambiguity : ");
            for (String type : list) {
                System.out.print(String.valueOf(type) + " ");
            }
            System.out.print("\n");
        }
    }

    private static void getDiploidPattern(Map<String, String> geneSymbolMap, Map<String, String> geneContentMap, List<DiploidType> diploidTypes) {
        String pattern1 = null;
        String pattern2 = null;
        String pattern = null;
        for (DiploidType diploidType : diploidTypes) {
            pattern = "";
            pattern1 = CustomResolveGeneContent.testPattern(geneContentMap.get(diploidType.getHaploid1()), geneSymbolMap);
            pattern2 = CustomResolveGeneContent.testPattern(geneContentMap.get(diploidType.getHaploid2()), geneSymbolMap);
            int i = 0;
            while (i < pattern1.length()) {
                pattern = pattern1.charAt(i) == '+' || pattern2.charAt(i) == '+' ? String.valueOf(pattern) + '+' : String.valueOf(pattern) + '-';
                ++i;
            }
            diploidType.setPattern(pattern);
        }
    }

    private static List<DiploidType> getDiploidTypes(Map<String, String> geneContentMap) {
        ArrayList<DiploidType> diploidTypes = new ArrayList<DiploidType>();
        String hType1 = null;
        String hType2 = null;
        DiploidType diploidType = null;
        Object[] types = geneContentMap.keySet().toArray();
        int i = 0;
        while (i < types.length) {
            hType1 = (String)types[i];
            int j = i;
            while (j < types.length) {
                hType2 = (String)types[j];
                diploidType = new DiploidType(hType1, hType2);
                diploidTypes.add(diploidType);
                ++j;
            }
            ++i;
        }
        return diploidTypes;
    }

    private static void buildStaticsPattern(Map<String, String> geneSymbolMap, Map<String, Integer> geneWorkingMap, Map<String, Integer> geneUniqueWorkingMap, Map<String, String> patternMap) {
        String pattern1 = null;
        String pattern2 = null;
        String content1 = null;
        String content2 = null;
        Object[] contents = patternMap.keySet().toArray();
        int i = 0;
        while (i < contents.length - 1) {
            content1 = (String)contents[i];
            pattern1 = patternMap.get(content1);
            int j = i + 1;
            while (j < contents.length) {
                content2 = (String)contents[j];
                pattern2 = patternMap.get(content2);
                CustomResolveGeneContent.populateWorkingMap(geneSymbolMap, pattern1, pattern2, geneWorkingMap, geneUniqueWorkingMap, content1, content2);
                ++j;
            }
            ++i;
        }
    }

    private static Map<String, String> buildMinimumSet(Map<String, String> geneContentMap, Map<String, String> geneSymbolMap, Map<String, Integer> geneWorkingMap, Map<String, Integer> geneUniqueWorkingMap) {
        String removeSymbol = CustomResolveGeneContent.getRemoveSymbol(geneWorkingMap, geneUniqueWorkingMap);
        Map<String, String> newGeneSymbolMap = null;
        if (removeSymbol == null) {
            for (String symbol : geneWorkingMap.keySet()) {
                System.out.println(String.valueOf(symbol) + "->" + geneSymbolMap.get(symbol) + "\t\t" + geneWorkingMap.get(symbol) + "\t" + geneUniqueWorkingMap.get(symbol));
            }
            return geneSymbolMap;
        }
        System.out.println("remove " + removeSymbol);
        newGeneSymbolMap = CustomResolveGeneContent.makeNewGeneSymbolMap(geneSymbolMap, removeSymbol);
        Map<String, Integer> newGeneWorkingMap = CustomResolveGeneContent.initCountMap(geneSymbolMap);
        Map<String, Integer> newGeneUniqueWorkingMap = CustomResolveGeneContent.initCountMap(geneSymbolMap);
        Map<String, String> patternMap = CustomResolveGeneContent.testGenePattern(geneContentMap, newGeneSymbolMap);
        CustomResolveGeneContent.buildStaticsPattern(newGeneSymbolMap, newGeneWorkingMap, newGeneUniqueWorkingMap, patternMap);
        return CustomResolveGeneContent.buildMinimumSet(geneContentMap, newGeneSymbolMap, newGeneWorkingMap, newGeneUniqueWorkingMap);
    }

    private static Map<String, String> makeNewGeneSymbolMap(Map<String, String> geneSymbolMap, String removeSymbol) {
        LinkedHashMap<String, String> newGeneSymbolMap = new LinkedHashMap<String, String>();
        for (String key : geneSymbolMap.keySet()) {
            if (key.equals(removeSymbol)) continue;
            newGeneSymbolMap.put(key, geneSymbolMap.get(key));
        }
        return newGeneSymbolMap;
    }

    private static String getRemoveSymbol(Map<String, Integer> geneWorkingMap, Map<String, Integer> geneUniqueWorkingMap) {
        String removeSymbol = null;
        for (String symbol : geneUniqueWorkingMap.keySet()) {
            if (geneUniqueWorkingMap.get(symbol) != 0) continue;
            if (removeSymbol == null) {
                removeSymbol = symbol;
                continue;
            }
            if (geneWorkingMap.get(removeSymbol) <= geneWorkingMap.get(symbol)) continue;
            removeSymbol = symbol;
        }
        return removeSymbol;
    }

    private static void populateWorkingMap(Map<String, String> geneSymbolMap, String pattern1, String pattern2, Map<String, Integer> geneWorkingMap, Map<String, Integer> geneUniqueWorkingMap, String content1, String content2) {
        Object[] symbols = geneSymbolMap.keySet().toArray();
        int plusMinus = 0;
        int minusPlus = 0;
        String symbol = null;
        int i = 0;
        while (i < symbols.length) {
            symbol = (String)symbols[i];
            if (pattern1.charAt(i) != pattern2.charAt(i)) {
                geneWorkingMap.put(symbol, geneWorkingMap.get(symbol) + 1);
                if (pattern1.charAt(i) == '+') {
                    ++plusMinus;
                } else {
                    ++minusPlus;
                }
            }
            ++i;
        }
        if (plusMinus == 0 && minusPlus == 0) {
            System.out.println("no diff between " + content1 + " and " + content2);
        }
        if (plusMinus == 0 || minusPlus == 0) {
            System.out.println("partially resolve " + content1 + " and " + content2);
        }
        if (plusMinus == 1) {
            i = 0;
            while (i < symbols.length) {
                symbol = (String)symbols[i];
                if (pattern1.charAt(i) != pattern2.charAt(i) && pattern1.charAt(i) == '+') {
                    geneUniqueWorkingMap.put(symbol, geneUniqueWorkingMap.get(symbol) + 1);
                }
                ++i;
            }
        }
        if (minusPlus == 1) {
            i = 0;
            while (i < symbols.length) {
                symbol = (String)symbols[i];
                if (pattern1.charAt(i) != pattern2.charAt(i) && pattern1.charAt(i) == '-') {
                    geneUniqueWorkingMap.put(symbol, geneUniqueWorkingMap.get(symbol) + 1);
                }
                ++i;
            }
        }
    }

    private static String testPattern(String genes, Map<String, String> geneSymbolMap) {
        String pattern = "";
        for (String symbol : geneSymbolMap.keySet()) {
            pattern = genes.indexOf(symbol) > -1 ? String.valueOf(pattern) + "+" : String.valueOf(pattern) + "-";
        }
        return pattern;
    }

    private static Map<String, String> testGenePattern(Map<String, String> geneContentMap, Map<String, String> geneSymbolMap) {
        LinkedHashMap<String, String> patternMap = new LinkedHashMap<String, String>();
        String pattern = null;
        String genes = null;
        for (String key : geneContentMap.keySet()) {
            pattern = "";
            genes = geneContentMap.get(key);
            patternMap.put(key, CustomResolveGeneContent.testPattern(genes, geneSymbolMap));
        }
        return patternMap;
    }

    private static Map<String, Integer> initCountMap(Map<String, String> geneSymbolMap) {
        LinkedHashMap<String, Integer> geneMap = new LinkedHashMap<String, Integer>();
        for (String key : geneSymbolMap.keySet()) {
            geneMap.put(key, 0);
        }
        return geneMap;
    }

    private static Map<String, String> parseGeneContent(File geneContentFile) {
        LinkedHashMap<String, String> geneContentMap = new LinkedHashMap<String, String>();
        String[] text = FileManager.readTextFile(geneContentFile).trim().split("\n");
        int i = 0;
        while (i < text.length - 1) {
            if (text[i].charAt(0) == '>') {
                geneContentMap.put(text[i].substring(1).trim(), text[i + 1].trim());
                System.out.println(String.valueOf(text[i].substring(1).trim()) + " " + text[i + 1].trim());
                ++i;
            }
            ++i;
        }
        return geneContentMap;
    }

    private static Map<String, String> parseGeneSymbol(File symbolFile) {
        String[] text;
        LinkedHashMap<String, String> geneSymbolMap = new LinkedHashMap<String, String>();
        String[] stringArray = text = FileManager.readTextFile(symbolFile).trim().split("\n");
        int n = text.length;
        int n2 = 0;
        while (n2 < n) {
            String info = stringArray[n2];
            geneSymbolMap.put(info.split("\t")[1].trim(), info.split("\t")[0].trim());
            System.out.println(String.valueOf(info.split("\t")[1].trim()) + " -> " + info.split("\t")[0].trim());
            ++n2;
        }
        return geneSymbolMap;
    }
}

