/*
 * Decompiled with CFR 0.152.
 */
package kirCountTyping;

import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kirCountTyping.GeneContentRulesetTyper;
import kirCountTyping.KirConstants;
import kirCountTyping.KirCount;
import kirCountTyping.KirDiploidType;
import kirCountTyping.KirGeneExonCountPoint;
import kirCountTyping.KirGeneExonCountSummary;
import kirCountTyping.KirGeneResult;
import kirCountTyping.KirSample;
import kirCountTyping.KirUtils;
import kirCountTyping.NmerRulesetParser;
import misc.FileManager;

public class ValidateGeneCopyByRatio {
    static final String COPY = "copy";
    static final String COUNT = "count";
    static final String COPY_BY_CORRECTED_RATIO = "copyBycorrectedRatio";
    static final String NO_RATIO = "noRatio";

    public static void main(String[] args) throws Exception {
        File kirCountFile = new File(args[0]);
        File kirNmerRulesetFile = new File(args[1]);
        File kirHapRulesetFile = new File(args[2]);
        File kirReport = new File(args[3]);
        File output = new File(args[4]);
        ValidateGeneCopyByRatio.validateGeneCopies(kirCountFile, kirNmerRulesetFile, kirHapRulesetFile, kirReport, output);
    }

    private static void validateGeneCopies(File kirCountFile, File kirNmerRulesetFile, File kirHapRulesetFile, File kirReport, File output) {
        Map<String, Float> exonFactors;
        String gene;
        GeneContentRulesetTyper geneContentRulesetTyper = new GeneContentRulesetTyper(kirHapRulesetFile);
        String[] lines = FileManager.readTextFile(kirCountFile).split("\n");
        HashMap<String, KirSample> samples = new HashMap<String, KirSample>();
        int i = 1;
        while (i < lines.length) {
            KirSample sample = ValidateGeneCopyByRatio.readInGeneExonCounts(geneContentRulesetTyper, kirNmerRulesetFile, lines, i);
            samples.put(sample.getName(), sample);
            ++i;
        }
        ValidateGeneCopyByRatio.readInGeneCopies(samples, kirReport);
        Map<String, Map<String, Float>> geneFactor = ValidateGeneCopyByRatio.calculateGeneFactor(samples);
        ValidateGeneCopyByRatio.generateFactorOutput(samples, geneFactor, output);
        String[] stringArray = KirConstants.KIR_GENES;
        int n = KirConstants.KIR_GENES.length;
        int n2 = 0;
        while (n2 < n) {
            gene = stringArray[n2];
            if (geneFactor.containsKey(gene)) {
                exonFactors = geneFactor.get(gene);
                System.out.println("--------------" + gene);
                for (String exon : exonFactors.keySet()) {
                    System.out.println(String.valueOf(exon) + " factor: " + exonFactors.get(exon));
                }
            }
            ++n2;
        }
        stringArray = KirConstants.KIR_COMBINED_GENES;
        n = KirConstants.KIR_COMBINED_GENES.length;
        n2 = 0;
        while (n2 < n) {
            gene = stringArray[n2];
            if (geneFactor.containsKey(gene)) {
                exonFactors = geneFactor.get(gene);
                System.out.println("--------------" + gene);
                for (String exon : exonFactors.keySet()) {
                    System.out.println(String.valueOf(exon) + " factor: " + exonFactors.get(exon));
                }
            }
            ++n2;
        }
    }

    private static void generateFactorOutput(Map<String, KirSample> samples, Map<String, Map<String, Float>> geneFactors, File output) {
        StringBuilder builder = new StringBuilder();
        ValidateGeneCopyByRatio.generateHeader(geneFactors, builder);
        for (String sampleName : samples.keySet()) {
            String gene;
            builder.append(sampleName).append("\t");
            if (samples.get(sampleName).getMostCommonType() == null) {
                builder.append("\n");
                continue;
            }
            builder.append(KirUtils.joinName(samples.get(sampleName).getMostCommonType(), true)).append("\t");
            String[] stringArray = KirConstants.KIR_GENES;
            int n = KirConstants.KIR_GENES.length;
            int n2 = 0;
            while (n2 < n) {
                gene = stringArray[n2];
                ValidateGeneCopyByRatio.outputCorrectedRatioForGene(samples, geneFactors, builder, sampleName, gene);
                ++n2;
            }
            stringArray = KirConstants.KIR_COMBINED_GENES;
            n = KirConstants.KIR_COMBINED_GENES.length;
            n2 = 0;
            while (n2 < n) {
                gene = stringArray[n2];
                ValidateGeneCopyByRatio.outputCorrectedRatioForGene(samples, geneFactors, builder, sampleName, gene);
                ++n2;
            }
            builder.append("\n");
        }
        FileManager.writeTextFile(output, builder.toString(), true);
    }

    private static void outputCorrectedRatioForGene(Map<String, KirSample> samples, Map<String, Map<String, Float>> geneFactors, StringBuilder builder, String sampleName, String gene) {
        KirGeneResult geneResult = samples.get(sampleName).getGeneResult().get(gene);
        int copy = ValidateGeneCopyByRatio.getGeneCopy(gene, samples.get(sampleName).getGeneResult());
        builder.append(copy).append("\t");
        if (gene.equals("3DL3")) {
            builder.append(geneResult.getSupportingExonCounts().get("3DL3-exon3").getCount()).append("\t");
            builder.append(geneResult.getSupportingExonCounts().get("3DL3-exon4").getCount()).append("\t");
            builder.append(geneResult.getSupportingExonCounts().get("3DL3-exon5").getCount()).append("\t");
            builder.append(geneResult.getSupportingExonCounts().get("3DL3-exon9").getCount()).append("\t");
            return;
        }
        if (geneFactors.containsKey(gene) && geneFactors.get(gene).size() > 0) {
            for (String exon : geneFactors.get(gene).keySet()) {
                String key = String.valueOf(gene) + "-" + exon;
                if (!geneResult.getSupportingExonCounts().containsKey(key)) {
                    key = ValidateGeneCopyByRatio.findAlternativeSite(geneResult.getSupportingExonCounts(), gene, exon);
                }
                builder.append(geneResult.getSupportingExonCounts().get(key).getCount()).append("\t");
                if (copy == 0) {
                    builder.append("0").append("\t");
                    continue;
                }
                float correctedCopy = ValidateGeneCopyByRatio.correctRatio(geneResult.getSupportingExonCounts(), samples.get(sampleName).getGeneResult().get("3DL3"), exon, geneFactors.get(gene).get(exon), gene);
                DecimalFormat df = new DecimalFormat();
                if (correctedCopy > 1.0f) {
                    df.setMaximumFractionDigits(1);
                } else {
                    df.setMaximumFractionDigits(2);
                }
                builder.append(df.format(correctedCopy)).append("\t");
            }
        } else {
            builder.append("-").append("\t");
        }
    }

    private static int getGeneCopy(String gene, Map<String, KirGeneResult> geneResult) {
        int copy = 0;
        if (Arrays.asList(KirConstants.KIR_COMBINED_GENES).contains(gene)) {
            String gene1 = gene.split("\\+")[0];
            String gene2 = gene.split("\\+")[1];
            copy = geneResult.get(gene1).getCopy() + geneResult.get(gene2).getCopy();
        } else {
            copy = geneResult.get(gene).getCopy();
        }
        return copy;
    }

    private static float correctRatio(Map<String, KirGeneExonCountSummary> kirGeneExonCounts, KirGeneResult controlKirGeneResult, String exon, Float correctFactor, String gene) {
        String key = String.valueOf(gene) + "-" + exon;
        if (!kirGeneExonCounts.containsKey(key)) {
            key = ValidateGeneCopyByRatio.findAlternativeSite(kirGeneExonCounts, gene, exon);
        }
        int count = kirGeneExonCounts.get(key).getCount();
        int controlCount = controlKirGeneResult.getSupportingExonCounts().get("3DL3-" + exon).getCount();
        float correctedCopy = (float)count / (float)controlCount * correctFactor.floatValue() * 2.0f;
        return correctedCopy;
    }

    private static void generateHeader(Map<String, Map<String, Float>> geneFactors, StringBuilder builder) {
        String gene;
        builder.append("SamplenName").append("\t").append("MostCommon").append("\t");
        String[] stringArray = KirConstants.KIR_GENES;
        int n = KirConstants.KIR_GENES.length;
        int n2 = 0;
        while (n2 < n) {
            gene = stringArray[n2];
            builder.append(String.valueOf(gene) + COPY).append("\t");
            if (gene.equals("3DL3")) {
                builder.append(String.valueOf(gene) + "-exon3-count").append("\t");
                builder.append(String.valueOf(gene) + "-exon4-count").append("\t");
                builder.append(String.valueOf(gene) + "-exon5-count").append("\t");
                builder.append(String.valueOf(gene) + "-exon9-count").append("\t");
            } else if (geneFactors.containsKey(gene) && geneFactors.get(gene).size() > 0) {
                for (String exon : geneFactors.get(gene).keySet()) {
                    builder.append(String.valueOf(gene) + "-" + exon + "-" + COUNT).append("\t");
                    builder.append(String.valueOf(gene) + "-" + exon + "-" + COPY_BY_CORRECTED_RATIO + "(" + geneFactors.get(gene).get(exon) + ")").append("\t");
                }
            } else {
                builder.append("NO_RATIO").append("\t");
            }
            ++n2;
        }
        stringArray = KirConstants.KIR_COMBINED_GENES;
        n = KirConstants.KIR_COMBINED_GENES.length;
        n2 = 0;
        while (n2 < n) {
            gene = stringArray[n2];
            builder.append(String.valueOf(gene) + COPY).append("\t");
            if (geneFactors.containsKey(gene) && geneFactors.get(gene).size() > 0) {
                for (String exon : geneFactors.get(gene).keySet()) {
                    builder.append(String.valueOf(gene) + "-" + exon + "-" + COUNT).append("\t");
                    builder.append(String.valueOf(gene) + "-" + exon + "-" + COPY_BY_CORRECTED_RATIO + "(" + geneFactors.get(gene).get(exon) + ")").append("\t");
                }
            } else {
                builder.append("NO_RATIO").append("\t");
            }
            ++n2;
        }
        builder.append("\n");
    }

    private static Map<String, Map<String, Float>> calculateGeneFactor(Map<String, KirSample> samples) {
        String gene;
        LinkedHashMap<String, Map<String, Float>> geneFactor = new LinkedHashMap<String, Map<String, Float>>();
        String[] stringArray = KirConstants.KIR_GENES;
        int n = KirConstants.KIR_GENES.length;
        int n2 = 0;
        while (n2 < n) {
            gene = stringArray[n2];
            if (!gene.equals("3DL3")) {
                Map<String, Float> exonFactors = ValidateGeneCopyByRatio.getGeneControlRatio(samples, gene);
                geneFactor.put(gene, exonFactors);
            }
            ++n2;
        }
        stringArray = KirConstants.KIR_COMBINED_GENES;
        n = KirConstants.KIR_COMBINED_GENES.length;
        n2 = 0;
        while (n2 < n) {
            gene = stringArray[n2];
            Map<String, Float> combineGeneExonFactors = ValidateGeneCopyByRatio.getGeneControlRatio(samples, gene);
            geneFactor.put(gene, combineGeneExonFactors);
            ++n2;
        }
        return geneFactor;
    }

    private static Map<String, Float> getGeneControlRatio(Map<String, KirSample> samples, String gene) {
        LinkedHashMap<String, Float> exonFactors = new LinkedHashMap<String, Float>();
        String exon = "exon3";
        ValidateGeneCopyByRatio.getControlRatioForExon(samples, gene, exonFactors, exon);
        exon = "exon4";
        ValidateGeneCopyByRatio.getControlRatioForExon(samples, gene, exonFactors, exon);
        exon = "exon5";
        ValidateGeneCopyByRatio.getControlRatioForExon(samples, gene, exonFactors, exon);
        exon = "exon9";
        ValidateGeneCopyByRatio.getControlRatioForExon(samples, gene, exonFactors, exon);
        return exonFactors;
    }

    private static void getControlRatioForExon(Map<String, KirSample> samples, String gene, Map<String, Float> exonFactors, String exon) {
        if (gene.indexOf("+") > 0) {
            ValidateGeneCopyByRatio.getControlRatioForCombinedGeneExon(samples, gene, exonFactors, exon);
        } else {
            ValidateGeneCopyByRatio.getControlRatioForSingleGeneExon(samples, gene, exonFactors, exon);
        }
    }

    private static void getControlRatioForCombinedGeneExon(Map<String, KirSample> samples, String gene, Map<String, Float> exonFactors, String exon) {
        float total = 0.0f;
        int divider = 0;
        ArrayList<Float> values = new ArrayList<Float>();
        for (String sampleName : samples.keySet()) {
            KirGeneResult geneResult = samples.get(sampleName).getGeneResult().get(gene);
            KirGeneResult controlResult = samples.get(sampleName).getGeneResult().get("3DL3");
            String gene1 = gene.split("\\+")[0];
            String gene2 = gene.split("\\+")[1];
            int copy = samples.get(sampleName).getGeneResult().get(gene1).getCopy() + samples.get(sampleName).getGeneResult().get(gene2).getCopy();
            if (copy <= 0 || controlResult.getCopy() <= 0) continue;
            Map<String, KirGeneExonCountSummary> geneCounts = geneResult.getSupportingExonCounts();
            Map<String, KirGeneExonCountSummary> controlCounts = controlResult.getSupportingExonCounts();
            if (geneCounts.containsKey(String.valueOf(gene) + "-" + exon)) {
                int geneCount = geneCounts.get(String.valueOf(gene) + "-" + exon).getCount() / copy;
                int controlCount = controlCounts.get("3DL3-" + exon).getCount() / controlResult.getCopy();
                total += (float)controlCount / (float)geneCount;
                values.add(Float.valueOf((float)controlCount / (float)geneCount));
                ++divider;
                continue;
            }
            String alternativeName = ValidateGeneCopyByRatio.findAlternativeSite(geneCounts, gene, exon);
            if (alternativeName == null) continue;
            int geneCount = geneCounts.get(alternativeName).getCount() / copy;
            int controlCount = controlCounts.get("3DL3-" + exon).getCount() / controlResult.getCopy();
            total += (float)controlCount / (float)geneCount;
            values.add(Float.valueOf((float)controlCount / (float)geneCount));
            ++divider;
        }
        if (divider > 0) {
            Object[] num = values.toArray();
            Arrays.sort(num);
            float average = total / (float)divider;
            float median = values.size() % 2 == 0 ? (((Float)num[values.size() / 2]).floatValue() + ((Float)num[values.size() / 2 - 1]).floatValue()) / 2.0f : ((Float)num[values.size() / 2]).floatValue();
            exonFactors.put(exon, Float.valueOf(median));
        }
    }

    private static void getControlRatioForSingleGeneExon(Map<String, KirSample> samples, String gene, Map<String, Float> exonFactors, String exon) {
        float total = 0.0f;
        int divider = 0;
        ArrayList<Float> values = new ArrayList<Float>();
        for (String sampleName : samples.keySet()) {
            KirGeneResult geneResult = samples.get(sampleName).getGeneResult().get(gene);
            KirGeneResult controlResult = samples.get(sampleName).getGeneResult().get("3DL3");
            if (geneResult.getCopy() <= 0 || controlResult.getCopy() <= 0) continue;
            Map<String, KirGeneExonCountSummary> geneCounts = geneResult.getSupportingExonCounts();
            Map<String, KirGeneExonCountSummary> controlCounts = controlResult.getSupportingExonCounts();
            if (geneCounts.containsKey(String.valueOf(gene) + "-" + exon)) {
                int geneCount = geneCounts.get(String.valueOf(gene) + "-" + exon).getCount() / geneResult.getCopy();
                int controlCount = controlCounts.get("3DL3-" + exon).getCount() / controlResult.getCopy();
                total += (float)controlCount / (float)geneCount;
                values.add(Float.valueOf((float)controlCount / (float)geneCount));
                ++divider;
                continue;
            }
            String alternativeName = ValidateGeneCopyByRatio.findAlternativeSite(geneCounts, gene, exon);
            if (alternativeName == null) continue;
            int geneCount = geneCounts.get(alternativeName).getCount() / geneResult.getCopy();
            int controlCount = controlCounts.get("3DL3-" + exon).getCount() / controlResult.getCopy();
            total += (float)controlCount / (float)geneCount;
            values.add(Float.valueOf((float)controlCount / (float)geneCount));
            ++divider;
        }
        if (divider > 0) {
            Object[] num = values.toArray();
            Arrays.sort(num);
            float average = total / (float)divider;
            float median = values.size() % 2 == 0 ? (((Float)num[values.size() / 2]).floatValue() + ((Float)num[values.size() / 2 - 1]).floatValue()) / 2.0f : ((Float)num[values.size() / 2]).floatValue();
            exonFactors.put(exon, Float.valueOf(median));
        }
    }

    private static String findAlternativeSite(Map<String, KirGeneExonCountSummary> geneCounts, String gene, String exon) {
        for (String exonName : geneCounts.keySet()) {
            if (!exonName.startsWith(gene) || !exonName.endsWith(exon)) continue;
            return exonName;
        }
        return null;
    }

    private static void readInGeneCopies(Map<String, KirSample> samples, File kirReport) {
        String[] lines = FileManager.readTextFile(kirReport).split("\n");
        int i = 1;
        while (i < lines.length) {
            String sampleName = lines[i].trim().split("\t")[0].trim();
            KirSample sample = samples.get(sampleName);
            ValidateGeneCopyByRatio.loadData(sample, lines[i], lines[0]);
            ++i;
        }
    }

    private static void loadData(KirSample sample, String data, String header) {
        String[] items = data.trim().split("\t");
        String[] genes = header.trim().split("\t");
        if (items.length < 23) {
            return;
        }
        List<KirDiploidType> mostCommonType = ValidateGeneCopyByRatio.parseDiploidType(items[4].trim());
        sample.setMostCommonType(mostCommonType);
        int i = 6;
        while (i < genes.length) {
            if (items[i].trim().length() != 0 && !genes[i].equals("2DS3/5")) {
                sample.getGeneResult().get(genes[i]).setCopy(Integer.valueOf(items[i]));
            }
            ++i;
        }
    }

    private static List<KirDiploidType> parseDiploidType(String entry) {
        String[] items = entry.split("/");
        ArrayList<KirDiploidType> dTypes = new ArrayList<KirDiploidType>();
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            KirDiploidType dType = new KirDiploidType();
            dType.setLocalName(item);
            dTypes.add(dType);
            ++n2;
        }
        return dTypes;
    }

    public static KirSample readInGeneExonCounts(GeneContentRulesetTyper geneContentRulesetTyper, File kirRulesetFile, String[] lines, int i) {
        List<KirCount> kirCounts = NmerRulesetParser.readInNmerRulesetFile(kirRulesetFile);
        List<KirGeneExonCountPoint> kirCountsPoints = NmerRulesetParser.correlateCountPositions(kirCounts);
        String sampleName = lines[i].trim().split("\t")[0].trim();
        KirUtils.readInCount(lines[0].trim(), lines[i].trim(), kirCounts);
        KirUtils.calculateCountPoint(kirCountsPoints);
        List<KirGeneExonCountSummary> geneExonSummaries = KirUtils.summarizeCountPoints(kirCountsPoints);
        Map<String, KirGeneResult> KirGeneResults = ValidateGeneCopyByRatio.collectCounts(geneExonSummaries);
        KirSample sample = new KirSample();
        sample.setName(sampleName);
        sample.setGeneResult(KirGeneResults);
        System.out.println("--------------" + sampleName);
        return sample;
    }

    public static Map<String, KirGeneResult> collectCounts(List<KirGeneExonCountSummary> geneExonSummaries) {
        Map<String, KirGeneExonCountSummary> supportingsExons;
        KirGeneResult result;
        String gene;
        LinkedHashMap<String, KirGeneResult> results = new LinkedHashMap<String, KirGeneResult>();
        String[] stringArray = KirConstants.KIR_GENES;
        int n = KirConstants.KIR_GENES.length;
        int n2 = 0;
        while (n2 < n) {
            gene = stringArray[n2];
            result = new KirGeneResult();
            result.setGeneName(gene);
            supportingsExons = KirUtils.collectSupportingSites(geneExonSummaries, gene, false);
            result.setSupportingExonCounts(supportingsExons);
            results.put(gene, result);
            ++n2;
        }
        stringArray = KirConstants.KIR_COMBINED_GENES;
        n = KirConstants.KIR_COMBINED_GENES.length;
        n2 = 0;
        while (n2 < n) {
            gene = stringArray[n2];
            result = new KirGeneResult();
            result.setGeneName(gene);
            supportingsExons = KirUtils.collectSupportingSites(geneExonSummaries, gene, true);
            result.setSupportingExonCounts(supportingsExons);
            results.put(gene, result);
            ++n2;
        }
        stringArray = KirConstants.KIR_GENES;
        n = KirConstants.KIR_GENES.length;
        n2 = 0;
        while (n2 < n) {
            gene = stringArray[n2];
            result = (KirGeneResult)results.get(gene);
            System.out.println(String.valueOf(gene) + " count: ");
            for (String name : result.getSupportingExonCounts().keySet()) {
                System.out.println("\t" + name + " " + result.getSupportingExonCounts().get(name).getCount());
            }
            ++n2;
        }
        stringArray = KirConstants.KIR_COMBINED_GENES;
        n = KirConstants.KIR_COMBINED_GENES.length;
        n2 = 0;
        while (n2 < n) {
            gene = stringArray[n2];
            result = (KirGeneResult)results.get(gene);
            System.out.println(String.valueOf(gene) + " count: ");
            for (String name : result.getSupportingExonCounts().keySet()) {
                System.out.println("\t" + name + " " + result.getSupportingExonCounts().get(name).getCount());
            }
            ++n2;
        }
        return results;
    }
}

