/*
 * Decompiled with CFR 0.152.
 */
package kirCountTyping;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kirCountTyping.KirCount;
import kirCountTyping.KirCountMode;
import kirCountTyping.KirGeneExonCountPoint;
import misc.FileManager;

public class NmerRulesetParser {
    public static List<KirCount> readInNmerRulesetFile(File rulesetFile) {
        String[] lines;
        ArrayList<KirCount> counts = new ArrayList<KirCount>();
        String[] stringArray = lines = FileManager.readTextFile(rulesetFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] items = line.trim().split("\t");
            if (items.length >= 6 && !items[0].startsWith("CountN")) {
                KirCount count = new KirCount();
                String countName = items[0].trim();
                String contentName = items[1].trim();
                KirCountMode mode = KirCountMode.GENE;
                if (contentName.indexOf("*") > 0) {
                    mode = KirCountMode.ALLELE;
                }
                count.setName(countName);
                count.setCountMode(mode);
                count.setExon(items[5].trim());
                count.setGenes(items[1].trim());
                if (items.length >= 7 && items[6].trim().length() > 0) {
                    List<String> negs = NmerRulesetParser.parserField(items[6]);
                    count.setNegativeAlleles(negs);
                }
                if (items.length >= 8 && items[7].trim().length() > 0) {
                    List<String> pos = NmerRulesetParser.parserField(items[7]);
                    count.setPositiveAlleles(pos);
                }
                counts.add(count);
            }
            ++n2;
        }
        return counts;
    }

    public static List<KirGeneExonCountPoint> correlateCountPositions(List<KirCount> counts) {
        ArrayList<KirGeneExonCountPoint> countPoints = new ArrayList<KirGeneExonCountPoint>();
        for (KirCount count : counts) {
            if (!count.getCountMode().equals((Object)KirCountMode.GENE)) continue;
            KirGeneExonCountPoint dataPoint = new KirGeneExonCountPoint();
            dataPoint.setGenes(count.getGenes());
            dataPoint.setExon(count.getExon());
            dataPoint.setGeneCount(count);
            if (count.getNegativeAlleles() != null) {
                NmerRulesetParser.setNegativeAlleleCounts(counts, count, dataPoint);
            }
            if (count.getPositiveAlleles() != null) {
                NmerRulesetParser.setPositiveAlleleCounts(counts, count, dataPoint);
            }
            countPoints.add(dataPoint);
        }
        return countPoints;
    }

    private static void setPositiveAlleleCounts(List<KirCount> counts, KirCount count, KirGeneExonCountPoint dataPoint) {
        ArrayList<KirCount> positiveAllelesCount = new ArrayList<KirCount>();
        ArrayList<String> remainingPos = new ArrayList<String>();
        for (String name : count.getPositiveAlleles()) {
            List<KirCount> kirAlleleCounts = NmerRulesetParser.findAlleleCount(counts, name, count.getExon());
            if (kirAlleleCounts.size() == 0) {
                remainingPos.add(name);
            }
            for (KirCount c : kirAlleleCounts) {
                if (positiveAllelesCount.contains(c)) continue;
                positiveAllelesCount.add(c);
            }
        }
        HashMap<String, List<KirCount>> posCountMap = new HashMap<String, List<KirCount>>();
        for (KirCount c : positiveAllelesCount) {
            if (!posCountMap.containsKey(c.getGenes())) {
                posCountMap.put(c.getGenes(), new ArrayList());
            }
            ((List)posCountMap.get(c.getGenes())).add(c);
        }
        dataPoint.setPositiveAllelesCount(posCountMap);
        dataPoint.setUnknownPositiveAlleles(remainingPos);
    }

    private static void setNegativeAlleleCounts(List<KirCount> counts, KirCount count, KirGeneExonCountPoint dataPoint) {
        ArrayList<KirCount> negativeAllelesCount = new ArrayList<KirCount>();
        ArrayList<String> remainingNeg = new ArrayList<String>();
        for (String name : count.getNegativeAlleles()) {
            List<KirCount> kirAlleleCounts = NmerRulesetParser.findAlleleCount(counts, name, count.getExon());
            if (kirAlleleCounts.size() == 0) {
                remainingNeg.add(name);
            }
            for (KirCount c : kirAlleleCounts) {
                if (negativeAllelesCount.contains(c)) continue;
                negativeAllelesCount.add(c);
            }
        }
        HashMap<String, List<KirCount>> negCountMap = new HashMap<String, List<KirCount>>();
        for (KirCount c : negativeAllelesCount) {
            if (!negCountMap.containsKey(c.getGenes())) {
                negCountMap.put(c.getGenes(), new ArrayList());
            }
            ((List)negCountMap.get(c.getGenes())).add(c);
        }
        dataPoint.setNegativeAllelesCount(negCountMap);
        dataPoint.setUnknownNegativeAlleles(remainingNeg);
    }

    private static List<KirCount> findAlleleCount(List<KirCount> counts, String name, String exon) {
        ArrayList<KirCount> kirAlleleCounts = new ArrayList<KirCount>();
        for (KirCount count : counts) {
            if (count.getCountMode().equals((Object)KirCountMode.GENE) || !count.getGenes().contains(name) || !count.getExon().equals(exon)) continue;
            kirAlleleCounts.add(count);
        }
        return kirAlleleCounts;
    }

    private static List<String> parserField(String entry) {
        String[] names;
        ArrayList<String> ret = new ArrayList<String>();
        String[] stringArray = names = entry.split(",");
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.trim().length() > 0) {
                ret.add(name);
            }
            ++n2;
        }
        return ret;
    }
}

