/*
 * Decompiled with CFR 0.152.
 */
package kirCountTyping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kirCountTyping.KirConstants;
import kirCountTyping.KirCount;
import kirCountTyping.KirDiploidType;
import kirCountTyping.KirGeneExonCountPoint;
import kirCountTyping.KirGeneExonCountSummary;
import kirCountTyping.KirGeneResult;
import kirCountTyping.KirSample;

public class KirUtils {
    public static final String COUNT = "Count";

    public static void readInCount(String header, String input, List<KirCount> kirCounts) {
        String[] counts = input.split("\t");
        String[] names = header.split("\t");
        int i = 1;
        while (i < names.length) {
            String name = names[i].trim();
            int count = KirUtils.formatCount(counts[i].trim());
            KirUtils.loadKirCount(name, count, kirCounts);
            ++i;
        }
    }

    private static void loadKirCount(String name, int count, List<KirCount> kirCounts) {
        for (KirCount kirCount : kirCounts) {
            if (!kirCount.getName().equalsIgnoreCase(name.split("-exon")[0])) continue;
            kirCount.setCount(count);
            break;
        }
    }

    private static int formatCount(String entry) {
        String[] num = entry.split("\\(");
        return Integer.valueOf(num[0]);
    }

    public static List<KirGeneExonCountSummary> summarizeCountPoints(List<KirGeneExonCountPoint> kirCountsPoints) {
        ArrayList<KirGeneExonCountSummary> geneExonSummaries = new ArrayList<KirGeneExonCountSummary>();
        LinkedHashMap orderedCountPoints = new LinkedHashMap();
        for (KirGeneExonCountPoint point : kirCountsPoints) {
            String keyName = KirUtils.generateKeyName(point);
            if (!orderedCountPoints.containsKey(keyName)) {
                orderedCountPoints.put(keyName, new ArrayList());
            }
            ((List)orderedCountPoints.get(keyName)).add(point);
        }
        for (String name : orderedCountPoints.keySet()) {
            KirGeneExonCountSummary summary = new KirGeneExonCountSummary();
            summary.setGeneNames(name.split("-exon")[0]);
            summary.setSingleGene(KirUtils.testSingleGene((List)orderedCountPoints.get(name)));
            summary.setExon(name.split("-exon")[1]);
            summary.setCount(KirUtils.averageCount((List)orderedCountPoints.get(name)));
            summary.setSupportingKirCountPoint((List)orderedCountPoints.get(name));
            geneExonSummaries.add(summary);
        }
        return geneExonSummaries;
    }

    private static boolean testSingleGene(List<KirGeneExonCountPoint> points) {
        Iterator<KirGeneExonCountPoint> iterator = points.iterator();
        if (iterator.hasNext()) {
            KirGeneExonCountPoint point = iterator.next();
            return point.getGenes().indexOf("+") <= 0;
        }
        return true;
    }

    private static int averageCount(List<KirGeneExonCountPoint> points) {
        int total = 0;
        for (KirGeneExonCountPoint point : points) {
            total += point.getCount();
        }
        return total / points.size();
    }

    private static String generateKeyName(KirGeneExonCountPoint point) {
        StringBuilder keyName = new StringBuilder();
        keyName.append(point.getGenes());
        if (point.getUnknownNegativeAlleles() != null && point.getUnknownNegativeAlleles().size() > 0) {
            String negNames = KirUtils.listToString(point.getUnknownNegativeAlleles());
            keyName.append("-").append(negNames);
        }
        if (point.getUnknownPositiveAlleles() != null && point.getUnknownPositiveAlleles().size() > 0) {
            String posNames = KirUtils.listToString(point.getUnknownPositiveAlleles());
            keyName.append("+").append(posNames);
        }
        keyName.append("-exon").append(point.getExon());
        return keyName.toString();
    }

    private static String listToString(List<String> alleles) {
        StringBuilder builder = new StringBuilder();
        for (String allele : alleles) {
            builder.append(allele).append("&");
        }
        return builder.toString().substring(0, builder.toString().length() - 1);
    }

    public static void calculateCountPoint(List<KirGeneExonCountPoint> kirCountsPoints) {
        for (KirGeneExonCountPoint point : kirCountsPoints) {
            int initialCount = point.getGeneCount().getCount();
            int negCount = 0;
            int posCount = 0;
            if (point.getNegativeAllelesCount() != null && point.getNegativeAllelesCount().size() > 0) {
                negCount = KirUtils.getAlleleAverageCount(point.getNegativeAllelesCount());
            }
            if (point.getPositiveAllelesCount() != null && point.getPositiveAllelesCount().size() > 0) {
                posCount = KirUtils.getAlleleAverageCount(point.getPositiveAllelesCount());
            }
            int correctedCount = initialCount + negCount - posCount;
            point.setCount(correctedCount);
        }
    }

    private static int getAlleleAverageCount(Map<String, List<KirCount>> countMap) {
        int negCount = 0;
        for (String allele : countMap.keySet()) {
            List<KirCount> alleleCounts = countMap.get(allele);
            int total = 0;
            for (KirCount kc : alleleCounts) {
                total += kc.getCount();
            }
            int average = total / alleleCounts.size();
            negCount += average;
        }
        return negCount;
    }

    public static Map<String, KirGeneResult> analyzeGenePresence(List<KirGeneExonCountSummary> geneExonSummaries) {
        LinkedHashMap<String, KirGeneResult> results = new LinkedHashMap<String, KirGeneResult>();
        String[] stringArray = KirConstants.KIR_GENES;
        int n = KirConstants.KIR_GENES.length;
        int n2 = 0;
        while (n2 < n) {
            String gene = stringArray[n2];
            KirGeneResult result = new KirGeneResult();
            result.setGeneName(gene);
            Map<String, KirGeneExonCountSummary> supportingsExons = KirUtils.collectSupportingSites(geneExonSummaries, gene, false);
            result.setSupportingExonCounts(supportingsExons);
            results.put(gene, result);
            ++n2;
        }
        HashMap<String, Integer> controlCounts = new HashMap<String, Integer>();
        boolean typable = KirUtils.qcFrameGenes(results, controlCounts);
        if (!typable) {
            System.out.println("QC failed, can't analyze this sample");
            return results;
        }
        String[] stringArray2 = KirConstants.KIR_GENES;
        int n3 = KirConstants.KIR_GENES.length;
        int n4 = 0;
        while (n4 < n3) {
            String gene = stringArray2[n4];
            KirGeneResult result = (KirGeneResult)results.get(gene);
            KirUtils.testPN(result.getSupportingExonCounts(), controlCounts, result);
            System.out.println(String.valueOf(gene) + " " + result.isPresent());
            for (String name : result.getSupportingExonCounts().keySet()) {
                System.out.println("\t" + name + " " + result.getSupportingExonCounts().get(name).getCount());
            }
            ++n4;
        }
        return results;
    }

    private static boolean qcFrameGenes(Map<String, KirGeneResult> results, Map<String, Integer> controlCounts) {
        Map<String, String> controls = KirConstants.generateRefCountmap();
        for (String exon : controls.keySet()) {
            String controlGene = controls.get(exon);
            Map<String, KirGeneExonCountSummary> geneExons = results.get(controlGene).getSupportingExonCounts();
            KirGeneExonCountSummary geneExon = geneExons.get(String.valueOf(controlGene) + "-" + KirConstants.EXON + exon);
            if (exon.equals("9") && geneExon.getCount() < KirConstants.COUNT_QC_MIN_EXON9) {
                System.out.println("exon" + exon + " controlGene " + controlGene + " count=" + geneExon.getCount());
                controlCounts.put(exon, -1);
                continue;
            }
            if (!exon.equals("9") && geneExon.getCount() < KirConstants.COUNT_QC_MIN) {
                System.out.println("exon" + exon + " controlGene " + controlGene + " count=" + geneExon.getCount());
                controlCounts.put(exon, -1);
                continue;
            }
            controlCounts.put(exon, geneExon.getCount());
        }
        Iterator<Object> iterator = controlCounts.values().iterator();
        while (iterator.hasNext()) {
            int count = (Integer)iterator.next();
            if (count <= 0) continue;
            return true;
        }
        return false;
    }

    public static Map<String, KirGeneExonCountSummary> collectSupportingSites(List<KirGeneExonCountSummary> geneExonSummaries, String gene, boolean forCombinedGenes) {
        HashMap<String, KirGeneExonCountSummary> supportingsExons = new HashMap<String, KirGeneExonCountSummary>();
        for (KirGeneExonCountSummary summary : geneExonSummaries) {
            if (forCombinedGenes && summary.getGeneNames().equals(gene)) {
                supportingsExons.put(String.valueOf(summary.getGeneNames()) + "-exon" + summary.getExon(), summary);
                continue;
            }
            if (forCombinedGenes || !summary.getGeneNames().startsWith(gene) || !summary.isSingleGene()) continue;
            supportingsExons.put(String.valueOf(summary.getGeneNames()) + "-exon" + summary.getExon(), summary);
        }
        return supportingsExons;
    }

    private static void testPN(Map<String, KirGeneExonCountSummary> supportingsExons, Map<String, Integer> controlCounts, KirGeneResult result) {
        KirConstants.generateRefCountmap();
        HashMap<String, Boolean> exonPNs = new HashMap<String, Boolean>();
        for (String geneExon : supportingsExons.keySet()) {
            String exonNum = geneExon.substring(geneExon.length() - 1);
            int controlCount = controlCounts.get(exonNum);
            if (controlCount < 0) {
                if (supportingsExons.get(geneExon).getCount() > 50) {
                    exonPNs.put(geneExon, true);
                    continue;
                }
                exonPNs.put(geneExon, false);
                continue;
            }
            if (supportingsExons.get(geneExon).getCount() > controlCount / 4) {
                exonPNs.put(geneExon, true);
                continue;
            }
            if (supportingsExons.get(geneExon).getCount() > controlCount / 8 && supportingsExons.get(geneExon).getCount() > KirConstants.COUNT_QC_MIN / 2) {
                exonPNs.put(geneExon, true);
                continue;
            }
            if (supportingsExons.size() == 1 && supportingsExons.get(geneExon).getCount() > controlCount / 10 && supportingsExons.get(geneExon).getCount() > 50) {
                exonPNs.put(geneExon, true);
                continue;
            }
            exonPNs.put(geneExon, false);
        }
        KirUtils.setPN(exonPNs, result);
    }

    private static void setPN(Map<String, Boolean> exonPNs, KirGeneResult result) {
        ArrayList<Boolean> p = new ArrayList<Boolean>();
        for (String geneExon : exonPNs.keySet()) {
            if (p.contains(exonPNs.get(geneExon))) continue;
            p.add(exonPNs.get(geneExon));
        }
        if (p.size() == 0) {
            result.setPresent(false);
            result.addCopyWarnings("can't decide PN for " + result.getGeneName());
        } else if (p.size() == 1) {
            result.setPresent((Boolean)p.get(0));
        } else {
            System.out.println("********** " + KirConstants.INCONSISTANT_EXON_PN);
            result.setPresent(true);
            result.addPnWarnings(KirConstants.INCONSISTANT_EXON_PN);
        }
    }

    public static void determint3DL13DS13DL2Copy(KirSample sample) {
        Map<String, KirGeneResult> results = sample.getGeneResult();
        if (KirUtils.noRatioPattern(results.get("3DL1").isPresent(), results.get("3DS1").isPresent(), results.get("3DL2").isPresent())) {
            return;
        }
        if (results.get("3DL1").isPresent() && results.get("3DS1").isPresent() && results.get("3DL2").isPresent()) {
            KirUtils.ratioThree3DLgenes(results);
        } else {
            KirUtils.ratioTwo3DL3DSgenes(results);
        }
    }

    private static void ratioTwo3DL3DSgenes(Map<String, KirGeneResult> results) {
        List<Integer> copies3DL1 = results.get("3DL1").getPossibleCopies();
        List<Integer> copies3DS1 = results.get("3DS1").getPossibleCopies();
        List<Integer> copies3DL2 = results.get("3DL2").getPossibleCopies();
        int count3DL1 = results.get("3DL1").getSupportingExonCounts().get("3DL1-3DL1*054-exon4").getCount();
        int count3DS1 = results.get("3DS1").getSupportingExonCounts().get("3DS1+3DL1*054-exon4").getCount();
        int count3DL2 = results.get("3DL2").getSupportingExonCounts().get("3DL2-exon4").getCount();
        int count3DL3 = results.get("3DL3").getSupportingExonCounts().get("3DL3-exon4").getCount();
        System.out.println("*******" + copies3DL1.toString() + ":" + copies3DS1.toString() + ":" + copies3DL2.toString());
        System.out.println("......." + count3DL1 + ":" + count3DS1 + ":" + count3DL2);
        System.out.println(".......count3DL3=" + count3DL3);
        if (copies3DL1.size() == 1 && copies3DS1.size() == 1 && copies3DL2.size() == 1) {
            return;
        }
        int controlOneCopyCount = count3DL3 / 2;
        float num3DL1 = (float)count3DL1 / (float)controlOneCopyCount;
        float num3DS1 = (float)count3DS1 / (float)controlOneCopyCount;
        float num3DL2 = (float)count3DL2 / (float)controlOneCopyCount;
        ArrayList<Integer> copies = new ArrayList<Integer>();
        if (!results.get("3DL1").isPresent()) {
            KirUtils.getTwoGeneCopy(count3DS1, count3DL2, num3DS1, num3DL2, copies, copies3DS1, copies3DL2, true);
            if (copies.size() > 0) {
                results.get("3DS1").setCopy((Integer)copies.get(0));
                results.get("3DL2").setCopy((Integer)copies.get(1));
            }
        } else if (!results.get("3DS1").isPresent()) {
            KirUtils.getTwoGeneCopy(count3DL1, count3DL2, num3DL1, num3DL2, copies, copies3DL1, copies3DL2, true);
            if (copies.size() > 0) {
                results.get("3DL1").setCopy((Integer)copies.get(0));
                results.get("3DL2").setCopy((Integer)copies.get(1));
            }
        } else if (!results.get("3DL2").isPresent()) {
            KirUtils.getTwoGeneCopy(count3DL1, count3DS1, num3DL1, num3DS1, copies, copies3DL1, copies3DS1, true);
            if (copies.size() > 0) {
                results.get("3DL1").setCopy((Integer)copies.get(0));
                results.get("3DS1").setCopy((Integer)copies.get(1));
            }
        }
        if (copies.size() == 0) {
            System.out.println(String.valueOf(KirConstants.RATIO_CAN_NOT_DETERMIN) + " on 3DL1:3DS1:3DL2 ");
        } else {
            System.out.println("copy based on 3DL1:3DS1:3DL2 " + results.get("3DL1").getCopy() + " " + results.get("3DS1").getCopy() + " " + results.get("3DL2").getCopy());
        }
    }

    private static void ratioThree3DLgenes(Map<String, KirGeneResult> results) {
        List<Integer> copies3DL1 = results.get("3DL1").getPossibleCopies();
        List<Integer> copies3DS1 = results.get("3DS1").getPossibleCopies();
        List<Integer> copies3DL2 = results.get("3DL2").getPossibleCopies();
        int count3DL1 = results.get("3DL1").getSupportingExonCounts().get("3DL1-3DL1*054-exon4").getCount();
        int count3DS1 = results.get("3DS1").getSupportingExonCounts().get("3DS1+3DL1*054-exon4").getCount();
        int count3DL2 = results.get("3DL2").getSupportingExonCounts().get("3DL2-exon4").getCount();
        System.out.println("*******" + copies3DL1.toString() + ":" + copies3DS1.toString() + ":" + copies3DL2.toString());
        System.out.println("......." + count3DL1 + ":" + count3DS1 + ":" + count3DL2);
        if (copies3DL1.size() == 1 && copies3DS1.size() == 1 && copies3DL2.size() == 1) {
            return;
        }
        int standartOneCopyCount = KirUtils.get3DL3DSOneCopyCount(copies3DL1, copies3DS1, copies3DL2, count3DL1, count3DS1, count3DL2);
        int copy3DL1 = KirUtils.determineCopy(standartOneCopyCount, count3DL1, copies3DL1);
        int copy3DS1 = KirUtils.determineCopy(standartOneCopyCount, count3DS1, copies3DS1);
        int copy3DL2 = KirUtils.determineCopy(standartOneCopyCount, count3DL2, copies3DL2);
        if (copy3DL1 > 0 && copy3DS1 > 0 && copy3DL2 > 0) {
            results.get("3DL1").setCopy(copy3DL1);
            results.get("3DS1").setCopy(copy3DS1);
            results.get("3DL2").setCopy(copy3DL2);
            System.out.println("copy based on 3DL1:3DS1:3DL2 " + copy3DL1 + " " + copy3DS1 + " " + copy3DL2);
        } else if (copy3DL1 == 0) {
            results.get("3DL1").addCopyWarnings(String.valueOf(KirConstants.RATIO_CAN_NOT_DETERMIN) + " on 3DL1:3DS1:3DL2");
        } else if (copy3DS1 == 0) {
            results.get("3DS1").addCopyWarnings(String.valueOf(KirConstants.RATIO_CAN_NOT_DETERMIN) + " on 3DL1:3DS1:3DL2");
        } else if (copy3DL2 == 0) {
            results.get("3DL2").addCopyWarnings(String.valueOf(KirConstants.RATIO_CAN_NOT_DETERMIN) + " on 3DL1:3DS1:3DL2");
        }
    }

    private static int get3DL3DSOneCopyCount(List<Integer> copies3DL1, List<Integer> copies3DS1, List<Integer> copies3DL2, int count3DL1, int count3DS1, int count3DL2) {
        int standartOneCopyCount = 0;
        int total = 0;
        int count = 0;
        if (copies3DL1.size() == 1) {
            total += count3DL1 / copies3DL1.get(0);
            ++count;
        }
        if (copies3DS1.size() == 1) {
            total += count3DS1 / copies3DS1.get(0);
            ++count;
        }
        if (copies3DL2.size() == 1) {
            total += count3DL2 / copies3DL2.get(0);
            ++count;
        }
        if ((standartOneCopyCount = count == 0 ? 0 : total / count) == 0) {
            standartOneCopyCount = Math.min(Math.min(count3DL1, count3DS1), count3DL2);
        }
        return standartOneCopyCount;
    }

    public static void determint2DL12DS12DS4Copy(KirSample sample) {
        Map<String, KirGeneResult> results = sample.getGeneResult();
        if (KirUtils.noRatioPattern(results.get("2DL1").isPresent(), results.get("2DS1").isPresent(), results.get("2DS4").isPresent())) {
            return;
        }
        if (results.get("2DL1").isPresent() && results.get("2DS1").isPresent() && results.get("2DS4").isPresent()) {
            KirUtils.ratioThree2DL2DSgenes(results);
        } else {
            KirUtils.ratioTwo2DL2DSgenes(results);
        }
    }

    private static void ratioTwo2DL2DSgenes(Map<String, KirGeneResult> results) {
        List<Integer> copies2DL1 = results.get("2DL1").getPossibleCopies();
        List<Integer> copies2DS1 = results.get("2DS1").getPossibleCopies();
        List<Integer> copies2DS4 = results.get("2DS4").getPossibleCopies();
        int count2DL1 = results.get("2DL1").getSupportingExonCounts().get("2DL1-exon4").getCount();
        int count2DS1 = results.get("2DS1").getSupportingExonCounts().get("2DS1-exon4").getCount();
        int count2DS4 = results.get("2DS4").getSupportingExonCounts().get("2DS4-exon4").getCount();
        int count3DL3 = results.get("3DL3").getSupportingExonCounts().get("3DL3-exon4").getCount();
        System.out.println("*******" + copies2DL1.toString() + ":" + copies2DS1.toString() + ":" + copies2DS4.toString());
        System.out.println("......." + count2DL1 + ":" + count2DS1 + ":" + count2DS4);
        System.out.println(".......count3DL3=" + count3DL3);
        if (copies2DL1.size() == 1 && copies2DS1.size() == 1 && copies2DS4.size() == 1) {
            return;
        }
        int controlOneCopyCount = count3DL3 / 2;
        float num2DL1 = (float)count2DL1 / (float)controlOneCopyCount;
        float num2DS1 = (float)count2DS1 / (float)controlOneCopyCount;
        float num2DS4 = (float)count2DS4 / (float)controlOneCopyCount;
        ArrayList<Integer> copies = new ArrayList<Integer>();
        if (!results.get("2DL1").isPresent()) {
            KirUtils.getTwoGeneCopy(count2DS1, count2DS4, num2DS1, num2DS4, copies, copies2DS1, copies2DS4, true);
            if (copies.size() > 0) {
                results.get("2DS1").setCopy((Integer)copies.get(0));
                results.get("2DS4").setCopy((Integer)copies.get(1));
            }
        } else if (!results.get("2DS1").isPresent()) {
            KirUtils.getTwoGeneCopy(count2DL1, count2DS4, num2DL1, num2DS4, copies, copies2DL1, copies2DS4, true);
            if (copies.size() > 0) {
                results.get("2DL1").setCopy((Integer)copies.get(0));
                results.get("2DS4").setCopy((Integer)copies.get(1));
            }
        } else if (!results.get("2DS4").isPresent()) {
            KirUtils.getTwoGeneCopy(count2DL1, count2DS1, num2DL1, num2DS1, copies, copies2DL1, copies2DS1, true);
            if (copies.size() > 0) {
                results.get("2DL1").setCopy((Integer)copies.get(0));
                results.get("2DS1").setCopy((Integer)copies.get(1));
            }
        }
        if (copies.size() == 0) {
            System.out.println(String.valueOf(KirConstants.RATIO_CAN_NOT_DETERMIN) + " on 2DL1:2DS1:2DS4 ");
        } else {
            System.out.println("copy based on 2DL1:2DS1:2DS4 " + results.get("2DL1").getCopy() + " " + results.get("2DS1").getCopy() + " " + results.get("2DS4").getCopy());
        }
    }

    private static void getTwoGeneCopy(int count1, int count2, float num1, float num2, List<Integer> copies, List<Integer> copies1, List<Integer> copies2, boolean favorTwoCopy) {
        float ratio = num1 / num2;
        if ((double)ratio > 0.7 && (double)ratio < 1.3) {
            if (copies1.size() == 1 || copies2.size() == 1) {
                int copy = copies1.size() == 1 ? copies1.get(0) : copies2.get(0);
                copies.add(copy);
                copies.add(copy);
            } else if (favorTwoCopy && ((double)num1 > 1.3 || (double)num2 > 1.3)) {
                copies.add(2);
                copies.add(2);
            } else if (!favorTwoCopy && ((double)num1 > 1.5 || (double)num2 > 1.5)) {
                copies.add(2);
                copies.add(2);
            } else if (favorTwoCopy && ((double)num1 > 0.7 && (double)num1 < 1.2 || (double)num2 > 0.7 && (double)num2 < 1.2)) {
                copies.add(1);
                copies.add(1);
            } else if (!favorTwoCopy && ((double)num1 > 0.7 && (double)num1 < 1.3 || (double)num2 > 0.7 && (double)num2 < 1.3)) {
                copies.add(1);
                copies.add(1);
            } else {
                System.out.println("ratio 1:1 or 2:2 " + KirConstants.RATIO_CAN_NOT_DETERMIN + count1 + " " + count2);
            }
        } else if ((double)ratio > 0.3 && (double)ratio < 0.6) {
            copies.add(1);
            copies.add(2);
        } else if ((double)ratio > 1.6) {
            copies.add(2);
            copies.add(1);
        } else {
            System.out.println(String.valueOf(KirConstants.RATIO_CAN_NOT_DETERMIN) + count1 + " " + count2);
        }
        if (!(copies.size() <= 0 || copies1.contains(copies.get(0)) && copies2.contains(copies.get(1)))) {
            System.out.println(String.valueOf(KirConstants.RATIO_CAN_NOT_DETERMIN) + " out of ruleset scoop " + count1 + " " + count2);
            copies.clear();
        }
    }

    private static void ratioThree2DL2DSgenes(Map<String, KirGeneResult> results) {
        List<Integer> copies2DL1 = results.get("2DL1").getPossibleCopies();
        List<Integer> copies2DS1 = results.get("2DS1").getPossibleCopies();
        List<Integer> copies2DS4 = results.get("2DS4").getPossibleCopies();
        int count2DL1 = results.get("2DL1").getSupportingExonCounts().get("2DL1-exon4").getCount();
        int count2DS1 = results.get("2DS1").getSupportingExonCounts().get("2DS1-exon4").getCount();
        int count2DS4 = results.get("2DS4").getSupportingExonCounts().get("2DS4-exon4").getCount();
        int count3DL3 = results.get("3DL3").getSupportingExonCounts().get("3DL3-exon4").getCount();
        System.out.println("*******" + copies2DL1.toString() + ":" + copies2DS1.toString() + ":" + copies2DS4.toString());
        System.out.println("......." + count2DL1 + ":" + count2DS1 + ":" + count2DS4);
        System.out.println(".......count3DL3=" + count3DL3);
        if (copies2DL1.size() == 1 && copies2DS1.size() == 1 && copies2DS4.size() == 1) {
            return;
        }
        int standartOneCopyCount = KirUtils.get2DL2DSOneCopyCount(copies2DL1, copies2DS1, copies2DS4, count2DL1, count2DS1, count2DS4, count3DL3);
        int copy2DL1 = KirUtils.determineCopy(standartOneCopyCount, count2DL1, copies2DL1);
        int copy2DS1 = KirUtils.determineCopy(standartOneCopyCount, count2DS1, copies2DS1);
        int copy2DS4 = KirUtils.determineCopy(standartOneCopyCount, count2DS4, copies2DS4);
        if (copy2DL1 > 0 && copy2DS1 > 0 && copy2DS4 > 0) {
            results.get("2DL1").setCopy(copy2DL1);
            results.get("2DS1").setCopy(copy2DS1);
            results.get("2DS4").setCopy(copy2DS4);
            System.out.println("copy based on 2DL1:2DS1:2DS4 " + copy2DL1 + " " + copy2DS1 + " " + copy2DS4);
        } else if (copy2DL1 == 0) {
            results.get("2DL1").addCopyWarnings(String.valueOf(KirConstants.RATIO_CAN_NOT_DETERMIN) + " on 2DL1:2DS1:2DS4");
        } else if (copy2DS1 == 0) {
            results.get("2DS1").addCopyWarnings(String.valueOf(KirConstants.RATIO_CAN_NOT_DETERMIN) + " on 2DL1:2DS1:2DS4");
        } else if (copy2DS4 == 0) {
            results.get("2DS4").addCopyWarnings(String.valueOf(KirConstants.RATIO_CAN_NOT_DETERMIN) + " on 2DL1:2DS1:2DS4");
        }
    }

    private static int determineCopy(int standartOneCopyCount, int count, List<Integer> copies2dl1) {
        float num = (float)count / (float)standartOneCopyCount;
        if (copies2dl1.size() == 1) {
            return copies2dl1.get(0);
        }
        if ((double)num > 0.6 && (double)num < 1.3 && copies2dl1.contains(1)) {
            return 1;
        }
        if ((double)num > 1.6 && (double)num < 2.6 && copies2dl1.contains(2)) {
            return 2;
        }
        if ((double)num > 2.9 && copies2dl1.contains(3)) {
            System.out.println(String.valueOf(KirConstants.RATIO_RARE_DETECTED) + 3);
            return 3;
        }
        if ((double)num > 1.6 && copies2dl1.get(copies2dl1.size() - 1) == 2) {
            return 2;
        }
        System.out.println(String.valueOf(KirConstants.RATIO_CAN_NOT_DETERMIN) + " on 2DL1:2DS1:2DS4 " + count + " " + copies2dl1.toString());
        return 0;
    }

    private static int get2DL2DSOneCopyCount(List<Integer> copies2DL1, List<Integer> copies2DS1, List<Integer> copies2DS4, int count2DL1, int count2DS1, int count2DS4, int count3DL3) {
        int standartOneCopyCount = 0;
        int total = 0;
        int count = 0;
        if (copies2DL1.size() == 1) {
            total += count2DL1 / copies2DL1.get(0);
            ++count;
        }
        if (copies2DS1.size() == 1) {
            total += count2DS1 / copies2DS1.get(0);
            ++count;
        }
        if (copies2DS4.size() == 1) {
            total += count2DS4 / copies2DS4.get(0);
            ++count;
        }
        if ((standartOneCopyCount = total / count) == 0) {
            standartOneCopyCount = count3DL3 / 2;
        }
        return standartOneCopyCount;
    }

    private static boolean noRatioPattern(boolean present1, boolean present2, boolean present3) {
        if (!present1 && !present2) {
            return true;
        }
        if (!present2 && !present3) {
            return true;
        }
        return !present1 && !present3;
    }

    public static void determint2DL5Copy(KirSample sample, List<KirSample> control2DL5samples) {
        Map<String, KirGeneResult> results = sample.getGeneResult();
        if (results.get("2DL4").isPresent() && results.get("2DL5").isPresent()) {
            KirUtils.ratio2DL45Lgenes(results, control2DL5samples);
        }
    }

    private static void ratio2DL45Lgenes(Map<String, KirGeneResult> results, List<KirSample> control2DL5samples) {
        List<Integer> copies2DL4 = results.get("2DL4").getPossibleCopies();
        List<Integer> copies2DL5 = results.get("2DL5").getPossibleCopies();
        int count2DL4 = results.get("2DL4").getSupportingExonCounts().get("2DL4-exon9").getCount();
        int count2DL5 = results.get("2DL5").getSupportingExonCounts().get("2DL5-exon9").getCount();
        float controlRatio2DL45 = KirUtils.get2DL45ControlRatio(control2DL5samples);
        float ratio2DL54 = (float)count2DL5 / ((float)count2DL4 * controlRatio2DL45);
        System.out.println("*******copies 2DL4:2DL5=" + copies2DL4.toString() + ":" + copies2DL5.toString());
        System.out.println(".......count 2DL4:2DL5=" + count2DL4 + ":" + count2DL5);
        System.out.println("standard 1:1 ratio " + controlRatio2DL45 + " corrected sample ratio=" + ratio2DL54 + " based on sample size=" + control2DL5samples.size());
        if (copies2DL4.size() == 1 && copies2DL5.size() == 1) {
            int copy4 = copies2DL4.get(0);
            int copy5 = copies2DL5.get(0);
            if ((double)ratio2DL54 < 0.7 * (double)copy5 / (1.0 * (double)copy4) || (double)ratio2DL54 > 1.3 * (double)copy5 / (1.0 * (double)copy4)) {
                System.out.println(String.valueOf(KirConstants.RATIO_ERROR_DETECTED) + " ratio2DL54= " + ratio2DL54 + ", but copy4 = " + copy4 + " copy5=" + copy5);
            }
            return;
        }
        if (copies2DL4.size() == 1 || copies2DL5.size() == 1) {
            int copy;
            if (copies2DL4.size() == 1) {
                copy = copies2DL4.get(0);
                if ((double)ratio2DL54 > 0.75 && (double)ratio2DL54 < 1.25 && copies2DL5.contains(copy)) {
                    results.get("2DL5").setCopy(copy);
                } else if ((double)ratio2DL54 > 1.6 && (double)ratio2DL54 < 2.5 && copy == 1 && copies2DL5.contains(2)) {
                    results.get("2DL5").setCopy(copy * 2);
                } else if ((double)ratio2DL54 > 1.6 && (double)ratio2DL54 < 2.5 && copy == 2 && copies2DL5.contains(4)) {
                    results.get("2DL5").setCopy(copy * 2);
                } else if ((double)ratio2DL54 > 0.4 && (double)ratio2DL54 < 0.6 && copy == 2 && copies2DL5.contains(1)) {
                    results.get("2DL5").setCopy(copy / 2);
                } else {
                    System.out.println(KirConstants.RATIO_CAN_NOT_DETERMIN);
                }
            }
            if (copies2DL5.size() == 1) {
                copy = copies2DL5.get(0);
                if ((double)ratio2DL54 > 0.75 && (double)ratio2DL54 < 1.25 && copies2DL4.contains(copy)) {
                    results.get("2DL4").setCopy(copy);
                } else if ((double)ratio2DL54 > 1.7 && (double)ratio2DL54 < 2.5 && copy == 2 && copies2DL4.contains(1)) {
                    results.get("2DL4").setCopy(copy / 2);
                } else if ((double)ratio2DL54 > 0.4 && (double)ratio2DL54 < 0.6 && copy == 1 && copies2DL4.contains(2)) {
                    results.get("2DL4").setCopy(copy * 2);
                } else {
                    System.out.println(KirConstants.RATIO_CAN_NOT_DETERMIN);
                }
            }
        } else if ((double)ratio2DL54 > 1.6 && (double)ratio2DL54 < 2.5 && copies2DL5.contains(2) && copies2DL4.contains(1)) {
            results.get("2DL4").setCopy(1);
            results.get("2DL5").setCopy(2);
        } else if ((double)ratio2DL54 > 0.4 && (double)ratio2DL54 < 0.6 && copies2DL5.contains(1) && copies2DL4.contains(2)) {
            results.get("2DL4").setCopy(2);
            results.get("2DL5").setCopy(1);
        } else {
            System.out.println("can't decide ccc ");
        }
        System.out.println("copy based on 2DL4:2DL5 " + results.get("2DL4").getCopy() + " " + results.get("2DL5").getCopy());
    }

    public static void determint2DS2Copy(KirSample sample, List<KirSample> control2DS2samples) {
        Map<String, KirGeneResult> results = sample.getGeneResult();
        if (results.get("2DS2").isPresent() && results.get("3DL2").isPresent()) {
            KirUtils.ratio2DS3DLgenes(results, control2DS2samples);
        }
    }

    private static void ratio2DS3DLgenes(Map<String, KirGeneResult> results, List<KirSample> control2DS2samples) {
        List<Integer> copies2DS2 = results.get("2DS2").getPossibleCopies();
        List<Integer> copies3DL2 = results.get("3DL2").getPossibleCopies();
        int count2DS2 = results.get("2DS2").getSupportingExonCounts().get("2DS2-exon4").getCount();
        int count3DL2 = results.get("3DL2").getSupportingExonCounts().get("3DL2-exon4").getCount();
        float controlRatio3DL2DS = KirUtils.get2DS3DLControlRatio(control2DS2samples);
        float ratio3DL2DS = (float)count3DL2 / ((float)count2DS2 * controlRatio3DL2DS);
        System.out.println("*******copies 2DS2:3DL2=" + copies2DS2.toString() + ":" + copies3DL2.toString());
        System.out.println(".......count 2DS2:3DL2=" + count2DS2 + ":" + count3DL2);
        System.out.println("standard 1:1 ratio " + controlRatio3DL2DS + " corrected sample ratio=" + ratio3DL2DS + " based on sample size=" + control2DS2samples.size());
        if (copies2DS2.size() == 1 && copies3DL2.size() == 1) {
            int copy2 = copies2DS2.get(0);
            int copy3 = copies3DL2.get(0);
            if ((double)ratio3DL2DS < 0.7 * (double)copy3 / (1.0 * (double)copy2) || (double)ratio3DL2DS > 1.3 * (double)copy3 / (1.0 * (double)copy2)) {
                System.out.println(String.valueOf(KirConstants.RATIO_ERROR_DETECTED) + " ratio3DL2DS= " + ratio3DL2DS + ", but copy2 = " + copy2 + " copy3=" + copy3);
            }
            return;
        }
        if (copies2DS2.size() == 1 || copies3DL2.size() == 1) {
            int copy;
            if (copies2DS2.size() == 1) {
                copy = copies2DS2.get(0);
                if ((double)ratio3DL2DS > 0.75 && (double)ratio3DL2DS < 1.25 && copies3DL2.contains(copy)) {
                    results.get("3DL2").setCopy(copy);
                } else if ((double)ratio3DL2DS > 1.6 && (double)ratio3DL2DS < 2.5 && copy == 1 && copies3DL2.contains(2)) {
                    results.get("3DL2").setCopy(copy * 2);
                } else if ((double)ratio3DL2DS > 0.4 && (double)ratio3DL2DS < 0.6 && copy == 2 && copies3DL2.contains(1)) {
                    results.get("3DL2").setCopy(copy / 2);
                } else {
                    System.out.println(KirConstants.RATIO_CAN_NOT_DETERMIN);
                }
            }
            if (copies3DL2.size() == 1) {
                copy = copies3DL2.get(0);
                if ((double)ratio3DL2DS > 0.75 && (double)ratio3DL2DS < 1.25 && copies2DS2.contains(copy)) {
                    results.get("2DS2").setCopy(copy);
                } else if ((double)ratio3DL2DS > 1.7 && (double)ratio3DL2DS < 2.5 && copy == 2 && copies2DS2.contains(1)) {
                    results.get("2DS2").setCopy(copy / 2);
                } else if ((double)ratio3DL2DS > 0.4 && (double)ratio3DL2DS < 0.6 && copy == 1 && copies2DS2.contains(2)) {
                    results.get("2DS2").setCopy(copy * 2);
                } else {
                    System.out.println(KirConstants.RATIO_CAN_NOT_DETERMIN);
                }
            }
        } else if ((double)ratio3DL2DS > 1.6 && (double)ratio3DL2DS < 2.5 && copies3DL2.contains(2) && copies2DS2.contains(1)) {
            results.get("2DS2").setCopy(1);
            results.get("3DL2").setCopy(2);
        } else if ((double)ratio3DL2DS > 0.4 && (double)ratio3DL2DS < 0.6 && copies3DL2.contains(1) && copies2DS2.contains(2)) {
            results.get("2DS2").setCopy(2);
            results.get("3DL2").setCopy(1);
        } else {
            System.out.println(KirConstants.RATIO_CAN_NOT_DETERMIN);
        }
        System.out.println("copy based on 2DS2:3DL2 " + results.get("2DS2").getCopy() + " " + results.get("3DL2").getCopy());
    }

    public static void determint2DP3DPCopy(KirSample sample, List<KirSample> controlAAsamples) {
        Map<String, KirGeneResult> results = sample.getGeneResult();
        if (results.get("2DP1").isPresent() && results.get("3DP1").isPresent()) {
            KirUtils.ratio2DP3DPgenes(results, controlAAsamples);
        }
    }

    private static void ratio2DP3DPgenes(Map<String, KirGeneResult> results, List<KirSample> controlAAsamples) {
        List<Integer> copies2DP1 = results.get("2DP1").getPossibleCopies();
        List<Integer> copies3DP1 = results.get("3DP1").getPossibleCopies();
        int count2DP1 = results.get("2DP1").getSupportingExonCounts().get("2DP1-exon4").getCount();
        int count3DP1 = results.get("3DP1").getSupportingExonCounts().get("3DP1-exon4").getCount();
        float controlRatio3DP2DP = KirUtils.get2DP3DPControlRatio(controlAAsamples);
        float ratio3DP2DP = (float)count3DP1 / ((float)count2DP1 * controlRatio3DP2DP);
        System.out.println("*******copies 2DP1:3DP1=" + copies2DP1.toString() + ":" + copies3DP1.toString());
        System.out.println(".......count 2DP1:3DP1=" + count2DP1 + ":" + count3DP1);
        System.out.println("standard 2:2 ratio " + controlRatio3DP2DP + " corrected sample ratio=" + ratio3DP2DP + " based on sample size=" + controlAAsamples.size());
        if (copies2DP1.size() == 1 && copies3DP1.size() == 1) {
            int copy2 = copies2DP1.get(0);
            int copy3 = copies3DP1.get(0);
            if ((double)ratio3DP2DP < 0.7 * (double)copy3 / (1.0 * (double)copy2) || (double)ratio3DP2DP > 1.3 * (double)copy3 / (1.0 * (double)copy2)) {
                System.out.println(String.valueOf(KirConstants.RATIO_ERROR_DETECTED) + " ratio3DP2DP= " + ratio3DP2DP + ", but copy2 = " + copy2 + " copy3=" + copy3);
            }
            return;
        }
        if (copies2DP1.size() == 1 || copies3DP1.size() == 1) {
            int copy;
            if (copies2DP1.size() == 1) {
                copy = copies2DP1.get(0);
                if ((double)ratio3DP2DP > 0.75 && (double)ratio3DP2DP < 1.25 && copies3DP1.contains(copy)) {
                    results.get("3DP1").setCopy(copy);
                } else if ((double)ratio3DP2DP > 1.6 && (double)ratio3DP2DP < 2.5 && copy == 1 && copies3DP1.contains(2)) {
                    results.get("3DP1").setCopy(copy * 2);
                } else if ((double)ratio3DP2DP > 0.4 && (double)ratio3DP2DP < 0.6 && copy == 2 && copies3DP1.contains(1)) {
                    results.get("3DP1").setCopy(copy / 2);
                } else {
                    System.out.println(KirConstants.RATIO_CAN_NOT_DETERMIN);
                }
            }
            if (copies3DP1.size() == 1) {
                copy = copies3DP1.get(0);
                if ((double)ratio3DP2DP > 0.75 && (double)ratio3DP2DP < 1.25 && copies2DP1.contains(copy)) {
                    results.get("2DP1").setCopy(copy);
                } else if ((double)ratio3DP2DP > 1.7 && (double)ratio3DP2DP < 2.5 && copy == 2 && copies2DP1.contains(1)) {
                    results.get("2DP1").setCopy(copy / 2);
                } else if ((double)ratio3DP2DP > 0.4 && (double)ratio3DP2DP < 0.6 && copy == 1 && copies2DP1.contains(2)) {
                    results.get("2DP1").setCopy(copy * 2);
                } else {
                    System.out.println(KirConstants.RATIO_CAN_NOT_DETERMIN);
                }
            }
        } else if ((double)ratio3DP2DP > 1.6 && (double)ratio3DP2DP < 2.5 && copies3DP1.contains(2) && copies2DP1.contains(1)) {
            results.get("2DP1").setCopy(1);
            results.get("3DP1").setCopy(2);
        } else if ((double)ratio3DP2DP > 0.4 && (double)ratio3DP2DP < 0.6 && copies3DP1.contains(1) && copies2DP1.contains(2)) {
            results.get("2DP1").setCopy(2);
            results.get("3DP1").setCopy(1);
        } else {
            System.out.println(KirConstants.RATIO_CAN_NOT_DETERMIN);
        }
        System.out.println("copy based on 2DP1:3DP1 " + results.get("2DP1").getCopy() + " " + results.get("3DP1").getCopy());
    }

    private static float get2DL45ControlRatio(List<KirSample> control2DL5samples) {
        float total = 0.0f;
        for (KirSample sample : control2DL5samples) {
            int count2DL4 = sample.getGeneResult().get("2DL4").getSupportingExonCounts().get("2DL4-exon9").getCount() / sample.getGeneResult().get("2DL4").getCopy();
            int count2DL5 = sample.getGeneResult().get("2DL5").getSupportingExonCounts().get("2DL5-exon9").getCount() / sample.getGeneResult().get("2DL5").getCopy();
            total += (float)count2DL5 / (float)count2DL4;
        }
        return total / (float)control2DL5samples.size();
    }

    private static float get2DS3DLControlRatio(List<KirSample> control2DS2samples) {
        float total = 0.0f;
        for (KirSample sample : control2DS2samples) {
            int count2DS2 = sample.getGeneResult().get("2DS2").getSupportingExonCounts().get("2DS2-exon4").getCount() / sample.getGeneResult().get("2DS2").getCopy();
            int count3DL2 = sample.getGeneResult().get("3DL2").getSupportingExonCounts().get("3DL2-exon4").getCount() / sample.getGeneResult().get("3DL2").getCopy();
            total += (float)count3DL2 / (float)count2DS2;
        }
        return total / (float)control2DS2samples.size();
    }

    private static float get2DP3DPControlRatio(List<KirSample> controlAAsamples) {
        float total = 0.0f;
        for (KirSample sample : controlAAsamples) {
            int count2DP1 = sample.getGeneResult().get("2DP1").getSupportingExonCounts().get("2DP1-exon4").getCount();
            int count3DP1 = sample.getGeneResult().get("3DP1").getSupportingExonCounts().get("3DP1-exon4").getCount();
            total += (float)count3DP1 / (float)count2DP1;
        }
        return total / (float)controlAAsamples.size();
    }

    public static void determint2DS12DS35Copy(KirSample sample) {
        Map<String, KirGeneResult> results = sample.getGeneResult();
        if (KirUtils.noRatioPattern(results.get("2DS1").isPresent(), results.get("2DS3").isPresent(), results.get("2DS5").isPresent())) {
            if (results.get("2DS4").isPresent() && results.get("2DS4").getCopy() > 0) {
                KirUtils.ratioTwo2DS12DS352DS4genes(results);
                return;
            }
            return;
        }
        if (results.get("2DS1").isPresent() && results.get("2DS3").isPresent() && results.get("2DS5").isPresent()) {
            KirUtils.ratioThree2DS12DS35genes(results);
        } else {
            KirUtils.ratioTwo2DS12DS35genes(results);
        }
    }

    private static void ratioTwo2DS12DS35genes(Map<String, KirGeneResult> results) {
        List<Integer> copies2DS1 = results.get("2DS1").getPossibleCopies();
        List<Integer> copies2DS3 = results.get("2DS3").getPossibleCopies();
        List<Integer> copies2DS5 = results.get("2DS5").getPossibleCopies();
        int count2DS1 = results.get("2DS1").getSupportingExonCounts().get("2DS1-exon4").getCount();
        int count2DS3 = results.get("2DS3").getSupportingExonCounts().get("2DS3-exon4").getCount();
        int count2DS5 = results.get("2DS5").getSupportingExonCounts().get("2DS5-exon4").getCount();
        List<Integer> copies2DS4 = results.get("2DS4").getPossibleCopies();
        int count2DS4 = results.get("2DS4").getSupportingExonCounts().get("2DS4-exon4").getCount();
        System.out.println("*******" + copies2DS1.toString() + ":" + copies2DS3.toString() + ":" + copies2DS5.toString());
        System.out.println("......." + count2DS1 + ":" + count2DS3 + ":" + count2DS5);
        System.out.println(".......count2DS4=" + count2DS4);
        if (copies2DS1.size() == 1 && copies2DS3.size() == 1 && copies2DS5.size() == 1) {
            return;
        }
        int standartOneCopyCount = KirUtils.get2DS12DS35OneCopyCount(copies2DS1, copies2DS3, copies2DS5, count2DS1, count2DS3, count2DS5, count2DS4, copies2DS4);
        if (standartOneCopyCount == 0) {
            if (!results.get("2DS1").isPresent()) {
                KirUtils.setBasedOnDoubleRatio(results, copies2DS3, copies2DS5, count2DS3, count2DS5, "2DS3", "2DS5");
            } else if (!results.get("2DS3").isPresent()) {
                KirUtils.setBasedOnDoubleRatio(results, copies2DS1, copies2DS5, count2DS1, count2DS5, "2DS1", "2DS5");
            } else if (!results.get("2DS5").isPresent()) {
                KirUtils.setBasedOnDoubleRatio(results, copies2DS1, copies2DS3, count2DS1, count2DS3, "2DS1", "2DS3");
            }
            return;
        }
        float num2DS1 = (float)count2DS1 / (float)standartOneCopyCount;
        float num2DS3 = (float)count2DS3 / (float)standartOneCopyCount;
        float num2DS5 = (float)count2DS5 / (float)standartOneCopyCount;
        ArrayList<Integer> copies = new ArrayList<Integer>();
        if (!results.get("2DS1").isPresent()) {
            KirUtils.getTwoGeneCopy(count2DS3, count2DS5, num2DS3, num2DS5, copies, copies2DS3, copies2DS5, false);
            if (copies.size() > 0 && KirUtils.pass2DS35check((Integer)copies.get(0), (Integer)copies.get(1), copies2DS3)) {
                results.get("2DS3").setCopy((Integer)copies.get(0));
                results.get("2DS5").setCopy((Integer)copies.get(1));
            }
        } else if (!results.get("2DS3").isPresent()) {
            KirUtils.getTwoGeneCopy(count2DS1, count2DS5, num2DS1, num2DS5, copies, copies2DS1, copies2DS5, false);
            if (copies.size() > 0) {
                results.get("2DS1").setCopy((Integer)copies.get(0));
                results.get("2DS5").setCopy((Integer)copies.get(1));
            }
        } else if (!results.get("2DS5").isPresent()) {
            KirUtils.getTwoGeneCopy(count2DS1, count2DS3, num2DS1, num2DS3, copies, copies2DS1, copies2DS3, false);
            if (copies.size() > 0) {
                results.get("2DS1").setCopy((Integer)copies.get(0));
                results.get("2DS3").setCopy((Integer)copies.get(1));
            }
        }
        if (copies.size() == 0) {
            System.out.println("!!!!!trouble on 2DS1:2DS3:2DS5 ");
        } else {
            System.out.println("copy based on 2DS1:2DS3:2DS5 " + results.get("2DS1").getCopy() + " " + results.get("2DS3").getCopy() + " " + results.get("2DS5").getCopy());
        }
    }

    private static boolean pass2DS35check(int copy2DS3, int copy2DS5, List<Integer> copies) {
        return copy2DS3 + copy2DS5 <= copies.get(copies.size() - 1) + 1;
    }

    private static void ratioTwo2DS12DS352DS4genes(Map<String, KirGeneResult> results) {
        List<Integer> copies2DS1 = results.get("2DS1").getPossibleCopies();
        List<Integer> copies2DS3 = results.get("2DS3").getPossibleCopies();
        List<Integer> copies2DS5 = results.get("2DS5").getPossibleCopies();
        int count2DS1 = results.get("2DS1").getSupportingExonCounts().get("2DS1-exon4").getCount();
        int count2DS3 = results.get("2DS3").getSupportingExonCounts().get("2DS3-exon4").getCount();
        int count2DS5 = results.get("2DS5").getSupportingExonCounts().get("2DS5-exon4").getCount();
        int copy2DS4 = results.get("2DS4").getCopy();
        int count2DS4 = results.get("2DS4").getSupportingExonCounts().get("2DS4-exon4").getCount();
        System.out.println("*******" + copies2DS1.toString() + ":" + copies2DS3.toString() + ":" + copies2DS5.toString());
        System.out.println("......." + count2DS1 + ":" + count2DS3 + ":" + count2DS5);
        System.out.println(".......count2DS4=" + count2DS4 + " 2DS4 copy=" + results.get("2DS4").getCopy());
        if (copies2DS1.size() == 1 && copies2DS3.size() == 1 && copies2DS5.size() == 1) {
            return;
        }
        int standartOneCopyCount = count2DS4 / copy2DS4;
        ArrayList<Integer> copies = new ArrayList<Integer>();
        if (results.get("2DS1").isPresent()) {
            float num2DS1 = (float)count2DS1 / (float)standartOneCopyCount;
            KirUtils.getTwoGeneCopy(count2DS1, count2DS4, num2DS1, copy2DS4, copies, copies2DS1, results.get("2DS4").getPossibleCopies(), false);
            if (copies.size() > 0) {
                results.get("2DS1").setCopy((Integer)copies.get(0));
            }
        } else if (results.get("2DS3").isPresent()) {
            float num2DS3 = (float)count2DS3 / (float)standartOneCopyCount;
            KirUtils.getTwoGeneCopy(count2DS3, count2DS4, num2DS3, copy2DS4, copies, copies2DS3, results.get("2DS4").getPossibleCopies(), false);
            if (copies.size() > 0) {
                results.get("2DS3").setCopy((Integer)copies.get(0));
            }
        } else if (results.get("2DS5").isPresent()) {
            float num2DS5 = (float)count2DS5 / (float)standartOneCopyCount;
            KirUtils.getTwoGeneCopy(count2DS5, count2DS4, num2DS5, copy2DS4, copies, copies2DS5, results.get("2DS4").getPossibleCopies(), false);
            if (copies.size() > 0) {
                results.get("2DS5").setCopy((Integer)copies.get(0));
            }
        }
        if (copies.size() == 0) {
            System.out.println("!!!!!trouble on 2DS1:2DS3:2DS5 ");
        } else {
            System.out.println("copy based on 2DS1:2DS3:2DS5:2DS4 " + results.get("2DS1").getCopy() + " " + results.get("2DS3").getCopy() + " " + results.get("2DS5").getCopy() + " " + results.get("2DS4").getCopy());
        }
    }

    private static void setBasedOnDoubleRatio(Map<String, KirGeneResult> results, List<Integer> copiesA, List<Integer> copiesB, int countA, int countB, String geneA, String geneB) {
        int minCount = Math.min(countA, countB);
        int maxCount = Math.max(countA, countB);
        float ratio = (float)maxCount / (float)minCount;
        if ((double)ratio > 1.5 && (double)ratio < 2.5) {
            if (countA == minCount && copiesA.contains(1) && copiesB.contains(2)) {
                results.get(geneA).setCopy(1);
                results.get(geneB).setCopy(2);
                System.out.println("copy based on " + geneA + ":" + geneB + " " + results.get(geneA).getCopy() + " " + results.get(geneB).getCopy());
            } else if (countB == minCount && copiesB.contains(1) && copiesA.contains(2)) {
                results.get(geneA).setCopy(2);
                results.get(geneB).setCopy(1);
                System.out.println("copy based on " + geneA + ":" + geneB + " " + results.get(geneA).getCopy() + " " + results.get(geneB).getCopy());
            } else {
                System.out.println("can't decide on 2DS1:2DS3:2DS5 ratio");
            }
        } else {
            System.out.println("!!!!!trouble on 2DS1:2DS3:2DS5 can't decide");
        }
    }

    private static void ratioThree2DS12DS35genes(Map<String, KirGeneResult> results) {
        int copy2DS5;
        List<Integer> copies2DS1 = results.get("2DS1").getPossibleCopies();
        List<Integer> copies2DS3 = results.get("2DS3").getPossibleCopies();
        List<Integer> copies2DS5 = results.get("2DS5").getPossibleCopies();
        int count2DS1 = results.get("2DS1").getSupportingExonCounts().get("2DS1-exon4").getCount();
        int count2DS3 = results.get("2DS3").getSupportingExonCounts().get("2DS3-exon4").getCount();
        int count2DS5 = results.get("2DS5").getSupportingExonCounts().get("2DS5-exon4").getCount();
        List<Integer> copies2DS4 = results.get("2DL1").getPossibleCopies();
        int count2DS4 = results.get("2DL1").getSupportingExonCounts().get("2DL1-exon4").getCount();
        System.out.println("*******" + copies2DS1.toString() + ":" + copies2DS3.toString() + ":" + copies2DS5.toString());
        System.out.println("......." + count2DS1 + ":" + count2DS3 + ":" + count2DS5);
        System.out.println(".......count2DS4=" + count2DS4 + " copies2DS4=" + copies2DS4.toString());
        if (copies2DS1.size() == 1 && copies2DS3.size() == 1 && copies2DS5.size() == 1) {
            return;
        }
        int standartOneCopyCount = KirUtils.get2DS12DS35OneCopyCount(copies2DS1, copies2DS3, copies2DS5, count2DS1, count2DS3, count2DS5, count2DS4, copies2DS4);
        int copy2DS1 = KirUtils.determineCopy(standartOneCopyCount, count2DS1, copies2DS1);
        int copy2DS3 = KirUtils.determineCopy(standartOneCopyCount, count2DS3, copies2DS3);
        if (copy2DS3 + (copy2DS5 = KirUtils.determineCopy(standartOneCopyCount, count2DS5, copies2DS5)) > copies2DS3.get(copies2DS3.size() - 1) + 1) {
            copy2DS3 = 0;
            copy2DS5 = 0;
        }
        if (copy2DS1 > 0 && copy2DS3 > 0 && copy2DS5 > 0) {
            results.get("2DS1").setCopy(copy2DS1);
            results.get("2DS3").setCopy(copy2DS3);
            results.get("2DS5").setCopy(copy2DS5);
            System.out.println("copy based on 2DS1:2DS3:2DS5 " + copy2DS1 + " " + copy2DS3 + " " + copy2DS5);
        } else if (copy2DS1 == 0) {
            results.get("2DS1").addCopyWarnings("can't determin copy based on 2DS1:2DS3:2DS5");
            System.out.println("can't determin copy based on 2DS1:2DS3:2DS5");
        } else if (copy2DS3 == 0) {
            results.get("2DS3").addCopyWarnings("can't determin copy based on 2DS1:2DS3:2DS5");
            System.out.println("can't determin copy based on 2DS1:2DS3:2DS5");
        } else if (copy2DS5 == 0) {
            results.get("2DS5").addCopyWarnings("can't determin copy based on 2DS1:2DS3:2DS5");
            System.out.println("can't determin copy based on 2DS1:2DS3:2DS5");
        }
    }

    private static int get2DS12DS35OneCopyCount(List<Integer> copies2DS1, List<Integer> copies2DS3, List<Integer> copies2DS5, int count2DS1, int count2DS3, int count2DS5, int count2DS4, List<Integer> copies2DS4) {
        int standartOneCopyCount = 0;
        int total = 0;
        int count = 0;
        if (copies2DS1.size() == 1 && copies2DS1.get(0) > 0) {
            total += count2DS1 / copies2DS1.get(0);
            ++count;
        }
        if (copies2DS3.size() == 1 && copies2DS3.get(0) > 0) {
            total += count2DS3 / copies2DS3.get(0);
            ++count;
        }
        if (copies2DS5.size() == 1 && copies2DS5.get(0) > 0) {
            total += count2DS5 / copies2DS5.get(0);
            ++count;
        }
        if ((standartOneCopyCount = count == 0 ? 0 : total / count) == 0 && copies2DS4.size() == 1 && copies2DS4.get(0) != 0) {
            standartOneCopyCount = count2DS4 / copies2DS4.get(0);
        }
        if (standartOneCopyCount == 0) {
            standartOneCopyCount = Math.min(Math.min(count2DS1, count2DS3), count2DS5);
        }
        return standartOneCopyCount;
    }

    public static List<KirSample> collect2DL5samples(List<KirSample> samples) {
        ArrayList<KirSample> aaSamples = new ArrayList<KirSample>();
        for (KirSample sample : samples) {
            if (sample.getMostCommonType() == null || sample.getGeneResult().get("2DL4").getCopy() <= 0 || sample.getGeneResult().get("2DL5").getCopy() <= 0) continue;
            aaSamples.add(sample);
        }
        return aaSamples;
    }

    public static List<KirSample> collect2DS2samples(List<KirSample> samples) {
        ArrayList<KirSample> aaSamples = new ArrayList<KirSample>();
        for (KirSample sample : samples) {
            if (sample.getMostCommonType() == null || sample.getGeneResult().get("2DS2").getCopy() <= 0 || sample.getGeneResult().get("3DL2").getCopy() <= 0) continue;
            aaSamples.add(sample);
        }
        return aaSamples;
    }

    public static List<KirSample> collectAAsamples(List<KirSample> samples) {
        ArrayList<KirSample> aaSamples = new ArrayList<KirSample>();
        for (KirSample sample : samples) {
            if (sample.getMostCommonType() == null || !sample.getMostCommonType().get(0).getLocalName().equals("A+A") || sample.getGeneResult().get("2DP1").getCopy() <= 0 || sample.getGeneResult().get("3DP1").getCopy() <= 0) continue;
            aaSamples.add(sample);
        }
        if (aaSamples.size() == 0) {
            for (KirSample sample : samples) {
                if (sample.getGeneResult().get("2DP1").getCopy() <= 0 || sample.getGeneResult().get("3DP1").getCopy() <= 0) continue;
                aaSamples.add(sample);
            }
        }
        return aaSamples;
    }

    public static String joinName(List<KirDiploidType> ambiguityType, boolean isLocal) {
        StringBuilder builder = new StringBuilder();
        for (KirDiploidType dType : ambiguityType) {
            if (isLocal) {
                builder.append(dType.getLocalName()).append("/");
                continue;
            }
            builder.append(dType.getOfficialName()).append("/");
        }
        return builder.toString().substring(0, builder.toString().length() - 1);
    }

    public static String getAmbiguityStatus(KirSample sample) {
        if (sample.isResolvedCopy()) {
            if (sample.getAmbiguityType().size() == 1) {
                return KirConstants.NO_TYPE_AND_COPY_AMBIGUITY;
            }
            return KirConstants.NO_COPY_AMBIGUITY;
        }
        return KirConstants.AMBIGUITY;
    }
}

