/*
 * Decompiled with CFR 0.152.
 */
package kirCountTyping;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kirCountTyping.KirConstants;
import kirCountTyping.KirDiploidType;
import kirCountTyping.KirGeneResult;
import kirCountTyping.KirHaploidType;
import kirCountTyping.KirSample;
import misc.FileManager;

public class GeneContentRulesetTyper {
    private static List<KirHaploidType> haploidTypes;
    private static List<KirDiploidType> diploidTypes;
    private static Map<String, List<KirDiploidType>> pnToDiploidTypesMap;

    public GeneContentRulesetTyper(File rulesetFile) {
        GeneContentRulesetTyper.loadHaploidGeneContents(rulesetFile);
        this.loadDiploidGeneContents();
        this.createPNtoDiploidTypesMap();
    }

    private void createPNtoDiploidTypesMap() {
        pnToDiploidTypesMap = new HashMap<String, List<KirDiploidType>>();
        for (KirDiploidType dType : diploidTypes) {
            StringBuilder key = new StringBuilder();
            String[] stringArray = KirConstants.KIR_HAP_GENES;
            int n = KirConstants.KIR_HAP_GENES.length;
            int n2 = 0;
            while (n2 < n) {
                String gene = stringArray[n2];
                key.append(dType.getPnMap().get(gene) != false ? "+" : "-");
                ++n2;
            }
            if (!pnToDiploidTypesMap.containsKey(key.toString())) {
                pnToDiploidTypesMap.put(key.toString(), new ArrayList());
            }
            pnToDiploidTypesMap.get(key.toString()).add(dType);
        }
    }

    private void loadDiploidGeneContents() {
        diploidTypes = new ArrayList<KirDiploidType>();
        int i = 0;
        while (i < haploidTypes.size()) {
            KirHaploidType hapType1 = haploidTypes.get(i);
            int j = i;
            while (j < haploidTypes.size()) {
                KirHaploidType hapType2 = haploidTypes.get(j);
                KirDiploidType diploidType = GeneContentRulesetTyper.createDiploidType(hapType1, hapType2);
                diploidTypes.add(diploidType);
                ++j;
            }
            ++i;
        }
    }

    private static KirDiploidType createDiploidType(KirHaploidType hapType1, KirHaploidType hapType2) {
        KirDiploidType diploidType = new KirDiploidType();
        if (hapType1.compareTo(hapType2) > 0) {
            diploidType.setHaploidType1(hapType2);
            diploidType.setHaploidType2(hapType1);
        } else {
            diploidType.setHaploidType1(hapType1);
            diploidType.setHaploidType2(hapType2);
        }
        diploidType.setLocalName(String.valueOf(diploidType.getHaploidType1().getLocalName()) + "+" + diploidType.getHaploidType2().getLocalName());
        diploidType.setOfficialName(String.valueOf(diploidType.getHaploidType1().getOfficialName()) + "+" + diploidType.getHaploidType2().getOfficialName());
        diploidType.setPnMap(GeneContentRulesetTyper.createPNmap(hapType1, hapType2));
        diploidType.setGeneCopies(GeneContentRulesetTyper.createCopyMap(hapType1, hapType2));
        return diploidType;
    }

    private static Map<String, Integer> createCopyMap(KirHaploidType hapType1, KirHaploidType hapType2) {
        LinkedHashMap<String, Integer> copyMap = new LinkedHashMap<String, Integer>();
        String[] stringArray = KirConstants.KIR_HAP_GENES;
        int n = KirConstants.KIR_HAP_GENES.length;
        int n2 = 0;
        while (n2 < n) {
            String gene = stringArray[n2];
            int pn1 = GeneContentRulesetTyper.getCopy(gene, hapType1);
            int pn2 = GeneContentRulesetTyper.getCopy(gene, hapType2);
            copyMap.put(gene, pn1 + pn2);
            ++n2;
        }
        return copyMap;
    }

    private static Map<String, Boolean> createPNmap(KirHaploidType hapType1, KirHaploidType hapType2) {
        LinkedHashMap<String, Boolean> pnMap = new LinkedHashMap<String, Boolean>();
        String[] stringArray = KirConstants.KIR_HAP_GENES;
        int n = KirConstants.KIR_HAP_GENES.length;
        int n2 = 0;
        while (n2 < n) {
            String gene = stringArray[n2];
            int pn1 = GeneContentRulesetTyper.getCopy(gene, hapType1);
            int pn2 = GeneContentRulesetTyper.getCopy(gene, hapType2);
            pnMap.put(gene, pn1 > 0 || pn2 > 0);
            ++n2;
        }
        return pnMap;
    }

    private static int getCopy(String gene, KirHaploidType hapType) {
        int count = 0;
        String[] stringArray = hapType.getGeneContent();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String g = stringArray[n2];
            if (g.equals(gene)) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    private static void loadHaploidGeneContents(File rulesetFile) {
        haploidTypes = new ArrayList<KirHaploidType>();
        String[] lines = FileManager.readTextFile(rulesetFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].startsWith(">")) {
                KirHaploidType hapType = new KirHaploidType();
                String[] names = lines[i].trim().substring(1).split("\\s+");
                hapType.setLocalName(names[0]);
                hapType.setOfficialName(names[1]);
                hapType.setGeneContent(lines[i + 1].trim().split("\\s+"));
                haploidTypes.add(hapType);
            }
            ++i;
        }
    }

    public void typeBasedOnPNresult(KirSample sample) {
        Map<String, KirGeneResult> geneResult = sample.getGeneResult();
        StringBuilder key = new StringBuilder();
        String[] stringArray = KirConstants.KIR_HAP_GENES;
        int n = KirConstants.KIR_HAP_GENES.length;
        int n2 = 0;
        while (n2 < n) {
            String gene = stringArray[n2];
            if (gene.equals("2DS3/5")) {
                if (geneResult.get("2DS3").isPresent() || geneResult.get("2DS5").isPresent()) {
                    key.append("+");
                } else {
                    key.append("-");
                }
            } else {
                key.append(geneResult.get(gene).isPresent() ? "+" : "-");
            }
            ++n2;
        }
        System.out.println("key=" + key.toString());
        if (pnToDiploidTypesMap.containsKey(key.toString())) {
            List<KirDiploidType> candidateTypes = pnToDiploidTypesMap.get(key.toString());
            List<KirDiploidType> mostCommon = this.getMostCommonType(candidateTypes);
            sample.setMostCommonType(mostCommon);
            sample.setAmbiguityType(candidateTypes);
        } else {
            sample.setMostCommonType(null);
        }
    }

    private List<KirDiploidType> getMostCommonType(List<KirDiploidType> candidateTypes) {
        ArrayList<KirDiploidType> bothCommonNames = new ArrayList<KirDiploidType>();
        ArrayList<KirDiploidType> oneCommonNames = new ArrayList<KirDiploidType>();
        ArrayList<KirDiploidType> otherNames = new ArrayList<KirDiploidType>();
        for (KirDiploidType dType : candidateTypes) {
            String[] names = dType.getLocalName().split("\\+");
            String name0 = names[0];
            String name1 = names[1];
            if (KirConstants.getCommonTypes().contains(name0) && KirConstants.getCommonTypes().contains(name1)) {
                bothCommonNames.add(dType);
                continue;
            }
            if (KirConstants.getCommonTypes().contains(name0) || KirConstants.getCommonTypes().contains(name1)) {
                oneCommonNames.add(dType);
                continue;
            }
            otherNames.add(dType);
        }
        if (bothCommonNames.size() > 0) {
            return bothCommonNames;
        }
        if (oneCommonNames.size() > 0) {
            return oneCommonNames.subList(0, 1);
        }
        return otherNames.subList(0, 1);
    }

    public void loadPossibleGeneCopies(KirSample sample) {
        List<KirDiploidType> possibleTypes = sample.getAmbiguityType();
        Map<String, List<Integer>> possibleCopies = this.getPossibleCopies(possibleTypes);
        Map<String, KirGeneResult> geneResult = sample.getGeneResult();
        String[] stringArray = KirConstants.KIR_HAP_GENES;
        int n = KirConstants.KIR_HAP_GENES.length;
        int n2 = 0;
        while (n2 < n) {
            String gene = stringArray[n2];
            if (gene.equals("2DS3/5")) {
                this.getPossibleCopiesFor2DS35(possibleCopies, geneResult, gene);
            } else {
                geneResult.get(gene).setPossibleCopies(possibleCopies.get(gene));
            }
            ++n2;
        }
        boolean allResolved = true;
        String[] stringArray2 = KirConstants.KIR_GENES;
        int n3 = KirConstants.KIR_GENES.length;
        n = 0;
        while (n < n3) {
            String gene = stringArray2[n];
            if (geneResult.get(gene).getPossibleCopies().size() == 1) {
                geneResult.get(gene).setCopy(geneResult.get(gene).getPossibleCopies().get(0));
            } else {
                allResolved = false;
            }
            ++n;
        }
        sample.setResolvedCopy(allResolved);
    }

    private void getPossibleCopiesFor2DS35(Map<String, List<Integer>> possibleCopies, Map<String, KirGeneResult> geneResult, String gene) {
        ArrayList<Integer> negative = new ArrayList<Integer>();
        negative.add(0);
        if (geneResult.get("2DS3").isPresent() && geneResult.get("2DS5").isPresent()) {
            ArrayList<Integer> dividedCopies = new ArrayList<Integer>();
            int max = possibleCopies.get(gene).get(possibleCopies.get(gene).size() - 1);
            int i = max - 1;
            while (i > 0) {
                dividedCopies.add(i);
                --i;
            }
            geneResult.get("2DS3").setPossibleCopies(dividedCopies);
            geneResult.get("2DS5").setPossibleCopies(dividedCopies);
        } else if (geneResult.get("2DS3").isPresent()) {
            geneResult.get("2DS3").setPossibleCopies(possibleCopies.get(gene));
            geneResult.get("2DS5").setPossibleCopies(negative);
        } else if (geneResult.get("2DS5").isPresent()) {
            geneResult.get("2DS5").setPossibleCopies(possibleCopies.get(gene));
            geneResult.get("2DS3").setPossibleCopies(negative);
        } else {
            geneResult.get("2DS3").setPossibleCopies(possibleCopies.get(gene));
            geneResult.get("2DS5").setPossibleCopies(possibleCopies.get(gene));
        }
    }

    private Map<String, List<Integer>> getPossibleCopies(List<KirDiploidType> possibleTypes) {
        LinkedHashMap<String, List<Integer>> possibleCopies = new LinkedHashMap<String, List<Integer>>();
        String[] stringArray = KirConstants.KIR_HAP_GENES;
        int n = KirConstants.KIR_HAP_GENES.length;
        int n2 = 0;
        while (n2 < n) {
            String gene = stringArray[n2];
            ArrayList<Integer> copies = new ArrayList<Integer>();
            for (KirDiploidType dType : possibleTypes) {
                int geneCopy = dType.getGeneCopies().get(gene);
                if (copies.contains(geneCopy)) continue;
                copies.add(geneCopy);
            }
            Collections.sort(copies);
            possibleCopies.put(gene, copies);
            ++n2;
        }
        return possibleCopies;
    }

    public void typeBasedOnGeneCopy(KirSample sample) {
        this.typeBasedOnPNresult(sample);
        List<KirDiploidType> candidateTypes = sample.getAmbiguityType();
        ArrayList<KirDiploidType> removeTypes = new ArrayList<KirDiploidType>();
        if (candidateTypes == null || candidateTypes.size() == 0) {
            return;
        }
        block0: for (KirDiploidType dType : candidateTypes) {
            String[] stringArray = KirConstants.KIR_HAP_GENES;
            int n = KirConstants.KIR_HAP_GENES.length;
            int n2 = 0;
            while (n2 < n) {
                String gene = stringArray[n2];
                int geneCopy = dType.getGeneCopies().get(gene);
                int sampleGeneCopy = this.getSampleGeneCopy(sample, gene);
                if (sampleGeneCopy > 0) {
                    if (geneCopy != sampleGeneCopy) {
                        removeTypes.add(dType);
                        continue block0;
                    }
                } else if (!gene.equals("2DS3/5") && !sample.getGeneResult().get(gene).getPossibleCopies().contains(geneCopy)) {
                    removeTypes.add(dType);
                    continue block0;
                }
                ++n2;
            }
        }
        ArrayList<KirDiploidType> resolvedTypes = new ArrayList<KirDiploidType>();
        for (KirDiploidType dType : candidateTypes) {
            if (removeTypes.contains(dType)) continue;
            resolvedTypes.add(dType);
        }
        if (resolvedTypes.size() == 0) {
            return;
        }
        sample.setAmbiguityType(resolvedTypes);
        List<KirDiploidType> mostCommon = this.getMostCommonType(resolvedTypes);
        System.out.println(String.valueOf(sample.getName()) + " mostCommon=" + mostCommon.get(0).getLocalName());
        sample.setMostCommonType(mostCommon);
    }

    private int getSampleGeneCopy(KirSample sample, String gene) {
        if (gene.equals("2DS3/5")) {
            if (sample.getGeneResult().get("2DS3").isPresent() && sample.getGeneResult().get("2DS3").getCopy() == 0) {
                return 0;
            }
            if (sample.getGeneResult().get("2DS5").isPresent() && sample.getGeneResult().get("2DS5").getCopy() == 0) {
                return 0;
            }
            return sample.getGeneResult().get("2DS3").getCopy() + sample.getGeneResult().get("2DS5").getCopy();
        }
        return sample.getGeneResult().get(gene).getCopy();
    }
}

