/*
 * Decompiled with CFR 0.152.
 */
package importChromat;

import guid.IdentifierFactory;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import misc.FileManager;

public class ImportExternalChromats {
    static String STATUS_ID = "1";
    static String STATUS_NAME = "OK_VALIDATED";
    static String ORIGIN = "GeMSCopy";

    public static void main(String[] args) {
        String projectName = args[0];
        File srcroot = new File(args[1]);
        File destroot = new File(args[2]);
        String destDBurl = "jdbc:postgresql://panacea:5432/gemsprod";
        try {
            Class.forName("org.postgresql.Driver");
            Connection srcDB = DriverManager.getConnection(destDBurl, "gems", "Caff1ne");
            srcDB.setAutoCommit(false);
            String projectId = ImportExternalChromats.getProjectId(projectName, srcDB);
            File[] files = srcroot.listFiles();
            String cellLineId = null;
            String primerId = null;
            Object newName = null;
            String chromatId = null;
            String coordId = null;
            String ampliconId = null;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (!file.getName().startsWith("___")) {
                    cellLineId = ImportExternalChromats.getClId(file.getName(), srcDB);
                    primerId = ImportExternalChromats.getPrimerId(file.getName(), srcDB);
                    ampliconId = ImportExternalChromats.getAmpliconId(file.getName(), srcDB);
                    chromatId = ImportExternalChromats.insertChromat(srcDB);
                    ImportExternalChromats.insertProjectChromat(chromatId, projectId, srcDB);
                    coordId = ImportExternalChromats.insertPCRPlateCoordinate(srcDB);
                    ImportExternalChromats.insertPCRChromatReport(cellLineId, primerId, ampliconId, chromatId, projectId, projectName, coordId, file.getName(), srcDB);
                    ImportExternalChromats.copyFile(chromatId, file, destroot);
                }
                ++n2;
            }
            srcDB.commit();
            ImportExternalChromats.closeResources(null, null, srcDB);
        }
        catch (Exception e) {
            System.err.println("Got an exception! ");
            System.err.println(e.getMessage());
        }
    }

    private static String insertPCRPlateCoordinate(Connection srcDB) {
        String id = IdentifierFactory.createUniqueIdentifier().getId();
        String sql = "insert into pcr.plate_coord (plate_coord_id, is_control) values (?, ?)";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = srcDB.prepareStatement(sql);
            preparedStatement.setString(1, id);
            preparedStatement.setBoolean(2, false);
            preparedStatement.executeUpdate();
            ImportExternalChromats.closeResources(null, preparedStatement, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return id;
    }

    private static void copyFile(String chromatId, File file, File destroot) {
        FileManager.copyFile(file, new File(ImportExternalChromats.getDbDir(chromatId, destroot), chromatId), true);
        System.out.println(String.valueOf(file.getAbsolutePath()) + " -> " + new File(ImportExternalChromats.getDbDir(chromatId, destroot), chromatId));
    }

    private static File getDbDir(String id, File destroot) {
        File thisDir = new File(FileManager.getFile(id, destroot).getParent());
        if (!thisDir.isDirectory()) {
            thisDir.mkdirs();
        }
        return thisDir;
    }

    private static void insertPCRChromatReport(String cellLineId, String primerId, String ampliconId, String chromatId, String projectId, String projectName, String coordId, String filename, Connection srcDB) {
        String sql = "insert into pcr.chromat_report_mv (chromat_id, amplicon_id, amplicon_name, seq_primer_id, seq_primer_name, cell_line_id, cell_line_name, project_id, project_name, status_id, status_name, base_count_q20, base_count_default, origin, coordinate_id) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = srcDB.prepareStatement(sql);
            preparedStatement.setString(1, chromatId);
            preparedStatement.setString(2, ampliconId);
            preparedStatement.setString(3, ImportExternalChromats.getAmpliconName(filename));
            preparedStatement.setString(4, primerId);
            preparedStatement.setString(5, ImportExternalChromats.getPrimerName(filename));
            preparedStatement.setString(6, cellLineId);
            preparedStatement.setString(7, ImportExternalChromats.getClName(filename));
            preparedStatement.setString(8, projectId);
            preparedStatement.setString(9, projectName);
            preparedStatement.setString(10, STATUS_ID);
            preparedStatement.setString(11, STATUS_NAME);
            preparedStatement.setInt(12, 200);
            preparedStatement.setInt(13, 200);
            preparedStatement.setString(14, ORIGIN);
            preparedStatement.setString(15, coordId);
            preparedStatement.executeUpdate();
            ImportExternalChromats.closeResources(null, preparedStatement, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void insertProjectChromat(String chromatId, String projectId, Connection srcDB) {
        String sql = "insert into core.project_chromat (project_id, chromat_id) values (?, ?)";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = srcDB.prepareStatement(sql);
            preparedStatement.setString(1, projectId);
            preparedStatement.setString(2, chromatId);
            preparedStatement.executeUpdate();
            ImportExternalChromats.closeResources(null, preparedStatement, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String insertChromat(Connection srcDB) {
        String chromat_id = IdentifierFactory.createUniqueIdentifier().getId();
        String sql = "insert into core.chromat (chromat_id, status_id, filename, actual_read_length_q20, actual_read_length_default, base_count_default, base_count_q20) values (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = srcDB.prepareStatement(sql);
            preparedStatement.setString(1, chromat_id);
            preparedStatement.setString(2, "1");
            preparedStatement.setString(3, chromat_id);
            preparedStatement.setInt(4, 200);
            preparedStatement.setInt(5, 200);
            preparedStatement.setInt(6, 200);
            preparedStatement.setInt(7, 200);
            preparedStatement.executeUpdate();
            ImportExternalChromats.closeResources(null, preparedStatement, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return chromat_id;
    }

    private static String getProjectId(String projectName, Connection srcDB) {
        String id = null;
        PreparedStatement preparedStatement = null;
        String sql = "select project_id from core.project where name =?";
        try {
            preparedStatement = srcDB.prepareStatement(sql);
            preparedStatement.setString(1, projectName);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                id = resultSet.getString(1);
            }
            ImportExternalChromats.closeResources(null, preparedStatement, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("project_id=" + id);
        return id;
    }

    private static String getAmpliconId(String fileName, Connection srcDB) {
        String id = null;
        String ampliconName = ImportExternalChromats.getAmpliconName(fileName);
        PreparedStatement preparedStatement = null;
        String sql = "select amplicon_id from pcr.amplicon where name =?";
        try {
            preparedStatement = srcDB.prepareStatement(sql);
            preparedStatement.setString(1, ampliconName);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                id = resultSet.getString(1);
            }
            ImportExternalChromats.closeResources(null, preparedStatement, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("amplicon_id=" + id + " " + ImportExternalChromats.getAmpliconName(fileName));
        return id;
    }

    private static String getPrimerId(String fileName, Connection srcDB) {
        String id = null;
        String primerName = ImportExternalChromats.getPrimerName(fileName);
        PreparedStatement preparedStatement = null;
        String sql = "select primer_id from pcr.primer where name =?";
        try {
            preparedStatement = srcDB.prepareStatement(sql);
            preparedStatement.setString(1, primerName);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                id = resultSet.getString(1);
            }
            ImportExternalChromats.closeResources(null, preparedStatement, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("primer_id=" + id + " " + ImportExternalChromats.getPrimerName(fileName));
        return id;
    }

    private static String getClId(String fileName, Connection srcDB) {
        String id = null;
        String clName = ImportExternalChromats.getClName(fileName);
        PreparedStatement preparedStatement = null;
        String sql = "select cell_line_id from core.cell_line where local_name =?";
        try {
            preparedStatement = srcDB.prepareStatement(sql);
            preparedStatement.setString(1, clName);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                id = resultSet.getString(1);
            }
            if (id == null) {
                id = ImportExternalChromats.insertCl(clName, srcDB);
            }
            ImportExternalChromats.closeResources(null, preparedStatement, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("cl_id=" + id + " " + ImportExternalChromats.getClName(fileName));
        return id;
    }

    private static String insertCl(String clName, Connection srcDB) {
        PreparedStatement preparedStatement = null;
        String sql = "insert into core.cell_line (cell_line_id, local_name) values (?, ?)";
        String id = IdentifierFactory.createUniqueIdentifier().getId();
        try {
            preparedStatement = srcDB.prepareStatement(sql);
            preparedStatement.setString(1, id);
            preparedStatement.setString(2, clName);
            preparedStatement.executeUpdate();
            ImportExternalChromats.closeResources(null, preparedStatement, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return id;
    }

    private static String getPrimerName(String fileName) {
        String primerName = fileName.split("_")[2];
        String ampliconName = ImportExternalChromats.getAmpliconName(fileName);
        if (ampliconName.equals("DRB1-03") && primerName.equalsIgnoreCase("DRB1-combineF")) {
            primerName = "DRB1-003F";
        } else if (ampliconName.equals("DRB1-03") && primerName.equalsIgnoreCase("DRB1-combineR")) {
            primerName = "DRB1-002R";
        } else if (ampliconName.equals("DRB1-05") && primerName.equalsIgnoreCase("DRB1-combineF")) {
            primerName = "DRB1-005F";
        } else if (ampliconName.equals("DRB1-05") && primerName.equalsIgnoreCase("DRB1-combineR")) {
            primerName = "DRB1-003R";
        } else if (ampliconName.equals("DRB1-13") && primerName.equalsIgnoreCase("DRB1-combineF")) {
            primerName = "DRB1-013F";
        } else if (ampliconName.equals("DRB1-13") && primerName.equalsIgnoreCase("DRB1-combineR")) {
            primerName = "DRB1-005R";
        } else if (ampliconName.equals("DRB1-15") && primerName.equalsIgnoreCase("DRB1-combineF")) {
            primerName = "DRB1-015F";
        } else if (ampliconName.equals("DRB1-15") && primerName.equalsIgnoreCase("DRB1-combineR")) {
            primerName = "DRB1-002R";
        } else if (ampliconName.equals("DRB1-Combined") && primerName.equalsIgnoreCase("DRB1-combineF")) {
            primerName = "DRB1-F";
        } else if (ampliconName.equals("DRB1-Combined") && primerName.equalsIgnoreCase("DRB1-combineR")) {
            primerName = "DRB1-R";
        }
        return primerName;
    }

    private static String getAmpliconName(String fileName) {
        String ampliconName = fileName.split("_")[1];
        if (ampliconName.equals("HLA-DRB1-Combined")) {
            ampliconName = "DRB1-Combined";
        }
        if (ampliconName.equals("HLA-DRB1-13")) {
            ampliconName = "DRB1-13";
        }
        if (ampliconName.equals("HLA-DRB1-15")) {
            ampliconName = "DRB1-15";
        }
        if (ampliconName.equals("HLA-DRB1-03")) {
            ampliconName = "DRB1-03";
        }
        if (ampliconName.equals("HLA-DRB1-05")) {
            ampliconName = "DRB1-05";
        }
        if (ampliconName.equals("HLA-B")) {
            ampliconName = "HLA-B-Single";
        }
        if (ampliconName.equals("HLA-C")) {
            ampliconName = "HLAC";
        }
        if (ampliconName.equals("HLA-DPA1")) {
            ampliconName = "DPA-M";
        }
        if (ampliconName.equals("HLA-DPB1")) {
            ampliconName = "DPB-M";
        }
        if (ampliconName.equals("HLA-DQB1")) {
            ampliconName = "HLA-DQB1-A";
        }
        if (ampliconName.equals("HLA-DQB1-A")) {
            ampliconName = "HLA-DQB1-A";
        }
        if (ampliconName.equals("HLA-DQB1-B")) {
            ampliconName = "HLA-DQB1-B";
        }
        return ampliconName;
    }

    private static String getClName(String fileName) {
        return fileName.split("_")[0];
    }

    public static void closeResources(ResultSet resultSet, Statement statement, Connection connection) {
        SQLException sqlException = new SQLException();
        boolean isSQLExceptionEncountered = false;
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (isSQLExceptionEncountered) {
            System.out.println("error close resource");
        }
    }
}

