/*
 * Decompiled with CFR 0.152.
 */
package genotyping;

import genotyping.DiploidAmbiguity;
import genotyping.DiploidAmbiguousPair;
import genotyping.Match;
import genotyping.RuleSet;
import genotyping.RuleSetSnpPosition;
import genotyping.TypeSet;
import genotyping.TypeSetExonVO;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class TransferRuleSetByVersion {
    public static void main(String[] args) {
        String versionInSourceDB = args[0];
        String versionInDestDB = args[1];
        String locus = args[2];
        String sourceDBurl = "jdbc:postgresql://panacea.fhcrc.org:5432/gemsprod";
        String destDBurl = "jdbc:postgresql://140.107.205.122:5432/gemsdev2";
        try {
            Class.forName("org.postgresql.Driver");
            Connection srcDB = DriverManager.getConnection(sourceDBurl, "gems", "Caff1ne");
            Connection destDB = DriverManager.getConnection(destDBurl, "gems", "gems1");
            TransferRuleSetByVersion.transfer(versionInSourceDB, versionInDestDB, locus, srcDB, destDB);
            TransferRuleSetByVersion.closeResources(null, null, srcDB);
            TransferRuleSetByVersion.closeResources(null, null, destDB);
        }
        catch (Exception e) {
            System.err.println("Got an exception! ");
            System.err.println(e.getMessage());
        }
    }

    private static void transfer(String versionInSourceDB, String versionInDestDB, String locus, Connection srcDB, Connection destDB) {
        String srcLocusId = TransferRuleSetByVersion.getLocusId(locus, srcDB);
        String destLocusId = TransferRuleSetByVersion.getLocusId(locus, destDB);
        if (srcLocusId == null || destLocusId == null) {
            return;
        }
        System.out.println("srcLocusId : " + srcLocusId);
        System.out.println("destLocusId : " + destLocusId);
        RuleSet srcRuleSet = TransferRuleSetByVersion.getFullRuleSet(versionInSourceDB, srcLocusId, srcDB, true);
        RuleSet destRuleSet = TransferRuleSetByVersion.getRuleSet(versionInDestDB, destLocusId, destDB, false);
        if (srcRuleSet == null || destRuleSet != null) {
            return;
        }
        System.out.println("srcRuleSet : " + srcRuleSet.getId() + " " + srcRuleSet.getLocusId() + " " + srcRuleSet.getVersion());
        srcRuleSet.setVersion(versionInDestDB);
        TransferRuleSetByVersion.transferRuleSet(srcRuleSet, destLocusId, destDB);
        TransferRuleSetByVersion.closeResources(null, null, srcDB);
        TransferRuleSetByVersion.closeResources(null, null, destDB);
    }

    private static void transferRuleSet(RuleSet srcRuleSet, String destLocusId, Connection destDB) {
        try {
            destDB.setAutoCommit(false);
            TransferRuleSetByVersion.insertRuleSet(srcRuleSet, destLocusId, destDB);
            for (TypeSet typeSet : srcRuleSet.getTypeSet()) {
                TransferRuleSetByVersion.insertTypeSet(destDB, typeSet);
                for (TypeSetExonVO exonVO : typeSet.getExons()) {
                    TransferRuleSetByVersion.insertionExon(destDB, exonVO);
                }
                for (Match match : typeSet.getMatches()) {
                    TransferRuleSetByVersion.insertMatch(destDB, match);
                }
            }
            for (RuleSetSnpPosition snpPosition : srcRuleSet.getSnpPositions()) {
                TransferRuleSetByVersion.insertRuleSetSnp(destDB, snpPosition);
            }
            for (DiploidAmbiguity diploidAmbiguity : srcRuleSet.getDiploidAmbiguities()) {
                TransferRuleSetByVersion.insertDiploidAmbiguity(destDB, diploidAmbiguity);
                for (DiploidAmbiguousPair diploidAmbiguousPair : diploidAmbiguity.getDiploidAmbiguousPairs()) {
                    TransferRuleSetByVersion.insertDiploidAmbiguityPair(destDB, diploidAmbiguousPair);
                }
            }
            System.out.println("commit all");
            destDB.commit();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                destDB.rollback();
            }
            catch (Exception x) {
                System.err.println("Got an exception when rollback! ");
                System.err.println(x.getMessage());
            }
        }
    }

    private static void insertDiploidAmbiguityPair(Connection destDB, DiploidAmbiguousPair diploidAmbiguousPair) throws SQLException {
        String insertDiploidAmbiguityPair = "INSERT INTO genotype.diploid_ambiguous_pair (diploid_ambiguous_pair_id,diploid_ambiguity_id,name) values(?,?,?)";
        PreparedStatement preparedStatement = destDB.prepareStatement(insertDiploidAmbiguityPair);
        preparedStatement.setString(1, diploidAmbiguousPair.getId());
        preparedStatement.setString(2, diploidAmbiguousPair.getDiploidAmbiguityId());
        preparedStatement.setString(3, diploidAmbiguousPair.getName());
        preparedStatement.executeUpdate();
        TransferRuleSetByVersion.closeResources(null, preparedStatement, null);
    }

    private static void insertDiploidAmbiguity(Connection destDB, DiploidAmbiguity diploidAmbiguity) throws SQLException {
        String insertDiploidAmbiguity = "INSERT INTO genotype.diploid_ambiguity (diploid_ambiguity_id,rule_set_id) values(?,?)";
        PreparedStatement preparedStatement = destDB.prepareStatement(insertDiploidAmbiguity);
        preparedStatement.setString(1, diploidAmbiguity.getId());
        preparedStatement.setString(2, diploidAmbiguity.getRuleSetId());
        preparedStatement.executeUpdate();
        TransferRuleSetByVersion.closeResources(null, preparedStatement, null);
    }

    private static void insertRuleSetSnp(Connection destDB, RuleSetSnpPosition snpPosition) throws SQLException {
        String insertRuleSetSnpPosition = "INSERT INTO genotype.rule_set_snp (rule_set_snp_id,rule_set_id,position,genotype) values(?,?,?,?)";
        PreparedStatement preparedStatement = destDB.prepareStatement(insertRuleSetSnpPosition);
        preparedStatement.setString(1, snpPosition.getId());
        preparedStatement.setString(2, snpPosition.getRuleSetId());
        preparedStatement.setInt(3, snpPosition.getPosition());
        preparedStatement.setString(4, snpPosition.getGenotype());
        preparedStatement.executeUpdate();
        TransferRuleSetByVersion.closeResources(null, preparedStatement, null);
    }

    private static void insertMatch(Connection destDB, Match match) throws SQLException {
        String insertMatch = "INSERT INTO genotype.match (match_id,position,genotype,not_match,type_set_id,match_type,parent_match_id,deletion_count,date_edited) values(?,?,?,?,?,?,?,?,?)";
        PreparedStatement preparedStatement = destDB.prepareStatement(insertMatch);
        preparedStatement.setString(1, match.getId());
        preparedStatement.setInt(2, match.getPosition());
        preparedStatement.setString(3, new String(match.getGenotype()));
        preparedStatement.setBoolean(4, match.isNotMatch());
        preparedStatement.setString(5, match.getTypeSetId());
        preparedStatement.setString(6, match.getMatchType());
        preparedStatement.setString(7, match.getParentMatchId());
        preparedStatement.setInt(8, match.getDeletionCount());
        if (match.getDateEdited() != null) {
            preparedStatement.setDate(9, new Date(match.getDateEdited().getTime()));
        } else {
            preparedStatement.setNull(9, 93);
        }
        preparedStatement.executeUpdate();
        TransferRuleSetByVersion.closeResources(null, preparedStatement, null);
    }

    private static void insertionExon(Connection destDB, TypeSetExonVO exonVO) throws SQLException {
        String insertExon = "INSERT INTO genotype.type_set_exon (type_set_exon_id,type_set_id,start_position_ale_seq,stop_position_ale_seq,start_position_bb_seq,stop_position_bb_seq,align_param_gap_open,align_param_gap_extend,number) values(?,?,?,?,?,?,?,?,?)";
        PreparedStatement preparedStatement = destDB.prepareStatement(insertExon);
        preparedStatement.setString(1, exonVO.getId());
        preparedStatement.setString(2, exonVO.getTypeSetId());
        preparedStatement.setInt(3, exonVO.getStartPositionAllele());
        preparedStatement.setInt(4, exonVO.getStopPositionAllele());
        preparedStatement.setInt(5, exonVO.getStartPositionBackBone());
        preparedStatement.setInt(6, exonVO.getStopPositionBackBone());
        preparedStatement.setInt(7, exonVO.getAlignParamGapOpen());
        preparedStatement.setInt(8, exonVO.getAlignParamGapExtend());
        preparedStatement.setInt(9, exonVO.getNumber());
        preparedStatement.executeUpdate();
        TransferRuleSetByVersion.closeResources(null, preparedStatement, null);
    }

    private static void insertTypeSet(Connection destDB, TypeSet typeSet) throws SQLException {
        String insertTypeSet = "INSERT INTO genotype.type_set (type_set_id,rule_set_id,name,sequence,deprecated,disambiguous_name,locked,date_edited) values(?,?,?,?,?,?,?,?)";
        PreparedStatement preparedStatement = destDB.prepareStatement(insertTypeSet);
        preparedStatement.setString(1, typeSet.getId());
        preparedStatement.setString(2, typeSet.getRuleSetId());
        preparedStatement.setString(3, typeSet.getName());
        preparedStatement.setString(4, typeSet.getSequence());
        preparedStatement.setBoolean(5, typeSet.isDeprecated());
        preparedStatement.setString(6, typeSet.getDisambigousName());
        preparedStatement.setBoolean(7, typeSet.isLocked());
        if (typeSet.getDateEdited() != null) {
            preparedStatement.setDate(8, new Date(typeSet.getDateEdited().getTime()));
        } else {
            preparedStatement.setNull(8, 93);
        }
        preparedStatement.executeUpdate();
        TransferRuleSetByVersion.closeResources(null, preparedStatement, null);
    }

    private static void insertRuleSet(RuleSet srcRuleSet, String destLocusId, Connection destDB) throws SQLException {
        String insertRuleSet = "INSERT INTO genotype.rule_set (rule_set_id,locus_id,version,active) values(?,?,?,?)";
        PreparedStatement preparedStatement = destDB.prepareStatement(insertRuleSet);
        preparedStatement.setString(1, srcRuleSet.getId());
        preparedStatement.setString(2, destLocusId);
        preparedStatement.setString(3, srcRuleSet.getVersion());
        preparedStatement.setBoolean(4, srcRuleSet.isActive());
        int status = preparedStatement.executeUpdate();
        System.out.println("INSERT INTO genotype.rule_set : " + srcRuleSet.getId() + ", status=" + status);
        TransferRuleSetByVersion.closeResources(null, preparedStatement, null);
    }

    public static RuleSet getFullRuleSet(String version, String locusId, Connection db, boolean isErrorNoExist) {
        RuleSet ruleSet = TransferRuleSetByVersion.getRuleSet(version, locusId, db, true);
        ruleSet.setTypeSet(TransferRuleSetByVersion.getTypeSets(ruleSet.getId(), db));
        ruleSet.setSnpPositions(TransferRuleSetByVersion.getRuleSetSnps(ruleSet.getId(), db));
        ruleSet.setDiploidAmbiguities(TransferRuleSetByVersion.getDiploidAmbiguities(ruleSet.getId(), db));
        return ruleSet;
    }

    private static List<DiploidAmbiguity> getDiploidAmbiguities(String ruleSetId, Connection db) {
        ArrayList<DiploidAmbiguity> list = new ArrayList<DiploidAmbiguity>();
        String selectDiploidAmbiguity = "select diploid_ambiguity_id, rule_set_id from genotype.diploid_ambiguity where rule_set_id = ?";
        try {
            PreparedStatement preparedStatement = db.prepareStatement(selectDiploidAmbiguity);
            preparedStatement.setString(1, ruleSetId);
            ResultSet resultSet = preparedStatement.executeQuery();
            DiploidAmbiguity diploidAmbiguity = null;
            while (resultSet.next()) {
                diploidAmbiguity = new DiploidAmbiguity();
                diploidAmbiguity.setId(resultSet.getString(1));
                diploidAmbiguity.setRuleSetId(resultSet.getString(2));
                diploidAmbiguity.setDiploidAmbiguousPairs(TransferRuleSetByVersion.getDiploidAmbiguousPairs(diploidAmbiguity.getId(), db));
                list.add(diploidAmbiguity);
            }
            TransferRuleSetByVersion.closeResources(resultSet, preparedStatement, null);
        }
        catch (Exception e) {
            System.err.println("Got an exception! ");
            System.err.println(e.getMessage());
        }
        System.out.println("diploidAmbiguity count : " + list.size());
        return list;
    }

    private static List<DiploidAmbiguousPair> getDiploidAmbiguousPairs(String diploidAmbiguityId, Connection db) {
        ArrayList<DiploidAmbiguousPair> list = new ArrayList<DiploidAmbiguousPair>();
        String selectDiploidAmbiguousPair = "select diploid_ambiguous_pair_id, diploid_ambiguity_id, name from genotype.diploid_ambiguous_pair where diploid_ambiguity_id = ? order by name";
        try {
            PreparedStatement preparedStatement = db.prepareStatement(selectDiploidAmbiguousPair);
            preparedStatement.setString(1, diploidAmbiguityId);
            ResultSet resultSet = preparedStatement.executeQuery();
            DiploidAmbiguousPair diploidAmbiguousPair = null;
            while (resultSet.next()) {
                diploidAmbiguousPair = new DiploidAmbiguousPair();
                diploidAmbiguousPair.setId(resultSet.getString(1));
                diploidAmbiguousPair.setDiploidAmbiguityId(resultSet.getString(2));
                diploidAmbiguousPair.setName(resultSet.getString(3));
                list.add(diploidAmbiguousPair);
            }
            TransferRuleSetByVersion.closeResources(resultSet, preparedStatement, null);
        }
        catch (Exception e) {
            System.err.println("Got an exception! ");
            System.err.println(e.getMessage());
        }
        System.out.println("diploidAmbiguousPair count : " + list.size());
        return list;
    }

    private static List<RuleSetSnpPosition> getRuleSetSnps(String id, Connection db) {
        ArrayList<RuleSetSnpPosition> list = new ArrayList<RuleSetSnpPosition>();
        String selectRuleSetSnp = "select rule_set_snp_id, rule_set_id, position, genotype from genotype.rule_set_snp where rule_set_id = ?";
        try {
            PreparedStatement preparedStatement = db.prepareStatement(selectRuleSetSnp);
            preparedStatement.setString(1, id);
            ResultSet resultSet = preparedStatement.executeQuery();
            RuleSetSnpPosition ruleSetSnpPosition = null;
            while (resultSet.next()) {
                ruleSetSnpPosition = new RuleSetSnpPosition();
                ruleSetSnpPosition.setId(resultSet.getString(1));
                ruleSetSnpPosition.setRuleSetId(resultSet.getString(2));
                ruleSetSnpPosition.setPosition(resultSet.getInt(3));
                ruleSetSnpPosition.setGenotype(resultSet.getString(4));
                list.add(ruleSetSnpPosition);
            }
            TransferRuleSetByVersion.closeResources(resultSet, preparedStatement, null);
        }
        catch (Exception e) {
            System.err.println("Got an exception! ");
            System.err.println(e.getMessage());
        }
        System.out.println("RuleSetSnpPosition count : " + list.size());
        return list;
    }

    private static List<TypeSet> getTypeSets(String ruleSetId, Connection db) {
        ArrayList<TypeSet> typeSets = new ArrayList<TypeSet>();
        String selectTypeSet = "select type_set_id, name, rule_set_id, sequence, deprecated, disambiguous_name, locked, date_edited from genotype.type_set where rule_set_id = ?";
        try {
            PreparedStatement preparedStatement = db.prepareStatement(selectTypeSet);
            preparedStatement.setString(1, ruleSetId);
            ResultSet resultSet = preparedStatement.executeQuery();
            TypeSet typeSet = null;
            while (resultSet.next()) {
                typeSet = new TypeSet();
                typeSet.setId(resultSet.getString(1));
                typeSet.setName(resultSet.getString(2));
                typeSet.setRuleSetId(resultSet.getString(3));
                typeSet.setSequence(resultSet.getString(4));
                typeSet.setDeprecated(resultSet.getBoolean(5));
                typeSet.setDisambigousName(resultSet.getString(6));
                typeSet.setLocked(resultSet.getBoolean(7));
                typeSet.setDateEdited(resultSet.getDate(8));
                typeSet.setMatches(TransferRuleSetByVersion.getMatches(typeSet.getId(), db));
                typeSet.setExons(TransferRuleSetByVersion.getTypeSetExons(typeSet.getId(), db));
                typeSets.add(typeSet);
            }
            TransferRuleSetByVersion.closeResources(resultSet, preparedStatement, null);
        }
        catch (Exception e) {
            System.err.println("Got an exception! ");
            System.err.println(e.getMessage());
        }
        System.out.println("typeSets count : " + typeSets.size());
        return typeSets;
    }

    private static List<Match> getMatches(String typeSetId, Connection db) {
        ArrayList<Match> matches = new ArrayList<Match>();
        String selectTypeSetExons = "select match_id, genotype, type_set_id, not_match, position, snp_id, match_type, parent_match_id, deletion_count, date_edited from genotype.match where type_set_id = ?";
        try {
            PreparedStatement preparedStatement = db.prepareStatement(selectTypeSetExons);
            preparedStatement.setString(1, typeSetId);
            ResultSet resultSet = preparedStatement.executeQuery();
            Match match = null;
            while (resultSet.next()) {
                match = new Match();
                match.setId(resultSet.getString(1));
                match.setGenotype(resultSet.getString(2).toCharArray());
                match.setTypeSetId(resultSet.getString(3));
                match.setNotMatch(resultSet.getBoolean(4));
                match.setPosition(resultSet.getInt(5));
                match.setSnpId(resultSet.getString(6));
                match.setMatchType(resultSet.getString(7));
                match.setParentMatchId(resultSet.getString(8));
                match.setDeletionCount(resultSet.getInt(9));
                match.setDateEdited(resultSet.getDate(10));
                matches.add(match);
            }
            TransferRuleSetByVersion.closeResources(resultSet, preparedStatement, null);
        }
        catch (Exception e) {
            System.err.println("Got an exception! ");
            System.err.println(e.getMessage());
        }
        System.out.println("Matches count for " + typeSetId + " : " + matches.size());
        return matches;
    }

    private static List<TypeSetExonVO> getTypeSetExons(String typeSetId, Connection db) {
        ArrayList<TypeSetExonVO> exons = new ArrayList<TypeSetExonVO>();
        String selectTypeSetExons = "select type_set_exon_id, type_set_id, start_position_bb_seq, stop_position_bb_seq, align_param_gap_open, align_param_gap_extend, number, start_position_ale_seq, stop_position_ale_seq from genotype.type_set_exon where type_set_id = ?";
        try {
            PreparedStatement preparedStatement = db.prepareStatement(selectTypeSetExons);
            preparedStatement.setString(1, typeSetId);
            ResultSet resultSet = preparedStatement.executeQuery();
            TypeSetExonVO exonVO = null;
            while (resultSet.next()) {
                exonVO = new TypeSetExonVO();
                exonVO.setId(resultSet.getString(1));
                exonVO.setTypeSetId(resultSet.getString(2));
                exonVO.setStartPositionBackBone(resultSet.getInt(3));
                exonVO.setStopPositionBackBone(resultSet.getInt(4));
                exonVO.setAlignParamGapOpen(resultSet.getInt(5));
                exonVO.setAlignParamGapExtend(resultSet.getInt(6));
                exonVO.setNumber(resultSet.getInt(7));
                exonVO.setStartPositionAllele(resultSet.getInt(8));
                exonVO.setStopPositionAllele(resultSet.getInt(9));
                exons.add(exonVO);
            }
            TransferRuleSetByVersion.closeResources(resultSet, preparedStatement, null);
        }
        catch (Exception e) {
            System.err.println("Got an exception! ");
            System.err.println(e.getMessage());
        }
        System.out.println("exons count : " + exons.size());
        return exons;
    }

    private static RuleSet getRuleSet(String version, String locusId, Connection db, boolean isErrorNoExist) {
        RuleSet ruleSet = null;
        String selectRuleSet = "select rule_set_id, version, active, locus_id from genotype.rule_set where locus_id = ? and version = ?";
        try {
            PreparedStatement preparedStatement = db.prepareStatement(selectRuleSet);
            preparedStatement.setString(1, locusId);
            preparedStatement.setString(2, version);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                ruleSet = new RuleSet();
                ruleSet.setId(resultSet.getString(1));
                ruleSet.setVersion(resultSet.getString(2));
                ruleSet.setActive(resultSet.getBoolean(3));
                ruleSet.setLocusId(resultSet.getString(4));
            } else if (isErrorNoExist) {
                System.out.println("Error : no rule set record for locus_id " + locusId);
            }
            if (resultSet.next()) {
                System.out.println("Error : multiple rule set record for locus_id" + locusId);
                ruleSet = null;
            }
            TransferRuleSetByVersion.closeResources(resultSet, preparedStatement, null);
        }
        catch (Exception e) {
            System.err.println("Got an exception! ");
            System.err.println(e.getMessage());
        }
        return ruleSet;
    }

    public static String getLocusId(String locus, Connection db) {
        String locusId = null;
        String selectLocusId = "select locus_id from genotype.locus where name = ?";
        try {
            PreparedStatement preparedStatement = db.prepareStatement(selectLocusId);
            preparedStatement.setString(1, locus);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                locusId = resultSet.getString(1);
            } else {
                System.out.println("Error : not locus record for " + locus);
            }
            if (resultSet.next()) {
                System.out.println("Error : multiple locus record for " + locus);
                locusId = null;
            }
            TransferRuleSetByVersion.closeResources(resultSet, preparedStatement, null);
        }
        catch (Exception e) {
            System.err.println("Got an exception! ");
            System.err.println(e.getMessage());
        }
        return locusId;
    }

    public static void closeResources(ResultSet resultSet, Statement statement, Connection connection) {
        SQLException sqlException = new SQLException();
        boolean isSQLExceptionEncountered = false;
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (isSQLExceptionEncountered) {
            System.out.println("error close resource");
        }
    }
}

