/*
 * Decompiled with CFR 0.152.
 */
package genotyping;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import misc.FileManager;

public class FindAmb {
    public static void main(String[] args) throws Exception {
        File exon2File = new File(args[0]);
        File exon2AmbFile = new File(args[1]);
        File exon3File = new File(args[2]);
        File exon3AmbFile = new File(args[3]);
        HashMap<String, String> hap2Names = new HashMap<String, String>();
        HashMap<String, String> hap3Names = new HashMap<String, String>();
        FindAmb.populateHapAmbNames(hap2Names, exon2AmbFile);
        FindAmb.populateHapAmbNames(hap3Names, exon3AmbFile);
        Map<String, String> exon2Seqs = FindAmb.organizeFastaByHap(hap2Names, exon2File);
        Map<String, String> exon3Seqs = FindAmb.organizeFastaByHap(hap3Names, exon3File);
    }

    private static Map<String, String> organizeFastaByHap(Map<String, String> hapAmbNames, File fastaFile) throws Exception {
        LinkedHashMap<String, String> exonSeqs = new LinkedHashMap<String, String>();
        ArrayList<String> existAmbTypes = new ArrayList<String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">")) {
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                if (!hapAmbNames.containsKey(name)) {
                    exonSeqs.put(name, sequence);
                } else {
                    String gname = hapAmbNames.get(name);
                    if (!existAmbTypes.contains(gname)) {
                        exonSeqs.put(gname, sequence);
                        existAmbTypes.add(gname);
                    }
                }
            }
            ++i;
        }
        return exonSeqs;
    }

    private static void populateHapAmbNames(Map<String, String> hapNames, File hapAmbFile) {
        String[] lines;
        String[] stringArray = lines = FileManager.readTextFile(hapAmbFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0) {
                String[] items = line.trim().split("\\s+");
                String gname = items[0].trim();
                int i = 1;
                while (i < items.length) {
                    hapNames.put(items[i].trim(), gname);
                    ++i;
                }
            }
            ++n2;
        }
    }
}

