/*
 * Decompiled with CFR 0.152.
 */
package genotyping;

import genotyping.DiploidAmbiguity;
import genotyping.DiploidAmbiguousPair;
import genotyping.Match;
import genotyping.RuleSet;
import genotyping.RuleSetSnpPosition;
import genotyping.TransferRuleSetByVersion;
import genotyping.TypeSet;
import genotyping.TypeSetExonVO;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class ExtraceRuleSet {
    public static void main(String[] args) {
        String versionInSourceDB = args[0];
        String locus = args[1];
        File dataDir = new File(args[2]);
        String sourceDBurl = "jdbc:postgresql://panacea.fhcrc.org:5432/gemsprod";
        try {
            Class.forName("org.postgresql.Driver");
            Connection srcDB = DriverManager.getConnection(sourceDBurl, "gems", "Caff1ne");
            ExtraceRuleSet.extractRuleSet(versionInSourceDB, locus, srcDB, dataDir);
            TransferRuleSetByVersion.closeResources(null, null, srcDB);
        }
        catch (Exception e) {
            System.err.println("Got an exception! ");
            System.err.println(e.getMessage());
        }
    }

    private static void extractRuleSet(String versionInSourceDB, String locus, Connection srcDB, File dataDir) {
        String locusId = TransferRuleSetByVersion.getLocusId(locus, srcDB);
        RuleSet ruleSet = TransferRuleSetByVersion.getFullRuleSet(versionInSourceDB, locusId, srcDB, true);
        String backboneSeq = ExtraceRuleSet.getBackboneSequence(locusId, srcDB);
        StringBuilder typeSetBuilder = new StringBuilder();
        StringBuilder exonBuilder = new StringBuilder();
        StringBuilder matchBuilder = new StringBuilder();
        StringBuilder snpBuilder = new StringBuilder();
        StringBuilder ambDiploidBuilder = new StringBuilder();
        StringBuilder ambHaploidBuilder = new StringBuilder();
        HashMap<String, List<String>> ambHap = new HashMap<String, List<String>>();
        for (TypeSet typeSet : ruleSet.getTypeSet()) {
            ExtraceRuleSet.recordTypeSet(typeSetBuilder, typeSet, ambHap);
            for (TypeSetExonVO exonVO : typeSet.getExons()) {
                ExtraceRuleSet.recordExon(exonBuilder, exonVO, typeSet.getName());
            }
            for (Match match : typeSet.getMatches()) {
                ExtraceRuleSet.recordMatch(matchBuilder, match, typeSet.getName());
            }
        }
        for (RuleSetSnpPosition snpPosition : ruleSet.getSnpPositions()) {
            ExtraceRuleSet.recordRuleSetSnp(snpBuilder, snpPosition);
        }
        for (String name : ambHap.keySet()) {
            ExtraceRuleSet.recordRuleSetSnp(ambHaploidBuilder, (List)ambHap.get(name), name);
        }
        for (DiploidAmbiguity diploidAmbiguity : ruleSet.getDiploidAmbiguities()) {
            for (DiploidAmbiguousPair diploidAmbiguousPair : diploidAmbiguity.getDiploidAmbiguousPairs()) {
                ExtraceRuleSet.recordDiploidAmbiguityPair(ambDiploidBuilder, diploidAmbiguousPair);
            }
            ambDiploidBuilder.append("\n");
        }
        FileManager.writeTextFile(new File(dataDir, "backbone.fa"), backboneSeq, true);
        FileManager.writeTextFile(new File(dataDir, "sequence.txt"), typeSetBuilder.toString(), true);
        FileManager.writeTextFile(new File(dataDir, "ruleSetSnp.txt"), snpBuilder.toString(), true);
        FileManager.writeTextFile(new File(dataDir, "exon.txt"), exonBuilder.toString(), true);
        FileManager.writeTextFile(new File(dataDir, "match.txt"), matchBuilder.toString(), true);
        FileManager.writeTextFile(new File(dataDir, "haploidAmbiguity.txt"), ambHaploidBuilder.toString(), true);
        FileManager.writeTextFile(new File(dataDir, "Diploidambiguity.txt"), ambDiploidBuilder.toString(), true);
    }

    private static String getBackboneSequence(String locusId, Connection srcDB) {
        String backboneSeq = null;
        String selectSeq = "select bs.sequence from genotype.locus l join core.backbone_sequence bs on l.backbone_sequence_id=bs.backbone_sequence_id where l.locus_id = ?";
        try {
            PreparedStatement preparedStatement = srcDB.prepareStatement(selectSeq);
            preparedStatement.setString(1, locusId);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                backboneSeq = resultSet.getString(1);
            } else {
                System.out.println("Error : not sequence record for " + locusId);
            }
            if (resultSet.next()) {
                System.out.println("Error : multiple locus record for " + locusId);
                locusId = null;
            }
            TransferRuleSetByVersion.closeResources(resultSet, preparedStatement, null);
        }
        catch (Exception e) {
            System.err.println("Got an exception! ");
            System.err.println(e.getMessage());
        }
        return backboneSeq;
    }

    private static void recordRuleSetSnp(StringBuilder ambHaploidBuilder, List<String> list, String name) {
        ambHaploidBuilder.append(name).append("\t");
        for (String type : list) {
            ambHaploidBuilder.append(type).append("\t");
        }
        ambHaploidBuilder.append("\n");
    }

    private static void recordDiploidAmbiguityPair(StringBuilder ambDiploidBuilder, DiploidAmbiguousPair diploidAmbiguousPair) {
        ambDiploidBuilder.append(diploidAmbiguousPair.getName()).append("\t");
    }

    private static void recordRuleSetSnp(StringBuilder snpBuilder, RuleSetSnpPosition snpPosition) {
        snpBuilder.append(snpPosition.getPosition()).append("\t");
        snpBuilder.append(snpPosition.getGenotype()).append("\n");
    }

    private static void recordMatch(StringBuilder matchBuilder, Match match, String typeSetName) {
        matchBuilder.append(typeSetName).append("\t");
        matchBuilder.append(match.getPosition()).append("\t");
        matchBuilder.append(new String(match.getGenotype())).append("\t");
        matchBuilder.append(match.getMatchType()).append("\t");
        matchBuilder.append(match.getDeletionCount()).append("\n");
    }

    private static void recordExon(StringBuilder exonBuilder, TypeSetExonVO exonVO, String typeSetName) {
        exonBuilder.append(typeSetName).append("\t");
        exonBuilder.append(exonVO.getNumber()).append("\t");
        exonBuilder.append(exonVO.getStartPositionAllele()).append("\t");
        exonBuilder.append(exonVO.getStopPositionAllele()).append("\t");
        exonBuilder.append(exonVO.getStartPositionBackBone()).append("\t");
        exonBuilder.append(exonVO.getStopPositionBackBone()).append("\n");
    }

    private static void recordTypeSet(StringBuilder typeSetBuilder, TypeSet typeSet, Map<String, List<String>> ambHap) {
        typeSetBuilder.append(typeSet.getName()).append("\t");
        typeSetBuilder.append(typeSet.getSequence()).append("\n");
        if (typeSet.getDisambigousName() != null && typeSet.getDisambigousName().trim().length() > 0) {
            String name = typeSet.getDisambigousName();
            if (!ambHap.containsKey(name)) {
                ambHap.put(name, new ArrayList());
            }
            ambHap.get(name).add(typeSet.getName());
        }
    }
}

