/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import misc.FileManager;

public class proteinReport {
    public static void main(String[] args) throws Exception {
        File inputFile = new File(args[0]);
        File outputFile = new File(args[1]);
        File rulesetDir = new File(args[2]);
        String[] lines = FileManager.readTextFile(inputFile).split("\n");
        StringBuilder builder = new StringBuilder();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] items = line.split("\\s+");
            String sampleName = items[0].trim();
            String locus = items[1].trim();
            String type1 = items[2].trim();
            String type2 = items[3].trim();
            String seq1 = "";
            String seq2 = "";
            File rulesetFile = proteinReport.getRulesetFile(rulesetDir, locus);
            if (type1.length() > 0 && type1.indexOf("Not_Present") < 0) {
                seq1 = proteinReport.getTypeSeq(rulesetFile, type1);
            }
            if (type2.length() > 0 && type2.indexOf("Not_Present") < 0) {
                seq2 = proteinReport.getTypeSeq(rulesetFile, type2);
            }
            builder.append(sampleName).append("\t").append(locus).append("\t").append(type1).append("\t").append(seq1).append("\t").append(type2).append("\t").append(seq2).append("\n");
            ++n2;
        }
        FileManager.writeTextFile(outputFile, builder.toString(), true);
    }

    private static String getTypeSeq(File rulesetFile, String name) {
        String[] lines = FileManager.readTextFile(rulesetFile).split("\n");
        String type = name;
        if (type.equals("C*17:01:01")) {
            type = "C*17:01:01:02";
        }
        int i = 0;
        while (i < lines.length) {
            String line = lines[i].trim();
            if (line.startsWith(">") && (line.substring(1).equals(type) || line.substring(1).equals(String.valueOf(type) + ":01") || line.substring(1).equals(String.valueOf(type) + ":01:01"))) {
                return lines[i + 1].trim();
            }
            ++i;
        }
        System.out.println("no seq for " + type);
        return "";
    }

    private static File getRulesetFile(File rulesetDir, String locus) {
        if (locus.startsWith("DRB")) {
            return new File(rulesetDir, "DRB1345.fa");
        }
        return new File(rulesetDir, String.valueOf(locus) + ".fa");
    }
}

