/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import misc.FileManager;

public class fastq2ToFasta {
    static String HEADER = "@M00474";
    static String SEPARATER = "000000000-A7PBP";
    static String NEW_HEADER = ">000000";

    public static void main(String[] args) throws Exception {
        File r1File = new File(args[0]);
        File r2File = new File(args[1]);
        File outputFile = new File(args[2]);
        String[] lines1 = FileManager.readTextFile(r1File).split("\n");
        String[] lines2 = FileManager.readTextFile(r2File).split("\n");
        Map<String, String> seqMap1 = fastq2ToFasta.getSeqMap(lines1);
        Map<String, String> seqMap2 = fastq2ToFasta.getSeqMap(lines2);
        StringBuilder out = new StringBuilder();
        long seed = System.nanoTime();
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(seqMap1.keySet());
        Collections.shuffle(names, new Random(seed));
        for (String name : names) {
            out.append(NEW_HEADER).append(name).append("/1").append("\n");
            out.append(seqMap1.get(name)).append("\n");
            out.append(NEW_HEADER).append(name).append("/2").append("\n");
            out.append(seqMap2.get(name)).append("\n");
        }
        FileManager.writeTextFile(outputFile, out.toString(), true);
    }

    private static Map<String, String> getSeqMap(String[] lines) {
        HashMap<String, String> seqMap = new HashMap<String, String>();
        int i = 0;
        while (i < lines.length) {
            String line = lines[i].trim();
            if (line.startsWith(HEADER)) {
                String name = fastq2ToFasta.generateName(line);
                seqMap.put(name, lines[i + 1].trim());
                ++i;
            }
            ++i;
        }
        return seqMap;
    }

    private static String generateName(String line) {
        String[] items = line.split("\\s+")[0].split(SEPARATER);
        String name = items[1].trim();
        return name;
    }
}

