/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.MatchEntry;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class TypeComparision {
    public static void main(String[] args) throws Exception {
        File gemsOutput = new File(args[0]);
        File pacBioOutput = new File(args[1]);
        File miSeqOutput = new File(args[2]);
        File output = new File(args[3]);
        Map<String, Map<String, List<String>>> gemsSampleResult = TypeComparision.loadGeMSSampleResult(gemsOutput);
        Map<String, Map<String, List<MatchEntry>>> pacBioSampleResult = TypeComparision.loadPacBioSampleResult(pacBioOutput);
        Map<String, Map<String, List<String>>> miSeqSampleResult = TypeComparision.loadMiseqSampleResult(miSeqOutput);
        StringBuilder report = new StringBuilder();
        report.append("Sample").append("\t").append("Locus").append("\t");
        report.append("rawType1").append("\t").append("rawType2").append("\t");
        report.append("MiseqResolvingType1").append("\t").append("MiseqResolvingType2").append("\t");
        report.append("PacBioType1").append("\t").append("PacBioType2").append("\t");
        report.append("Type1-Discrep").append("\t").append("Type2-Discrep").append("\n");
        TypeComparision.outputComparison(gemsSampleResult, miSeqSampleResult, pacBioSampleResult, report);
        FileManager.writeTextFile(output, report.toString(), true);
    }

    private static void outputComparison(Map<String, Map<String, List<String>>> gemsSampleResult, Map<String, Map<String, List<String>>> miSeqSampleResult, Map<String, Map<String, List<MatchEntry>>> pacBioSampleResult, StringBuilder report) {
        for (String sample : gemsSampleResult.keySet()) {
            Map<String, List<String>> locusMap = gemsSampleResult.get(sample);
            Map<String, List<String>> miSeqLocusMap = miSeqSampleResult.get(sample);
            Map<String, List<MatchEntry>> pacBioLocusMap = pacBioSampleResult.get(sample);
            for (String locus : locusMap.keySet()) {
                List<String> rawTypes = locusMap.get(locus);
                report.append(sample).append("\t").append(locus).append("\t");
                for (String rawType : rawTypes) {
                    report.append(rawType).append("\t");
                }
                if (rawTypes.size() == 0) {
                    report.append("").append("\t");
                    report.append("").append("\t");
                }
                TypeComparision.addMiseqTypes(miSeqLocusMap, locus, report);
                TypeComparision.addPacBioTypes(pacBioLocusMap, locus, report);
                report.append("\n");
            }
        }
    }

    private static void addPacBioTypes(Map<String, List<MatchEntry>> pacBioLocusMap, String locus, StringBuilder report) {
        if (pacBioLocusMap == null) {
            report.append("").append("\t");
            report.append("").append("\t");
            return;
        }
        List<MatchEntry> types = pacBioLocusMap.get(locus);
        if (types == null) {
            report.append("").append("\t");
            report.append("").append("\t");
            return;
        }
        for (MatchEntry entry : types) {
            report.append(entry.getType()).append("\t");
        }
        if (types.size() == 0) {
            report.append("").append("\t");
            report.append("").append("\t");
        } else if (types.size() == 1) {
            report.append("").append("\t");
        }
        for (MatchEntry entry : types) {
            report.append(entry.getMatchDetail() == null ? "" : entry.getMatchDetail()).append("\t");
        }
        if (types.size() == 0) {
            report.append("").append("\t");
            report.append("").append("\t");
        } else if (types.size() == 1) {
            report.append("").append("\t");
        }
    }

    private static void addMiseqTypes(Map<String, List<String>> miSeqLocusMap, String locus, StringBuilder report) {
        if (miSeqLocusMap == null) {
            report.append("").append("\t");
            report.append("").append("\t");
            return;
        }
        List<String> types = miSeqLocusMap.get(locus);
        if (types == null) {
            report.append("").append("\t");
            report.append("").append("\t");
            return;
        }
        for (String type : types) {
            report.append(type).append("\t");
        }
        if (types.size() == 0) {
            report.append("").append("\t");
            report.append("").append("\t");
            return;
        }
        if (types.size() == 1) {
            report.append("").append("\t");
            return;
        }
    }

    private static Map<String, Map<String, List<String>>> loadGeMSSampleResult(File gemsOutput) {
        LinkedHashMap<String, Map<String, List<String>>> gemsSampleResult = new LinkedHashMap<String, Map<String, List<String>>>();
        String[] lines = FileManager.readTextFile(gemsOutput).split("\n");
        int i = 1;
        while (i < lines.length) {
            String[] items = lines[i].trim().split("\t");
            if (items.length >= 2 && items[0].trim().indexOf("-CIP") <= 0) {
                String name = TypeComparision.fixGemsName(items[0].trim());
                String locus = items[1].trim();
                if (locus.length() <= 1) {
                    if (!gemsSampleResult.containsKey(name)) {
                        gemsSampleResult.put(name, new LinkedHashMap());
                    }
                    if (!((Map)gemsSampleResult.get(name)).containsKey(locus)) {
                        ((Map)gemsSampleResult.get(name)).put(locus, new ArrayList());
                    }
                    String type1 = null;
                    String type2 = null;
                    if (items.length >= 3 && items[2].trim().length() > 0) {
                        type1 = items[2].trim();
                        ((List)((Map)gemsSampleResult.get(name)).get(locus)).add(type1);
                    }
                    if (items.length >= 4 && items[3].trim().length() > 0) {
                        type2 = items[3].trim();
                        ((List)((Map)gemsSampleResult.get(name)).get(locus)).add(type2);
                    }
                }
            }
            ++i;
        }
        return gemsSampleResult;
    }

    private static String fixGemsName(String fullName) {
        return fullName.split("-")[0];
    }

    private static Map<String, Map<String, List<MatchEntry>>> loadPacBioSampleResult(File pacBioOutput) {
        LinkedHashMap<String, Map<String, List<MatchEntry>>> pacBioSampleResult = new LinkedHashMap<String, Map<String, List<MatchEntry>>>();
        String[] lines = FileManager.readTextFile(pacBioOutput).split("\n");
        int i = 1;
        while (i < lines.length) {
            String[] items = lines[i].trim().split("\t");
            if (items.length >= 2) {
                String name = items[0].trim();
                String locus = items[1].trim();
                if (locus.length() <= 1) {
                    if (!pacBioSampleResult.containsKey(name)) {
                        pacBioSampleResult.put(name, new LinkedHashMap());
                    }
                    if (!((Map)pacBioSampleResult.get(name)).containsKey(locus)) {
                        ((Map)pacBioSampleResult.get(name)).put(locus, new ArrayList());
                    }
                    MatchEntry matchEntry = null;
                    if (items.length >= 4 && items[3].trim().length() > 0) {
                        System.out.println(lines[i]);
                        matchEntry = new MatchEntry();
                        String type = items[3].trim();
                        if (items.length >= 7 && items[6].trim().length() > 0) {
                            type = String.valueOf(type) + "," + items[6].trim();
                        }
                        matchEntry.setType(type);
                        matchEntry.setDiscrep(Double.valueOf(items[5].trim()));
                        if (items.length >= 8 && items[7].trim().length() > 0) {
                            matchEntry.setMatchDetail(items[7].trim());
                        }
                        ((List)((Map)pacBioSampleResult.get(name)).get(locus)).add(matchEntry);
                    }
                }
            }
            ++i;
        }
        TypeComparision.orderAndRefineResult(pacBioSampleResult);
        return pacBioSampleResult;
    }

    private static void orderAndRefineResult(Map<String, Map<String, List<MatchEntry>>> pacBioSampleResult) {
        for (String sample : pacBioSampleResult.keySet()) {
            Map<String, List<MatchEntry>> sampleResult = pacBioSampleResult.get(sample);
            for (String locus : sampleResult.keySet()) {
                List<MatchEntry> locusResult = sampleResult.get(locus);
                List<Object> newLocusResult = new ArrayList();
                if (locusResult.size() == 2 && locusResult.get(0).getType().compareTo(locusResult.get(1).getType()) > 0) {
                    newLocusResult.add(locusResult.get(1));
                    newLocusResult.add(locusResult.get(0));
                    sampleResult.put(locus, newLocusResult);
                }
                if (locusResult.size() <= 2) continue;
                newLocusResult = TypeComparision.getBestTwo(locusResult);
                sampleResult.put(locus, newLocusResult);
            }
        }
    }

    private static List<MatchEntry> getBestTwo(List<MatchEntry> locusResult) {
        ArrayList<MatchEntry> newLocusResult = new ArrayList<MatchEntry>();
        System.out.println("-----------");
        for (MatchEntry match : locusResult) {
            System.out.println(match.getType());
        }
        double minMisMatch = 100.0;
        MatchEntry bestEntry1 = null;
        for (MatchEntry match : locusResult) {
            if (!(match.getDiscrep() < minMisMatch)) continue;
            bestEntry1 = match;
            minMisMatch = match.getDiscrep();
        }
        System.out.println("bestEntry1=" + bestEntry1.getType() + " " + bestEntry1.getDiscrep());
        minMisMatch = 100.0;
        MatchEntry bestEntry2 = null;
        for (MatchEntry match : locusResult) {
            if (match.getType().equals(bestEntry1.getType()) || !(match.getDiscrep() < minMisMatch)) continue;
            bestEntry2 = match;
            minMisMatch = match.getDiscrep();
        }
        System.out.println("bestEntry2=" + bestEntry2.getType() + " " + bestEntry2.getDiscrep());
        if (bestEntry1.getType().compareTo(bestEntry2.getType()) > 0) {
            newLocusResult.add(bestEntry2);
            newLocusResult.add(bestEntry1);
        } else {
            newLocusResult.add(bestEntry1);
            newLocusResult.add(bestEntry2);
        }
        return newLocusResult;
    }

    private static Map<String, Map<String, List<String>>> loadMiseqSampleResult(File miSeqOutput) {
        LinkedHashMap<String, Map<String, List<String>>> miSeqSampleResult = new LinkedHashMap<String, Map<String, List<String>>>();
        String[] lines = FileManager.readTextFile(miSeqOutput).split("\n");
        int i = 2;
        while (i < lines.length) {
            String[] items = lines[i].trim().split("\t");
            if (items.length >= 2) {
                String name = TypeComparision.fixGemsName(items[0].trim());
                String locus = items[1].trim();
                if (locus.length() <= 1) {
                    if (!miSeqSampleResult.containsKey(name)) {
                        miSeqSampleResult.put(name, new LinkedHashMap());
                    }
                    if (!((Map)miSeqSampleResult.get(name)).containsKey(locus)) {
                        ((Map)miSeqSampleResult.get(name)).put(locus, new ArrayList());
                    }
                    String type1 = null;
                    String type2 = null;
                    if (items.length >= 3 && items[2].trim().length() > 0) {
                        type1 = items[2].trim();
                        ((List)((Map)miSeqSampleResult.get(name)).get(locus)).add(type1);
                    }
                    if (items.length >= 4 && items[3].trim().length() > 0) {
                        type2 = items[3].trim();
                        ((List)((Map)miSeqSampleResult.get(name)).get(locus)).add(type2);
                    }
                }
            }
            ++i;
        }
        return miSeqSampleResult;
    }
}

