/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.LocusExon;
import fileOperation.LocusExonResult;
import fileOperation.MatchStatistics;
import fileOperation.ParseFastaByHapType7;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import misc.FileManager;

public class SummarizeTypingResult {
    static String DPA1 = "DPA1";
    static String DPB1 = "DPB1";
    static String DQA1 = "DQA1";
    static String DQB1 = "DQB1";
    static String HLAA = "A";
    static String HLAB = "B";
    static String HLAC = "C";
    static String SUDO = "sudo";
    static String DQBSUDO = "DQBsudo";
    static String DPBSUDO = "DPBsudo";
    static String DQASUDO = "DQAsudo";
    static String ASUDO = "HLAAsudo";
    static String BSUDO = "HLABsudo";
    static String CSUDO = "HLACsudo";
    static String DRB1345 = "DRB1345";
    static String DRB1 = "DRB1";
    static String DRB345 = "DRB345";
    static String DRB3 = "DRB3";
    static String DRB4 = "DRB4";
    static String DRB5 = "DRB5";
    static String EXON2 = "exon2";
    static String EXON3 = "exon3";
    static String EXON4 = "exon4";
    static String EXON23 = "exon23";
    static String NO_RESULT = "No Result";
    static String HAP_AMB_TXT = "-hap-amb.txt";
    static int MIN_SUPPORT_READS = 20;
    static int FIRM_SUPPORT_READS = 30;
    static String HOMOZYGOUS = "homozygous";
    static int MAJOR_DIFF_COUNT = 2;
    static String NO_PERFECT_RESULT = "No PERFECT MATCH";
    static boolean EXPAND_HAP_AMBGUITY = true;
    static boolean DRB_EXON3_IGNORE_BEGINNING = true;
    static String SUMMARY_FN = "summary.txt";
    static String CANADATE_FN = "candidateType.csv";
    static String DETAIL_ORDERED_FN = "detail-ordered.txt";
    static String SEPARATOR = "&&";
    static String IMAGE_URL_PREFIX = "https://dl.dropboxusercontent.com/u/75753247/";
    static String COVERAGE = "Coverage";
    static String ALIGNMENT = "Alignment";
    static int ABC23_BOUNDARY = 343;
    static int POS_NUMBER_LENGTH = 3;
    private static final int LINE_WIDTH = 2;
    private static final int TABLE_NAME_WIDTH = 180;
    private static String[] HEADERS_CLASSI = new String[]{"Hap Type", "Exon2 Match Pairs", "Exon3 Match Pairs", "Coverage", "Positions w >50% mismatch", "#Bridge Reads"};
    private static String[] HEADERS_CLASSII = new String[]{"Hap Type", "Exon Match Pairs", "Coverage", "Positions w >50% mismatch"};
    private static final int TYPE_NAME_WIDTH = 180;
    private static final int IMAGE_WIDTH = 200;
    private static final int ALIGNMENT_WIDTH_SINGLE_EXON = 6200;
    private static final int ALIGNMENT_WIDTH_COMBINE_EXON = 12200;
    private static final int ALIGNMENT_WIDTH = 1000;
    private static final int IMAGE_HEIGHT = 200;
    private static final int BOADER_WIDTH = 20;
    private static final int STRING_HEIGHT = 20;
    private static final int MARKER_SIZE = 2;
    private static final int OFFSET = 0;

    public static void main(String[] args) throws Exception {
        File detailedResultFile = new File(args[0]);
        File hapTypeRoot = new File(args[1]);
        File outputDir = new File(args[2]);
        boolean useNatureOrderWhenNotSure = new Boolean(args[3]);
        int orderBy = new Integer(args[4]);
        boolean generateImage = new Boolean(args[5]);
        boolean forWebService = new Boolean(args[6]);
        String[] detailedResult = FileManager.readTextFile(detailedResultFile).split("\n");
        Map<String, List<LocusExon>> allLocus = SummarizeTypingResult.initLocusMap();
        HashMap<String, Map<String, String>> summaryMap = new HashMap<String, Map<String, String>>();
        ArrayList<String> candidateTypes = new ArrayList<String>();
        HashMap<String, Map<String, Map<String, List<String>>>> detailMap = new HashMap<String, Map<String, Map<String, List<String>>>>();
        File imageDir = null;
        if (!(!generateImage || (imageDir = new File(outputDir, "image")).exists() && imageDir.isDirectory())) {
            imageDir.mkdirs();
        }
        for (String locus : allLocus.keySet()) {
            System.out.println("memory usage 0: " + (double)Runtime.getRuntime().totalMemory() / 1.073741824E9);
            System.out.println("--------------process " + locus);
            summaryMap.put(locus, new HashMap());
            detailMap.put(locus, new HashMap());
            List<LocusExon> locusExons = allLocus.get(locus);
            LocusExon majorExon = locusExons.get(0);
            LocusExon minorExon = locusExons.size() > 1 ? locusExons.get(1) : null;
            String representString1 = String.valueOf(locus) + "-" + majorExon.getExon();
            File hapTypeFile1 = new File(hapTypeRoot, String.valueOf(representString1) + ".fa");
            File hapAmbFile1 = new File(hapTypeRoot, String.valueOf(hapTypeFile1.getName().substring(0, hapTypeFile1.getName().length() - 3)) + HAP_AMB_TXT);
            HashMap<String, Map<String, String>> allMajorRefTypeString = new HashMap<String, Map<String, String>>();
            Map<String, Map<String, MatchStatistics>> allMajorResult = SummarizeTypingResult.extractForLocusExon(detailedResult, representString1, (Map)detailMap.get(locus), allMajorRefTypeString);
            if (allMajorResult.size() == 0) continue;
            Map<String, LocusExonResult> locusExonResultMajor = SummarizeTypingResult.analyzeResult(allMajorResult, hapTypeFile1, hapAmbFile1, majorExon, useNatureOrderWhenNotSure, imageDir, (Map)detailMap.get(locus), representString1, allMajorRefTypeString);
            SummarizeTypingResult.setCanadidateType(locusExonResultMajor, locus, candidateTypes, majorExon, allMajorResult);
            Map<String, LocusExonResult> locusExonResultMinor = null;
            Map<String, LocusExonResult> locusExonResultCombined = null;
            if (minorExon != null) {
                String representString2 = String.valueOf(locus) + "-" + minorExon.getExon();
                File hapTypeFile2 = new File(hapTypeRoot, String.valueOf(representString2) + ".fa");
                File hapAmbFile2 = new File(hapTypeRoot, String.valueOf(hapTypeFile2.getName().substring(0, hapTypeFile2.getName().length() - 3)) + HAP_AMB_TXT);
                HashMap<String, Map<String, String>> allMinorRefTypeString = new HashMap<String, Map<String, String>>();
                Map<String, Map<String, MatchStatistics>> allMinorResult = SummarizeTypingResult.extractForLocusExon(detailedResult, representString2, (Map)detailMap.get(locus), allMinorRefTypeString);
                if (allMinorResult.size() > 0) {
                    locusExonResultMinor = SummarizeTypingResult.analyzeResult(allMinorResult, hapTypeFile2, hapAmbFile2, minorExon, useNatureOrderWhenNotSure, imageDir, (Map)detailMap.get(locus), representString2, allMinorRefTypeString);
                    SummarizeTypingResult.setCanadidateType(locusExonResultMinor, locus, candidateTypes, minorExon, allMinorResult);
                    locusExonResultCombined = SummarizeTypingResult.combineExonResult(locusExonResultMajor, locusExonResultMinor, hapTypeFile1, hapAmbFile1, hapTypeFile2, hapAmbFile2);
                    if (majorExon.getLocus().equals(DRB1345)) {
                        SummarizeTypingResult.combineExonResultForOtherTypes(locusExonResultCombined, locusExonResultMajor, locusExonResultMinor, hapTypeFile1, hapAmbFile1, hapTypeFile2, hapAmbFile2);
                    }
                }
            }
            System.out.println("memory usage 1: " + (double)Runtime.getRuntime().totalMemory() / 1.073741824E9);
            SummarizeTypingResult.setOutput((Map)summaryMap.get(locus), locus, majorExon, minorExon, locusExonResultMajor, locusExonResultMinor, locusExonResultCombined, forWebService);
        }
        SummarizeTypingResult.outputSummaryAndDetails(outputDir, summaryMap, detailMap, orderBy, forWebService, candidateTypes);
    }

    private static void setCanadidateType(Map<String, LocusExonResult> locusExonResults, String locus, List<String> candidateTypes, LocusExon exon, Map<String, Map<String, MatchStatistics>> allResult) {
        for (String sample : locusExonResults.keySet()) {
            StringBuilder builder;
            LocusExonResult locusExonResult = locusExonResults.get(sample);
            for (String type : locusExonResult.getCandidateTypes()) {
                builder = new StringBuilder();
                builder.append(sample).append(",");
                if (locus.equals(DRB1345)) {
                    builder.append(DRB1).append(",");
                } else {
                    builder.append(locus).append(",");
                }
                builder.append(exon.getExon()).append(",");
                builder.append(type).append(",");
                builder.append(allResult.get(sample).get(type).getNumPairsSupport()).append(",");
                builder.append(allResult.get(sample).get(type).getNumPosGoodCoverage()).append("/").append(allResult.get(sample).get(type).getExonSize()).append(",");
                if (exon.getExon().equals(EXON23)) {
                    builder.append(allResult.get(sample).get(type).getBridgeCount()).append(",");
                } else {
                    builder.append("").append(",");
                }
                candidateTypes.add(builder.toString());
            }
            if (!locus.equals(DRB1345)) continue;
            for (String type : locusExonResult.getOtherCandidateTypes()) {
                builder = new StringBuilder();
                builder.append(sample).append(",");
                builder.append(DRB345).append(",");
                builder.append(exon.getExon()).append(",");
                builder.append(type).append(",");
                builder.append(allResult.get(sample).get(type).getNumPairsSupport()).append(",");
                builder.append(allResult.get(sample).get(type).getNumPosGoodCoverage()).append("/").append(allResult.get(sample).get(type).getExonSize()).append(",");
                builder.append("").append(",");
                candidateTypes.add(builder.toString());
            }
        }
    }

    private static void setDataUsed(List<String> info, LocusExonResult locusExonResult) {
        for (String line : info) {
            if (line.indexOf("usedTotaldata") < 0) continue;
            locusExonResult.setDataUsed(line.trim());
        }
    }

    private static void combineExonResultForOtherTypes(Map<String, LocusExonResult> locusExonResultCombined, Map<String, LocusExonResult> locusExonResultMajor, Map<String, LocusExonResult> locusExonResultMinor, File hapTypeFile1, File hapAmbFile1, File hapTypeFile2, File hapAmbFile2) {
        List<String> allMajorHapTypes = SummarizeTypingResult.getAllTypes(hapTypeFile1);
        List<String> allMinorHapTypes = SummarizeTypingResult.getAllTypes(hapTypeFile2);
        List<String> minorMissingTypes = SummarizeTypingResult.getMissTypes(allMajorHapTypes, allMinorHapTypes);
        Map<String, List<String>> majorAmbTypes = SummarizeTypingResult.getAmbTypes(hapAmbFile1);
        Map<String, List<String>> minorAmbTypes = SummarizeTypingResult.getAmbTypes(hapAmbFile2);
        for (String sample : locusExonResultMajor.keySet()) {
            LocusExonResult sampleCombineExonResult = locusExonResultCombined.get(sample);
            LocusExonResult major = locusExonResultMajor.get(sample);
            LocusExonResult minor = locusExonResultMinor.get(sample);
            if (major.getOtherTypes() == null || major.getOtherTypes().length() == 0) continue;
            String[] majorTypes = major.getOtherTypes().split(",");
            String majorType1 = majorTypes[0];
            String majorType2 = majorTypes.length == 1 ? majorTypes[0] : majorTypes[1];
            String minorType1 = null;
            String minorType2 = null;
            if (minor.getOtherTypes() != null && minor.getOtherTypes().length() > 0) {
                String[] minorTypes = minor.getOtherTypes().split(",");
                minorType1 = minorTypes[0];
                minorType2 = minorTypes.length == 1 ? minorTypes[0] : minorTypes[1];
            }
            List<String> majorHapTypeGroup1 = SummarizeTypingResult.getExpandedHapType(majorType1, majorAmbTypes);
            List<String> majorHapTypeGroup2 = SummarizeTypingResult.getExpandedHapType(majorType2, majorAmbTypes);
            if (minorType1 != null && minorType2 != null) {
                List<String> minorHapTypeGroup1 = SummarizeTypingResult.getExpandedHapType(minorType1, minorAmbTypes);
                List<String> minorHapTypeGroup2 = SummarizeTypingResult.getExpandedHapType(minorType2, minorAmbTypes);
                boolean common11 = SummarizeTypingResult.checkCommon(majorHapTypeGroup1, minorHapTypeGroup1);
                boolean common12 = SummarizeTypingResult.checkCommon(majorHapTypeGroup1, minorHapTypeGroup2);
                boolean common21 = SummarizeTypingResult.checkCommon(majorHapTypeGroup2, minorHapTypeGroup1);
                boolean common22 = SummarizeTypingResult.checkCommon(majorHapTypeGroup2, minorHapTypeGroup2);
                List<String> fileteredName1 = null;
                List<String> fileteredName2 = null;
                boolean isMajorHomo = majorType1.equals(majorType2);
                if (common11 && !common12 || common22 && !common21) {
                    fileteredName1 = SummarizeTypingResult.filterWithMinorType(majorHapTypeGroup1, minorHapTypeGroup1, minorHapTypeGroup1, minorMissingTypes, sampleCombineExonResult);
                    fileteredName2 = SummarizeTypingResult.filterWithMinorType(majorHapTypeGroup2, minorHapTypeGroup2, minorHapTypeGroup2, minorMissingTypes, sampleCombineExonResult);
                } else if (common12 && !common11 || common21 && !common22) {
                    fileteredName1 = SummarizeTypingResult.filterWithMinorType(majorHapTypeGroup1, minorHapTypeGroup2, minorHapTypeGroup2, minorMissingTypes, sampleCombineExonResult);
                    fileteredName2 = SummarizeTypingResult.filterWithMinorType(majorHapTypeGroup2, minorHapTypeGroup1, minorHapTypeGroup1, minorMissingTypes, sampleCombineExonResult);
                } else if (isMajorHomo) {
                    fileteredName1 = SummarizeTypingResult.filterWithMinorType(majorHapTypeGroup1, minorHapTypeGroup1, minorHapTypeGroup1, minorMissingTypes, sampleCombineExonResult);
                    fileteredName2 = SummarizeTypingResult.filterWithMinorType(majorHapTypeGroup2, minorHapTypeGroup2, minorHapTypeGroup2, minorMissingTypes, sampleCombineExonResult);
                } else {
                    fileteredName1 = SummarizeTypingResult.filterWithMinorType(majorHapTypeGroup1, minorHapTypeGroup1, minorHapTypeGroup2, minorMissingTypes, sampleCombineExonResult);
                    fileteredName2 = SummarizeTypingResult.filterWithMinorType(majorHapTypeGroup2, minorHapTypeGroup1, minorHapTypeGroup2, minorMissingTypes, sampleCombineExonResult);
                    if (!minorType1.equals(minorType2)) {
                        SummarizeTypingResult.logForAmbiguities(fileteredName1, minorHapTypeGroup1, minorHapTypeGroup2, sampleCombineExonResult, true);
                        SummarizeTypingResult.logForAmbiguities(fileteredName2, minorHapTypeGroup1, minorHapTypeGroup2, sampleCombineExonResult, true);
                    }
                }
                if (String.valueOf(String.valueOf(SummarizeTypingResult.format(fileteredName1, majorType1))).equals(String.valueOf(SummarizeTypingResult.format(fileteredName2, majorType2)))) {
                    SummarizeTypingResult.logForUnknowns(fileteredName1, minorMissingTypes, sampleCombineExonResult, true);
                } else {
                    SummarizeTypingResult.logForUnknowns(fileteredName1, minorMissingTypes, sampleCombineExonResult, true);
                    SummarizeTypingResult.logForUnknowns(fileteredName2, minorMissingTypes, sampleCombineExonResult, true);
                }
                sampleCombineExonResult.setOtherTypes(String.valueOf(String.valueOf(SummarizeTypingResult.format(fileteredName1, majorType1))) + SEPARATOR + String.valueOf(SummarizeTypingResult.format(fileteredName2, majorType2)));
            } else {
                sampleCombineExonResult.setOtherTypes(String.valueOf(String.valueOf(SummarizeTypingResult.format(majorHapTypeGroup1, majorType1))) + SEPARATOR + String.valueOf(SummarizeTypingResult.format(majorHapTypeGroup2, majorType2)));
            }
            locusExonResultCombined.put(sample, sampleCombineExonResult);
        }
    }

    private static void outputSummaryAndDetails(File outputDir, Map<String, Map<String, String>> summaryMap, Map<String, Map<String, Map<String, List<String>>>> detailMap, int orderBy, boolean forWebService, List<String> candidateTypes) {
        if (orderBy == 3) {
            SummarizeTypingResult.writeSeparateOutput(outputDir, summaryMap, detailMap, forWebService);
        } else if (orderBy == 2) {
            SummarizeTypingResult.writeOut(outputDir, summaryMap, detailMap, forWebService);
        } else {
            SummarizeTypingResult.OutputBySampleOrder(outputDir, summaryMap, detailMap, forWebService);
        }
        if (forWebService) {
            SummarizeTypingResult.writeCandidateTypes(outputDir, candidateTypes);
        }
    }

    private static void writeCandidateTypes(File outputDir, List<String> candidateTypes) {
        File candidateFile = new File(outputDir, CANADATE_FN);
        StringBuilder builder = new StringBuilder();
        builder.append("Sample,").append("Locus,").append("Exon,").append("Type,").append("ReadPairs,").append("Coverage,").append("BridgeCount\n");
        for (String type : candidateTypes) {
            builder.append(type).append("\n");
        }
        FileManager.writeTextFile(candidateFile, builder.toString(), true);
    }

    private static void writeSeparateOutput(File outputDir, Map<String, Map<String, String>> summaryMap, Map<String, Map<String, Map<String, List<String>>>> detailMap, boolean forWebService) {
        for (String locus : summaryMap.keySet()) {
            File summaryFile = new File(outputDir, String.valueOf(locus) + "-" + SUMMARY_FN);
            File detailFile = new File(outputDir, String.valueOf(locus) + "-" + DETAIL_ORDERED_FN);
            StringBuilder summary = new StringBuilder();
            if (forWebService) {
                summary.append("Sample\t").append("Locus\t").append("Exon 2\t").append("Exon 2 A\t").append("Exon 2 B\t").append("Coverage 2\t").append("Alignment 2\t").append("Other Types 2\t").append("Validated 2\t").append("Info 2\t");
                summary.append("Exon 3\t").append("Exon 3 A\t").append("Exon 3 B\t").append("Coverage 3\t").append("Alignment 3\t").append("Other Types 3\t").append("Validated 3\t").append("Info 3\t");
                summary.append("Combined\t").append("Combined A\t").append("Combined B\t").append("Validated Combined\t").append("Type Details\n");
            } else {
                summary.append("Sample\t").append("locus\t").append("Exon #\t").append("Type1\t").append("Type2\t").append("OtherTypes\t").append("isFirm\t").append("log\n");
            }
            StringBuilder detail = new StringBuilder();
            detail.append("Sample\t").append("locus\t").append("Hap Type\t").append("#Pairs Support Match\t").append("#Pairs Perfect Match\t").append("#Positions w >=10x Coverage\t").append("Positions w >50% mismatch\t").append("#Pairs Completely Cover Exon\t").append("#Bridge Reads\t").append("index\n");
            Map<String, String> nextLevelSummaryMap = summaryMap.get(locus);
            Object[] namesLevel2 = nextLevelSummaryMap.keySet().toArray();
            Arrays.sort(namesLevel2);
            Object[] objectArray = namesLevel2;
            int n = namesLevel2.length;
            int n2 = 0;
            while (n2 < n) {
                Object name2 = objectArray[n2];
                summary.append(nextLevelSummaryMap.get(name2)).append("\n");
                Map<String, List<String>> locusExonMap = detailMap.get(locus).get(name2);
                Object[] namesLevel3 = locusExonMap.keySet().toArray();
                Arrays.sort(namesLevel3);
                Object[] objectArray2 = namesLevel3;
                int n3 = namesLevel3.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object name3 = objectArray2[n4];
                    List<String> data = locusExonMap.get(name3);
                    for (String line : data) {
                        detail.append(line).append("\n");
                    }
                    detail.append("\n");
                    ++n4;
                }
                ++n2;
            }
            FileManager.writeTextFile(summaryFile, summary.toString(), true);
            FileManager.writeTextFile(detailFile, detail.toString(), true);
        }
    }

    private static void OutputBySampleOrder(File outputDir, Map<String, Map<String, String>> summaryMap, Map<String, Map<String, Map<String, List<String>>>> detailMap, boolean forWebService) {
        HashMap<String, Map<String, String>> newSummaryMap = new HashMap<String, Map<String, String>>();
        HashMap<String, Map<String, Map<String, List<String>>>> newDetailMap = new HashMap<String, Map<String, Map<String, List<String>>>>();
        for (String locus : summaryMap.keySet()) {
            Map<String, String> resultMap = summaryMap.get(locus);
            for (String sample : resultMap.keySet()) {
                if (!newSummaryMap.containsKey(sample)) {
                    newSummaryMap.put(sample, new HashMap());
                    newDetailMap.put(sample, new HashMap());
                }
                ((Map)newSummaryMap.get(sample)).put(locus, resultMap.get(sample));
                ((Map)newDetailMap.get(sample)).put(locus, detailMap.get(locus).get(sample));
            }
        }
        SummarizeTypingResult.writeOut(outputDir, newSummaryMap, newDetailMap, forWebService);
    }

    private static void writeOut(File outputDir, Map<String, Map<String, String>> summaryMap, Map<String, Map<String, Map<String, List<String>>>> detailMap, boolean forWebService) {
        Object[] names = summaryMap.keySet().toArray();
        Arrays.sort(names);
        StringBuilder summary = new StringBuilder();
        if (forWebService) {
            summary.append("Sample\t").append("Locus\t").append("Exon 2\t").append("Exon 2 A\t").append("Exon 2 B\t").append("Coverage 2\t").append("Alignment 2\t").append("Other Types 2\t").append("Validated 2\t").append("Info 2\t");
            summary.append("Exon 3\t").append("Exon 3 A\t").append("Exon 3 B\t").append("Coverage 3\t").append("Alignment 3\t").append("Other Types 3\t").append("Validated 3\t").append("Info 3\t");
            summary.append("Combined\t").append("Combined A\t").append("Combined B\t").append("Validated Combined\t").append("Type Details\n");
        } else {
            summary.append("Sample\t").append("locus\t").append("Exon #\t").append("Type1\t").append("Type2\t").append("OtherTypes\t").append("isFirm\t").append("log\t").append("Exon #\t").append("Type1\t").append("Type2\t").append("OtherTypes\t").append("isFirm\t").append("log\t").append("Combined Exon\t").append("Type1\t").append("Type2\t").append("BothExonConsistent\t").append("log\n");
        }
        StringBuilder detail = new StringBuilder();
        detail.append("Sample\t").append("locus\t").append("Hap Type\t").append("#Pairs Support Match\t").append("#Pairs Perfect Match\t").append("#Positions w >=10x Coverage\t").append("Positions w >50% mismatch\t").append("#Pairs Completely Cover Exon\t").append("#Bridge Reads\t").append("index\n");
        Object[] objectArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            Object name = objectArray[n2];
            Map<String, String> nextLevelSummaryMap = summaryMap.get(name);
            Object[] namesLevel2 = nextLevelSummaryMap.keySet().toArray();
            Arrays.sort(namesLevel2);
            Object[] objectArray2 = namesLevel2;
            int n3 = namesLevel2.length;
            int n4 = 0;
            while (n4 < n3) {
                Object name2 = objectArray2[n4];
                summary.append(nextLevelSummaryMap.get(name2)).append("\n");
                Map<String, List<String>> locusExonMap = detailMap.get(name).get(name2);
                Object[] namesLevel3 = locusExonMap.keySet().toArray();
                Arrays.sort(namesLevel3);
                Object[] objectArray3 = namesLevel3;
                int n5 = namesLevel3.length;
                int n6 = 0;
                while (n6 < n5) {
                    Object name3 = objectArray3[n6];
                    List<String> data = locusExonMap.get(name3);
                    for (String line : data) {
                        detail.append(line).append("\n");
                    }
                    detail.append("\n");
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        File summaryFile = new File(outputDir, SUMMARY_FN);
        File detailFile = new File(outputDir, DETAIL_ORDERED_FN);
        FileManager.writeTextFile(summaryFile, summary.toString(), true);
        FileManager.writeTextFile(detailFile, detail.toString(), true);
    }

    public static Map<String, LocusExonResult> combineExonResult(Map<String, LocusExonResult> locusExonResultMajor, Map<String, LocusExonResult> locusExonResultMinor, File hapTypeFile1, File hapAmbFile1, File hapTypeFile2, File hapAmbFile2) {
        LinkedHashMap<String, LocusExonResult> locusExonResultCombined = new LinkedHashMap<String, LocusExonResult>();
        List<String> allMajorHapTypes = SummarizeTypingResult.getAllTypes(hapTypeFile1);
        List<String> allMinorHapTypes = SummarizeTypingResult.getAllTypes(hapTypeFile2);
        List<String> minorMissingTypes = SummarizeTypingResult.getMissTypes(allMajorHapTypes, allMinorHapTypes);
        Map<String, List<String>> majorAmbTypes = SummarizeTypingResult.getAmbTypes(hapAmbFile1);
        Map<String, List<String>> minorAmbTypes = SummarizeTypingResult.getAmbTypes(hapAmbFile2);
        for (String sample : locusExonResultMajor.keySet()) {
            LocusExonResult sampleCombineExonResult = new LocusExonResult();
            LocusExonResult major = locusExonResultMajor.get(sample);
            LocusExonResult minor = locusExonResultMinor.get(sample);
            String majorType1 = major.getType1();
            String majorType2 = major.getType2();
            String minorType1 = minor.getType1();
            String minorType2 = minor.getType2();
            if (majorType1 == null || majorType2 == null) {
                locusExonResultCombined.put(sample, sampleCombineExonResult);
                continue;
            }
            List<String> majorHapTypeGroup1 = SummarizeTypingResult.getExpandedHapType(majorType1, majorAmbTypes);
            List<String> majorHapTypeGroup2 = SummarizeTypingResult.getExpandedHapType(majorType2, majorAmbTypes);
            if (minorType1 != null && minorType2 != null) {
                List<String> minorHapTypeGroup1 = SummarizeTypingResult.getExpandedHapType(minorType1, minorAmbTypes);
                List<String> minorHapTypeGroup2 = SummarizeTypingResult.getExpandedHapType(minorType2, minorAmbTypes);
                boolean common11 = SummarizeTypingResult.checkCommon(majorHapTypeGroup1, minorHapTypeGroup1);
                boolean common12 = SummarizeTypingResult.checkCommon(majorHapTypeGroup1, minorHapTypeGroup2);
                boolean common21 = SummarizeTypingResult.checkCommon(majorHapTypeGroup2, minorHapTypeGroup1);
                boolean common22 = SummarizeTypingResult.checkCommon(majorHapTypeGroup2, minorHapTypeGroup2);
                List<String> fileteredName1 = null;
                List<String> fileteredName2 = null;
                boolean isMajorHomo = major.getType1().equals(major.getType2());
                if (common11 && !common12 || common22 && !common21) {
                    fileteredName1 = SummarizeTypingResult.filterWithMinorType(majorHapTypeGroup1, minorHapTypeGroup1, minorHapTypeGroup1, minorMissingTypes, sampleCombineExonResult);
                    fileteredName2 = SummarizeTypingResult.filterWithMinorType(majorHapTypeGroup2, minorHapTypeGroup2, minorHapTypeGroup2, minorMissingTypes, sampleCombineExonResult);
                } else if (common12 && !common11 || common21 && !common22) {
                    fileteredName1 = SummarizeTypingResult.filterWithMinorType(majorHapTypeGroup1, minorHapTypeGroup2, minorHapTypeGroup2, minorMissingTypes, sampleCombineExonResult);
                    fileteredName2 = SummarizeTypingResult.filterWithMinorType(majorHapTypeGroup2, minorHapTypeGroup1, minorHapTypeGroup1, minorMissingTypes, sampleCombineExonResult);
                } else if (isMajorHomo) {
                    fileteredName1 = SummarizeTypingResult.filterWithMinorType(majorHapTypeGroup1, minorHapTypeGroup1, minorHapTypeGroup1, minorMissingTypes, sampleCombineExonResult);
                    fileteredName2 = SummarizeTypingResult.filterWithMinorType(majorHapTypeGroup2, minorHapTypeGroup2, minorHapTypeGroup2, minorMissingTypes, sampleCombineExonResult);
                } else {
                    fileteredName1 = SummarizeTypingResult.filterWithMinorType(majorHapTypeGroup1, minorHapTypeGroup1, minorHapTypeGroup2, minorMissingTypes, sampleCombineExonResult);
                    fileteredName2 = SummarizeTypingResult.filterWithMinorType(majorHapTypeGroup2, minorHapTypeGroup1, minorHapTypeGroup2, minorMissingTypes, sampleCombineExonResult);
                    if (!minor.getType1().equals(minor.getType2())) {
                        SummarizeTypingResult.logForAmbiguities(fileteredName1, minorHapTypeGroup1, minorHapTypeGroup2, sampleCombineExonResult, false);
                        SummarizeTypingResult.logForAmbiguities(fileteredName2, minorHapTypeGroup1, minorHapTypeGroup2, sampleCombineExonResult, false);
                    }
                }
                sampleCombineExonResult.setType1(SummarizeTypingResult.format(fileteredName1, majorType1));
                sampleCombineExonResult.setType2(SummarizeTypingResult.format(fileteredName2, majorType2));
                if (sampleCombineExonResult.getType1() != null && sampleCombineExonResult.getType2() != null && sampleCombineExonResult.getType1().equals(sampleCombineExonResult.getType2())) {
                    SummarizeTypingResult.logForUnknowns(fileteredName1, minorMissingTypes, sampleCombineExonResult, false);
                } else {
                    SummarizeTypingResult.logForUnknowns(fileteredName1, minorMissingTypes, sampleCombineExonResult, false);
                    SummarizeTypingResult.logForUnknowns(fileteredName2, minorMissingTypes, sampleCombineExonResult, false);
                }
                if (isMajorHomo) {
                    SummarizeTypingResult.reverseCheckingForHomoMajorType(major, minor, majorAmbTypes, minorAmbTypes, sampleCombineExonResult);
                }
                if (fileteredName1.size() > 0 && fileteredName2.size() > 0) {
                    sampleCombineExonResult.setFirm(true);
                }
            } else {
                sampleCombineExonResult.setType1(SummarizeTypingResult.format(majorHapTypeGroup1, majorType1));
                sampleCombineExonResult.setType2(SummarizeTypingResult.format(majorHapTypeGroup2, majorType2));
            }
            locusExonResultCombined.put(sample, sampleCombineExonResult);
        }
        return locusExonResultCombined;
    }

    public static void logForUnknowns(List<String> fileteredName, List<String> minorMissingTypes, LocusExonResult sampleCombineExonResult, boolean isOtherLog) {
        for (String aType : fileteredName) {
            if (!minorMissingTypes.contains(aType)) continue;
            if (isOtherLog) {
                SummarizeTypingResult.addToOtherLog(sampleCombineExonResult, String.valueOf(aType) + "(unknown)");
                continue;
            }
            SummarizeTypingResult.addToLog(sampleCombineExonResult, String.valueOf(aType) + "(unknown)");
        }
    }

    public static void logForAmbiguities(List<String> fileteredName, List<String> minorHapTypeGroup1, List<String> minorHapTypeGroup2, LocusExonResult sampleCombineExonResult, boolean isOtherLog) {
        ArrayList<String> group1 = new ArrayList<String>();
        ArrayList<String> group2 = new ArrayList<String>();
        for (String aType : fileteredName) {
            if (minorHapTypeGroup1.contains(aType)) {
                group1.add(aType);
                continue;
            }
            if (!minorHapTypeGroup2.contains(aType)) continue;
            group2.add(aType);
        }
        if (group1.size() > 0 && group2.size() > 0) {
            if (isOtherLog) {
                SummarizeTypingResult.addToOtherLog(sampleCombineExonResult, "ambiguity");
            } else {
                SummarizeTypingResult.addToLog(sampleCombineExonResult, "ambiguity");
                System.out.println(group1 + " ????  " + group2);
            }
        }
    }

    public static boolean checkCommon(List<String> majorHapTypeGroup, List<String> minorHapTypeGroup) {
        for (String aType : majorHapTypeGroup) {
            if (!minorHapTypeGroup.contains(aType)) continue;
            return true;
        }
        return false;
    }

    private static void reverseCheckingForHomoMajorType(LocusExonResult major, LocusExonResult minor, Map<String, List<String>> majorAmbTypes, Map<String, List<String>> minorAmbTypes, LocusExonResult sampleCombineExonResult) {
        String minorType1 = minor.getType1();
        String minorType2 = minor.getType2();
        List<String> minorHapTypeGroup1 = SummarizeTypingResult.getExpandedHapType(minorType1, minorAmbTypes);
        List<String> minorHapTypeGroup2 = SummarizeTypingResult.getExpandedHapType(minorType2, minorAmbTypes);
        List<String> majorHapTypeGroup1 = SummarizeTypingResult.getExpandedHapType(major.getType1(), majorAmbTypes);
        boolean minor1Passed = false;
        boolean minor2Passed = false;
        for (String hap : minorHapTypeGroup1) {
            if (!majorHapTypeGroup1.contains(hap)) continue;
            minor1Passed = true;
            break;
        }
        for (String hap : minorHapTypeGroup2) {
            if (!majorHapTypeGroup1.contains(hap)) continue;
            minor2Passed = true;
            break;
        }
        String impossibleTypes = "";
        if (!minor1Passed) {
            impossibleTypes = String.valueOf(impossibleTypes) + minorType1 + ",";
        }
        if (!minorType1.equals(minorType2) && !minor2Passed) {
            impossibleTypes = String.valueOf(impossibleTypes) + minorType2 + ",";
        }
        if (impossibleTypes.trim().length() > 0) {
            SummarizeTypingResult.addToLog(major, "homoCheck Failed(" + impossibleTypes + ")show at other exon");
            major.setFirm(false);
        }
    }

    public static String format(List<String> majorHapTypeGroup, String majorType) {
        String name = "";
        for (String type : majorHapTypeGroup) {
            name = String.valueOf(name) + type + ",";
        }
        if (EXPAND_HAP_AMBGUITY) {
            return name.length() == 0 ? null : name.substring(0, name.length() - 1);
        }
        return name.length() == 0 ? null : majorType;
    }

    public static List<String> getMissTypes(List<String> allMajorHapTypes, List<String> allMinorHapTypes) {
        ArrayList<String> missingTypes = new ArrayList<String>();
        for (String type : allMajorHapTypes) {
            if (allMinorHapTypes.contains(type)) continue;
            missingTypes.add(type);
        }
        return missingTypes;
    }

    public static List<String> filterWithMinorType(List<String> majorHapTypeGroup, List<String> minorHapTypeGroup1, List<String> minorHapTypeGroup2, List<String> minorMissingTypes, LocusExonResult sampleCombineExonResult) {
        ArrayList<String> types = new ArrayList<String>();
        for (String aType : majorHapTypeGroup) {
            if (minorMissingTypes.contains(aType)) {
                types.add(aType);
                continue;
            }
            if (!minorHapTypeGroup1.contains(aType) && !minorHapTypeGroup2.contains(aType)) continue;
            types.add(aType);
        }
        return types;
    }

    public static List<String> getExpandedHapType(String type, Map<String, List<String>> ambTypes) {
        if (ambTypes.containsKey(type)) {
            return ambTypes.get(type);
        }
        ArrayList<String> allHapTypes = new ArrayList<String>();
        allHapTypes.add(type);
        return allHapTypes;
    }

    public static Map<String, List<String>> getAmbTypes(File hapAmbFile) {
        String[] lines;
        HashMap<String, List<String>> ambTypes = new HashMap<String, List<String>>();
        String[] stringArray = lines = FileManager.readTextFile(hapAmbFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0) {
                String[] items = line.trim().split("\\s+");
                String gname = items[0].trim();
                ambTypes.put(gname, new ArrayList());
                int i = 1;
                while (i < items.length) {
                    ((List)ambTypes.get(gname)).add(items[i].trim());
                    ++i;
                }
            }
            ++n2;
        }
        return ambTypes;
    }

    public static List<String> getAllTypes(File hapTypeFile) {
        ArrayList<String> allHapTypes = new ArrayList<String>();
        String[] lines = FileManager.readTextFile(hapTypeFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">")) {
                String name = lines[i].trim().substring(1);
                allHapTypes.add(name);
            }
            ++i;
        }
        return allHapTypes;
    }

    private static void setOutput(Map<String, String> resultMap, String locus, LocusExon majorExon, LocusExon minorExon, Map<String, LocusExonResult> locusExonResultMajor, Map<String, LocusExonResult> locusExonResultMinor, Map<String, LocusExonResult> locusExonResultCombined, boolean forWebService) {
        for (String sample : locusExonResultMajor.keySet()) {
            LocusExonResult combined;
            LocusExonResult minor;
            StringBuilder result = new StringBuilder();
            LocusExonResult major = locusExonResultMajor.get(sample);
            result.append(sample).append("\t");
            if (locus.equals(DRB1345)) {
                result.append(DRB1).append("\t");
            } else {
                result.append(locus).append("\t");
            }
            result.append(majorExon.getExon()).append("\t");
            result.append(major.getType1() == null ? "?" : major.getType1()).append("\t");
            result.append(major.getType2() == null ? "?" : major.getType2()).append("\t");
            if (forWebService) {
                result.append(major.getCoverageUrl() == null ? " " : major.getCoverageUrl()).append("\t");
                result.append(major.getDetailUrl() == null ? " " : major.getDetailUrl()).append("\t");
            }
            if (!majorExon.getLocus().equals(DRB1345)) {
                result.append(major.getOtherTypes() == null ? " " : major.getOtherTypes()).append("\t");
            } else {
                result.append("").append("\t");
            }
            result.append(major.isFirm()).append("\t");
            result.append(major.getLog() == null ? " " : major.getLog()).append("\t");
            if (locusExonResultMinor != null) {
                minor = locusExonResultMinor.get(sample);
                result.append(minorExon.getExon()).append("\t");
                result.append(minor.getType1() == null ? "?" : minor.getType1()).append("\t");
                result.append(minor.getType2() == null ? "?" : minor.getType2()).append("\t");
                if (forWebService) {
                    result.append(minor.getCoverageUrl() == null ? "" : minor.getCoverageUrl()).append("\t");
                    result.append(minor.getDetailUrl() == null ? "" : minor.getDetailUrl()).append("\t");
                }
                if (!majorExon.getLocus().equals(DRB1345)) {
                    result.append(minor.getOtherTypes() == null ? "" : minor.getOtherTypes()).append("\t");
                } else {
                    result.append("").append("\t");
                }
                result.append(minor.isFirm()).append("\t");
                result.append(minor.getLog() == null ? " " : minor.getLog()).append("\t");
                combined = locusExonResultCombined.get(sample);
                result.append(majorExon.getExon()).append("+").append(minorExon.getExon()).append("\t");
                result.append(combined.getType1() == null ? "?" : combined.getType1()).append("\t");
                result.append(combined.getType2() == null ? "?" : combined.getType2()).append("\t");
                if (forWebService) {
                    result.append(combined.isFirm()).append("\t");
                    result.append(SummarizeTypingResult.generateDetailURL(sample, locus)).append("\t");
                } else {
                    result.append(combined.isFirm()).append("\t");
                    result.append(combined.getLog() == null ? "" : combined.getLog()).append("\t");
                }
            } else {
                result.append("").append("\t");
                result.append("").append("\t");
                result.append("").append("\t");
                result.append("").append("\t");
                result.append("").append("\t");
                result.append("").append("\t");
                if (forWebService) {
                    result.append("").append("\t");
                    result.append("").append("\t");
                }
                if (forWebService) {
                    result.append(majorExon.getExon()).append("\t");
                    result.append(major.getType1() == null ? "?" : major.getType1()).append("\t");
                    result.append(major.getType2() == null ? "?" : major.getType2()).append("\t");
                    result.append(major.isFirm()).append("\t");
                    result.append(SummarizeTypingResult.generateDetailURL(sample, locus)).append("\t");
                } else {
                    result.append("").append("\t");
                    result.append("").append("\t");
                    result.append("").append("\t");
                    result.append("").append("\t");
                    result.append("").append("\t");
                }
            }
            if (locus.equals(DRB1345)) {
                result.append("\n");
                result.append(sample).append("\t");
                result.append(DRB345).append("\t");
                result.append(majorExon.getExon()).append("\t");
                if (major.getOtherTypes() == null || major.getOtherTypes().length() == 0) {
                    result.append("?").append("\t");
                    result.append("?").append("\t");
                    if (forWebService) {
                        result.append("").append("\t");
                        result.append("").append("\t");
                    }
                    result.append("").append("\t");
                    result.append("").append("\t");
                } else {
                    String[] types = major.getOtherTypes().split(",");
                    result.append(types[0]).append("\t");
                    if (types.length > 1) {
                        result.append(types[1]).append("\t");
                    } else if (SummarizeTypingResult.isTwoCopy(major.getType1(), major.getType2(), types[0])) {
                        result.append(types[0]).append("\t");
                    } else {
                        result.append("").append("\t");
                    }
                    if (forWebService) {
                        result.append(major.getCoverageUrl()).append("\t");
                        result.append(major.getDetailUrl()).append("\t");
                    }
                    result.append("").append("\t");
                    result.append(major.isOtherTypeFirm()).append("\t");
                }
                result.append(major.getOtherLog() == null ? " " : major.getOtherLog()).append("\t");
                if (locusExonResultMinor != null) {
                    minor = locusExonResultMinor.get(sample);
                    result.append(minorExon.getExon()).append("\t");
                    if (minor.getOtherTypes() == null || minor.getOtherTypes().length() == 0) {
                        result.append("?").append("\t");
                        result.append("?").append("\t");
                        if (forWebService) {
                            result.append("").append("\t");
                            result.append("").append("\t");
                        }
                        result.append("").append("\t");
                        result.append("").append("\t");
                    } else {
                        String[] types = minor.getOtherTypes().split(",");
                        result.append(types[0]).append("\t");
                        if (types.length > 1) {
                            result.append(types[1]).append("\t");
                        } else if (SummarizeTypingResult.isTwoCopy(minor.getType1(), minor.getType2(), types[0])) {
                            result.append(types[0]).append("\t");
                        } else {
                            result.append("").append("\t");
                        }
                        if (forWebService) {
                            result.append(minor.getCoverageUrl()).append("\t");
                            result.append(minor.getDetailUrl()).append("\t");
                        }
                        result.append("").append("\t");
                        result.append(minor.isOtherTypeFirm()).append("\t");
                    }
                    result.append(minor.getOtherLog() == null ? " " : minor.getOtherLog()).append("\t");
                    combined = locusExonResultCombined.get(sample);
                    result.append(majorExon.getExon()).append("+").append(minorExon.getExon()).append("\t");
                    if (combined.getOtherTypes() == null || combined.getOtherTypes().length() == 0) {
                        result.append("?").append("\t");
                        result.append("?").append("\t");
                    } else {
                        String[] types = combined.getOtherTypes().split(SEPARATOR);
                        result.append(types[0].equals("null") ? "?" : types[0]).append("\t");
                        if (types.length > 1 && !types[0].equals(types[1])) {
                            result.append(types[1].equals("null") ? "?" : types[1]).append("\t");
                        } else if (types[0].equals(types[1]) && SummarizeTypingResult.isTwoCopy(combined.getType1(), combined.getType2(), types[0])) {
                            result.append(types[0].equals("null") ? "?" : types[0]).append("\t");
                        } else {
                            result.append("").append("\t");
                        }
                    }
                    boolean consistent = true;
                    if (combined.getOtherTypes() == null || combined.getOtherTypes().split(SEPARATOR)[0].equals("null") || combined.getOtherTypes().split(SEPARATOR)[1].equals("null")) {
                        consistent = false;
                    }
                    if (forWebService) {
                        result.append(consistent).append("\t");
                        result.append(SummarizeTypingResult.generateDetailURL(sample, locus)).append("\t");
                    } else {
                        result.append(consistent).append("\t");
                        result.append("").append("\t");
                        result.append("").append("\t");
                    }
                }
            }
            resultMap.put(sample, result.toString());
        }
    }

    private static boolean isTwoCopy(String type1, String type2, String otherType) {
        if (type1 == null || type2 == null) {
            return false;
        }
        if (type1.equals(type2)) {
            return true;
        }
        if (otherType.indexOf("DRB3") >= 0 && SummarizeTypingResult.isDRB3groupTypes(type1) && SummarizeTypingResult.isDRB3groupTypes(type2)) {
            return true;
        }
        if (otherType.indexOf("DRB4") >= 0 && SummarizeTypingResult.isDRB4groupTypes(type1) && SummarizeTypingResult.isDRB4groupTypes(type2)) {
            return true;
        }
        return otherType.indexOf("DRB5") >= 0 && SummarizeTypingResult.isDRB5groupTypes(type1) && SummarizeTypingResult.isDRB5groupTypes(type2);
    }

    private static Object generateDetailURL(String sample, String locus) {
        StringBuilder builder = new StringBuilder();
        try {
            builder.append("<a href='https://creator.zoho.com/edwardgow/hla-typing/#View:Details_View?Sample=");
            builder.append(URLEncoder.encode(sample, "UTF-8"));
            builder.append("&Locus=");
            builder.append(locus);
            builder.append("' target='_blank'>Details</a>");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        return builder.toString();
    }

    private static Map<String, Map<String, MatchStatistics>> extractForLocusExon(String[] detailedResult, String representString, Map<String, Map<String, List<String>>> details, Map<String, Map<String, String>> allRefTypeString) {
        LinkedHashMap<String, Map<String, MatchStatistics>> allMajorResult = new LinkedHashMap<String, Map<String, MatchStatistics>>();
        int i = 0;
        while (i < detailedResult.length) {
            String line = detailedResult[i];
            if (line.indexOf(representString) > 0) {
                String[] items = line.split("\\s+");
                String sampleName = items[0].trim();
                if (!allMajorResult.containsKey(sampleName)) {
                    allMajorResult.put(sampleName, new LinkedHashMap());
                    allRefTypeString.put(sampleName, new HashMap());
                    if (!details.containsKey(sampleName)) {
                        details.put(sampleName, new HashMap());
                    }
                    details.get(sampleName).put(representString, SummarizeTypingResult.getDetailedResult(detailedResult, i, sampleName, representString));
                }
                if (line.indexOf(NO_RESULT) < 0 && items.length >= 8) {
                    ((Map)allMajorResult.get(sampleName)).put(items[2].trim(), SummarizeTypingResult.parseStatistices(items, detailedResult, i));
                    allRefTypeString.get(sampleName).put(representString, SummarizeTypingResult.parseRefString(items, detailedResult, i));
                }
            }
            ++i;
        }
        return allMajorResult;
    }

    private static String parseRefString(String[] items, String[] detailedResult, int lineCount) {
        int i = lineCount + 1;
        while (i < detailedResult.length) {
            String[] entries = detailedResult[i].split("\t");
            if (entries.length == 2 && entries[1].trim().indexOf("-") < 0) {
                return detailedResult[i];
            }
            ++i;
        }
        return null;
    }

    private static List<String> getDetailedResult(String[] detailedResult, int index, String sampleName, String representString) {
        ArrayList<String> results = new ArrayList<String>();
        int i = index;
        while (i < detailedResult.length) {
            String line = detailedResult[i].trim();
            if (line.indexOf(NO_RESULT) > 0) {
                results.add(line);
                return results;
            }
            String[] entries = line.split("\t");
            if (entries.length >= 8 && entries[0].trim().equals(sampleName) && entries[1].trim().indexOf(representString) >= 0) {
                results.add(line);
            } else if (line.indexOf("usedTotaldata") >= 0) {
                results.add(line);
            } else if (entries.length == 2) {
                results.add(line);
            } else if (line.length() == 0) {
                results.add(line);
            } else {
                if (!(entries.length < 8 || entries[0].trim().equals(sampleName) && entries[1].trim().indexOf(representString) >= 0)) {
                    return results;
                }
                System.out.println("don't know what is it!!! " + line);
            }
            ++i;
        }
        return results;
    }

    public static Map<String, String> organizeSequenceFromFasta(Map<String, String> hapAmbNames, File fastaFile) throws Exception {
        LinkedHashMap<String, String> sequences = new LinkedHashMap<String, String>();
        ArrayList<String> existAmbTypes = new ArrayList<String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">")) {
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                if (!hapAmbNames.containsKey(name)) {
                    sequences.put(name, sequence);
                } else {
                    String gname = hapAmbNames.get(name);
                    if (!existAmbTypes.contains(gname)) {
                        sequences.put(gname, sequence);
                        existAmbTypes.add(gname);
                    }
                }
            }
            ++i;
        }
        return sequences;
    }

    private static Map<String, LocusExonResult> analyzeResult(Map<String, Map<String, MatchStatistics>> allResult, File hapTypeFile, File hapAmbFile, LocusExon locusExon, boolean useNatureOrderWhenNotSure, File imageDir, Map<String, Map<String, List<String>>> detail, String representString, Map<String, Map<String, String>> allRefTypeString) throws Exception {
        LinkedHashMap<String, LocusExonResult> locusExonResult = new LinkedHashMap<String, LocusExonResult>();
        HashMap<String, String> hapNames = new HashMap<String, String>();
        if (hapAmbFile.exists()) {
            ParseFastaByHapType7.populateHapAmbNames(hapNames, hapAmbFile);
        }
        Map<String, String> sequences = SummarizeTypingResult.organizeSequenceFromFasta(hapNames, hapTypeFile);
        for (String sample : allResult.keySet()) {
            System.out.println("--------------" + sample);
            Map<String, MatchStatistics> matches = allResult.get(sample);
            LocusExonResult sampleExonResult = new LocusExonResult();
            SummarizeTypingResult.setCanadidateResult(matches, locusExon, sampleExonResult);
            Map<String, MatchStatistics> perfectMatches = SummarizeTypingResult.filterForGoodMatches(matches, locusExon, true);
            Map<String, MatchStatistics> mainMatches = SummarizeTypingResult.seperateOtherTypes(locusExon, sampleExonResult, perfectMatches);
            if (locusExon.getExon().equals(EXON23)) {
                SummarizeTypingResult.workForCombinedExon(locusExon, sequences, matches, sampleExonResult, mainMatches);
            } else {
                SummarizeTypingResult.workForSingleExon(locusExon, sequences, matches, sampleExonResult, mainMatches, perfectMatches);
            }
            if (locusExon.getLocus().equals(DRB1345)) {
                SummarizeTypingResult.determinDRB345types(sampleExonResult, perfectMatches, locusExon);
            }
            if (locusExon.isMajor) {
                SummarizeTypingResult.verifyDRBlogic(sampleExonResult);
            }
            if (!sampleExonResult.isFirm() && useNatureOrderWhenNotSure && matches.size() > 0) {
                SummarizeTypingResult.resetResultWithNatureOrder(locusExon, sampleExonResult, matches);
            }
            if (sampleExonResult.getType1() != null && sampleExonResult.getType1().compareTo(sampleExonResult.getType2()) > 0) {
                String t = sampleExonResult.getType1();
                sampleExonResult.setType1(sampleExonResult.getType2());
                sampleExonResult.setType2(t);
            }
            SummarizeTypingResult.setDataUsed(detail.get(sample).get(representString), sampleExonResult);
            locusExonResult.put(sample, sampleExonResult);
            if (imageDir == null || matches.size() <= 0) continue;
            SummarizeTypingResult.drawImage(new File(imageDir, SummarizeTypingResult.getImageName(sample, locusExon)), matches, sampleExonResult, allRefTypeString.get(sample).get(representString), locusExon, sample);
        }
        return locusExonResult;
    }

    private static void setCanadidateResult(Map<String, MatchStatistics> matches, LocusExon locusExon, LocusExonResult sampleExonResult) {
        List<String> otherTypeNames = locusExon.getOtherTypeNames();
        for (String type : matches.keySet()) {
            if (otherTypeNames.contains(type.split("\\*")[0])) {
                sampleExonResult.addOtherCandidateTypes(type);
                continue;
            }
            sampleExonResult.addCandidateTypes(type);
        }
    }

    private static void drawImage(File outputImage, Map<String, MatchStatistics> matches, LocusExonResult sampleExonResult, String refString, LocusExon locusExon, String sample) {
        BufferedImage bufferedImage = SummarizeTypingResult.initializeBufferedImage(matches.size(), locusExon, refString);
        Graphics2D graphics2D = SummarizeTypingResult.initializeGraphics2D(bufferedImage);
        SummarizeTypingResult.drawGrid(graphics2D, bufferedImage, matches.size(), sample, locusExon);
        int i = 0;
        for (String type : matches.keySet()) {
            SummarizeTypingResult.drawType(graphics2D, bufferedImage, type, matches.get(type), sampleExonResult, i, matches.size());
            ++i;
        }
        graphics2D.setColor(Color.BLACK);
        int yanchor = SummarizeTypingResult.getChartHeight(matches.size());
        if (sampleExonResult.getLog() != null) {
            graphics2D.drawString(String.valueOf(sampleExonResult.isFirm() ? "Log: Confirmed. " : "Warning: ") + sampleExonResult.getLog() + (sampleExonResult.getDataUsed() == null ? "" : ", " + sampleExonResult.getDataUsed()), 20, yanchor + 40);
        } else {
            graphics2D.drawString(String.valueOf(sampleExonResult.isFirm() ? "Log: Confirmed" : "Warning: Unsure") + (sampleExonResult.getDataUsed() == null ? "" : ", " + sampleExonResult.getDataUsed()), 20, yanchor + 40);
        }
        SummarizeTypingResult.drawRankingTable(graphics2D, bufferedImage, matches, sampleExonResult, locusExon);
        SummarizeTypingResult.drawAlignmentTable(graphics2D, bufferedImage, matches, sampleExonResult, refString, locusExon);
        SummarizeTypingResult.writeImageToFile(bufferedImage, outputImage);
        sampleExonResult.setCoverageUrl("<a href='" + IMAGE_URL_PREFIX + COVERAGE + "/" + outputImage.getName() + "' target='_blank'>" + COVERAGE + "</a>");
        sampleExonResult.setDetailUrl("<a href='" + IMAGE_URL_PREFIX + ALIGNMENT + "/" + outputImage.getName() + "' target='_blank'>" + ALIGNMENT + "</a>");
    }

    private static void drawCoverageTable(Graphics2D graphics2D, BufferedImage bufferedImage, Map<String, MatchStatistics> matches, LocusExonResult sampleExonResult, String refString, LocusExon locusExon) {
        graphics2D.setColor(Color.BLACK);
        int lineOffset = 10 + matches.size() * 2 + 1;
        graphics2D.drawString("Coverage: ", 20, 220 + 20 * lineOffset + 2 * lineOffset);
        Font font = new Font("Monospaced", 0, 12);
        graphics2D.setFont(font);
        String[] ref = refString.split("\t");
        FontMetrics fm = graphics2D.getFontMetrics();
        int width = fm.stringWidth(String.valueOf(ref[1].trim()) + " ") * 3 + 180;
        int sperationLineIndex = ++lineOffset;
        graphics2D.setColor(Color.GRAY);
        graphics2D.drawLine(20, 220 + 20 * (lineOffset - 1) + 2 * lineOffset, width, 220 + 20 * (lineOffset - 1) + 2 * lineOffset);
        graphics2D.drawString("Position", 20, 220 + 20 * lineOffset + 2 * lineOffset);
        SummarizeTypingResult.drawPositions(graphics2D, ref[1], 200, 220 + 20 * lineOffset + 2 * lineOffset, locusExon);
        int ybase = 220 + 20 * ++lineOffset + 2 * lineOffset;
        int i = 0;
        for (String type : matches.keySet()) {
            SummarizeTypingResult.drawAlignment(graphics2D, bufferedImage, type, matches.get(type), sampleExonResult, i, matches.size(), ybase, width, ref[1].trim(), false);
            ++i;
        }
        graphics2D.drawLine(20, 220 + 20 * ((lineOffset += i) - 1) + 2 * lineOffset, width, 220 + 20 * (lineOffset - 1) + 2 * lineOffset);
        SummarizeTypingResult.drawSeparationLine(graphics2D, 220 + 20 * (sperationLineIndex - 1) + 2 * sperationLineIndex, matches.size(), ref[1].length(), false);
    }

    private static void drawAlignmentTable(Graphics2D graphics2D, BufferedImage bufferedImage, Map<String, MatchStatistics> matches, LocusExonResult sampleExonResult, String refString, LocusExon locusExon) {
        graphics2D.setColor(Color.BLACK);
        int lineOffset = 6 + matches.size() + 1;
        int yanchor = SummarizeTypingResult.getChartHeight(matches.size());
        graphics2D.drawString("Alignments: ", 20, yanchor + 20 * lineOffset + 2 * lineOffset);
        graphics2D.drawString("Coverage Color key: ", 20, yanchor + 20 * ++lineOffset + 2 * lineOffset);
        int i = 0;
        while (i < 10) {
            graphics2D.draw3DRect(180 + i * 50, yanchor + 20 * lineOffset + 2 * lineOffset - 10, 50, 10, true);
            graphics2D.setColor(SummarizeTypingResult.getBackGroundColor(String.valueOf(i).charAt(0)));
            graphics2D.fill3DRect(180 + i * 50, yanchor + 20 * lineOffset + 2 * lineOffset - 10, 50, 10, true);
            graphics2D.setColor(Color.GRAY);
            graphics2D.drawString("" + i, 180 + i * 50 + 25, yanchor + 20 * lineOffset + 2 * lineOffset - 20);
            ++i;
        }
        Font font = new Font("Monospaced", 0, 12);
        graphics2D.setFont(font);
        String[] ref = refString.split("\t");
        FontMetrics fm = graphics2D.getFontMetrics();
        int cDNAypos = yanchor + 20 * ++lineOffset + 2 * lineOffset;
        graphics2D.setColor(Color.GRAY);
        graphics2D.drawString("cDNA", 20, cDNAypos);
        int refIndex = ++lineOffset;
        graphics2D.drawString(String.valueOf(ref[0].trim()) + "-REF", 20, yanchor + 20 * lineOffset + 2 * lineOffset);
        int lineIndex = lineOffset;
        int c = 1;
        int ybase = yanchor + 20 * lineIndex + 2 * lineIndex;
        for (String type : matches.keySet()) {
            Color customColor;
            if (type.equals(sampleExonResult.getType1()) || type.equals(sampleExonResult.getType2())) {
                customColor = new Color(204, 255, 204);
                graphics2D.setColor(customColor);
                graphics2D.fill3DRect(20, ybase + 20 * c + 2 * c - 20, fm.stringWidth(type), 20, true);
            }
            if (type.startsWith("DRB") && sampleExonResult.getOtherTypes() != null && sampleExonResult.getOtherTypes().indexOf(type) > -1) {
                customColor = new Color(175, 238, 238);
                graphics2D.setColor(customColor);
                graphics2D.fill3DRect(20, ybase + 20 * c + 2 * c - 20, fm.stringWidth(type), 20, true);
            }
            if (type.equals(sampleExonResult.getType1()) || type.equals(sampleExonResult.getType2())) {
                graphics2D.setColor(Color.BLACK);
            } else {
                graphics2D.setColor(Color.GRAY);
            }
            graphics2D.drawString(type, 20, ybase + 20 * c + 2 * c);
            ++c;
        }
        int blockCount = 0;
        int start = locusExon.getStartNumber();
        int unit = fm.stringWidth("A");
        int yAnchor = yanchor + 20 * refIndex + 2 * refIndex;
        int lineCounter = 0;
        int i2 = 0;
        while (i2 < ref[1].length()) {
            graphics2D.drawString(String.valueOf(ref[1].charAt(i2)), 200 + (lineCounter + blockCount) * unit, yAnchor);
            SummarizeTypingResult.drawBase(matches, 200 + (lineCounter + blockCount) * unit, yAnchor, i2, graphics2D);
            if (start % 10 == 0) {
                graphics2D.drawString(" ", 200 + (lineCounter + ++blockCount) * unit, yAnchor);
                graphics2D.drawString(String.valueOf(start), 200 + (lineCounter + blockCount) * unit - String.valueOf(start).length() * unit, cDNAypos);
            }
            if (ref[1].charAt(i2) != '.') {
                ++start;
            }
            if (locusExon.getExon().endsWith(EXON23) && start + 1 == ABC23_BOUNDARY) {
                graphics2D.drawString("|", 200 + (lineCounter + blockCount) * unit + 18, cDNAypos);
            }
            ++lineCounter;
            if (blockCount > 0 && blockCount % 10 == 0) {
                graphics2D.drawString("cDNA", 20, yAnchor += (matches.size() + 3) * 22);
                cDNAypos = yAnchor;
                graphics2D.drawString(String.valueOf(ref[0].trim()) + "-REF", 20, yAnchor + 22);
                int x = 2;
                for (String type : matches.keySet()) {
                    Color customColor;
                    if (type.equals(sampleExonResult.getType1()) || type.equals(sampleExonResult.getType2())) {
                        customColor = new Color(204, 255, 204);
                        graphics2D.setColor(customColor);
                        graphics2D.fill3DRect(20, yAnchor + 20 * x + 2 * x + 2 - 20, fm.stringWidth(type), 20, true);
                    }
                    if (type.startsWith("DRB") && sampleExonResult.getOtherTypes() != null && sampleExonResult.getOtherTypes().indexOf(type) > -1) {
                        customColor = new Color(175, 238, 238);
                        graphics2D.setColor(customColor);
                        graphics2D.fill3DRect(20, yAnchor + 20 * x + 2 * x + 2 - 20, fm.stringWidth(type), 20, true);
                    }
                    if (type.equals(sampleExonResult.getType1()) || type.equals(sampleExonResult.getType2())) {
                        graphics2D.setColor(Color.BLACK);
                    } else {
                        graphics2D.setColor(Color.GRAY);
                    }
                    graphics2D.drawString(type, 20, yAnchor + 20 * x + 2 * x);
                    ++x;
                }
                yAnchor += 22;
                blockCount = 0;
                lineCounter = 0;
            }
            ++i2;
        }
    }

    private static void drawBase(Map<String, MatchStatistics> matches, int x, int anchor, int index, Graphics2D graphics2D) {
        int line = 1;
        FontMetrics fm = graphics2D.getFontMetrics();
        for (String type : matches.keySet()) {
            if (index >= matches.get(type).getCoverageString().length()) {
                ++line;
                continue;
            }
            graphics2D.setColor(SummarizeTypingResult.getBackGroundColor(matches.get(type).getCoverageString().charAt(index)));
            graphics2D.fillRect(x, anchor + 22 * line, fm.stringWidth("1"), 10);
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawString(String.valueOf(matches.get(type).getAlignmentString().charAt(index)), x, anchor + 22 * line);
            ++line;
        }
        graphics2D.setColor(Color.GRAY);
    }

    private static Color getBackGroundColor(char coverage) {
        Color customColor = new Color(255, 255, 255);
        if (coverage == '0') {
            customColor = new Color(255, 51, 51);
        }
        if (coverage == '1') {
            customColor = new Color(255, 178, 102);
        }
        if (coverage == '2') {
            customColor = new Color(255, 255, 51);
        }
        if (coverage == '3') {
            customColor = new Color(255, 255, 153);
        }
        if (coverage == '4') {
            customColor = new Color(255, 255, 204);
        }
        if (coverage == '5') {
            customColor = new Color(204, 255, 204);
        }
        if (coverage == '6') {
            customColor = new Color(153, 255, 153);
        }
        if (coverage == '7') {
            customColor = new Color(102, 255, 102);
        }
        if (coverage == '8') {
            customColor = new Color(51, 255, 51);
        }
        if (coverage == '9') {
            customColor = new Color(0, 255, 0);
        }
        return customColor;
    }

    private static void drawSeparationLine(Graphics2D graphics2D, int yStart, int MatchTypeNumber, int refStringLength, boolean isAlignment) {
        FontMetrics fm = graphics2D.getFontMetrics();
        int unit = fm.stringWidth("123");
        graphics2D.drawLine(20, yStart, 20, yStart + 22 * (MatchTypeNumber + 1));
        int i = 0;
        while (i <= refStringLength) {
            graphics2D.drawLine(200 + i * unit, yStart, 200 + i * unit, yStart + 22 * (MatchTypeNumber + (isAlignment ? 2 : 1)));
            ++i;
        }
    }

    private static void drawPositions(Graphics2D graphics2D, String ref, int x, int y, LocusExon locusExon) {
        FontMetrics fm = graphics2D.getFontMetrics();
        int unit = fm.stringWidth("123");
        int i = 0;
        while (i < ref.length()) {
            String val = String.valueOf(locusExon.getStartNumber() + i);
            int j = 0;
            while (j < POS_NUMBER_LENGTH - val.length()) {
                val = String.valueOf(val) + " ";
                ++j;
            }
            graphics2D.drawString(val, x + unit * i, y);
            if (locusExon.getExon().endsWith(EXON23) && locusExon.getStartNumber() + i == ABC23_BOUNDARY) {
                graphics2D.drawLine(x + unit * (i + 1), y - 40, x + unit * (i + 1), y);
                graphics2D.drawString("Exon Boundry", x + unit * i, y - 40);
            }
            ++i;
        }
    }

    private static String formatAlignmentForImage(String alignment) {
        StringBuilder ret = new StringBuilder();
        int i = 0;
        while (i < alignment.length()) {
            ret.append(" ").append(alignment.charAt(i)).append(" ");
            ++i;
        }
        return ret.toString();
    }

    private static void drawRankingTable(Graphics2D graphics2D, BufferedImage bufferedImage, Map<String, MatchStatistics> matches, LocusExonResult sampleExonResult, LocusExon locusExon) {
        graphics2D.setColor(Color.BLACK);
        int yanchor = SummarizeTypingResult.getChartHeight(matches.size());
        graphics2D.drawString("Detailed Result: ", 20, yanchor + 100);
        int ybase = yanchor + 120 + 2;
        String[] header = HEADERS_CLASSII;
        if (locusExon.getExon().equals(EXON23)) {
            header = HEADERS_CLASSI;
        }
        int j = 0;
        while (j < header.length) {
            int xbase = 20 + 180 * j + 2 * (j + 1);
            graphics2D.drawString(header[j], xbase, ybase);
            ++j;
        }
        ybase = yanchor + 140 + 4;
        int ycount = 0;
        for (String type : matches.keySet()) {
            Color customColor;
            if (type.equals(sampleExonResult.getType1()) || type.equals(sampleExonResult.getType2())) {
                customColor = new Color(204, 255, 204);
                graphics2D.setColor(customColor);
                graphics2D.fill3DRect(20, ybase + (ycount - 1) * 20 + (ycount + 1) * 2, 180 * header.length, 20, true);
            }
            if (type.startsWith("DRB") && sampleExonResult.getOtherTypes() != null && sampleExonResult.getOtherTypes().indexOf(type) > -1) {
                customColor = new Color(175, 238, 238);
                graphics2D.setColor(customColor);
                graphics2D.fill3DRect(20, ybase + (ycount - 1) * 20 + (ycount + 1) * 2, 180 * header.length, 20, true);
            }
            if (type.equals(sampleExonResult.getType1()) || type.equals(sampleExonResult.getType2())) {
                graphics2D.setColor(Color.BLACK);
            } else {
                graphics2D.setColor(Color.GRAY);
            }
            graphics2D.drawString(type, 22, ybase + ycount * 22);
            if (locusExon.getExon().equals(EXON23)) {
                graphics2D.drawString(String.valueOf(matches.get(type).getNumPairsSupportExonA()), 204, ybase + ycount * 22);
                graphics2D.drawString(String.valueOf(matches.get(type).getNumPairsSupportExonB()), 386, ybase + ycount * 22);
                graphics2D.drawString(String.valueOf(matches.get(type).getNumPosGoodCoverage()) + "/" + matches.get(type).getExonSize(), 568, ybase + ycount * 22);
                graphics2D.drawString(matches.get(type).formatQuestionPostion(matches.get(type).getQuestionPos()), 750, ybase + ycount * 22);
                graphics2D.drawString(SummarizeTypingResult.getBridgeCount(matches.get(type), locusExon), 932, ybase + ycount * 22);
            } else {
                graphics2D.drawString(SummarizeTypingResult.getNumberPairSupport(matches.get(type), locusExon), 204, ybase + ycount * 22);
                graphics2D.drawString(String.valueOf(matches.get(type).getNumPosGoodCoverage()) + "/" + matches.get(type).getExonSize(), 386, ybase + ycount * 22);
                graphics2D.drawString(matches.get(type).formatQuestionPostion(matches.get(type).getQuestionPos()), 568, ybase + ycount * 22);
            }
            ++ycount;
        }
        int i = 0;
        while (i < matches.size() + 2) {
            ybase = yanchor + 100 + 2 + i * 20 + 2 * i;
            if (i < matches.size() + 1) {
                int j2 = 0;
                while (j2 < header.length + 1) {
                    int xbase = 20 + 180 * j2;
                    graphics2D.drawLine(xbase, ybase, xbase, ybase + 20 + 2);
                    ++j2;
                }
            }
            graphics2D.drawLine(20, ybase, 20 + 180 * header.length, ybase);
            ++i;
        }
    }

    private static String getBridgeCount(MatchStatistics matchStatistics, LocusExon locusExon) {
        if (locusExon.getExon().equals(EXON23)) {
            return String.valueOf(matchStatistics.getBridgeCount());
        }
        return "-";
    }

    private static String getNumberPairSupport(MatchStatistics matchStatistics, LocusExon locusExon) {
        if (locusExon.getExon().equals(EXON23)) {
            return String.valueOf(matchStatistics.getNumPairsSupportExonA()) + "/" + matchStatistics.getNumPairsSupportExonB();
        }
        return String.valueOf(matchStatistics.getNumPairsSupport());
    }

    private static void drawAlignment(Graphics2D graphics2D, BufferedImage bufferedImage, String type, MatchStatistics matchStatistics, LocusExonResult sampleExonResult, int i, int numberToDraw, int ybase, int width, String refString, boolean isAlignment) {
        Color customColor;
        FontMetrics fm = graphics2D.getFontMetrics();
        if (type.equals(sampleExonResult.getType1()) || type.equals(sampleExonResult.getType2())) {
            customColor = new Color(204, 255, 204);
            graphics2D.setColor(customColor);
            graphics2D.fill3DRect(20, ybase + (i - 1) * 20 + (i + 1) * 2, fm.stringWidth(refString) * 3 + 180, 20, true);
        }
        if (type.startsWith("DRB") && sampleExonResult.getOtherTypes() != null && sampleExonResult.getOtherTypes().indexOf(type) > -1) {
            customColor = new Color(175, 238, 238);
            graphics2D.setColor(customColor);
            graphics2D.fill3DRect(20, ybase + (i - 1) * 20 + (i + 1) * 2, fm.stringWidth(refString) * 3 + 180, 20, true);
        }
        if (type.equals(sampleExonResult.getType1()) || type.equals(sampleExonResult.getType2())) {
            graphics2D.setColor(Color.BLACK);
        } else {
            graphics2D.setColor(Color.GRAY);
        }
        String alignment = SummarizeTypingResult.formatAlignmentForImage(isAlignment ? matchStatistics.getAlignmentString() : matchStatistics.getCoverageString());
        graphics2D.drawString(type, 20, ybase + 20 * i + 2 * i);
        graphics2D.drawString(alignment, 200, ybase + 20 * i + 2 * i);
        graphics2D.drawLine(20, ybase + 20 * (i - 1) + 2 * i, width, ybase + 20 * (i - 1) + 2 * i);
    }

    private static void drawType(Graphics2D graphics2D, BufferedImage bufferedImage, String type, MatchStatistics matchStatistics, LocusExonResult sampleExonResult, int index, int numberToDraw) {
        Color customColor;
        int width;
        graphics2D.setColor(Color.GRAY);
        String coverage = matchStatistics.getCoverageString().replaceAll("\\.", "");
        int row = index / 5;
        int rowIndex = index % 5;
        int xbase = 20 + rowIndex * 200;
        int ybase = 220 + row * 260;
        float yunit = 20.0f;
        float xunit = Float.valueOf(200.0f).floatValue() / Float.valueOf(coverage.length()).floatValue();
        if (sampleExonResult.getType1() != null && sampleExonResult.getType1().equals(type) || sampleExonResult.getType2() != null && sampleExonResult.getType2().equals(type)) {
            graphics2D.setColor(Color.BLACK);
        }
        int i = 0;
        while (i < coverage.length() - 1) {
            graphics2D.drawLine(xbase + Math.round((float)i * xunit), Math.round((float)ybase - yunit * (float)Integer.valueOf(String.valueOf(coverage.charAt(i))).intValue()), xbase + Math.round((float)(i + 1) * xunit), Math.round((float)ybase - yunit * (float)Integer.valueOf(String.valueOf(coverage.charAt(i + 1))).intValue()));
            ++i;
        }
        if (sampleExonResult.getType1() != null && sampleExonResult.getType1().equals(type) || sampleExonResult.getType2() != null && sampleExonResult.getType2().equals(type)) {
            FontMetrics fm = graphics2D.getFontMetrics();
            width = fm.stringWidth(type);
            customColor = new Color(204, 255, 204);
            graphics2D.setColor(customColor);
            graphics2D.fill3DRect(xbase, ybase + 4, width + 2, 20, true);
            graphics2D.setColor(Color.BLACK);
        }
        if (type.startsWith("DRB") && sampleExonResult.getOtherTypes() != null && sampleExonResult.getOtherTypes().indexOf(type) > -1) {
            FontMetrics fm = graphics2D.getFontMetrics();
            width = fm.stringWidth(type);
            customColor = new Color(175, 238, 238);
            graphics2D.setColor(customColor);
            graphics2D.fill3DRect(xbase, ybase + 4, width + 2, 20, true);
            graphics2D.setColor(Color.BLACK);
        }
        graphics2D.drawString(type, xbase, ybase + 20);
        graphics2D.drawString(SummarizeTypingResult.formatStatistics(matchStatistics), xbase, ybase + 40);
        graphics2D.setColor(Color.GRAY);
    }

    private static String formatStatistics(MatchStatistics matchStatistics) {
        String ret = "(" + matchStatistics.getNumPosGoodCoverage() + "/" + matchStatistics.getExonSize() + ")";
        return ret;
    }

    public static void writeImageToFile(BufferedImage bufferedImage, File imageFile) {
        FileImageOutputStream fileImageOutputStream = null;
        ImageWriter imageWriter = null;
        try {
            try {
                fileImageOutputStream = new FileImageOutputStream(imageFile);
                imageWriter = ImageIO.getImageWritersByFormatName("jpg").next();
                imageWriter.setOutput(fileImageOutputStream);
                imageWriter.write(bufferedImage);
            }
            catch (IOException e) {
                e.printStackTrace();
                if (fileImageOutputStream != null) {
                    try {
                        fileImageOutputStream.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                if (imageWriter != null) {
                    imageWriter.dispose();
                }
            }
        }
        finally {
            if (fileImageOutputStream != null) {
                try {
                    fileImageOutputStream.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (imageWriter != null) {
                imageWriter.dispose();
            }
        }
    }

    private static void drawGrid(Graphics2D graphics2D, BufferedImage bufferedImage, int numberToDraw, String sample, LocusExon locusExon) {
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawString("Sample : " + sample + ", Locus : " + locusExon.getLocus() + ", " + locusExon.getExon(), 5, 15);
        graphics2D.setColor(Color.LIGHT_GRAY);
        int wrap = numberToDraw % 5 == 0 ? numberToDraw / 5 : numberToDraw / 5 + 1;
        int xanchor = 20;
        int yanchor = 220;
        int i = 0;
        while (i < wrap) {
            graphics2D.setColor(Color.LIGHT_GRAY);
            graphics2D.draw3DRect(xanchor, yanchor + i * 260, 200 * Math.min(5, numberToDraw - i * 5), 2, true);
            graphics2D.fill3DRect(xanchor, yanchor + i * 260, 200 * Math.min(5, numberToDraw - i * 5), 2, true);
            graphics2D.draw3DRect(20, 20 + i * 260, 2, 200, true);
            graphics2D.fill3DRect(20, 20 + i * 260, 2, 200, true);
            graphics2D.setColor(Color.BLACK);
            int ybase = yanchor + i * 260;
            int x = 0;
            while (x < 10) {
                graphics2D.drawLine(20, ybase - 20 * x, 22, ybase - 20 * x);
                graphics2D.drawString(String.valueOf(x), 5, ybase - 20 * x);
                ++x;
            }
            x = 0;
            while (x < Math.min(5, numberToDraw - i * 5)) {
                graphics2D.drawLine(20 + 200 * (x + 1), ybase, 20 + 200 * (x + 1), ybase - 200);
                ++x;
            }
            ++i;
        }
    }

    public static Graphics2D initializeGraphics2D(BufferedImage bufferedImage) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setBackground(Color.white);
        graphics2D.clearRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.setClip(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return graphics2D;
    }

    public static BufferedImage initializeBufferedImage(int numberToDraw, LocusExon locusExon, String refString) {
        BufferedImage bufferedImage = new BufferedImage(SummarizeTypingResult.getImageWidth(numberToDraw, locusExon), SummarizeTypingResult.getImageHeight(numberToDraw, refString), 9);
        return bufferedImage;
    }

    private static int getChartHeight(int numberToDraw) {
        int wrap = numberToDraw % 5 == 0 ? numberToDraw / 5 : numberToDraw / 5 + 1;
        return 260 * wrap;
    }

    private static int getImageHeight(int numberToDraw, String refString) {
        int wrap = numberToDraw % 5 == 0 ? numberToDraw / 5 : numberToDraw / 5 + 1;
        int height = 260 * wrap + 20 * (numberToDraw + 1) * 2 + 2 * (numberToDraw + 1) * 2 + (refString.length() / 100 + 1) * (numberToDraw + 6) * 21 + 200;
        return height;
    }

    private static int getImageWidth(int numberToDraw, LocusExon locusExon) {
        return 1000;
    }

    private static String getImageName(String sample, LocusExon locusExon) {
        return String.valueOf(sample) + "-" + locusExon.getLocus() + "-" + locusExon.getExon() + ".jpg";
    }

    private static void determinDRB345types(LocusExonResult sampleExonResult, Map<String, MatchStatistics> perfectMatches, LocusExon locusExon) {
        if (sampleExonResult.getOtherTypes() == null || sampleExonResult.getOtherTypes().trim().length() == 0) {
            return;
        }
        String[] types = sampleExonResult.getOtherTypes().split(",");
        if (types.length == 1) {
            SummarizeTypingResult.checkIfConfirm(types, perfectMatches, sampleExonResult, locusExon);
            return;
        }
        LinkedHashMap<String, List<String>> typeMap = new LinkedHashMap<String, List<String>>();
        String[] stringArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            String name = type.split("\\*")[0];
            if (!typeMap.containsKey(name)) {
                typeMap.put(name, new ArrayList());
            }
            ((List)typeMap.get(name)).add(type);
            ++n2;
        }
        if (typeMap.size() > 1) {
            sampleExonResult.setOtherTypes(SummarizeTypingResult.formatAndOrder(typeMap));
        } else {
            sampleExonResult.setOtherTypes(SummarizeTypingResult.formatSingleLocus(typeMap, perfectMatches));
        }
        SummarizeTypingResult.checkIfConfirm(sampleExonResult.getOtherTypes().split(","), perfectMatches, sampleExonResult, locusExon);
    }

    private static void checkIfConfirm(String[] types, Map<String, MatchStatistics> perfectMatches, LocusExonResult sampleExonResult, LocusExon locusExon) {
        sampleExonResult.setOtherTypeFirm(true);
        String[] stringArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            boolean isEnoughPopulation = SummarizeTypingResult.checkFirmPopulation(type, perfectMatches.get(type), sampleExonResult, true);
            boolean isContainQuestionPos = SummarizeTypingResult.checkQuestionPosition(type, perfectMatches.get(type), locusExon, sampleExonResult, true);
            if (!isEnoughPopulation || isContainQuestionPos) {
                sampleExonResult.setOtherTypeFirm(false);
            }
            ++n2;
        }
        if (types.length >= 3) {
            SummarizeTypingResult.addToOtherLog(sampleExonResult, "more than 2 types exist,");
            sampleExonResult.setOtherTypeFirm(false);
        }
    }

    private static String formatSingleLocus(Map<String, List<String>> typeMap, Map<String, MatchStatistics> perfectMatches) {
        Object object;
        List<String> thistypes;
        String types = "";
        ArrayList<String> nn = new ArrayList<String>();
        int count = 0;
        int topCount = 0;
        block0: for (String name : typeMap.keySet()) {
            thistypes = typeMap.get(name);
            for (String tt : thistypes) {
                MatchStatistics st = perfectMatches.get(tt);
                if (st == null) continue;
                if (count == 0) {
                    nn.add(tt);
                    ++count;
                    topCount = st.getNumPairsSupport();
                    continue;
                }
                if (!((double)st.getNumPairsSupport() * 2.5 > (double)topCount)) continue block0;
                nn.add(tt);
                if (++count >= 2) continue block0;
            }
        }
        if (nn.size() == 0) {
            for (String name : typeMap.keySet()) {
                String tt;
                thistypes = typeMap.get(name);
                object = thistypes.iterator();
                if (!object.hasNext()) continue;
                tt = (String)object.next();
                return tt;
            }
        }
        Object[] names = nn.toArray();
        Arrays.sort(names);
        object = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            Object name = object[n2];
            types = String.valueOf(types) + name + ",";
            ++n2;
        }
        return types.substring(0, types.length() - 1);
    }

    private static String formatAndOrder(Map<String, List<String>> typeMap) {
        ArrayList<String> tt = new ArrayList<String>();
        for (String name : typeMap.keySet()) {
            tt.add(typeMap.get(name).get(0));
        }
        Object[] names = tt.toArray();
        Arrays.sort(names);
        String types = "";
        Object[] objectArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            Object name = objectArray[n2];
            types = String.valueOf(types) + name + ",";
            ++n2;
        }
        return types.substring(0, types.length() - 1);
    }

    private static void resetResultWithNatureOrder(LocusExon locusExon, LocusExonResult sampleExonResult, Map<String, MatchStatistics> matches) {
        sampleExonResult.setLog("useNatureOrder");
        sampleExonResult.setType1(null);
        sampleExonResult.setType2(null);
        List<String> otherTypeNames = locusExon.getOtherTypeNames();
        int topCount = 0;
        int typeCount = 0;
        for (String type : matches.keySet()) {
            if (otherTypeNames.contains(type.split("\\*")[0])) continue;
            if (sampleExonResult.getType1() == null) {
                sampleExonResult.setType1(type);
                ++typeCount;
                topCount = matches.get(type).getNumPairsSupport();
            } else if (sampleExonResult.getType2() == null && matches.get(type).getNumPairsSupport() * 5 > topCount) {
                sampleExonResult.setType2(type);
                ++typeCount;
            }
            if (typeCount >= 2) break;
        }
        if (sampleExonResult.getType2() == null) {
            sampleExonResult.setType2(sampleExonResult.getType1());
        }
        if (sampleExonResult.getType1() == null && sampleExonResult.getType2() == null) {
            return;
        }
        SummarizeTypingResult.logWarnings(locusExon, sampleExonResult, matches);
    }

    private static void logWarnings(LocusExon locusExon, LocusExonResult sampleExonResult, Map<String, MatchStatistics> mainMatches) {
        SummarizeTypingResult.logForType(sampleExonResult.getType1(), locusExon, sampleExonResult, mainMatches);
        if (!sampleExonResult.getType1().equals(sampleExonResult.getType2()) && sampleExonResult.getType2() != null) {
            SummarizeTypingResult.logForType(sampleExonResult.getType2(), locusExon, sampleExonResult, mainMatches);
            SummarizeTypingResult.passPopulationDistanceCheck(sampleExonResult.getType1(), mainMatches.get(sampleExonResult.getType1()), sampleExonResult.getType2(), mainMatches.get(sampleExonResult.getType2()), sampleExonResult);
        }
    }

    private static void logForType(String type, LocusExon locusExon, LocusExonResult sampleExonResult, Map<String, MatchStatistics> mainMatches) {
        SummarizeTypingResult.checkFirmPopulation(type, mainMatches.get(type), sampleExonResult, false);
        SummarizeTypingResult.checkQuestionPosition(type, mainMatches.get(type), locusExon, sampleExonResult, false);
        SummarizeTypingResult.checkDropOff(type, mainMatches.get(type), sampleExonResult);
    }

    private static void workForCombinedExon(LocusExon locusExon, Map<String, String> sequences, Map<String, MatchStatistics> matches, LocusExonResult sampleExonResult, Map<String, MatchStatistics> mainMatches) {
        if (mainMatches.size() == 0) {
            SummarizeTypingResult.getTopPerfectData(locusExon, matches, sampleExonResult);
        } else if (mainMatches.size() == 1) {
            SummarizeTypingResult.generateHomoResult(mainMatches, sampleExonResult);
            boolean isEnoughPopulation = SummarizeTypingResult.checkFirmPopulation(sampleExonResult.getType1(), mainMatches.get(sampleExonResult.getType1()), sampleExonResult, false);
            boolean isContainQuestionPos = SummarizeTypingResult.checkQuestionPosition(sampleExonResult.getType1(), mainMatches.get(sampleExonResult.getType1()), locusExon, sampleExonResult, false);
            if (isEnoughPopulation && !isContainQuestionPos) {
                SummarizeTypingResult.addToLog(sampleExonResult, HOMOZYGOUS);
                sampleExonResult.setFirm(true);
            }
        } else if (mainMatches.size() == 2) {
            sampleExonResult.setType1(null);
            sampleExonResult.setType2(null);
            SummarizeTypingResult.generateHeterResult(mainMatches, sampleExonResult);
            sampleExonResult.setFirm(true);
            if (!SummarizeTypingResult.checkFirmPopulation(sampleExonResult.getType1(), mainMatches.get(sampleExonResult.getType1()), sampleExonResult, false) || !SummarizeTypingResult.checkFirmPopulation(sampleExonResult.getType2(), mainMatches.get(sampleExonResult.getType2()), sampleExonResult, false) || SummarizeTypingResult.checkQuestionPosition(sampleExonResult.getType1(), mainMatches.get(sampleExonResult.getType1()), locusExon, sampleExonResult, false) || SummarizeTypingResult.checkQuestionPosition(sampleExonResult.getType2(), mainMatches.get(sampleExonResult.getType2()), locusExon, sampleExonResult, false) || !SummarizeTypingResult.passPopulationDistanceCheck(sampleExonResult.getType1(), mainMatches.get(sampleExonResult.getType1()), sampleExonResult.getType2(), mainMatches.get(sampleExonResult.getType2()), sampleExonResult) || !SummarizeTypingResult.TypesWithMajorDifference(sampleExonResult.getType1(), sampleExonResult.getType2(), sequences, sampleExonResult, locusExon, mainMatches) || SummarizeTypingResult.checkDropOff(sampleExonResult.getType1(), mainMatches.get(sampleExonResult.getType1()), sampleExonResult) || SummarizeTypingResult.checkDropOff(sampleExonResult.getType2(), mainMatches.get(sampleExonResult.getType2()), sampleExonResult)) {
                sampleExonResult.setFirm(false);
            }
        } else if (mainMatches.size() > 2) {
            SummarizeTypingResult.identifyTrueTypesCombineExon(mainMatches, sampleExonResult, sequences, locusExon);
            if (!SummarizeTypingResult.checkFirmPopulation(sampleExonResult.getType1(), mainMatches.get(sampleExonResult.getType1()), sampleExonResult, false) || !SummarizeTypingResult.checkFirmPopulation(sampleExonResult.getType2(), mainMatches.get(sampleExonResult.getType2()), sampleExonResult, false) || SummarizeTypingResult.checkQuestionPosition(sampleExonResult.getType1(), mainMatches.get(sampleExonResult.getType1()), locusExon, sampleExonResult, false) || SummarizeTypingResult.checkQuestionPosition(sampleExonResult.getType2(), mainMatches.get(sampleExonResult.getType2()), locusExon, sampleExonResult, false) || !SummarizeTypingResult.passPopulationDistanceCheck(sampleExonResult.getType1(), mainMatches.get(sampleExonResult.getType1()), sampleExonResult.getType2(), mainMatches.get(sampleExonResult.getType2()), sampleExonResult)) {
                sampleExonResult.setFirm(false);
            } else {
                sampleExonResult.setFirm(true);
            }
        }
    }

    private static void identifyTrueTypesCombineExon(Map<String, MatchStatistics> inputMatches, LocusExonResult sampleExonResult, Map<String, String> sequences, LocusExon locusExon) {
        String type1 = null;
        String type2 = null;
        Map<String, MatchStatistics> mainMatches = SummarizeTypingResult.filterMatches(inputMatches);
        LinkedHashMap<String, MatchStatistics> mainMatchesA = new LinkedHashMap<String, MatchStatistics>();
        LinkedHashMap<String, MatchStatistics> mainMatchesB = new LinkedHashMap<String, MatchStatistics>();
        SummarizeTypingResult.separateMatches(mainMatchesA, mainMatchesB, mainMatches);
        int maxBridgeCount1 = SummarizeTypingResult.getMaxBridgeCount(mainMatchesA);
        int maxBridgeCount2 = 0;
        type1 = SummarizeTypingResult.getBestMatches(mainMatchesA, maxBridgeCount1);
        System.out.println("set type1=" + type1 + " " + maxBridgeCount1);
        if (mainMatchesB.size() > 0) {
            maxBridgeCount2 = SummarizeTypingResult.getMaxBridgeCount(mainMatchesB);
            type2 = SummarizeTypingResult.getBestMatches(mainMatchesB, maxBridgeCount2);
            System.out.println("set type2=" + type2 + " " + maxBridgeCount2);
        }
        if (type2 == null) {
            sampleExonResult.setType1(type1);
            sampleExonResult.setType2(type1);
            SummarizeTypingResult.addToLog(sampleExonResult, "Homo");
            return;
        }
        if (maxBridgeCount1 < 5) {
            sampleExonResult.setType1(type1);
            sampleExonResult.setType2(type2 == null ? type1 : type2);
            SummarizeTypingResult.addToLog(sampleExonResult, "Ambiguity, no clear resolving/bridge info");
            return;
        }
        ArrayList<String> tighType1 = new ArrayList<String>();
        ArrayList<String> tighType2 = new ArrayList<String>();
        SummarizeTypingResult.checkTighTypes(tighType1, mainMatchesA, maxBridgeCount1, type1);
        SummarizeTypingResult.checkTighTypes(tighType2, mainMatchesB, maxBridgeCount2, type2);
        if (tighType1.size() > 1 && tighType2.size() > 1) {
            SummarizeTypingResult.addToLog(sampleExonResult, "Ambiguity, bridge reads count same " + SummarizeTypingResult.format(tighType1) + " and " + SummarizeTypingResult.format(tighType2));
        }
        sampleExonResult.setType1(type1);
        sampleExonResult.setType2(type2 == null ? type1 : type2);
    }

    private static void checkTighTypes(List<String> tighType, Map<String, MatchStatistics> mainMatches, int maxBridgeCount, String bestType) {
        for (String type : mainMatches.keySet()) {
            if (mainMatches.get(type).getBridgeCount() != maxBridgeCount || !SummarizeTypingResult.passPopulationCheck(mainMatches, type, bestType)) continue;
            tighType.add(type);
        }
    }

    private static boolean passPopulationCheck(Map<String, MatchStatistics> mainMatches, String type, String bestType) {
        if (type.equals(bestType)) {
            return true;
        }
        int aCount = mainMatches.get(type).getNumPairsSupportExonA();
        int bCount = mainMatches.get(type).getNumPairsSupportExonB();
        int bestACount = mainMatches.get(bestType).getNumPairsSupportExonA();
        int bestBCount = mainMatches.get(bestType).getNumPairsSupportExonB();
        return (float)aCount > (float)bestACount * 0.75f && (float)bCount > (float)bestBCount * 0.75f;
    }

    private static String format(List<String> tighTypes) {
        String out = null;
        for (String type : tighTypes) {
            out = out == null ? type : String.valueOf(out) + "/" + type;
        }
        return out;
    }

    private static String getBestMatches(Map<String, MatchStatistics> mainMatches, int maxBridgeCount) {
        ArrayList<String> bestBridgeTypes = new ArrayList<String>();
        for (String type : mainMatches.keySet()) {
            if (maxBridgeCount < 5) {
                return type;
            }
            if (mainMatches.get(type).getBridgeCount() != maxBridgeCount && maxBridgeCount - mainMatches.get(type).getBridgeCount() >= 2) continue;
            bestBridgeTypes.add(type);
        }
        if (bestBridgeTypes.size() == 0) {
            return null;
        }
        if (bestBridgeTypes.size() == 1) {
            return (String)bestBridgeTypes.get(0);
        }
        ArrayList<String> bestTypes = new ArrayList<String>();
        int maxMin = Math.min(mainMatches.get(bestBridgeTypes.get(0)).getNumPairsSupportExonA(), mainMatches.get(bestBridgeTypes.get(0)).getNumPairsSupportExonB());
        for (String type : bestBridgeTypes) {
            if (Math.min(mainMatches.get(type).getNumPairsSupportExonA(), mainMatches.get(type).getNumPairsSupportExonB()) != maxMin) continue;
            bestTypes.add(type);
        }
        if (bestTypes.size() == 1) {
            return (String)bestTypes.get(0);
        }
        return SummarizeTypingResult.rankByTotal(bestTypes, mainMatches);
    }

    private static String rankByTotal(List<String> bestTypes, Map<String, MatchStatistics> mainMatches) {
        int max = 0;
        String btype = null;
        for (String type : bestTypes) {
            int total = mainMatches.get(type).getNumPairsSupportExonA() + mainMatches.get(type).getNumPairsSupportExonB();
            if (max == 0) {
                btype = type;
                max = total;
                continue;
            }
            if (total <= max) continue;
            max = total;
            btype = type;
        }
        return btype;
    }

    private static void separateMatches(Map<String, MatchStatistics> mainMatchesA, Map<String, MatchStatistics> mainMatchesB, Map<String, MatchStatistics> mainMatches) {
        String group = null;
        for (String type : mainMatches.keySet()) {
            if (group == null) {
                group = SummarizeTypingResult.extractMainTypeString(type);
                mainMatchesA.put(type, mainMatches.get(type));
                continue;
            }
            if (!group.equals(SummarizeTypingResult.extractMainTypeString(type))) {
                mainMatchesB.put(type, mainMatches.get(type));
                continue;
            }
            mainMatchesA.put(type, mainMatches.get(type));
        }
    }

    private static Map<String, MatchStatistics> filterMatches(Map<String, MatchStatistics> inputMatches) {
        int max1 = 0;
        int max2 = 0;
        for (MatchStatistics matchStatistics : inputMatches.values()) {
            if (matchStatistics.getNumPairsSupportExonA() > max1) {
                max1 = matchStatistics.getNumPairsSupportExonA();
            }
            if (matchStatistics.getNumPairsSupportExonB() <= max2) continue;
            max2 = matchStatistics.getNumPairsSupportExonB();
        }
        Map<String, MatchStatistics> mainMatches = new LinkedHashMap<String, MatchStatistics>();
        int i = 0;
        while (i < 8) {
            mainMatches = SummarizeTypingResult.getMatches(inputMatches, i, max1, max2);
            if (SummarizeTypingResult.findMultiGroup(mainMatches)) break;
            ++i;
        }
        if (!SummarizeTypingResult.findMultiGroup(mainMatches)) {
            mainMatches = SummarizeTypingResult.getMatches(inputMatches, 0, max1, max2);
        }
        if (mainMatches.size() == 0) {
            mainMatches = SummarizeTypingResult.getBestMatches(inputMatches, max1, max2);
        }
        return mainMatches;
    }

    private static Map<String, MatchStatistics> getBestMatches(Map<String, MatchStatistics> inputMatches, int max1, int max2) {
        LinkedHashMap<String, MatchStatistics> matches = new LinkedHashMap<String, MatchStatistics>();
        boolean foundA = false;
        boolean foundB = false;
        for (String type : inputMatches.keySet()) {
            if (inputMatches.get(type).getNumPairsSupportExonA() == max1 && !foundA) {
                foundA = true;
                matches.put(type, inputMatches.get(type));
            }
            if (inputMatches.get(type).getNumPairsSupportExonB() != max2 || foundB) continue;
            foundB = true;
            matches.put(type, inputMatches.get(type));
        }
        return matches;
    }

    private static Map<String, MatchStatistics> getMatches(Map<String, MatchStatistics> inputMatches, int i, int max1, int max2) {
        LinkedHashMap<String, MatchStatistics> matches = new LinkedHashMap<String, MatchStatistics>();
        for (String type : inputMatches.keySet()) {
            if (!((double)inputMatches.get(type).getNumPairsSupportExonA() * ((double)i + 2.25) > (double)max1) || !((double)inputMatches.get(type).getNumPairsSupportExonB() * ((double)i + 2.25) > (double)max2)) continue;
            matches.put(type, inputMatches.get(type));
        }
        return matches;
    }

    private static boolean findMultiGroup(Map<String, MatchStatistics> mainMatches) {
        String group = null;
        for (String type : mainMatches.keySet()) {
            if (group == null) {
                group = SummarizeTypingResult.extractMainTypeString(type);
                continue;
            }
            if (group.equals(SummarizeTypingResult.extractMainTypeString(type))) continue;
            System.out.println(">>>>>>>>find " + group + " " + SummarizeTypingResult.extractMainTypeString(type));
            return true;
        }
        return false;
    }

    private static String extractMainTypeString(String type) {
        return type.split("\\*")[1].split(":")[0];
    }

    private static int getMaxBridgeCount(Map<String, MatchStatistics> mainMatches) {
        int max = 0;
        for (String type : mainMatches.keySet()) {
            MatchStatistics matchStatistics = mainMatches.get(type);
            if (matchStatistics.getBridgeCount() <= max) continue;
            max = matchStatistics.getBridgeCount();
        }
        return max;
    }

    private static void workForSingleExon(LocusExon locusExon, Map<String, String> sequences, Map<String, MatchStatistics> matches, LocusExonResult sampleExonResult, Map<String, MatchStatistics> mainMatches, Map<String, MatchStatistics> perfectMatches) {
        if (mainMatches.size() == 0) {
            SummarizeTypingResult.getTopPerfectData(locusExon, matches, sampleExonResult);
        } else if (mainMatches.size() == 1) {
            SummarizeTypingResult.generateHomoResult(mainMatches, sampleExonResult);
            boolean isEnoughPopulation = SummarizeTypingResult.checkFirmPopulation(sampleExonResult.getType1(), mainMatches.get(sampleExonResult.getType1()), sampleExonResult, false);
            boolean isContainQuestionPos = SummarizeTypingResult.checkQuestionPosition(sampleExonResult.getType1(), mainMatches.get(sampleExonResult.getType1()), locusExon, sampleExonResult, false);
            boolean isOtherAlleleExist = SummarizeTypingResult.checkOtherAlleleExist(matches, sampleExonResult, sequences, locusExon, sampleExonResult.getType1(), true);
            if (isEnoughPopulation && !isContainQuestionPos && !isOtherAlleleExist) {
                SummarizeTypingResult.addToLog(sampleExonResult, HOMOZYGOUS);
                sampleExonResult.setFirm(true);
            }
        } else if (mainMatches.size() == 2) {
            if ((locusExon.getLocus().equals(DQB1) && !locusExon.isMajor || locusExon.getLocus().equals(DQA1) && !locusExon.isMajor) && SummarizeTypingResult.secondTypeFromRecombination(mainMatches, sampleExonResult, sequences, locusExon, perfectMatches)) {
                boolean isEnoughPopulation = SummarizeTypingResult.checkFirmPopulation(sampleExonResult.getType1(), mainMatches.get(sampleExonResult.getType1()), sampleExonResult, false);
                boolean isContainQuestionPos = SummarizeTypingResult.checkQuestionPosition(sampleExonResult.getType1(), mainMatches.get(sampleExonResult.getType1()), locusExon, sampleExonResult, false);
                boolean isOtherAlleleExist = SummarizeTypingResult.checkOtherAlleleExist(matches, sampleExonResult, sequences, locusExon, sampleExonResult.getType1(), false);
                if (isEnoughPopulation && !isContainQuestionPos && !isOtherAlleleExist) {
                    sampleExonResult.setFirm(true);
                } else {
                    sampleExonResult.setFirm(false);
                }
            } else {
                sampleExonResult.setType1(null);
                sampleExonResult.setType2(null);
                SummarizeTypingResult.generateHeterResult(mainMatches, sampleExonResult);
                sampleExonResult.setFirm(true);
                if (!SummarizeTypingResult.checkFirmPopulation(sampleExonResult.getType1(), mainMatches.get(sampleExonResult.getType1()), sampleExonResult, false) || !SummarizeTypingResult.checkFirmPopulation(sampleExonResult.getType2(), mainMatches.get(sampleExonResult.getType2()), sampleExonResult, false) || SummarizeTypingResult.checkQuestionPosition(sampleExonResult.getType1(), mainMatches.get(sampleExonResult.getType1()), locusExon, sampleExonResult, false) || SummarizeTypingResult.checkQuestionPosition(sampleExonResult.getType2(), mainMatches.get(sampleExonResult.getType2()), locusExon, sampleExonResult, false) || !SummarizeTypingResult.passPopulationDistanceCheck(sampleExonResult.getType1(), mainMatches.get(sampleExonResult.getType1()), sampleExonResult.getType2(), mainMatches.get(sampleExonResult.getType2()), sampleExonResult) || !SummarizeTypingResult.TypesWithMajorDifference(sampleExonResult.getType1(), sampleExonResult.getType2(), sequences, sampleExonResult, locusExon, mainMatches) || SummarizeTypingResult.checkDropOff(sampleExonResult.getType1(), mainMatches.get(sampleExonResult.getType1()), sampleExonResult) || SummarizeTypingResult.checkDropOff(sampleExonResult.getType2(), mainMatches.get(sampleExonResult.getType2()), sampleExonResult)) {
                    sampleExonResult.setFirm(false);
                }
            }
        } else if (mainMatches.size() > 2) {
            SummarizeTypingResult.addToLog(sampleExonResult, ">2 types");
            if (locusExon.getLocus().equals(DRB1345) || locusExon.getLocus().equals(DPB1) && !locusExon.isMajor || locusExon.getLocus().equals(DQB1) && !locusExon.isMajor || locusExon.getLocus().equals(DQA1) && !locusExon.isMajor || locusExon.getLocus().equals(HLAA) && !locusExon.isMajor || locusExon.getLocus().equals(HLAB) && !locusExon.isMajor || locusExon.getLocus().equals(HLAC) && !locusExon.isMajor) {
                SummarizeTypingResult.identifyTrueTypesOtherGeneExist(mainMatches, sampleExonResult, sequences, locusExon, perfectMatches);
            } else {
                SummarizeTypingResult.identifyTrueTypes(mainMatches, sampleExonResult, sequences, locusExon, perfectMatches);
            }
            if (!SummarizeTypingResult.checkFirmPopulation(sampleExonResult.getType1(), mainMatches.get(sampleExonResult.getType1()), sampleExonResult, false) || !SummarizeTypingResult.checkFirmPopulation(sampleExonResult.getType2(), mainMatches.get(sampleExonResult.getType2()), sampleExonResult, false) || SummarizeTypingResult.checkQuestionPosition(sampleExonResult.getType1(), mainMatches.get(sampleExonResult.getType1()), locusExon, sampleExonResult, false) || SummarizeTypingResult.checkQuestionPosition(sampleExonResult.getType2(), mainMatches.get(sampleExonResult.getType2()), locusExon, sampleExonResult, false) || !SummarizeTypingResult.passPopulationDistanceCheck(sampleExonResult.getType1(), mainMatches.get(sampleExonResult.getType1()), sampleExonResult.getType2(), mainMatches.get(sampleExonResult.getType2()), sampleExonResult)) {
                sampleExonResult.setFirm(false);
            }
        }
    }

    private static void getTopPerfectData(LocusExon locusExon, Map<String, MatchStatistics> matches, LocusExonResult sampleExonResult) {
        Map<String, MatchStatistics> perfectMatches = SummarizeTypingResult.filterForGoodMatches(matches, locusExon, false);
        Map<String, MatchStatistics> mainMatches = SummarizeTypingResult.seperateOtherTypes(locusExon, sampleExonResult, perfectMatches);
        if (mainMatches.size() == 1) {
            SummarizeTypingResult.generateHomoResult(mainMatches, sampleExonResult);
        } else if (mainMatches.size() == 2) {
            SummarizeTypingResult.generateHeterResult(mainMatches, sampleExonResult);
        }
        SummarizeTypingResult.addToLog(sampleExonResult, NO_PERFECT_RESULT);
    }

    private static void verifyDRBlogic(LocusExonResult sampleExonResult) {
        if (sampleExonResult.getType1() == null && sampleExonResult.getType2() == null) {
            return;
        }
        if (sampleExonResult.getOtherTypes() == null || sampleExonResult.getOtherTypes().length() == 0) {
            if (SummarizeTypingResult.isDRB345groupTypes(sampleExonResult)) {
                sampleExonResult.setFirm(false);
            }
            return;
        }
        if (sampleExonResult.getOtherTypes().indexOf("DRB3") >= 0 && !SummarizeTypingResult.isDRB3groupTypes(sampleExonResult.getType1()) && !SummarizeTypingResult.isDRB3groupTypes(sampleExonResult.getType2())) {
            SummarizeTypingResult.addBeggingLog(sampleExonResult, "Error:DRB3 Present, but no DRB1*3/11/12/13/14");
            sampleExonResult.setFirm(false);
        }
        if (sampleExonResult.getOtherTypes().indexOf("DRB4") >= 0 && !SummarizeTypingResult.isDRB4groupTypes(sampleExonResult.getType1()) && !SummarizeTypingResult.isDRB4groupTypes(sampleExonResult.getType2())) {
            SummarizeTypingResult.addBeggingLog(sampleExonResult, "Error:DRB4 Present, but no DRB1*4/7/9");
            sampleExonResult.setFirm(false);
        }
        if (sampleExonResult.getOtherTypes().indexOf("DRB5") >= 0 && !SummarizeTypingResult.isDRB5groupTypes(sampleExonResult.getType1()) && !SummarizeTypingResult.isDRB5groupTypes(sampleExonResult.getType2())) {
            SummarizeTypingResult.addBeggingLog(sampleExonResult, "Error:DRB5 Present, but no DRB1*15/16");
            sampleExonResult.setFirm(false);
        }
    }

    private static boolean isDRB345groupTypes(LocusExonResult sampleExonResult) {
        if (SummarizeTypingResult.isDRB3groupTypes(sampleExonResult.getType1()) || SummarizeTypingResult.isDRB3groupTypes(sampleExonResult.getType2())) {
            SummarizeTypingResult.addBeggingLog(sampleExonResult, "Error:DRB3 missing");
            return true;
        }
        if (SummarizeTypingResult.isDRB4groupTypes(sampleExonResult.getType1()) || SummarizeTypingResult.isDRB4groupTypes(sampleExonResult.getType2())) {
            SummarizeTypingResult.addBeggingLog(sampleExonResult, "Error:DRB4 missing");
            return true;
        }
        if (SummarizeTypingResult.isDRB5groupTypes(sampleExonResult.getType1()) || SummarizeTypingResult.isDRB5groupTypes(sampleExonResult.getType2())) {
            SummarizeTypingResult.addBeggingLog(sampleExonResult, "Error:DRB5 missing");
            return true;
        }
        return false;
    }

    private static void addBeggingLog(LocusExonResult sampleExonResult, String msg) {
        if (sampleExonResult.getLog() == null) {
            sampleExonResult.setLog(msg);
        } else {
            sampleExonResult.setLog(String.valueOf(msg) + "," + sampleExonResult.getLog());
        }
    }

    private static boolean isDRB5groupTypes(String type) {
        return type.indexOf("DRB1*15") >= 0 || type.indexOf("DRB1*16") >= 0;
    }

    private static boolean isDRB4groupTypes(String type) {
        return type.indexOf("DRB1*04") >= 0 || type.indexOf("DRB1*07") >= 0 || type.indexOf("DRB1*09") >= 0;
    }

    private static boolean isDRB3groupTypes(String type) {
        return type.indexOf("DRB1*03") >= 0 || type.indexOf("DRB1*11") >= 0 || type.indexOf("DRB1*12") >= 0 || type.indexOf("DRB1*13") >= 0 || type.indexOf("DRB1*14") >= 0;
    }

    private static boolean checkDropOff(String type, MatchStatistics matchStatistics, LocusExonResult sampleExonResult) {
        if (matchStatistics.isDropOff()) {
            SummarizeTypingResult.addToLog(sampleExonResult, String.valueOf(type) + " allele Drop Off");
            return true;
        }
        return false;
    }

    private static boolean secondTypeFromRecombination(Map<String, MatchStatistics> mainMatches, LocusExonResult sampleExonResult, Map<String, String> sequences, LocusExon locusExon, Map<String, MatchStatistics> perfectMatches) {
        StringBuilder homoLog;
        boolean isValidatedAsHomo;
        String type1 = null;
        String type2 = null;
        for (String type : mainMatches.keySet()) {
            if (type1 == null) {
                type1 = type;
                continue;
            }
            if (type2 != null) continue;
            type2 = type;
        }
        LinkedHashMap<String, Map<Integer, String>> discrepancyPositions = new LinkedHashMap<String, Map<Integer, String>>();
        discrepancyPositions.put(type2, SummarizeTypingResult.getDiscrepancies(type2, type1, perfectMatches));
        ArrayList<String> allOtherTypes = new ArrayList<String>();
        if (sampleExonResult.getOtherTypes() != null && sampleExonResult.getOtherTypes().length() > 0) {
            String[] otherTypes;
            String[] stringArray = otherTypes = sampleExonResult.getOtherTypes().split(",");
            int n = otherTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String otherType = stringArray[n2];
                allOtherTypes.add(otherType);
                discrepancyPositions.put(otherType, SummarizeTypingResult.getDiscrepancies(otherType, type1, perfectMatches));
                ++n2;
            }
        }
        if ((float)mainMatches.get(type2).getNumPairsSupport() < (float)mainMatches.get(type1).getNumPairsSupport() * 0.55f && (isValidatedAsHomo = SummarizeTypingResult.recombineHomoValidation(mainMatches, sampleExonResult, type1, discrepancyPositions, allOtherTypes, homoLog = new StringBuilder()))) {
            System.out.println("find homo sample result " + type1 + " not using---- " + type2);
            sampleExonResult.setFirm(true);
            SummarizeTypingResult.addToLog(sampleExonResult, homoLog.toString());
            return true;
        }
        return false;
    }

    private static boolean checkOtherAlleleExist(Map<String, MatchStatistics> mainMatches, LocusExonResult sampleExonResult, Map<String, String> sequences, LocusExon locusExon, String homoType, boolean isHomoCheck) {
        LinkedHashMap<String, Map<Integer, String>> discrepancyPositions = new LinkedHashMap<String, Map<Integer, String>>();
        for (String type : mainMatches.keySet()) {
            if (type.equals(homoType)) continue;
            discrepancyPositions.put(type, SummarizeTypingResult.getDiscrepancies(type, homoType, mainMatches));
        }
        ArrayList<String> allOtherTypes = new ArrayList<String>();
        if (sampleExonResult.getOtherTypes() != null && sampleExonResult.getOtherTypes().length() > 0) {
            String[] otherTypes;
            String[] stringArray = otherTypes = sampleExonResult.getOtherTypes().split(",");
            int n = otherTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String otherType = stringArray[n2];
                allOtherTypes.add(otherType);
                discrepancyPositions.put(otherType, SummarizeTypingResult.getDiscrepancies(otherType, homoType, mainMatches));
                ++n2;
            }
        }
        for (String type : discrepancyPositions.keySet()) {
            if (type.equals(homoType) || allOtherTypes.contains(type) || SummarizeTypingResult.isOtherType(locusExon, type) || SummarizeTypingResult.isSubsetType(type, homoType, allOtherTypes, discrepancyPositions, mainMatches.get(type))) continue;
            if (isHomoCheck) {
                sampleExonResult.setType2(type);
                SummarizeTypingResult.addToLog(sampleExonResult, String.valueOf(type) + " not fully covered");
            } else {
                SummarizeTypingResult.addToLog(sampleExonResult, String.valueOf(type) + "(unique)");
            }
            return true;
        }
        return false;
    }

    private static boolean isOtherType(LocusExon locusExon, String type) {
        List<String> otherTypeNames = locusExon.getOtherTypeNames();
        return otherTypeNames.contains(type.split("\\*")[0]);
    }

    private static boolean isSubsetType(String type, String homoType, List<String> allOtherTypes, Map<String, Map<Integer, String>> discrepancyPositions, MatchStatistics matchStatistics) {
        Map<Integer, String> discrepencies = discrepancyPositions.get(type);
        for (Integer pos : discrepencies.keySet()) {
            if (SummarizeTypingResult.isQuestionPos(pos, matchStatistics.getQuestionPos()) || matchStatistics.getCoverageString().length() <= pos || SummarizeTypingResult.isWeakPosition(String.valueOf(matchStatistics.getCoverageString().charAt(pos))) || discrepencies.get(pos).equalsIgnoreCase("*")) continue;
            boolean isOK = false;
            for (String otherType : allOtherTypes) {
                Map<Integer, String> otherDiscrepencies = discrepancyPositions.get(otherType);
                if (!otherDiscrepencies.containsKey(pos) || !discrepencies.get(pos).equals(otherDiscrepencies.get(pos))) continue;
                isOK = true;
            }
            if (isOK) continue;
            return false;
        }
        return true;
    }

    private static void identifyTrueTypes(Map<String, MatchStatistics> mainMatches, LocusExonResult sampleExonResult, Map<String, String> sequences, LocusExon locusExon, Map<String, MatchStatistics> perfectMatches) {
        String type1 = null;
        String type2 = null;
        int topPopulation = 0;
        for (String type : mainMatches.keySet()) {
            if (type1 != null) continue;
            type1 = type;
            topPopulation = mainMatches.get(type).getNumPairsSupport();
            break;
        }
        LinkedHashMap<String, Map<Integer, String>> discrepancyPositions = new LinkedHashMap<String, Map<Integer, String>>();
        for (String type : mainMatches.keySet()) {
            if (type.equals(type1)) continue;
            if (SummarizeTypingResult.isDQAexon2DiffGroups(type, type1, locusExon) && type2 == null) {
                type2 = type;
            }
            discrepancyPositions.put(type, SummarizeTypingResult.getDiscrepancies(type, type1, perfectMatches));
        }
        if (type2 == null) {
            type2 = SummarizeTypingResult.getFurtherestDistanceType(discrepancyPositions, mainMatches, topPopulation);
        }
        ArrayList<String> allOtherTypes = new ArrayList<String>();
        if (sampleExonResult.getOtherTypes() != null && sampleExonResult.getOtherTypes().length() > 0) {
            String[] otherTypes;
            String[] stringArray = otherTypes = sampleExonResult.getOtherTypes().split(",");
            int n = otherTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String otherType = stringArray[n2];
                allOtherTypes.add(otherType);
                discrepancyPositions.put(otherType, SummarizeTypingResult.getDiscrepancies(otherType, type1, perfectMatches));
                ++n2;
            }
        }
        StringBuilder log = new StringBuilder();
        SummarizeTypingResult.addToLog(sampleExonResult, "recombinedCheck");
        boolean isAllValidated = SummarizeTypingResult.recombineValidation(mainMatches, sampleExonResult, type1, type2, discrepancyPositions, allOtherTypes, log);
        if (isAllValidated) {
            sampleExonResult.setFirm(true);
            SummarizeTypingResult.addToLog(sampleExonResult, log.toString());
        } else if (SummarizeTypingResult.isAllGoodPos(mainMatches.get(type2))) {
            sampleExonResult.setFirm(false);
            SummarizeTypingResult.addToLog(sampleExonResult, log.toString());
        } else {
            System.out.println("recombineValidation failed reset to next type !! not using " + type2 + " " + SummarizeTypingResult.isAllGoodPos(mainMatches.get(type2)));
            type2 = SummarizeTypingResult.getNextType(discrepancyPositions, mainMatches, topPopulation, new ArrayList<String>(), allOtherTypes, 0);
            StringBuilder log1 = new StringBuilder();
            isAllValidated = SummarizeTypingResult.recombineValidation(mainMatches, sampleExonResult, type1, type2, discrepancyPositions, allOtherTypes, log1);
            if (isAllValidated) {
                sampleExonResult.setFirm(true);
            }
            SummarizeTypingResult.addToLog(sampleExonResult, log1.toString());
        }
    }

    private static boolean isAllGoodPos(MatchStatistics matchStatistics) {
        String coverageString = matchStatistics.getCoverageString();
        int i = 0;
        while (i < coverageString.length()) {
            String coverage = String.valueOf(matchStatistics.getCoverageString().charAt(i));
            if (!coverage.equals(".") && Integer.valueOf(coverage) < 3) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static void identifyTrueTypesOtherGeneExist(Map<String, MatchStatistics> mainMatches, LocusExonResult sampleExonResult, Map<String, String> sequences, LocusExon locusExon, Map<String, MatchStatistics> perfectMatches) {
        StringBuilder homoLog;
        boolean isValidatedAsHomo;
        String type1 = null;
        String type2 = null;
        int topPopulation = 0;
        for (String type : mainMatches.keySet()) {
            if (type1 != null) continue;
            type1 = type;
            topPopulation = mainMatches.get(type).getNumPairsSupport();
            break;
        }
        LinkedHashMap<String, Map<Integer, String>> discrepancyPositions = new LinkedHashMap<String, Map<Integer, String>>();
        for (String type : mainMatches.keySet()) {
            if (type.equals(type1)) continue;
            discrepancyPositions.put(type, SummarizeTypingResult.getDiscrepancies(type, type1, perfectMatches));
        }
        ArrayList<String> allOtherTypes = new ArrayList<String>();
        if (sampleExonResult.getOtherTypes() != null && sampleExonResult.getOtherTypes().length() > 0) {
            String[] otherTypes;
            String[] stringArray = otherTypes = sampleExonResult.getOtherTypes().split(",");
            int n = otherTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String otherType = stringArray[n2];
                allOtherTypes.add(otherType);
                discrepancyPositions.put(otherType, SummarizeTypingResult.getDiscrepancies(otherType, type1, perfectMatches));
                ++n2;
            }
        }
        ArrayList<String> excludingTypes = new ArrayList<String>();
        SummarizeTypingResult.addToLog(sampleExonResult, "recombinedCheck");
        type2 = SummarizeTypingResult.getBestDropOffType(type1, mainMatches);
        if (type2 != null) {
            sampleExonResult.setType1(type1);
            sampleExonResult.setType2(type2);
            SummarizeTypingResult.addToLog(sampleExonResult, String.valueOf(type2) + " dropOff");
            return;
        }
        type2 = SummarizeTypingResult.getNextType(discrepancyPositions, mainMatches, topPopulation, excludingTypes, allOtherTypes, 0);
        if ((float)mainMatches.get(type2).getNumPairsSupport() < (float)topPopulation * 0.5f && (isValidatedAsHomo = SummarizeTypingResult.recombineHomoValidation(mainMatches, sampleExonResult, type1, discrepancyPositions, allOtherTypes, homoLog = new StringBuilder()))) {
            System.out.println("find homo sample result " + type1 + " not using " + type2);
            sampleExonResult.setFirm(true);
            SummarizeTypingResult.addToLog(sampleExonResult, homoLog.toString());
            return;
        }
        int i = 0;
        while (i < 5) {
            type2 = SummarizeTypingResult.getNextType(discrepancyPositions, mainMatches, topPopulation, excludingTypes, allOtherTypes, i);
            if (type2 == null) break;
            StringBuilder log = new StringBuilder();
            boolean isAllValidated = SummarizeTypingResult.recombineValidation(mainMatches, sampleExonResult, type1, type2, discrepancyPositions, allOtherTypes, log);
            if (isAllValidated) {
                sampleExonResult.setFirm(true);
                SummarizeTypingResult.addToLog(sampleExonResult, log.toString());
                break;
            }
            excludingTypes.add(type2);
            ++i;
        }
        if (!sampleExonResult.isFirm()) {
            type2 = SummarizeTypingResult.getNextType(discrepancyPositions, mainMatches, topPopulation, new ArrayList<String>(), allOtherTypes, 0);
            StringBuilder log = new StringBuilder();
            SummarizeTypingResult.recombineValidation(mainMatches, sampleExonResult, type1, type2, discrepancyPositions, allOtherTypes, log);
            SummarizeTypingResult.addToLog(sampleExonResult, log.toString());
        }
    }

    private static String getBestDropOffType(String type1, Map<String, MatchStatistics> mainMatches) {
        ArrayList<String> allDropOffTypes = new ArrayList<String>();
        for (String name : mainMatches.keySet()) {
            if (name.equals(type1) || !mainMatches.get(name).isDropOff() || mainMatches.get(name).getDropOffCount() * 3 <= mainMatches.get(type1).getNumPairsSupport()) continue;
            allDropOffTypes.add(name);
        }
        String bestType = null;
        for (String type : allDropOffTypes) {
            if (bestType == null) {
                bestType = type;
                continue;
            }
            if (mainMatches.get(type).getQuestionPos().size() >= mainMatches.get(bestType).getQuestionPos().size()) continue;
            bestType = type;
        }
        return bestType;
    }

    private static boolean recombineHomoValidation(Map<String, MatchStatistics> mainMatches, LocusExonResult sampleExonResult, String type1, Map<String, Map<Integer, String>> discrepancyPositions, List<String> allOtherTypes, StringBuilder log) {
        boolean isAllValidated = true;
        for (String type : discrepancyPositions.keySet()) {
            if (allOtherTypes.contains(type)) continue;
            if (SummarizeTypingResult.isRecombinedFromOtherTypes(type, type1, null, allOtherTypes, discrepancyPositions, mainMatches.get(type))) {
                log.append(",").append(String.valueOf(type) + "(T)");
                continue;
            }
            log.append(",").append(String.valueOf(type) + "(F)");
            isAllValidated = false;
        }
        sampleExonResult.setType1(type1);
        sampleExonResult.setType2(type1);
        return isAllValidated;
    }

    private static boolean recombineValidation(Map<String, MatchStatistics> mainMatches, LocusExonResult sampleExonResult, String type1, String type2, Map<String, Map<Integer, String>> discrepancyPositions, List<String> allOtherTypes, StringBuilder log) {
        boolean isAllValidated = true;
        for (String type : discrepancyPositions.keySet()) {
            if (type.equals(type2) || allOtherTypes.contains(type) || type.indexOf(SUDO) > 0) continue;
            if (SummarizeTypingResult.isRecombined(type, type1, type2, discrepancyPositions, mainMatches.get(type)) || SummarizeTypingResult.isRecombinedFromOtherTypes(type, type1, type2, allOtherTypes, discrepancyPositions, mainMatches.get(type))) {
                log.append(",").append(String.valueOf(type) + "(T)");
                continue;
            }
            log.append(",").append(String.valueOf(type) + "(F)");
            isAllValidated = false;
        }
        sampleExonResult.setType1(type1);
        sampleExonResult.setType2(type2);
        return isAllValidated;
    }

    private static String getNextType(Map<String, Map<Integer, String>> discrepancyPositions, Map<String, MatchStatistics> mainMatches, int topPopulation, List<String> excludingTypes, List<String> allOtherTypes, int roundNum) {
        String type2;
        if (roundNum == 0) {
            for (String type2 : discrepancyPositions.keySet()) {
                if (excludingTypes.contains(type2) || allOtherTypes.contains(type2) || mainMatches.get(type2).getNumPairsSupport() <= topPopulation) continue;
                return type2;
            }
        }
        Iterator<String> iterator = discrepancyPositions.keySet().iterator();
        while (iterator.hasNext()) {
            type2 = iterator.next();
            if (excludingTypes.contains(type2) || allOtherTypes.contains(type2) || !((float)mainMatches.get(type2).getNumPairsSupport() > (float)topPopulation * 0.4f) && (!((float)mainMatches.get(type2).getNumPairsSupport() > (float)topPopulation * 0.25f) || mainMatches.get(type2).getQuestionPos().size() != 0)) continue;
            return type2;
        }
        if (roundNum == 0 && (iterator = discrepancyPositions.keySet().iterator()).hasNext()) {
            type2 = iterator.next();
            return type2;
        }
        return null;
    }

    private static boolean isRecombinedFromOtherTypes(String type, String type1, String type2, List<String> allOtherTypes, Map<String, Map<Integer, String>> discrepancyPositions, MatchStatistics matchStatistics) {
        if (allOtherTypes.size() == 0) {
            return false;
        }
        for (String otherType : allOtherTypes) {
            if (!SummarizeTypingResult.isRecombined(type, type1, otherType, discrepancyPositions, matchStatistics) && (type2 == null || !SummarizeTypingResult.isRecombined(type, type2, otherType, discrepancyPositions, matchStatistics))) continue;
            System.out.println("find recombine " + type + " from " + otherType);
            return true;
        }
        return false;
    }

    private static boolean isRecombined(String type, String type1, String type2, Map<String, Map<Integer, String>> discrepancyPositions, MatchStatistics matchStatistics) {
        Map<Integer, String> discrepencies = discrepancyPositions.get(type);
        Map<Integer, String> discrepencies1 = discrepancyPositions.get(type1);
        Map<Integer, String> discrepencies2 = discrepancyPositions.get(type2);
        for (Integer pos : discrepencies.keySet()) {
            if (SummarizeTypingResult.isQuestionPos(pos, matchStatistics.getQuestionPos()) || SummarizeTypingResult.isWeakPosition(String.valueOf(matchStatistics.getCoverageString().charAt(pos))) || discrepencies2.containsKey(pos) && discrepencies.get(pos).equals(discrepencies2.get(pos)) || (discrepencies1 == null || discrepencies1.containsKey(pos) && discrepencies.get(pos).equals(discrepencies1.get(pos))) && discrepencies1 != null) continue;
            return false;
        }
        return true;
    }

    private static boolean isWeakPosition(String coverage) {
        return coverage.equals(" ") || coverage.equals(".") || Integer.valueOf(coverage) < 2;
    }

    private static boolean isQuestionPos(Integer pos, List<Integer> questionPos) {
        return questionPos.contains(pos);
    }

    private static String getFurtherestDistanceType(Map<String, Map<Integer, String>> discrepancyPositions, Map<String, MatchStatistics> mainMatches, int topPopulation) {
        String hypType = null;
        int maxCount = 0;
        for (String type : discrepancyPositions.keySet()) {
            if (mainMatches.get(type).getNumPairsSupport() >= topPopulation) {
                return type;
            }
            if (!((float)mainMatches.get(type).getNumPairsSupport() > (float)topPopulation * 0.4f) && (!((float)mainMatches.get(type).getNumPairsSupport() > (float)topPopulation * 0.25f) || mainMatches.get(type).getQuestionPos().size() != 0) || discrepancyPositions.get(type).size() <= maxCount) continue;
            hypType = type;
            maxCount = discrepancyPositions.get(type).size();
        }
        if (hypType == null) {
            for (String type : discrepancyPositions.keySet()) {
                if (hypType != null) continue;
                return type;
            }
        }
        return hypType;
    }

    private static Map<Integer, String> getDiscrepancies(String query, String target, Map<String, MatchStatistics> mainMatches) {
        LinkedHashMap<Integer, String> positions = new LinkedHashMap<Integer, String>();
        String querySeq = mainMatches.get(query).getAlignmentString();
        String targetSeq = mainMatches.get(target).getAlignmentString();
        int i = 0;
        while (i < Math.min(targetSeq.length(), querySeq.length())) {
            if (querySeq.charAt(i) != targetSeq.charAt(i)) {
                positions.put(i, String.valueOf(querySeq.charAt(i)));
            }
            ++i;
        }
        return positions;
    }

    private static boolean checkFirmPopulation(String type, MatchStatistics matchStatistics, LocusExonResult sampleExonResult, boolean isOtherType) {
        if (matchStatistics == null) {
            if (isOtherType) {
                SummarizeTypingResult.addToOtherLog(sampleExonResult, String.valueOf(type) + " missing coverage");
            }
            return false;
        }
        if (matchStatistics.getNumPairsSupport() < FIRM_SUPPORT_READS) {
            if (isOtherType) {
                SummarizeTypingResult.addToOtherLog(sampleExonResult, String.valueOf(type) + "<" + FIRM_SUPPORT_READS + "pairs");
            }
            return false;
        }
        String coverage = matchStatistics.getCoverageString();
        int i = 0;
        while (i < coverage.length()) {
            if (!String.valueOf(coverage.charAt(i)).equals(".") && (String.valueOf(coverage.charAt(i)).equals(" ") || Integer.valueOf(String.valueOf(coverage.charAt(i))) < 2)) {
                if (isOtherType) {
                    SummarizeTypingResult.addToOtherLog(sampleExonResult, String.valueOf(type) + " contains weak point");
                } else {
                    SummarizeTypingResult.addToLog(sampleExonResult, String.valueOf(type) + " contains weak point");
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean passPopulationDistanceCheck(String type1, MatchStatistics matchStatistics1, String type2, MatchStatistics matchStatistics2, LocusExonResult sampleExonResult) {
        if (matchStatistics1.getNumPairsSupportExonA() > 0 || matchStatistics1.getNumPairsSupportExonB() > 0) {
            if (matchStatistics1.getNumPairsSupportExonA() > matchStatistics2.getNumPairsSupportExonA() * 4 || matchStatistics2.getNumPairsSupportExonA() > matchStatistics1.getNumPairsSupportExonA() * 4) {
                SummarizeTypingResult.addToLog(sampleExonResult, "Population Diff>75% in exon2");
                return false;
            }
            if (matchStatistics1.getNumPairsSupportExonB() > matchStatistics2.getNumPairsSupportExonB() * 4 || matchStatistics2.getNumPairsSupportExonB() > matchStatistics1.getNumPairsSupportExonB() * 4) {
                SummarizeTypingResult.addToLog(sampleExonResult, "Population Diff>75% in exon3");
                return false;
            }
            return true;
        }
        if (matchStatistics1.getNumPairsSupport() > matchStatistics2.getNumPairsSupport() * 4 || matchStatistics2.getNumPairsSupport() > matchStatistics1.getNumPairsSupport() * 2) {
            SummarizeTypingResult.addToLog(sampleExonResult, "Population Diff>75%");
            return false;
        }
        return true;
    }

    private static boolean checkQuestionPosition(String type, MatchStatistics matchStatistics, LocusExon locusExon, LocusExonResult sampleExonResult, boolean isOtherType) {
        if (matchStatistics == null) {
            return true;
        }
        if (matchStatistics.getQuestionPos().size() > 0 && !SummarizeTypingResult.questionPositionOK(matchStatistics.getQuestionPos(), locusExon.getIgnoredPrimerDiffPositions())) {
            if (isOtherType) {
                SummarizeTypingResult.addToOtherLog(sampleExonResult, String.valueOf(type) + " question position " + matchStatistics.formatQuestionPostion(matchStatistics.getQuestionPos()));
            } else {
                SummarizeTypingResult.addToLog(sampleExonResult, String.valueOf(type) + " question position " + matchStatistics.formatQuestionPostion(matchStatistics.getQuestionPos()));
            }
            return true;
        }
        return false;
    }

    private static void generateHeterResult(Map<String, MatchStatistics> mainMatches, LocusExonResult sampleExonResult) {
        for (String type : mainMatches.keySet()) {
            if (sampleExonResult.getType1() == null) {
                sampleExonResult.setType1(type);
                continue;
            }
            if (sampleExonResult.getType2() != null) continue;
            sampleExonResult.setType2(type);
        }
    }

    private static boolean TypesWithMajorDifference(String type1, String type2, Map<String, String> sequences, LocusExonResult sampleExonResult, LocusExon locusExon, Map<String, MatchStatistics> mainMatches) {
        if (SummarizeTypingResult.isDQAexon2DiffGroups(type1, type2, locusExon)) {
            return true;
        }
        String seq1 = sequences.get(type1);
        String seq2 = sequences.get(type2);
        MatchStatistics st1 = mainMatches.get(type1);
        MatchStatistics st2 = mainMatches.get(type2);
        int diff = 0;
        int i = 0;
        while (i < seq1.length()) {
            if (i < seq2.length() && seq1.charAt(i) != 'N' && seq2.charAt(i) != 'N' && seq1.charAt(i) != seq2.charAt(i)) {
                ++diff;
                if (!SummarizeTypingResult.isWeakPosition(String.valueOf(st1.getCoverageString().charAt(i))) && !SummarizeTypingResult.isWeakPosition(String.valueOf(st2.getCoverageString().charAt(i)))) {
                    return true;
                }
                if (diff >= MAJOR_DIFF_COUNT) {
                    return true;
                }
            }
            ++i;
        }
        SummarizeTypingResult.addToLog(sampleExonResult, "2 types diff positions<" + MAJOR_DIFF_COUNT);
        return false;
    }

    private static boolean isDQAexon2DiffGroups(String type1, String type2, LocusExon locusExon) {
        if (locusExon.getLocus().equals("DQA1") && locusExon.equals("exon2")) {
            if (ParseFastaByHapType7.isSpecialDQA1exon2Type(type1) && !ParseFastaByHapType7.isSpecialDQA1exon2Type(type2)) {
                return true;
            }
            if (!ParseFastaByHapType7.isSpecialDQA1exon2Type(type1) && ParseFastaByHapType7.isSpecialDQA1exon2Type(type2)) {
                return true;
            }
        }
        return false;
    }

    private static void generateHomoResult(Map<String, MatchStatistics> mainMatches, LocusExonResult sampleExonResult) {
        for (String type : mainMatches.keySet()) {
            sampleExonResult.setType1(type);
            sampleExonResult.setType2(type);
        }
    }

    private static void addToOtherLog(LocusExonResult sampleExonResult, String msg) {
        if (sampleExonResult.getOtherLog() == null) {
            sampleExonResult.setOtherLog(msg);
        } else {
            sampleExonResult.setOtherLog(String.valueOf(sampleExonResult.getOtherLog()) + "," + msg);
        }
    }

    private static void addToLog(LocusExonResult sampleExonResult, String msg) {
        if (sampleExonResult.getLog() == null) {
            sampleExonResult.setLog(msg);
        } else {
            sampleExonResult.setLog(String.valueOf(sampleExonResult.getLog()) + "," + msg);
        }
    }

    private static Map<String, MatchStatistics> seperateOtherTypes(LocusExon locusExon, LocusExonResult sampleExonResult, Map<String, MatchStatistics> perfectMatches) {
        LinkedHashMap<String, MatchStatistics> mainMatches = new LinkedHashMap<String, MatchStatistics>();
        List<String> otherTypeNames = locusExon.getOtherTypeNames();
        for (String type : perfectMatches.keySet()) {
            if (otherTypeNames.contains(type.split("\\*")[0])) {
                String allOtherTypes = sampleExonResult.getOtherTypes();
                if (allOtherTypes == null || allOtherTypes.length() == 0) {
                    sampleExonResult.setOtherTypes(type);
                    continue;
                }
                sampleExonResult.setOtherTypes(String.valueOf(allOtherTypes) + "," + type);
                continue;
            }
            mainMatches.put(type, perfectMatches.get(type));
        }
        return mainMatches;
    }

    private static Map<String, MatchStatistics> filterForGoodMatches(Map<String, MatchStatistics> matches, LocusExon locusExon, boolean requirePerfectCoverage) {
        LinkedHashMap<String, MatchStatistics> perfectMatches = new LinkedHashMap<String, MatchStatistics>();
        if (requirePerfectCoverage) {
            for (String type : matches.keySet()) {
                MatchStatistics matchStatistics = matches.get(type);
                if (SummarizeTypingResult.withGoodNumber(matchStatistics, locusExon) && SummarizeTypingResult.isGoodMatch(matchStatistics, locusExon)) {
                    perfectMatches.put(type, matchStatistics);
                    continue;
                }
                if (!matchStatistics.isDropOff()) continue;
                perfectMatches.put(type, matchStatistics);
            }
        } else {
            int count = 0;
            for (String type : matches.keySet()) {
                MatchStatistics matchStatistics = matches.get(type);
                if (!SummarizeTypingResult.withGoodNumber(matchStatistics, locusExon) && !SummarizeTypingResult.isGoodMatch(matchStatistics, locusExon)) continue;
                perfectMatches.put(type, matchStatistics);
                if (++count < 2) {
                    continue;
                }
                break;
            }
        }
        return perfectMatches;
    }

    private static boolean withGoodNumber(MatchStatistics matchStatistics, LocusExon locusExon) {
        if (locusExon.getExon().equals(EXON23) && (matchStatistics.getNumPairsSupportExonA() > 0 || matchStatistics.getNumPairsSupportExonB() > 0)) {
            return Math.min(matchStatistics.getNumPairsSupportExonA(), matchStatistics.getNumPairsSupportExonB()) > MIN_SUPPORT_READS;
        }
        return matchStatistics.getNumPairsSupport() >= MIN_SUPPORT_READS;
    }

    private static boolean isGoodMatch(MatchStatistics matchStatistics, LocusExon locusExon) {
        if (matchStatistics.getExonSize() == matchStatistics.getNumPosGoodCoverage()) {
            return true;
        }
        if (locusExon.getLocus().equals(DRB1345) && locusExon.getExon().equals(EXON3) && DRB_EXON3_IGNORE_BEGINNING) {
            int uncoveredCount = matchStatistics.getExonSize() - matchStatistics.getNumPosGoodCoverage();
            int i = 0;
            while (i < 5) {
                if (matchStatistics.getCoverageString().charAt(i) == ' ' || matchStatistics.getCoverageString().charAt(i) == '0') {
                    --uncoveredCount;
                }
                ++i;
            }
            if (uncoveredCount <= 0) {
                return true;
            }
        }
        return false;
    }

    private static boolean questionPositionOK(List<Integer> questionPositions, List<Integer> ignoredPrimerDiffPositions) {
        for (Integer pos : questionPositions) {
            if (ignoredPrimerDiffPositions.contains(pos)) continue;
            return false;
        }
        return true;
    }

    private static MatchStatistics parseStatistices(String[] items, String[] detailedResult, int lineCount) {
        MatchStatistics matchStatistics = new MatchStatistics();
        if (items[3].indexOf("/") > 0) {
            String[] nums = items[3].trim().split("/");
            int numa = new Integer(nums[0]);
            int numb = new Integer(nums[1]);
            matchStatistics.setNumPairsSupport(numa + numb);
            matchStatistics.setNumPairsSupportExonA(numa);
            matchStatistics.setNumPairsSupportExonB(numb);
        } else {
            matchStatistics.setNumPairsSupport(new Integer(items[3].trim()));
        }
        matchStatistics.setNumPairsPerfect(new Integer(items[4].split("\\.")[0].trim()));
        matchStatistics.setNumPosGoodCoverage(new Integer(items[5].trim().split("/")[0]));
        matchStatistics.setExonSize(new Integer(items[5].trim().split("/")[1]));
        matchStatistics.setQuestionPos(SummarizeTypingResult.parsePositions(items[6].trim()));
        if (items[7].indexOf("/") > 0) {
            String[] uniques = items[7].trim().split("/");
            matchStatistics.setNumPairsUniqueExonA(new Integer(uniques[0].trim()));
            matchStatistics.setNumPairsUniqueExonB(new Integer(uniques[1].trim()));
        } else {
            matchStatistics.setNumPairsUnique(new Integer(items[7].trim()));
        }
        matchStatistics.setBridgeCount(new Integer(items[8].trim()));
        int i = lineCount + 1;
        while (i < detailedResult.length) {
            String[] entries = detailedResult[i].split("\t");
            if (entries.length > 1 && entries[0].trim().equals(items[2].trim()) && SummarizeTypingResult.isCoverage(entries[1].trim().charAt(0))) {
                matchStatistics.setCoverageString(entries[1]);
                break;
            }
            ++i;
        }
        i = lineCount + 1;
        while (i < detailedResult.length) {
            String[] entries = detailedResult[i].split("\t");
            if (entries.length > 1 && entries[0].trim().equals(items[2].trim()) && !SummarizeTypingResult.isCoverage(entries[1].trim().charAt(0)) && entries[1].indexOf("-") >= 0) {
                matchStatistics.setAlignmentString(entries[1].trim());
                break;
            }
            ++i;
        }
        if (items.length >= 11 && items[10].trim().startsWith("dropOff")) {
            matchStatistics.setDropOff(true);
            if (items[10].trim().split("=").length > 1) {
                matchStatistics.setDropOffCount(Integer.valueOf(items[10].trim().split("=")[1]));
            } else {
                matchStatistics.setDropOffCount(100);
            }
        } else {
            matchStatistics.setDropOff(false);
        }
        return matchStatistics;
    }

    private static boolean isCoverage(char thisChar) {
        return thisChar == ' ' || thisChar == '0' || thisChar == '1' || thisChar == '2' || thisChar == '3' || thisChar == '4' || thisChar == '5' || thisChar == '6' || thisChar == '7' || thisChar == '8' || thisChar == '9';
    }

    private static List<Integer> parsePositions(String positions) {
        String[] items;
        ArrayList<Integer> posList = new ArrayList<Integer>();
        if (positions.equals("0")) {
            return posList;
        }
        String[] stringArray = items = positions.split(",");
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            posList.add(new Integer(item));
            ++n2;
        }
        return posList;
    }

    public static Map<String, List<LocusExon>> initLocusMap() {
        LinkedHashMap<String, List<LocusExon>> allLocus = new LinkedHashMap<String, List<LocusExon>>();
        allLocus.put(DPA1, new ArrayList());
        ((List)allLocus.get(DPA1)).add(new LocusExon(DPA1, EXON2, true, 101));
        allLocus.put(DPB1, new ArrayList());
        ((List)allLocus.get(DPB1)).add(new LocusExon(DPB1, EXON2, true, 101));
        LocusExon dpbExon3 = new LocusExon(DPB1, EXON3, false, 365);
        dpbExon3.addOtherTypeNames(DPBSUDO);
        ((List)allLocus.get(DPB1)).add(dpbExon3);
        allLocus.put(DRB1345, new ArrayList());
        LocusExon drbExon2 = new LocusExon(DRB1345, EXON2, true, 101);
        drbExon2.addOtherTypeNames(DRB3);
        drbExon2.addOtherTypeNames(DRB4);
        drbExon2.addOtherTypeNames(DRB5);
        ((List)allLocus.get(DRB1345)).add(drbExon2);
        LocusExon drbExon3 = new LocusExon(DRB1345, EXON3, false, 371);
        drbExon3.addIgnoredPrimerDiffPositions(264);
        drbExon3.addIgnoredPrimerDiffPositions(9);
        drbExon3.addOtherTypeNames(DRB3);
        drbExon3.addOtherTypeNames(DRB4);
        drbExon3.addOtherTypeNames(DRB5);
        ((List)allLocus.get(DRB1345)).add(drbExon3);
        allLocus.put(DQA1, new ArrayList());
        LocusExon dqaExon2 = new LocusExon(DQA1, EXON2, true, 83);
        dqaExon2.addOtherTypeNames(DQASUDO);
        ((List)allLocus.get(DQA1)).add(dqaExon2);
        LocusExon dqaExon3 = new LocusExon(DQA1, EXON3, false, 332);
        dqaExon3.addOtherTypeNames(DQASUDO);
        ((List)allLocus.get(DQA1)).add(dqaExon3);
        allLocus.put(DQB1, new ArrayList());
        ((List)allLocus.get(DQB1)).add(new LocusExon(DQB1, EXON2, true, 110));
        LocusExon dqbExon3 = new LocusExon(DQB1, EXON3, false, 380);
        dqbExon3.addOtherTypeNames(DQBSUDO);
        ((List)allLocus.get(DQB1)).add(dqbExon3);
        allLocus.put(HLAA, new ArrayList());
        LocusExon aExon23 = new LocusExon(HLAA, EXON23, true, 74);
        SummarizeTypingResult.addOtherCIgenes(aExon23);
        ((List)allLocus.get(HLAA)).add(aExon23);
        LocusExon aExon4 = new LocusExon(HLAA, EXON4, false, 620);
        SummarizeTypingResult.addOtherCIgenes(aExon4);
        aExon4.addOtherTypeNames(ASUDO);
        ((List)allLocus.get(HLAA)).add(aExon4);
        allLocus.put(HLAB, new ArrayList());
        LocusExon bExon23 = new LocusExon(HLAB, EXON23, true, 74);
        SummarizeTypingResult.addOtherCIgenes(bExon23);
        ((List)allLocus.get(HLAB)).add(bExon23);
        LocusExon bExon4 = new LocusExon(HLAB, EXON4, false, 620);
        SummarizeTypingResult.addOtherCIgenes(bExon4);
        bExon4.addOtherTypeNames(BSUDO);
        ((List)allLocus.get(HLAB)).add(bExon4);
        allLocus.put(HLAC, new ArrayList());
        LocusExon cExon23 = new LocusExon(HLAC, EXON23, true, 74);
        SummarizeTypingResult.addOtherCIgenes(cExon23);
        ((List)allLocus.get(HLAC)).add(cExon23);
        LocusExon cExon4 = new LocusExon(HLAC, EXON4, false, 620);
        SummarizeTypingResult.addOtherCIgenes(cExon4);
        cExon4.addOtherTypeNames(CSUDO);
        ((List)allLocus.get(HLAC)).add(cExon4);
        return allLocus;
    }

    private static void addOtherCIgenes(LocusExon locusExon) {
        locusExon.addOtherTypeNames("E");
        locusExon.addOtherTypeNames("F");
        locusExon.addOtherTypeNames("G");
        locusExon.addOtherTypeNames("H");
        locusExon.addOtherTypeNames("J");
        locusExon.addOtherTypeNames("K");
        locusExon.addOtherTypeNames("L");
    }

    private static void appendToFile(StringBuilder result, File targetFile) throws Exception {
        BufferedWriter writer = new BufferedWriter(new FileWriter(targetFile, true));
        writer.write(result.toString());
        writer.close();
    }
}

