/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import misc.FileManager;

public class SummarizeResolvedType {
    public static void main(String[] args) throws Exception {
        File inputDir = new File(args[0]);
        File outFile = new File(args[1]);
        File[] inputFiles = inputDir.listFiles();
        LinkedHashMap<String, Map<String, Map<String, Integer>>> eightDigitMap = new LinkedHashMap<String, Map<String, Map<String, Integer>>>();
        LinkedHashMap<String, Map<String, Integer>> sixDigitMap = new LinkedHashMap<String, Map<String, Integer>>();
        HashMap<String, Integer> incompleteCountMap = new HashMap<String, Integer>();
        HashMap<String, List<String>> incompleteSampleMap = new HashMap<String, List<String>>();
        File[] fileArray = inputFiles;
        int n = inputFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File inputFile = fileArray[n2];
            if (inputFile.getName().startsWith("summary")) {
                String[] data;
                System.out.println("parsing " + inputFile.getName());
                String[] stringArray = data = FileManager.readTextFile(inputFile).split("\n");
                int n3 = data.length;
                int n4 = 0;
                while (n4 < n3) {
                    String line = stringArray[n4];
                    if (!line.startsWith("Sample") && line.trim().length() != 0) {
                        String[] items = line.split("\t");
                        if (items.length < 4) {
                            System.out.println("\tskip " + line);
                        } else {
                            SummarizeResolvedType.parseThisLine(items, eightDigitMap, sixDigitMap, incompleteCountMap, incompleteSampleMap, line);
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        SummarizeResolvedType.output(outFile, eightDigitMap, sixDigitMap, incompleteCountMap, incompleteSampleMap);
    }

    private static void output(File outFile, Map<String, Map<String, Map<String, Integer>>> eightDigitMap, Map<String, Map<String, Integer>> sixDigitMap, Map<String, Integer> incompleteCountMap, Map<String, List<String>> incompleteSampleMap) {
        StringBuilder out = new StringBuilder();
        for (String locus : eightDigitMap.keySet()) {
            out.append("locus").append("\t").append(locus).append("\n");
            out.append("8digitResolving\n");
            out.append("TypeGroup").append("\t").append("ResolvedType").append("\t").append("count").append("\t").append("incompleteCoverageTypeCount").append("\t").append("incompleteCoverageSampleName").append("\n");
            Map<String, Map<String, Integer>> baseTypeMap = eightDigitMap.get(locus);
            for (String baseType : baseTypeMap.keySet()) {
                Map<String, Integer> countMap = baseTypeMap.get(baseType);
                for (String resolvedType : countMap.keySet()) {
                    out.append(baseType).append("\t").append(resolvedType).append("\t").append(countMap.get(resolvedType)).append("\t");
                    if (incompleteCountMap.containsKey(resolvedType)) {
                        out.append(incompleteCountMap.get(resolvedType)).append("\t").append(incompleteSampleMap.get(resolvedType).toString()).append("\n");
                        continue;
                    }
                    out.append("").append("\t").append("").append("\n");
                }
            }
            out.append("6digitCount\n");
            out.append("Type").append("\t").append("count\t").append("incompleteCoverageTypeCount").append("\t").append("incompleteCoverageSampleName").append("\n");
            Map<String, Integer> typeMap = sixDigitMap.get(locus);
            for (String baseType : typeMap.keySet()) {
                if (baseType.trim().length() == 0) {
                    out.append("NoResolvingType").append("\t").append(typeMap.get(baseType)).append("\t");
                    if (incompleteCountMap.containsKey(baseType)) {
                        out.append(incompleteCountMap.get(baseType)).append("\t").append(incompleteSampleMap.get(baseType)).append("\n");
                        continue;
                    }
                    out.append("").append("\t").append("").append("\n");
                    continue;
                }
                out.append(baseType).append("\t").append(typeMap.get(baseType)).append("\t");
                if (incompleteCountMap.containsKey(baseType)) {
                    out.append(incompleteCountMap.get(baseType)).append("\t").append(incompleteSampleMap.get(baseType)).append("\n");
                    continue;
                }
                out.append("").append("\t").append("").append("\n");
            }
            out.append("\n");
        }
        System.out.println(out.toString());
        FileManager.writeTextFile(outFile, out.toString(), true);
    }

    private static void parseThisLine(String[] items, Map<String, Map<String, Map<String, Integer>>> eightDigitMap, Map<String, Map<String, Integer>> sixDigitMap, Map<String, Integer> incompleteCountMap, Map<String, List<String>> incompleteSampleMap, String line) {
        String locus = items[1].trim();
        String type1 = items[2].trim();
        String type2 = items[3].trim();
        String warning1 = "";
        String warning2 = "";
        if (items.length > 4) {
            warning1 = items[4].trim();
        }
        if (items.length > 5) {
            warning2 = items[5].trim();
        }
        if (!eightDigitMap.containsKey(locus)) {
            eightDigitMap.put(locus, new TreeMap());
            sixDigitMap.put(locus, new TreeMap());
        }
        SummarizeResolvedType.processType(type1, eightDigitMap.get(locus), sixDigitMap.get(locus), line, 1);
        SummarizeResolvedType.processWarning(items[0].trim(), incompleteCountMap, incompleteSampleMap, type1, warning1);
        if (!type1.equals(type2)) {
            SummarizeResolvedType.processType(type2, eightDigitMap.get(locus), sixDigitMap.get(locus), line, 2);
            SummarizeResolvedType.processWarning(items[0].trim(), incompleteCountMap, incompleteSampleMap, type2, warning2);
        }
    }

    private static void processWarning(String name, Map<String, Integer> incompleteCountMap, Map<String, List<String>> incompleteSampleMap, String type, String warning) {
        if (warning.indexOf("incomplete coverage") > 0) {
            if (!incompleteCountMap.containsKey(type)) {
                incompleteCountMap.put(type, 0);
                incompleteSampleMap.put(type, new ArrayList());
            }
            incompleteCountMap.put(type, incompleteCountMap.get(type) + 1);
            incompleteSampleMap.get(type).add(name.trim());
        }
    }

    private static void processType(String type, Map<String, Map<String, Integer>> eightDigitTypeMap, Map<String, Integer> sixDigitTypeMap, String line, int index) {
        String name = type.split("/")[0];
        String[] fields = name.split(":");
        boolean isEight = false;
        if (fields.length == 4) {
            isEight = true;
        }
        if (isEight) {
            String baseName = String.valueOf(fields[0]) + ":" + fields[1] + ":" + fields[2];
            if (!eightDigitTypeMap.containsKey(baseName)) {
                eightDigitTypeMap.put(baseName, new TreeMap());
            }
            if (!eightDigitTypeMap.get(baseName).containsKey(type)) {
                eightDigitTypeMap.get(baseName).put(type, 0);
            }
            int count = eightDigitTypeMap.get(baseName).get(type) + 1;
            eightDigitTypeMap.get(baseName).put(type, count);
        } else {
            if (type.trim().length() == 0) {
                String[] items = line.split("\t");
                type = items[index + 3].trim();
            }
            if (!sixDigitTypeMap.containsKey(type)) {
                sixDigitTypeMap.put(type, 0);
            }
            int count = sixDigitTypeMap.get(type) + 1;
            sixDigitTypeMap.put(type, count);
        }
    }
}

