/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;
import misc.SystemCommand;

public class StringMatchForKir {
    public static void main(String[] args) throws Exception {
        File fastaFile = new File(args[0]);
        File kirSeqFile = new File(args[1]);
        LinkedHashMap<String, Map<String, List<Integer>>> overallResult = new LinkedHashMap<String, Map<String, List<Integer>>>();
        StringMatchForKir.match(fastaFile, kirSeqFile, overallResult);
    }

    public static void match(File fastaFile, File kirSeqFile, Map<String, Map<String, List<Integer>>> overallResult) {
        String[] lines = FileManager.readTextFile(kirSeqFile).split("\n");
        LinkedHashMap result = new LinkedHashMap();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String data = stringArray[n2];
            String[] info = data.trim().split("\\s+");
            if (info.length >= 4) {
                String geneExon;
                if (info.length == 4) {
                    geneExon = String.valueOf(info[0]) + "-exon" + info[3];
                    if (!result.containsKey(geneExon)) {
                        result.put(geneExon, new ArrayList());
                    }
                    String f = info[1];
                    String cmd = "grep -o \"" + f + "\" " + fastaFile.getAbsolutePath() + " | wc -l";
                    String[] commandArray = new String[]{"bash", "-c", cmd};
                    SystemCommand command = new SystemCommand(commandArray, null, true);
                    command.makeItSo();
                    ((List)result.get(geneExon)).add(Integer.valueOf(command.getStandardOut().trim()));
                }
                if (info.length > 4) {
                    geneExon = String.valueOf(info[0]) + "-exon" + info[4];
                    if (!result.containsKey(geneExon)) {
                        result.put(geneExon, new ArrayList());
                    }
                    String f1 = info[1];
                    String f2 = info[2];
                    String cmd = "grep -R -B1 \"" + f1 + "\" " + fastaFile.getAbsolutePath() + " | ";
                    cmd = String.valueOf(cmd) + "grep -o \"" + f2 + "\" " + " | wc -l";
                    String[] commandArray = new String[]{"bash", "-c", cmd};
                    SystemCommand command = new SystemCommand(commandArray, null, true);
                    command.makeItSo();
                    ((List)result.get(geneExon)).add(Integer.valueOf(command.getStandardOut().trim()));
                }
            }
            ++n2;
        }
        overallResult.put(fastaFile.getName().substring(0, fastaFile.getName().length() - 2), result);
    }

    private static Object formatCount(List<Integer> list) {
        String out = "(";
        for (Integer count : list) {
            out = String.valueOf(out) + count;
            out = String.valueOf(out) + ", ";
        }
        return String.valueOf(out) + ")";
    }

    private static Object calculateAverage(List<Integer> list) {
        int total = 0;
        for (Integer count : list) {
            total += count.intValue();
        }
        return total / list.size();
    }
}

