/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import misc.FileManager;

public class SeparateExons {
    public static void main(String[] args) throws Exception {
        File fastaFile = new File(args[0]);
        File logFile = new File(args[1]);
        File outputFile = new File(args[2]);
        StringBuilder builder = new StringBuilder();
        SeparateExons.startProcess(fastaFile, logFile, builder);
        FileManager.writeTextFile(outputFile, builder.toString(), true);
    }

    private static void startProcess(File fastaFile, File logFile, StringBuilder builder) {
        String[] lines;
        LinkedHashMap<String, String> seqMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> nameMap = new LinkedHashMap<String, String>();
        SeparateExons.getFastas(fastaFile, seqMap, nameMap);
        String[] stringArray = lines = FileManager.readTextFile(logFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String data = stringArray[n2];
            String[] item = data.trim().split("\\s+");
            if (item.length >= 11) {
                String name = item[7].trim();
                int start = Integer.valueOf(item[8].trim());
                int end = Integer.valueOf(item[9].trim());
                int ext = Integer.valueOf(item[6].trim().substring(1, item[6].trim().length() - 1));
                builder.append(">").append((String)nameMap.get(name)).append("\n");
                builder.append(((String)seqMap.get(name)).substring(start - 1, Math.min(end + ext, ((String)seqMap.get(name)).length()))).append("\n");
            }
            ++n2;
        }
    }

    private static void getFastas(File fastaFile, Map<String, String> backboneMap, Map<String, String> nameMap) {
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        String name = null;
        String fullName = null;
        String sequence = "";
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String data = stringArray[n2];
            if (data.startsWith(">")) {
                if (sequence.length() == 0) {
                    fullName = data.substring(1).trim();
                    name = fullName.split("\\s+")[0];
                } else {
                    backboneMap.put(name, sequence);
                    nameMap.put(name, fullName);
                    System.out.println(String.valueOf(data) + " " + name);
                    fullName = data.substring(1).trim();
                    name = fullName.split("\\s+")[0];
                    sequence = "";
                }
            } else if (data.trim().length() > 0) {
                sequence = String.valueOf(sequence) + data.trim();
            }
            backboneMap.put(name, sequence);
            nameMap.put(name, fullName);
            ++n2;
        }
    }
}

