/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import misc.FileManager;

public class RandomizeFasta {
    static String HEADER = "@M00474";
    static String HEADER2 = "@M00676";
    static String SEPARATER1 = "000000000-A7PBP";
    static String SEPARATER2 = "000000000-A6U3L";
    static String SEPARATER3 = "000000000-A7WBV";
    static String SEPARATER4 = "000000000-A6AN3";
    static String SEPARATER5 = "000000000-A8Y79";
    static String SEPARATER6 = "000000000-A87UJ";
    static String NEW_HEADER = ">000000";

    public static void main(String[] args) throws Exception {
        File faFile = new File(args[0]);
        File outputFile = new File(args[1]);
        String[] lines = FileManager.readTextFile(faFile).split("\n");
        Map<String, String> seqMap1 = RandomizeFasta.getSeqMap(lines);
        StringBuilder out = new StringBuilder();
        long seed = System.nanoTime();
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(seqMap1.keySet());
        Collections.shuffle(names, new Random(seed));
        for (String name : names) {
            out.append(name).append("\n");
            out.append(seqMap1.get(name));
        }
        FileManager.writeTextFile(outputFile, out.toString(), true);
    }

    private static Map<String, String> getSeqMap(String[] lines) {
        HashMap<String, String> seqMap = new HashMap<String, String>();
        int i = 0;
        while (i < lines.length) {
            String line = lines[i].trim();
            if (line.startsWith(">") && line.endsWith("1")) {
                String name = line;
                seqMap.put(name, String.valueOf(lines[i + 1].trim()) + "\n" + lines[i + 2].trim() + "\n" + lines[i + 3].trim() + "\n");
                i += 3;
            }
            ++i;
        }
        return seqMap;
    }
}

