/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import misc.FileManager;
import misc.OsHelper;
import misc.SystemCommand;

public class PickPrimerForFosmidGap {
    private static int OFFSET = 25;
    private static int RANGE = 300;
    private static int NUMBER = 20;

    public static void main(String[] args) throws Exception {
        File fastaFile = new File(args[0]);
        File primerFile = new File(args[1]);
        Map<String, String> backboneMap = PickPrimerForFosmidGap.getFastas(fastaFile);
        StringBuilder primers = new StringBuilder();
        StringBuffer outputPrimers = new StringBuffer();
        outputPrimers.append("Primer Name\tSequence\tPrimer Start(End)\tTm\n");
        for (String name : backboneMap.keySet()) {
            System.out.println("pick Primer for " + name + " " + backboneMap.get(name).length());
            PickPrimerForFosmidGap.runPrimer3(PickPrimerForFosmidGap.formatName(fastaFile.getName(), name), backboneMap.get(name), primers, primerFile, outputPrimers);
        }
        FileManager.writeTextFile(primerFile, outputPrimers.toString(), true);
    }

    private static String formatName(String FileName, String nodeName) {
        return String.valueOf(FileName.split("_")[0]) + "_" + nodeName;
    }

    private static void runPrimer3(String name, String sequence, StringBuilder primers, File primerFile, StringBuffer outputPrimers) throws Exception {
        File inputFile1 = File.createTempFile("input", ".txt");
        File tmpFile1 = File.createTempFile("output", ".txt");
        StringBuilder buffer1 = PickPrimerForFosmidGap.createInputForForward(sequence);
        System.out.println(inputFile1.getAbsolutePath());
        FileManager.writeTextFile(inputFile1, buffer1.toString(), true);
        String cmd = "/genome/bin/primer3_core < " + inputFile1.getAbsolutePath() + " > " + tmpFile1.getAbsolutePath();
        String[] acmd1 = new String[]{"/bin/sh", "-c", cmd};
        SystemCommand systemCommand = new SystemCommand(acmd1, inputFile1.getParentFile(), false);
        systemCommand.makeItSo();
        OsHelper.excuteCommand(cmd);
        System.out.println(cmd);
        outputPrimers.append(PickPrimerForFosmidGap.parseOutputForForward(sequence.length(), name, FileManager.readTextFile(tmpFile1)));
        File inputFile2 = File.createTempFile("input", ".txt");
        File tmpFile2 = File.createTempFile("output", ".txt");
        StringBuilder buffer2 = PickPrimerForFosmidGap.createInputForReverse(sequence);
        System.out.println(inputFile2.getAbsolutePath());
        FileManager.writeTextFile(inputFile2, buffer2.toString(), true);
        cmd = "/genome/bin/primer3_core < " + inputFile2.getAbsolutePath() + " > " + tmpFile2.getAbsolutePath();
        String[] acmd2 = new String[]{"/bin/sh", "-c", cmd};
        systemCommand = new SystemCommand(acmd2, inputFile2.getParentFile(), false);
        systemCommand.makeItSo();
        OsHelper.excuteCommand(cmd);
        System.out.println(cmd);
        outputPrimers.append(PickPrimerForFosmidGap.parseOutputForReverse(sequence.length(), name, FileManager.readTextFile(tmpFile2)));
    }

    private static StringBuilder createInputForReverse(String sequence) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("PRIMER_SEQUENCE_ID=SequenceRev\n");
        buffer.append("SEQUENCE=").append(sequence).append("\n");
        buffer.append("INCLUDED_REGION=").append(OFFSET).append(",").append(Math.min(RANGE, sequence.length() - OFFSET)).append("\n");
        buffer.append("PRIMER_PRODUCT_SIZE_RANGE=50-250 100-300 301-400 401-500 501-600 601-700 701-850 851-1000\n");
        buffer.append("PRIMER_OPT_SIZE=25\n");
        buffer.append("PRIMER_MIN_SIZE=16\n");
        buffer.append("PRIMER_MAX_SIZE=30\n");
        buffer.append("PRIMER_OPT_TM=55.0\n");
        buffer.append("PRIMER_MIN_TM=50.0\n");
        buffer.append("PRIMER_MAX_TM=61.0\n");
        buffer.append("PRIMER_MAX_DIFF_TM=10\n");
        buffer.append("PRIMER_DNA_CONC=0.25\n");
        buffer.append("PRIMER_SALT_CONC=50.0\n");
        buffer.append("PRIMER_SELF_ANY=3\n");
        buffer.append("PRIMER_SELF_END=3\n");
        buffer.append("PRIMER_MAX_POLY_X=7\n");
        buffer.append("PRIMER_NUM_RETURN=").append(NUMBER).append("\n");
        buffer.append("PRIMER_FIRST_BASE_INDEX=1\n");
        buffer.append("PRIMER_MAX_END_STABILITY=20\n");
        buffer.append("=\n");
        return buffer;
    }

    private static StringBuilder createInputForForward(String sequence) {
        StringBuilder buffer = new StringBuilder();
        int start = Math.max(1, sequence.length() - RANGE);
        int size = sequence.length() - start - OFFSET;
        buffer.append("PRIMER_SEQUENCE_ID=SequenceFor\n");
        buffer.append("SEQUENCE=").append(sequence).append("\n");
        buffer.append("INCLUDED_REGION=").append(start).append(",").append(size).append("\n");
        buffer.append("PRIMER_PRODUCT_SIZE_RANGE=50-250 100-300 301-400 401-500 501-600 601-700 701-850 851-1000\n");
        buffer.append("PRIMER_OPT_SIZE=25\n");
        buffer.append("PRIMER_MIN_SIZE=16\n");
        buffer.append("PRIMER_MAX_SIZE=30\n");
        buffer.append("PRIMER_OPT_TM=55.0\n");
        buffer.append("PRIMER_MIN_TM=50.0\n");
        buffer.append("PRIMER_MAX_TM=61.0\n");
        buffer.append("PRIMER_MAX_DIFF_TM=10\n");
        buffer.append("PRIMER_DNA_CONC=0.25\n");
        buffer.append("PRIMER_SALT_CONC=50.0\n");
        buffer.append("PRIMER_SELF_ANY=3\n");
        buffer.append("PRIMER_SELF_END=3\n");
        buffer.append("PRIMER_MAX_POLY_X=7\n");
        buffer.append("PRIMER_NUM_RETURN=").append(NUMBER).append("\n");
        buffer.append("PRIMER_FIRST_BASE_INDEX=1\n");
        buffer.append("PRIMER_MAX_END_STABILITY=20\n");
        buffer.append("=\n");
        return buffer;
    }

    private static String parseOutputForReverse(int length, String name, String output) {
        StringBuffer buffer = new StringBuffer();
        String[] data = output.trim().split("\n");
        boolean find = false;
        String sequence = null;
        String tm = null;
        int position = -1;
        String[] stringArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String info = stringArray[n2];
            if (info.startsWith("PRIMER_LEFT_SEQUENCE=")) {
                find = true;
                sequence = info.split("=")[1];
            }
            if (info.startsWith("PRIMER_LEFT=")) {
                position = new Integer(info.split("=")[1].split(",")[0].trim());
                System.out.println("set 111 " + position);
            }
            if (info.startsWith("PRIMER_LEFT_TM=")) {
                tm = info.split("=")[1].trim();
            }
            ++n2;
        }
        if (!find) {
            return buffer.append(String.valueOf(name) + "-R\t" + "?" + "\t" + "?" + "\t" + "?" + "\n").toString();
        }
        String tmpSequence = null;
        int tmpposition = -1;
        String tmpTm = null;
        int i = 1;
        while (i < NUMBER) {
            String[] stringArray2 = data;
            int n3 = data.length;
            int n4 = 0;
            while (n4 < n3) {
                String info = stringArray2[n4];
                if (info.startsWith("PRIMER_LEFT_" + i + "_SEQUENCE=")) {
                    tmpSequence = info.split("=")[1].trim();
                }
                if (info.startsWith("PRIMER_LEFT_" + i + "=")) {
                    tmpposition = new Integer(info.split("=")[1].split(",")[0].trim());
                    System.out.println("find or !!!!!!!!!!!! " + tmpposition);
                }
                if (info.startsWith("PRIMER_LEFT_" + i + "_TM=")) {
                    tmpTm = info.split("=")[1].trim();
                }
                if (tmpposition < position && tmpposition != -1) {
                    sequence = tmpSequence;
                    position = tmpposition;
                    System.out.println("replace 333 " + tmpposition + " ");
                    tm = tmpTm;
                }
                ++n4;
            }
            ++i;
        }
        return buffer.append(String.valueOf(name) + "-R\t" + PickPrimerForFosmidGap.revComp(sequence) + "\t" + (position + sequence.length()) + "\t" + tmpTm + "\t" + length + "\n").toString();
    }

    private static String parseOutputForForward(int length, String name, String output) {
        StringBuffer buffer = new StringBuffer();
        String[] data = output.trim().split("\n");
        boolean find = false;
        String sequence = null;
        String tm = null;
        int position = -1;
        String[] stringArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String info = stringArray[n2];
            if (info.startsWith("PRIMER_RIGHT_SEQUENCE=")) {
                find = true;
                sequence = info.split("=")[1];
            }
            if (info.startsWith("PRIMER_RIGHT=")) {
                position = new Integer(info.split("=")[1].split(",")[0].trim());
            }
            if (info.startsWith("PRIMER_RIGHT_TM=")) {
                tm = info.split("=")[1].trim();
            }
            ++n2;
        }
        if (!find) {
            return buffer.append(String.valueOf(name) + "-F\t" + "?" + "\t" + "?" + "\t" + "?" + "\n").toString();
        }
        String tmpSequence = null;
        int tmpposition = -1;
        String tmpTm = null;
        int i = 1;
        while (i < NUMBER) {
            String[] stringArray2 = data;
            int n3 = data.length;
            int n4 = 0;
            while (n4 < n3) {
                String info = stringArray2[n4];
                if (info.startsWith("PRIMER_RIGHT_" + i + "_SEQUENCE=")) {
                    tmpSequence = info.split("=")[1].trim();
                }
                if (info.startsWith("PRIMER_RIGHT_" + i + "=")) {
                    tmpposition = new Integer(info.split("=")[1].split(",")[0].trim());
                }
                if (info.startsWith("PRIMER_RIGHT_" + i + "_TM=")) {
                    tmpTm = info.split("=")[1].trim();
                }
                if (tmpposition > position) {
                    sequence = tmpSequence;
                    position = tmpposition;
                    tm = tmpTm;
                }
                ++n4;
            }
            ++i;
        }
        return buffer.append(String.valueOf(name) + "-F\t" + PickPrimerForFosmidGap.revComp(sequence) + "\t" + (position - sequence.length()) + "\t" + tmpTm + "\t" + length + "\n").toString();
    }

    private static Map<String, String> getFastas(File fastaFile) {
        LinkedHashMap<String, String> backboneMap = new LinkedHashMap<String, String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        String name = null;
        String sequence = "";
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String data = stringArray[n2];
            if (data.startsWith(">")) {
                String fullName;
                if (sequence.length() == 0) {
                    fullName = data.substring(1).trim();
                    name = String.valueOf(fullName.split("_")[0]) + "_" + fullName.split("_")[1];
                } else {
                    backboneMap.put(name, sequence);
                    System.out.println(String.valueOf(data) + " " + name);
                    fullName = data.substring(1).trim();
                    name = String.valueOf(fullName.split("_")[0]) + "_" + fullName.split("_")[1];
                    sequence = "";
                }
            } else if (data.trim().length() > 0) {
                sequence = String.valueOf(sequence) + data.trim();
            }
            backboneMap.put(name, sequence);
            ++n2;
        }
        return backboneMap;
    }

    private static String revComp(String seq) {
        StringBuilder builder = new StringBuilder();
        int i = seq.length() - 1;
        while (i >= 0) {
            builder.append(PickPrimerForFosmidGap.complement(seq.charAt(i)));
            --i;
        }
        return builder.toString();
    }

    public static char complement(char base) {
        if (base == 'a' || base == 'A') {
            return 'T';
        }
        if (base == 't' || base == 'T') {
            return 'A';
        }
        if (base == 'c' || base == 'C') {
            return 'G';
        }
        if (base == 'g' || base == 'G') {
            return 'C';
        }
        if (base == 'n' || base == 'N') {
            return 'N';
        }
        return base;
    }
}

