/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.ConvertFastaQdataMiSeq;
import fileOperation.OneMatch;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;
import misc.OsHelper;

public class ParseFastaByKirSeq {
    private static final int MIN_HIT = 10;
    static int MIN_SCORE = 40;
    static String LABEL = "M00116";

    public static void main(String[] args) throws Exception {
        File fastaFile = new File(args[0]);
        File hapTypeRoot = new File(args[1]);
        ParseFastaByKirSeq.startType(fastaFile, hapTypeRoot);
    }

    public static void startType(File fastaFile, File hapTypeRoot) {
        File[] hapFiles;
        File[] fileArray = hapFiles = hapTypeRoot.listFiles();
        int n = hapFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File hapFile = fileArray[n2];
            if (hapFile.getName().endsWith("fa")) {
                Map<String, Map<String, OneMatch>> result;
                boolean needMoreTyping;
                System.out.print("---------" + hapFile.getName());
                String matchResult = ParseFastaByKirSeq.runCrossMatch(fastaFile, hapFile);
                if (hapFile.getName().startsWith("kir")) {
                    Map<String, Map<String, OneMatch>> map = ParseFastaByKirSeq.ParseKirResult(matchResult);
                }
                if (needMoreTyping = ParseFastaByKirSeq.output(result = ParseFastaByKirSeq.ParseResult(matchResult), hapFile, 0)) {
                    ParseFastaByKirSeq.output(result, hapFile, 1);
                }
            }
            ++n2;
        }
    }

    private static boolean output(Map<String, Map<String, OneMatch>> result, File hapFile, int roundNum) {
        Map<String, String> types = ParseFastaByKirSeq.getAllTypes(hapFile);
        HashMap orgnizedTypes = new HashMap();
        for (String type : result.keySet()) {
            Map<String, OneMatch> matches = result.get(type);
            int count = 0;
            for (OneMatch match : matches.values()) {
                if (roundNum == 0 && match.isForwardExist() && match.isReverseExist()) {
                    ++count;
                    continue;
                }
                if (roundNum <= 0 || !match.isForwardExist() && !match.isReverseExist()) continue;
                ++count;
            }
            if (count <= 0) continue;
            if (!orgnizedTypes.containsKey(count)) {
                orgnizedTypes.put(count, new ArrayList());
            }
            ((List)orgnizedTypes.get(count)).add(types.get(type));
        }
        Object[] num = orgnizedTypes.keySet().toArray();
        Arrays.sort(num);
        int i = num.length - 1;
        while (i >= 0) {
            int c = (Integer)num[i];
            for (String t : (List)orgnizedTypes.get(c)) {
                if (roundNum == 0) {
                    System.out.println("\t" + c + " pairs");
                    continue;
                }
                System.out.println("\t**" + c + " single direction ");
            }
            --i;
        }
        return num.length == 0 || (Integer)num[num.length - 1] < 10;
    }

    private static Map<String, String> getAllTypes(File hapFile) {
        String[] lines;
        HashMap<String, String> types = new HashMap<String, String>();
        String[] stringArray = lines = FileManager.readTextFile(hapFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.startsWith(">")) {
                String[] items = line.substring(1).split("\\s+");
                if (items.length == 1) {
                    types.put(items[0], items[0]);
                } else {
                    types.put(items[0], items[1]);
                }
            }
            ++n2;
        }
        return types;
    }

    private static Map<String, Map<String, OneMatch>> ParseKirResult(String matchResult) {
        String[] lines = matchResult.split("\n");
        HashMap<String, Map<String, OneMatch>> result = new HashMap<String, Map<String, OneMatch>>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] items;
            String line = stringArray[n2];
            if (line.indexOf(LABEL) > 0 && line.trim().split("\\s+").length >= 12 && Integer.valueOf((items = line.trim().split("\\s+"))[0]) > MIN_SCORE) {
                OneMatch aMatch;
                Map matches;
                String type;
                String thisRead = ConvertFastaQdataMiSeq.generateName(items[4].trim());
                String name = thisRead.substring(0, thisRead.length() - 2);
                boolean isRevComp = items[8].trim().equals("C");
                String string = type = isRevComp ? items[9].trim() : items[8].trim();
                if (!result.containsKey(type)) {
                    result.put(type, new HashMap());
                }
                if (!(matches = (Map)result.get(type)).containsKey(name)) {
                    aMatch = new OneMatch();
                    aMatch.setName(name);
                    matches.put(name, aMatch);
                }
                aMatch = (OneMatch)matches.get(name);
                if (isRevComp) {
                    aMatch.setReverseExist(true);
                    aMatch.setReverseScore(Integer.valueOf(items[0].trim()));
                } else {
                    aMatch.setForwardExist(true);
                    aMatch.setForwardScore(Integer.valueOf(items[0].trim()));
                }
            }
            ++n2;
        }
        return result;
    }

    private static Map<String, Map<String, OneMatch>> ParseResult(String matchResult) {
        String[] lines = matchResult.split("\n");
        HashMap<String, Map<String, OneMatch>> result = new HashMap<String, Map<String, OneMatch>>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] items;
            String line = stringArray[n2];
            if (line.indexOf(LABEL) > 0 && line.trim().split("\\s+").length >= 12 && (items = line.trim().split("\\s+"))[1].equals("0.00") && items[2].equals("0.00") && items[3].equals("0.00")) {
                OneMatch aMatch;
                Map matches;
                String type;
                String thisRead = ConvertFastaQdataMiSeq.generateName(items[4].trim());
                String name = thisRead.substring(0, thisRead.length() - 2);
                boolean isRevComp = items[8].trim().equals("C");
                String string = type = isRevComp ? items[9].trim() : items[8].trim();
                if (!result.containsKey(type)) {
                    result.put(type, new HashMap());
                }
                if (!(matches = (Map)result.get(type)).containsKey(name)) {
                    aMatch = new OneMatch();
                    aMatch.setName(name);
                    matches.put(name, aMatch);
                }
                aMatch = (OneMatch)matches.get(name);
                if (isRevComp) {
                    aMatch.setReverseExist(true);
                    aMatch.setReverseScore(Integer.valueOf(items[0].trim()));
                } else {
                    aMatch.setForwardExist(true);
                    aMatch.setForwardScore(Integer.valueOf(items[0].trim()));
                }
            }
            ++n2;
        }
        return result;
    }

    private static String runCrossMatch(File fastaFile, File hapFile) {
        String cmd = "/genome/bin/cross_match -masklevel 101 -minscore " + MIN_SCORE + " " + fastaFile.getAbsolutePath() + " " + hapFile.getAbsolutePath();
        String data = OsHelper.excuteCommand(cmd);
        return data;
    }
}

