/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.ConvertFastaQdataMiSeq;
import fileOperation.MatchStatistics;
import fileOperation.MatchUnit;
import fileOperation.OneMatch;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import misc.FileManager;
import misc.OsHelper;

public class ParseFastaByHapTypeABC {
    private static final int MIN_HIT = 10;
    static int MIN_SCORE = 80;
    static String LABEL = "000000";
    static String HAP_AMB_TXT = "-hap-amb.txt";
    static int COVERAGE_CUTOFF = 8;
    static int IMAGE_TO_DRAW = 10;
    private static final int IMAGE_HEIGHT = 1000;
    private static final int IMAGE_SEQUENCE_POSITION = 450;
    private static final int IMAGE_WIDTH = 1000;
    private static final int IMAGE_SEQUENCE_BAR_HEIGHT = 10;
    private static final int INDEX_SPACE = 16;
    private static final int INDEX_POSITION = 424;
    private static final int LETTER_WIDTH = 8;
    private static final int DEEPTH_HEIGHT = 400;
    private static final int LABEL_POSITION = 650;
    private static final int AMPLICON_TO_DRAW = 100;
    private static final int AMPLICON_HEIGHT = 400;
    private static String DRB1_07_SPECIFIC = "TTCCTGTGGCAGGG";
    private static final int COUNT_CUTOFF = 25;
    private static final int DRB1_07_STABLE_SIZE = 22;
    private static String DRB1_07_SPECIFIC2 = "AAGTATAAGTGTCATTT";
    private static String DRB1_07_SPECIFIC3 = "TTCAACGGG";
    private static final int DRB1_07_STABLE_SIZE_EXTENSION = 47;
    private static final String[] DRB1_07_SPECIFIC23_EXCLUDING = new String[]{"DRB1*07:22", "DRB1*07:01:02", "DRB1*07:21"};
    private static final int MIN_NUM_PAIRS_OUTPUT = 5;
    private static final int MIN_PAIRS_COMPLETE_COVERAGE_COUNT = 5;

    public static void main(String[] args) throws Exception {
        File fastaFile = new File(args[0]);
        File hapTypeRoot = new File(args[1]);
        File outputFile = new File(args[2]);
        File outputImageDir = new File(args[3]);
        String name = new String(args[4]);
        File exonBoundaryFile = new File(args[5]);
        StringBuilder result = new StringBuilder();
        ParseFastaByHapTypeABC.startType(fastaFile, hapTypeRoot, outputFile, outputImageDir, name, result, exonBoundaryFile);
        System.out.println(result.toString());
    }

    public static void startType(File fastaFile, File hapTypeRoot, File outputFile, File outputImageDir, String name, StringBuilder resultSummary, File exonBoundaryFile) throws Exception {
        File[] hapFiles;
        StringBuilder builder = new StringBuilder();
        Map<String, Map<Integer, MatchUnit>> exons = ParseFastaByHapTypeABC.parseExons(exonBoundaryFile);
        File[] fileArray = hapFiles = hapTypeRoot.listFiles();
        int n = hapFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File hapFile = fileArray[n2];
            if (hapFile.getName().endsWith("fa")) {
                File hapAmbFile = new File(hapTypeRoot, String.valueOf(hapFile.getName().substring(0, hapFile.getName().length() - 3)) + HAP_AMB_TXT);
                HashMap<String, String> hapNames = new HashMap<String, String>();
                if (hapAmbFile.exists()) {
                    System.out.println("parse hap amb file " + hapAmbFile.getName());
                    ParseFastaByHapTypeABC.populateHapAmbNames(hapNames, hapAmbFile);
                }
                builder.append("\n---------").append(hapFile.getName());
                resultSummary.append("\n");
                File tmpFile = ParseFastaByHapTypeABC.organizeFastaByHap(hapNames, hapFile, builder);
                int exonSize = FileManager.readTextFile(tmpFile).split("\n")[1].trim().length();
                builder.append(" exon size=").append(exonSize).append("\n");
                builder.append("Hap Type\t").append("#Pairs Perfect Match Exon 2\t").append("Average Amplicon Size\t").append("#Positions w >=8x Coverage\t").append("#Pairs Completely Cover Exon2\t");
                builder.append("#Pairs Perfect Match Exon 3\t").append("Average Amplicon Size\t").append("#Positions w >=8x Coverage\t").append("#Pairs Completely Cover Exon3\t");
                builder.append("#Pairs Perfect Match Exon 2+3\t").append("Average Amplicon Size\n");
                File outputImage = new File(outputImageDir, String.valueOf(name) + "-" + hapFile.getName().split("\\.")[0] + ".jpg");
                String matchResult = ParseFastaByHapTypeABC.runCrossMatch(fastaFile, tmpFile);
                List<String> filteredResult = ParseFastaByHapTypeABC.filterResult(matchResult);
                Map<String, Map<String, OneMatch>> result = ParseFastaByHapTypeABC.ParseResult(filteredResult);
                boolean bl = ParseFastaByHapTypeABC.output(result, hapFile, 0, builder, exonSize, outputImage, resultSummary, hapFile.getName().split("\\.")[0].toUpperCase(), name, exons);
            }
            ++n2;
        }
        FileManager.writeTextFile(outputFile, builder.toString(), true);
    }

    private static Map<String, Map<Integer, MatchUnit>> parseExons(File exonFile) {
        String[] data;
        LinkedHashMap<String, Map<Integer, MatchUnit>> exons = new LinkedHashMap<String, Map<Integer, MatchUnit>>();
        String[] stringArray = data = FileManager.readTextFile(exonFile).split("\n");
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] items = line.trim().split("\\s+");
            if (items.length >= 4) {
                String gene = items[0].trim();
                if (!exons.containsKey(gene)) {
                    exons.put(gene, new LinkedHashMap());
                }
                int exonNum = Integer.valueOf(items[1]);
                int exonStart = Integer.valueOf(items[2]);
                int exonEnd = Integer.valueOf(items[3]);
                MatchUnit unit = new MatchUnit(exonStart, exonEnd);
                ((Map)exons.get(gene)).put(new Integer(exonNum), unit);
            }
            ++n2;
        }
        return exons;
    }

    private static List<String> filterResult(String matchResult) {
        ArrayList<String> results = new ArrayList<String>();
        LinkedHashMap groupedMap = new LinkedHashMap();
        String[] lines = matchResult.split("\n");
        HashMap result = new HashMap();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] items;
            String line = stringArray[n2];
            if (line.indexOf(LABEL) > 0 && line.trim().split("\\s+").length >= 12 && (items = line.trim().split("\\s+"))[1].equals("0.00") && items[2].equals("0.00") && items[3].equals("0.00")) {
                String thisRead = ConvertFastaQdataMiSeq.generateName(items[4].trim());
                if (!groupedMap.containsKey(thisRead)) {
                    groupedMap.put(thisRead, new HashMap());
                }
                Integer score = Integer.valueOf(items[0].trim());
                if (!((Map)groupedMap.get(thisRead)).containsKey(score)) {
                    ((Map)groupedMap.get(thisRead)).put(score, new ArrayList());
                }
                ((List)((Map)groupedMap.get(thisRead)).get(score)).add(line.trim());
            }
            ++n2;
        }
        for (String read : groupedMap.keySet()) {
            Map scoreMap = (Map)groupedMap.get(read);
            Object[] num = scoreMap.keySet().toArray();
            Arrays.sort(num);
            results.addAll((Collection)scoreMap.get(num[num.length - 1]));
        }
        return results;
    }

    private static File organizeFastaByHap(Map<String, String> hapAmbNames, File fastaFile, StringBuilder log) throws Exception {
        File tmpFn = File.createTempFile("seq", "fasta");
        StringBuilder builder = new StringBuilder();
        ArrayList<String> existAmbTypes = new ArrayList<String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">")) {
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                if (!hapAmbNames.containsKey(name)) {
                    builder.append(lines[i].trim()).append("\n");
                    builder.append(sequence).append("\n");
                } else {
                    String gname = hapAmbNames.get(name);
                    if (!existAmbTypes.contains(gname)) {
                        builder.append(">").append(gname).append("\n");
                        builder.append(sequence).append("\n");
                        existAmbTypes.add(gname);
                    }
                }
            }
            ++i;
        }
        FileManager.writeTextFile(tmpFn, builder.toString(), true);
        return tmpFn;
    }

    private static void populateHapAmbNames(Map<String, String> hapNames, File hapAmbFile) {
        String[] lines;
        String[] stringArray = lines = FileManager.readTextFile(hapAmbFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0) {
                String[] items = line.trim().split("\\s+");
                String gname = items[0].trim();
                int i = 1;
                while (i < items.length) {
                    hapNames.put(items[i].trim(), gname);
                    ++i;
                }
            }
            ++n2;
        }
    }

    private static boolean output(Map<String, Map<String, OneMatch>> result, File hapFile, int roundNum, StringBuilder builder, int exonSize, File outputImage, StringBuilder resultSummary, String locus, String sample, Map<String, Map<Integer, MatchUnit>> exons) {
        HashMap orgnizedTypes = new HashMap();
        HashMap<String, ArrayList<OneMatch>> effectiveMatchesByType = new HashMap<String, ArrayList<OneMatch>>();
        HashMap<String, List<MatchStatistics>> matchStatisticsList = new HashMap<String, List<MatchStatistics>>();
        for (String type : result.keySet()) {
            Map<String, OneMatch> matches = result.get(type);
            ArrayList<OneMatch> effectiveMatches = new ArrayList<OneMatch>();
            int count = 0;
            for (OneMatch match : matches.values()) {
                if (roundNum == 0 && match.isForwardExist() && match.isReverseExist()) {
                    effectiveMatches.add(match);
                    ++count;
                    continue;
                }
                if (roundNum <= 0 || !match.isForwardExist() && !match.isReverseExist()) continue;
                effectiveMatches.add(match);
                ++count;
            }
            if (count <= 0) continue;
            effectiveMatchesByType.put(type, effectiveMatches);
            System.out.println("round " + roundNum + " type= " + type + " " + effectiveMatches.size());
            matchStatisticsList.put(type, ParseFastaByHapTypeABC.fillMatchStatistics(effectiveMatches, exonSize, roundNum, exons.get(locus)));
            System.out.println(String.valueOf(((MatchStatistics)((List)matchStatisticsList.get(type)).get(0)).getNumPairsPerfect()) + " " + ((MatchStatistics)((List)matchStatisticsList.get(type)).get(1)).getNumPairsPerfect() + " " + ((MatchStatistics)((List)matchStatisticsList.get(type)).get(2)).getNumPairsPerfect());
            if (!orgnizedTypes.containsKey(count)) {
                orgnizedTypes.put(count, new ArrayList());
            }
            ((List)orgnizedTypes.get(count)).add(type);
        }
        List<String> types = ParseFastaByHapTypeABC.summaryResult(resultSummary, matchStatisticsList, exonSize, locus, sample);
        Object[] num = orgnizedTypes.keySet().toArray();
        Arrays.sort(num);
        BufferedImage bufferedImage = ParseFastaByHapTypeABC.initializeBufferedImage(exonSize);
        Graphics2D graphics2D = ParseFastaByHapTypeABC.initializeGraphics2D(bufferedImage);
        int imageCount = 0;
        for (String t : types) {
            String info;
            if (roundNum == 0) {
                info = String.valueOf(t) + "\t" + ((MatchStatistics)((List)matchStatisticsList.get(t)).get(0)).format() + "\t" + ((MatchStatistics)((List)matchStatisticsList.get(t)).get(1)).format() + "\t" + ((MatchStatistics)((List)matchStatisticsList.get(t)).get(2)).format();
                builder.append(info);
                ParseFastaByHapTypeABC.getStatistics(t, (List)matchStatisticsList.get(t), (List)effectiveMatchesByType.get(t), 0, exonSize, bufferedImage, graphics2D, imageCount, (Integer)num[num.length - 1]);
                builder.append("\n");
                ++imageCount;
                continue;
            }
            info = String.valueOf(t) + "\t" + ((MatchStatistics)((List)matchStatisticsList.get(t)).get(0)).format() + "\t" + ((MatchStatistics)((List)matchStatisticsList.get(t)).get(1)).format() + "\t" + ((MatchStatistics)((List)matchStatisticsList.get(t)).get(2)).format();
            builder.append(info);
            ParseFastaByHapTypeABC.getStatistics(t, (List)matchStatisticsList.get(t), (List)effectiveMatchesByType.get(t), 1, exonSize, bufferedImage, graphics2D, imageCount, (Integer)num[num.length - 1]);
            builder.append("\n");
            ++imageCount;
        }
        ParseFastaByHapTypeABC.writeImageToFile(bufferedImage, outputImage);
        return num.length == 0 || (Integer)num[num.length - 1] < 10;
    }

    private static List<String> summaryResult(StringBuilder resultSummary, Map<String, List<MatchStatistics>> matchStatisticsList, int exonSize, String locus, String sample) {
        HashMap orgnizedByPairCompleteCoverTypes = new HashMap();
        HashMap orgnizedByExonCoverageTypes = new HashMap();
        ArrayList<String> types = new ArrayList<String>();
        for (String type : matchStatisticsList.keySet()) {
            MatchStatistics matchStatistics2 = matchStatisticsList.get(type).get(0);
            MatchStatistics matchStatistics3 = matchStatisticsList.get(type).get(1);
            MatchStatistics matchStatistics23 = matchStatisticsList.get(type).get(2);
            int totalGoodCoverage = matchStatistics2.getNumPosGoodCoverage() + matchStatistics3.getNumPosGoodCoverage();
            if (!orgnizedByExonCoverageTypes.containsKey(totalGoodCoverage)) {
                orgnizedByExonCoverageTypes.put(totalGoodCoverage, new ArrayList());
            }
            ((List)orgnizedByExonCoverageTypes.get(totalGoodCoverage)).add(type);
        }
        int count = 0;
        Object[] num = orgnizedByExonCoverageTypes.keySet().toArray();
        Arrays.sort(num);
        int i = num.length - 1;
        while (i >= 0) {
            int c = (Integer)num[i];
            if (c != exonSize && count >= 2 || (double)c < 0.3 * (double)exonSize) break;
            HashMap orgnizedByBigAmpliconMatches = new HashMap();
            for (String t : (List)orgnizedByExonCoverageTypes.get(c)) {
                if (types.contains(t)) continue;
                if (!orgnizedByBigAmpliconMatches.containsKey(matchStatisticsList.get(t).get(2).getNumPairsPerfect())) {
                    orgnizedByBigAmpliconMatches.put(matchStatisticsList.get(t).get(2).getNumPairsPerfect(), new ArrayList());
                }
                ((List)orgnizedByBigAmpliconMatches.get(matchStatisticsList.get(t).get(2).getNumPairsPerfect())).add(t);
            }
            Object[] num3 = orgnizedByBigAmpliconMatches.keySet().toArray();
            Arrays.sort(num3);
            int j = num3.length - 1;
            while (j >= 0) {
                int z = (Integer)num3[j];
                for (String tt : (List)orgnizedByBigAmpliconMatches.get(z)) {
                    resultSummary.append(sample).append("\t").append(locus).append("\t").append(tt).append("\t").append(matchStatisticsList.get(tt).get(0).format()).append(matchStatisticsList.get(tt).get(1).format()).append(matchStatisticsList.get(tt).get(2).format()).append("\n");
                    types.add(tt);
                    ++count;
                }
                --j;
            }
            --i;
        }
        return types;
    }

    private static List<MatchStatistics> fillMatchStatistics(List<OneMatch> list, int exonSize, int rountNum, Map<Integer, MatchUnit> exonUnit) {
        ArrayList<MatchStatistics> allStatistics = new ArrayList<MatchStatistics>();
        MatchStatistics matchStatistics2 = new MatchStatistics();
        MatchStatistics matchStatistics3 = new MatchStatistics();
        MatchStatistics matchStatistics23 = new MatchStatistics();
        MatchUnit unit2 = exonUnit.get(2);
        Map<Integer, Integer> posCount2 = ParseFastaByHapTypeABC.initMap(unit2.getMatchEnd() - unit2.getMatchStart() + 1, 0);
        MatchUnit unit3 = exonUnit.get(3);
        Map<Integer, Integer> posCount3 = ParseFastaByHapTypeABC.initMap(unit3.getMatchEnd() - unit3.getMatchStart() + 1, unit3.getMatchStart() - 1);
        Map<Integer, Integer> posCount23 = ParseFastaByHapTypeABC.initMap(unit2.getMatchEnd() - unit2.getMatchStart() + 1 + unit3.getMatchEnd() - unit3.getMatchStart() + 1, 0);
        int totalSize2 = 0;
        int totalCount2 = 0;
        int pairsWithCompleteCoverage2 = 0;
        int totalSize3 = 0;
        int totalCount3 = 0;
        int pairsWithCompleteCoverage3 = 0;
        int totalSize23 = 0;
        int totalCount23 = 0;
        boolean pairsWithCompleteCoverage23 = false;
        for (OneMatch match : list) {
            int fstart = match.getForwardTargetStart();
            int fend = match.getForwardTargetEnd();
            int rstart = match.getReverseTargetStart();
            int rend = match.getReverseTargetEnd();
            if (fstart > match.getReverseTargetStart()) {
                fstart = match.getReverseTargetStart();
                fend = match.getReverseTargetEnd();
                rstart = match.getForwardTargetStart();
                rend = match.getForwardTargetEnd();
            }
            int size = 0;
            if (rountNum == 0) {
                if (fend >= rstart) {
                    size = rend - fstart + 1;
                    if (ParseFastaByHapTypeABC.withinExon(fstart, rend, unit2)) {
                        ParseFastaByHapTypeABC.addToPosCount(posCount2, fstart, rend);
                        if (fstart == unit2.getMatchStart() && rend == unit2.getMatchEnd()) {
                            ++pairsWithCompleteCoverage2;
                        }
                        totalSize2 += size;
                        ++totalCount2;
                    } else if (ParseFastaByHapTypeABC.withinExon(fstart, rend, unit3)) {
                        ParseFastaByHapTypeABC.addToPosCount(posCount3, fstart, rend);
                        if (fstart == unit3.getMatchStart() && rend == unit3.getMatchEnd()) {
                            ++pairsWithCompleteCoverage3;
                        }
                        totalSize3 += size;
                        ++totalCount3;
                    } else {
                        ParseFastaByHapTypeABC.addToPosCount(posCount23, fstart, rend);
                        totalSize23 += size;
                        ++totalCount23;
                    }
                } else {
                    size = fend - fstart + 1 + (rend - rstart + 1);
                    if (ParseFastaByHapTypeABC.withinExon(fstart, rend, unit2)) {
                        ParseFastaByHapTypeABC.addToPosCount(posCount2, fstart, fend);
                        ParseFastaByHapTypeABC.addToPosCount(posCount2, rstart, rend);
                        totalSize2 += size;
                        ++totalCount2;
                    } else if (ParseFastaByHapTypeABC.withinExon(fstart, rend, unit3)) {
                        ParseFastaByHapTypeABC.addToPosCount(posCount3, fstart, fend);
                        ParseFastaByHapTypeABC.addToPosCount(posCount3, rstart, rend);
                        totalSize3 += size;
                        ++totalCount3;
                    } else {
                        ParseFastaByHapTypeABC.addToPosCount(posCount23, fstart, fend);
                        ParseFastaByHapTypeABC.addToPosCount(posCount23, rstart, rend);
                        totalSize23 += size;
                        ++totalCount23;
                    }
                }
                match.setCoverageSize(size);
                continue;
            }
            int thisSize = 0;
            if (match.isForwardExist()) {
                size = fend - fstart + 1;
                if (ParseFastaByHapTypeABC.withinExon(fstart, fend, unit2)) {
                    ParseFastaByHapTypeABC.addToPosCount(posCount2, fstart, fend);
                    totalSize2 += size;
                    thisSize += size;
                    ++totalCount2;
                } else if (ParseFastaByHapTypeABC.withinExon(fstart, fend, unit3)) {
                    ParseFastaByHapTypeABC.addToPosCount(posCount3, fstart, fend);
                    totalSize3 += size;
                    thisSize += size;
                    ++totalCount3;
                } else {
                    System.out.println("can't locate " + fstart + " " + fend);
                }
            }
            if (match.isReverseExist()) {
                size = rend - rstart + 1;
                if (ParseFastaByHapTypeABC.withinExon(rstart, rend, unit2)) {
                    ParseFastaByHapTypeABC.addToPosCount(posCount2, rstart, rend);
                    totalSize2 += size;
                    thisSize += size;
                    ++totalCount2;
                } else if (ParseFastaByHapTypeABC.withinExon(rstart, rend, unit3)) {
                    ParseFastaByHapTypeABC.addToPosCount(posCount3, rstart, rend);
                    totalSize3 += size;
                    thisSize += size;
                    ++totalCount3;
                } else {
                    System.out.println("can't locate " + rstart + " " + rend);
                }
            }
            match.setCoverageSize(thisSize);
        }
        if (totalCount2 > 0) {
            matchStatistics2.setAverageAmpliconSize(totalSize2 / totalCount2);
        }
        if (totalCount3 > 0) {
            matchStatistics3.setAverageAmpliconSize(totalSize3 / totalCount3);
        }
        if (totalCount23 > 0) {
            matchStatistics23.setAverageAmpliconSize(totalSize23 / totalCount23);
        }
        ArrayList<Integer> firmPos2 = new ArrayList<Integer>();
        ArrayList<Integer> firmPos3 = new ArrayList<Integer>();
        ArrayList<Integer> firmPos23 = new ArrayList<Integer>();
        for (int pos : posCount2.keySet()) {
            if (posCount2.get(pos) < COVERAGE_CUTOFF) continue;
            firmPos2.add(pos);
        }
        for (int pos : posCount3.keySet()) {
            if (posCount3.get(pos) < COVERAGE_CUTOFF) continue;
            firmPos3.add(pos);
        }
        for (int pos : posCount23.keySet()) {
            if (posCount23.get(pos) < COVERAGE_CUTOFF) continue;
            firmPos23.add(pos);
        }
        matchStatistics2.setPosCount(posCount2);
        matchStatistics2.setNumPosGoodCoverage(firmPos2.size());
        matchStatistics2.setNumPairsCompletelyCoverExon(pairsWithCompleteCoverage2);
        matchStatistics2.setExonSize(unit2.getMatchEnd() - unit2.getMatchStart() + 1);
        matchStatistics2.setNumPairsPerfect(totalCount2);
        matchStatistics3.setPosCount(posCount3);
        matchStatistics3.setNumPosGoodCoverage(firmPos3.size());
        matchStatistics3.setNumPairsCompletelyCoverExon(pairsWithCompleteCoverage3);
        matchStatistics3.setExonSize(unit3.getMatchEnd() - unit3.getMatchStart() + 1);
        matchStatistics3.setNumPairsPerfect(totalCount3);
        matchStatistics23.setPosCount(posCount3);
        matchStatistics23.setNumPosGoodCoverage(firmPos3.size());
        matchStatistics23.setNumPairsCompletelyCoverExon(pairsWithCompleteCoverage3);
        matchStatistics23.setExonSize(unit2.getMatchEnd() - unit2.getMatchStart() + 1 + unit3.getMatchEnd() - unit3.getMatchStart() + 1);
        matchStatistics23.setNumPairsPerfect(totalCount23);
        allStatistics.add(matchStatistics2);
        allStatistics.add(matchStatistics3);
        allStatistics.add(matchStatistics23);
        return allStatistics;
    }

    private static boolean withinExon(int fstart, int rend, MatchUnit unit) {
        return fstart >= unit.getMatchStart() - 5 && fstart <= unit.getMatchEnd() + 5 && rend >= unit.getMatchStart() - 5 && rend <= unit.getMatchEnd() + 5;
    }

    private static void getStatistics(String hap, List<MatchStatistics> matchStatistics, List<OneMatch> list, int rountNum, int exonSize, BufferedImage bufferedImage, Graphics2D graphics2D, int imageCount, int scale) {
        String label = " average match size exon2 =" + matchStatistics.get(0).getAverageAmpliconSize();
        label = String.valueOf(label) + " average match size exon3 =" + matchStatistics.get(1).getAverageAmpliconSize();
        label = String.valueOf(label) + ", positions with over 8x coverage =" + (matchStatistics.get(0).getNumPosGoodCoverage() + matchStatistics.get(1).getNumPosGoodCoverage()) + " ";
        label = String.valueOf(label) + ", number of pairs complete covered exon2 =" + matchStatistics.get(0).getNumPairsCompletelyCoverExon();
        label = String.valueOf(label) + ", number of pairs complete covered exon3 =" + matchStatistics.get(1).getNumPairsCompletelyCoverExon();
        if (imageCount < IMAGE_TO_DRAW) {
            Map<Integer, Integer> posCount = ParseFastaByHapTypeABC.mergePosCount(matchStatistics.get(0).getPosCount(), matchStatistics.get(1).getPosCount(), matchStatistics.get(2).getPosCount());
            ParseFastaByHapTypeABC.drawSequence(posCount, exonSize, imageCount, bufferedImage, graphics2D, hap);
            ParseFastaByHapTypeABC.drawDeepth(posCount, exonSize, imageCount, bufferedImage, graphics2D, scale, label);
            ParseFastaByHapTypeABC.drawAmplicons(list, exonSize, imageCount, bufferedImage, graphics2D);
        }
    }

    private static Map<Integer, Integer> mergePosCount(Map<Integer, Integer> posCount1, Map<Integer, Integer> posCount2, Map<Integer, Integer> posCount3) {
        HashMap<Integer, Integer> poscount = new HashMap<Integer, Integer>();
        for (int i : posCount3.keySet()) {
            int count = posCount3.get(i) + (posCount1.containsKey(i) ? posCount1.get(i) : 0) + (posCount2.containsKey(i) ? posCount2.get(i) : 0);
            poscount.put(i, count);
        }
        return poscount;
    }

    private static void drawAmplicons(List<OneMatch> alllist, int exonSize, int count, BufferedImage bufferedImage, Graphics2D graphics2D) {
        int length = exonSize;
        Color[] colors = new Color[]{Color.RED, Color.BLUE};
        List<OneMatch> list = ParseFastaByHapTypeABC.orgnizeMatches(alllist, exonSize);
        int yBase = bufferedImage.getHeight() - (IMAGE_TO_DRAW - count - 1) * 1000;
        int index = 1;
        for (OneMatch match : list) {
            int x2;
            int y1;
            int x1;
            graphics2D.setColor(colors[index % 2]);
            if (match.isForwardExist()) {
                x1 = Math.round(new Float(new Double(bufferedImage.getWidth()) / new Double(length) * (double)match.getForwardTargetStart()).floatValue());
                y1 = yBase - 424 + index * 4;
                x2 = Math.round(new Float(new Double(bufferedImage.getWidth()) / new Double(length) * (double)match.getForwardTargetEnd()).floatValue());
                graphics2D.drawLine(x1, y1, x2, y1);
            }
            if (match.isReverseExist()) {
                x1 = Math.round(new Float(new Double(bufferedImage.getWidth()) / new Double(length) * (double)match.getReverseTargetStart()).floatValue());
                y1 = yBase - 424 + index * 4;
                x2 = Math.round(new Float(new Double(bufferedImage.getWidth()) / new Double(length) * (double)match.getReverseTargetEnd()).floatValue());
                graphics2D.drawLine(x1, y1, x2, y1);
            }
            if (++index > 100) break;
        }
    }

    private static List<OneMatch> orgnizeMatches(List<OneMatch> list, int exonSize) {
        HashMap sortedMatches = new HashMap();
        ArrayList<OneMatch> sortedList = new ArrayList<OneMatch>();
        int count = 0;
        for (OneMatch match : list) {
            int size = match.getCoverageSize();
            if (!sortedMatches.containsKey(size)) {
                sortedMatches.put(size, new ArrayList());
            }
            ((List)sortedMatches.get(size)).add(match);
            if (++count > 100) break;
        }
        Object[] num = sortedMatches.keySet().toArray();
        Arrays.sort(num);
        int i = num.length - 1;
        while (i >= 0) {
            sortedList.addAll((Collection)sortedMatches.get(num[i]));
            --i;
        }
        return sortedList;
    }

    private static void drawDeepth(Map<Integer, Integer> posCount, int exonSize, int count, BufferedImage bufferedImage, Graphics2D graphics2D, int scale, String output) {
        int length = exonSize;
        int countMax = ParseFastaByHapTypeABC.getCountMax(posCount);
        graphics2D.setColor(Color.LIGHT_GRAY);
        int yBase = bufferedImage.getHeight() - (IMAGE_TO_DRAW - count - 1) * 1000;
        for (int pos : posCount.keySet()) {
            int x1 = Math.round(new Float(new Double(bufferedImage.getWidth()) / new Double(length) * (double)pos).floatValue());
            int y1 = yBase - 450 - 10;
            int y2 = Math.round(new Float(new Double(400.0) / new Double((double)scale * 1.5) * (double)posCount.get(pos).intValue()).floatValue());
            graphics2D.drawLine(x1, y1 - y2, x1, y1);
        }
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawString(" coverage max=" + countMax, 1, yBase - 650);
        graphics2D.drawString(output, 1, yBase - 650 + 10);
    }

    private static int getCountMax(Map<Integer, Integer> posCount) {
        int max = 0;
        for (Integer count : posCount.values()) {
            if (count <= max) continue;
            max = count;
        }
        return max;
    }

    private static void addToPosCount(Map<Integer, Integer> posCount, int start, int end) {
        int i = start;
        while (i < end + 1) {
            if (posCount.get(i) == null) {
                System.out.println("pass " + i + " " + start + "-" + end);
            } else {
                int count = posCount.get(i) + 1;
                posCount.put(i, count);
            }
            ++i;
        }
    }

    private static Map<Integer, Integer> initMap(int exonSize, int offset) {
        LinkedHashMap<Integer, Integer> posCount = new LinkedHashMap<Integer, Integer>();
        int i = 1;
        while (i < exonSize + 1) {
            posCount.put(i + offset, 0);
            ++i;
        }
        return posCount;
    }

    private static Object getName(String t, Map<String, String> types) {
        for (String name : types.keySet()) {
            if (!types.get(name).equals(t)) continue;
            return name;
        }
        return null;
    }

    private static Map<String, String> getAllTypes(File hapFile) {
        String[] lines;
        HashMap<String, String> types = new HashMap<String, String>();
        String[] stringArray = lines = FileManager.readTextFile(hapFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.startsWith(">")) {
                String[] items = line.substring(1).trim().split("\\s+");
                if (items.length == 1) {
                    types.put(items[0], items[0]);
                } else {
                    types.put(items[0], items[1]);
                }
            }
            ++n2;
        }
        return types;
    }

    private static Map<String, Map<String, OneMatch>> ParseKirResult(String matchResult) {
        String[] lines = matchResult.split("\n");
        HashMap<String, Map<String, OneMatch>> result = new HashMap<String, Map<String, OneMatch>>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] items;
            String line = stringArray[n2];
            if (line.indexOf(LABEL) > 0 && line.trim().split("\\s+").length >= 12 && Integer.valueOf((items = line.trim().split("\\s+"))[0]) > 50) {
                OneMatch aMatch;
                Map matches;
                String type;
                String thisRead = ConvertFastaQdataMiSeq.generateName(items[4].trim());
                String name = thisRead.substring(0, thisRead.length() - 2);
                boolean isRevComp = items[8].trim().equals("C");
                String string = type = isRevComp ? items[9].trim() : items[8].trim();
                if (!result.containsKey(type)) {
                    result.put(type, new HashMap());
                }
                if (!(matches = (Map)result.get(type)).containsKey(name)) {
                    aMatch = new OneMatch();
                    aMatch.setName(name);
                    matches.put(name, aMatch);
                }
                aMatch = (OneMatch)matches.get(name);
                if (isRevComp) {
                    aMatch.setReverseExist(true);
                    aMatch.setReverseScore(Integer.valueOf(items[0].trim()));
                } else {
                    aMatch.setForwardExist(true);
                    aMatch.setForwardScore(Integer.valueOf(items[0].trim()));
                }
            }
            ++n2;
        }
        return result;
    }

    private static Map<String, Map<String, OneMatch>> ParseResult(List<String> filteredResult) {
        HashMap<String, Map<String, OneMatch>> result = new HashMap<String, Map<String, OneMatch>>();
        for (String line : filteredResult) {
            OneMatch aMatch;
            Map matches;
            String type;
            String[] items;
            if (line.indexOf(LABEL) <= 0 || line.trim().split("\\s+").length < 12 || !(items = line.trim().split("\\s+"))[1].equals("0.00") || !items[2].equals("0.00") || !items[3].equals("0.00")) continue;
            String thisRead = ConvertFastaQdataMiSeq.generateName(items[4].trim());
            String name = thisRead.substring(0, thisRead.length() - 2);
            boolean isRevComp = items[8].trim().equals("C");
            String string = type = isRevComp ? items[9].trim() : items[8].trim();
            if (!result.containsKey(type)) {
                result.put(type, new HashMap());
            }
            if (!(matches = (Map)result.get(type)).containsKey(name)) {
                aMatch = new OneMatch();
                aMatch.setName(name);
                matches.put(name, aMatch);
            }
            aMatch = (OneMatch)matches.get(name);
            if (isRevComp) {
                aMatch.setReverseExist(true);
                aMatch.setReverseScore(Integer.valueOf(items[0].trim()));
                aMatch.setReverseTargetStart(Integer.valueOf(items[12].trim()));
                aMatch.setReverseTargetEnd(Integer.valueOf(items[11].trim()));
                continue;
            }
            aMatch.setForwardExist(true);
            aMatch.setForwardScore(Integer.valueOf(items[0].trim()));
            aMatch.setForwardTargetStart(Integer.valueOf(items[9].trim()));
            aMatch.setForwardTargetEnd(Integer.valueOf(items[10].trim()));
        }
        return result;
    }

    private static boolean inExcludingList(String type) {
        int i = 0;
        while (i < DRB1_07_SPECIFIC23_EXCLUDING.length) {
            if (type.equals(DRB1_07_SPECIFIC23_EXCLUDING[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static List<String> addDRB107SpecificReads(String[] log) {
        ArrayList<String> names = new ArrayList<String>();
        String[] stringArray = log;
        int n = log.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().startsWith(">")) {
                String thisRead = ConvertFastaQdataMiSeq.generateName(line.trim().substring(1));
                String name = thisRead.substring(0, thisRead.length() - 2);
                names.add(name);
            }
            ++n2;
        }
        return names;
    }

    private static String runCrossMatch(File fastaFile, File hapFile) {
        String cmd = "/genome/bin/cross_match -masklevel 101 -minmatch 60 -minscore " + MIN_SCORE + " " + fastaFile.getAbsolutePath() + " " + hapFile.getAbsolutePath();
        String data = OsHelper.excuteCommand(cmd);
        return data;
    }

    private static BufferedImage initializeBufferedImage(int exonSize) {
        BufferedImage bufferedImage = new BufferedImage(1000, 1000 * IMAGE_TO_DRAW, 9);
        return bufferedImage;
    }

    /*
     * Unable to fully structure code
     */
    private static double getUnit(int length) {
        num = length;
        i = 0;
        if (!((double)length <= 5.0)) ** GOTO lbl6
        return 1.0;
lbl-1000:
        // 1 sources

        {
            num = new Double((double)length / Math.pow(10.0, ++i));
lbl6:
            // 2 sources

            ** while (num > 10.0)
        }
lbl7:
        // 1 sources

        if (num > 5.0) {
            return Math.pow(10.0, i);
        }
        j = 1;
        while (num * (double)j * 2.0 < 5.0) {
            ++j;
        }
        return Math.pow(10.0, i) / new Double(j * 2);
    }

    private static Graphics2D initializeGraphics2D(BufferedImage bufferedImage) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setBackground(Color.white);
        graphics2D.clearRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.setClip(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return graphics2D;
    }

    private static void drawSequence(Map<Integer, Integer> posCount, int exonSize, int count, BufferedImage bufferedImage, Graphics2D graphics2D, String hap) {
        int length = exonSize;
        graphics2D.setColor(Color.LIGHT_GRAY);
        int yBase = bufferedImage.getHeight() - (IMAGE_TO_DRAW - count - 1) * 1000;
        graphics2D.draw3DRect(0, yBase - 450, 1000, 10, true);
        graphics2D.fill3DRect(0, yBase - 450, 1000, 10, true);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawLine(1, yBase - 450, 1, bufferedImage.getHeight() - (IMAGE_TO_DRAW - count - 1) * 1000 - 450 + 10);
        graphics2D.drawString("1 " + hap, 1, yBase - 424);
        graphics2D.drawLine(bufferedImage.getWidth() - 1, yBase - 450, bufferedImage.getWidth() - 1, bufferedImage.getHeight() - (IMAGE_TO_DRAW - count - 1) * 1000 - 450 + 10);
        graphics2D.drawString(new Integer(length).toString(), bufferedImage.getWidth() - new Integer(length).toString().length() * 8, yBase - 424);
        double unit = ParseFastaByHapTypeABC.getUnit(exonSize);
        int num = new Double((double)exonSize / unit).intValue();
        int x = 0;
        String index = null;
        int i = 1;
        while (i <= num) {
            x = Math.round(new Float(new Double(bufferedImage.getWidth()) / new Double(length) * unit * (double)i).floatValue());
            index = String.valueOf(new Double(unit * (double)i).intValue());
            graphics2D.drawLine(x, yBase - 450, x, yBase - 450 + 10);
            if (i < num || i == num && (double)length - unit * (double)num >= unit / 2.0) {
                graphics2D.drawString(index, x, yBase - 424);
            }
            ++i;
        }
    }

    private static void writeImageToFile(BufferedImage bufferedImage, File imageFile) {
        FileImageOutputStream fileImageOutputStream = null;
        ImageWriter imageWriter = null;
        try {
            try {
                fileImageOutputStream = new FileImageOutputStream(imageFile);
                imageWriter = ImageIO.getImageWritersByFormatName("jpg").next();
                imageWriter.setOutput(fileImageOutputStream);
                imageWriter.write(bufferedImage);
            }
            catch (IOException e) {
                e.printStackTrace();
                if (fileImageOutputStream != null) {
                    try {
                        fileImageOutputStream.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                if (imageWriter != null) {
                    imageWriter.dispose();
                }
            }
        }
        finally {
            if (fileImageOutputStream != null) {
                try {
                    fileImageOutputStream.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (imageWriter != null) {
                imageWriter.dispose();
            }
        }
    }
}

